package edu.jhu.ece.iacl.algorithms.gvf;

import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

/**
 * Trilinear interpolation to up sample volume by arbitrary amount
 * 
 * @author Blake Lucas
 * 
 */
public class Interpolate3dTrilinear implements Interpolate3d {
	private static final Interpolate3dTrilinear interpolate = new Interpolate3dTrilinear();

	public static ImageDataFloat doSolve(ImageDataFloat in, int xo, int yo, int zo) {
		return interpolate.solve(in, xo, yo, zo);
	}

	/**
	 * Up sample volume to specified dimension
	 * 
	 * @param in
	 *            matrix 3d
	 * @param xo
	 *            must be larger than input x dimension
	 * @param yo
	 *            must be larger than input y dimension
	 * @param zo
	 *            must be larger than input z dimension
	 */
	public ImageDataFloat solve(ImageDataFloat in, int xo, int yo, int zo) {
		ImageDataFloat out = new ImageDataFloat(xo, yo, zo);

		int xi = in.getRows();
		int yi = in.getCols();
		int zi = in.getSlices();

		int ic, jc, kc, nexti, nextj, nextk, i, j, k;
		float scaleZ, scaleY, scaleX;
		float s, t, w, tmpv;
		scaleZ = (zi - 1.0f) / (zo - 1.0f);
		scaleY = (yi - 1.0f) / (yo - 1.0f);
		scaleX = (xi - 1.0f) / (xo - 1.0f);
		float[][][] inmat=in.toArray3d();
		float[][][] outmat=out.toArray3d();
		for (k = 0; k < xo; k++) {
			tmpv = (float) k * scaleX;
			kc = (int) Math.floor(tmpv);
			w = tmpv - kc;
			if (k == 0) {
				w = 0;
				kc = 0;
				nextk = 1;
			} else if (k == (xo - 1)) {
				w = 0;
				kc = xi - 1;
				nextk = xi - 1;
			} else {
				nextk = kc + 1;
			}
			for (i = 0; i < yo; i++) {
				tmpv = (float) i * scaleY;
				ic = (int) Math.floor(tmpv);
				s = tmpv - (float) ic;
				if (i == 0) {
					s = 0;
					ic = 0;
					nexti = 1;
				} else if (i == (yo - 1)) {
					s = 0;
					ic = yi - 1;
					nexti = yi - 1;
				} else {
					nexti = ic + 1;
				}
				for (j = 0; j < zo; j++) {
					tmpv = (float) j * scaleZ;
					jc = (int) Math.floor(tmpv);
					t = tmpv - (float) jc;
					if (j == 0) {
						t = 0;
						jc = 0;
						nextj = 1;
					} else if (j == (zo - 1)) {
						t = 0;
						jc = zi - 1;
						nextj = zi - 1;
					} else {
						nextj = jc + 1;
					}

					outmat[k][i][j]=(1.0f - w)
							* ((1.0f - s)
									* ((1.0f - t) * inmat[kc][ic][jc] + t
											* inmat[kc][ic][nextj]) + s
									* ((1.0f - t) * inmat[kc][nexti][jc] + t
											* inmat[kc][nexti][nextj]))
							+ w
							* ((1.0f - s)
									* ((1.0f - t) * inmat[nextk][ic][jc] + t
											* inmat[nextk][ic][nextj]) + s
									* ((1.0f - t) * inmat[nextk][nexti][jc] + t
											* inmat[nextk][nexti][nextj]));

				}
			}
		}
		return out;
	}
}
