package edu.jhu.ece.iacl.algorithms.gvf;

import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.vector.Vector3;

/**
 * Compute Laplacian for specified point in vector matrix 3d
 * 
 * @author Blake Lucas
 * 
 */
public class Laplace3d {
	public static Vector3 doSolve(ImageDataFloat M, int x, int y, int z) {
		int xn = M.getRows();
		int yn = M.getCols();
		int zn = M.getSlices();
		Vector3 del2 = new Vector3(0.0, 0.0, 0.0);
		int lz, hz, ly, hy, lx, hx;
		lz = (z == 0) ? 1 : 0;
		hz = (z == (zn - 1)) ? 1 : 0;
		ly = (y == 0) ? 1 : 0;
		hy = (y == (yn - 1)) ? 1 : 0;
		lx = (x == 0) ? 1 : 0;
		hx = (x == (xn - 1)) ? 1 : 0;
		float[][][][] Mmat=M.toArray4d();
		/* use Neuman boundary condition */
		del2.setZ((Mmat[x][y][z - 1 + lz][2] + Mmat[x][y][z + 1 - hz][2]
				+ Mmat[x][y - 1 + ly][z][2] + Mmat[x][y + 1 - hy][z][2]
				+ Mmat[x - 1 + lx][y][z][2] + Mmat[x + 1 - hx][y][z][2])
				/ 6.0 - Mmat[x][y][z][2]);

		del2.setY((Mmat[x][y][z - 1 + lz][1] + Mmat[x][y][z + 1 - hz][1]
				+ Mmat[x][y - 1 + ly][z][1] + Mmat[x][y + 1 - hy][z][1]
				+ Mmat[x - 1 + lx][y][z][1] + Mmat[x + 1 - hx][y][z][1])
				/ 6.0 - Mmat[x][y][z][1]);

		del2.setX((Mmat[x][y][z - 1 + lz][0] + Mmat[x][y][z + 1 - hz][0]
				+ Mmat[x][y - 1 + ly][z][0] + Mmat[x][y + 1 - hy][z][0]
				+ Mmat[x - 1 + lx][y][z][0] + Mmat[x + 1 - hx][y][z][0])
				/ 6.0 - Mmat[x][y][z][0]);
		return del2;
	}
}
