package edu.jhu.ece.iacl.algorithms.thickness;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.IntersectorTriangle;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * Compute thickness by measuring the shortest distance between corresponding
 * points.
 * 
 * @author Blake Lucas (bclucas@jhu.edu)
 * 
 */
public class ClosestPointThickness extends ThicknessSolver {
	public ClosestPointThickness(double lambda, double isoVal,
			double lagrangeDeltaT) {
		this.isoVal = isoVal;
		this.lambda = lambda;
		this.lagrangeDeltaT = lagrangeDeltaT;
		setLabel("Closest Point Thickness");
	}
	public void solve(ImageData innerVol, ImageData outerVol) {
		this.innerVol = innerVol;
		this.outerVol = outerVol;
		rows = innerVol.getRows();
		cols = innerVol.getCols();
		slices = innerVol.getSlices();
		IsoSurfaceOnGrid surfGen = new IsoSurfaceOnGrid();
		innerMesh = (ADJUST_BOUNDARY) ? surfGen.solveNoMove(innerVol,
				ConnectivityRule.CONNECT_18_6, (float) isoVal, false) : surfGen
				.solveOriginal(innerVol, ConnectivityRule.CONNECT_18_6,
						(float) isoVal, false);
		outerMesh = (ADJUST_BOUNDARY) ? surfGen.solveNoMove(outerVol,
				ConnectivityRule.CONNECT_18_6, (float) isoVal, false) : surfGen
				.solveOriginal(outerVol, ConnectivityRule.CONNECT_18_6,
						(float) isoVal, false);
		computeThickness();
		markCompleted();
	}

	public void solve(EmbeddedSurface innerMesh, EmbeddedSurface outerMesh) {
		this.innerMesh = innerMesh;
		this.outerMesh = outerMesh;
		computeThickness();
		markCompleted();
	}

	protected void computeThickness() {
		SurfaceIntersector intersect = new SurfaceIntersector(this, 13,
				innerMesh);
		int vertCount = outerMesh.getVertexCount();
		Point3f pt;
		double[][] vertData = new double[vertCount][5];
		// Vector3f v;
		setTotalUnits(vertCount + innerMesh.getVertexCount());
		for (int id = 0; id < vertCount; id++) {
			pt = outerMesh.getVertex(id);
			double[] stats = vertData[id];
			stats[0] = intersect.distance(pt);
			Point3d lastPoint = ((IntersectorTriangle) intersect
					.getLastIntersectionTriangle()).getBaryCoords(intersect
					.getLastIntersectionPoint());
			stats[1] = lastPoint.x;
			stats[2] = lastPoint.y;
			stats[3] = lastPoint.z;
			stats[4] = ((IntersectorTriangle) intersect
					.getLastIntersectionTriangle()).fid;

			incrementCompletedUnits();
		}

		outerMesh.setVertexData(vertData);

		intersect = new SurfaceIntersector(this, 13, outerMesh);
		vertCount = innerMesh.getVertexCount();
		vertData = new double[vertCount][5];
		for (int id = 0; id < vertCount; id++) {
			pt = innerMesh.getVertex(id);
			double[] stats = vertData[id];
			stats[0] = intersect.distance(pt);
			Point3d lastPoint = ((IntersectorTriangle) intersect
					.getLastIntersectionTriangle()).getBaryCoords(intersect
					.getLastIntersectionPoint());
			stats[1] = lastPoint.x;
			stats[2] = lastPoint.y;
			stats[3] = lastPoint.z;
			stats[4] = ((IntersectorTriangle) intersect
					.getLastIntersectionTriangle()).fid;
			incrementCompletedUnits();
		}
		innerMesh.setVertexData(vertData);
		String name = innerMesh.getName();
		innerMesh.setName(name + "_src");
		outerMesh.setName(name + "_dest");
	}

}
