package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Node at boundary of shell
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public abstract class BoundaryNode extends GridNode{
	protected double thickness;
	public byte marchingLabel;
	protected Point3f location;
	protected Point3f innerPoint,outerPoint;

	public BoundaryNode(Point3f p,Point3f corr,byte label){
		super();
		this.i=(int)Math.floor(p.x);this.j=(int)Math.floor(p.y);this.k=(int)Math.floor(p.z);
		thickness=0;
		location=new Point3f(p);
		if(label==INNER_BOUNDARY){
			innerPoint=corr;
			outerPoint=new Point3f();
		} else {
			outerPoint=corr;
			innerPoint=new Point3f();
		}
		this.regionLabel=label;
	}

	protected Vector3f tanget;
	public Vector3f getTanget(){
		return tanget;
	}
	public void setTanget(Vector3f v){
		this.tanget=v;
	}
	public Point3f getLocation(){
		return location;
	}
	public double getThickness(){
		return thickness;
	}

	public void setLength(double inner,double outer){
		thickness=inner+outer;
	}
	public void setRefPosition(int i, int j, int k) {
		this.i=i;
		this.j=j;
		this.k=k;
		location=new Point3f(i,j,k);
	}
	public void setLocation(Point3f p){
		location=p;
	}
	public byte getMarchingLabel(){
		return marchingLabel;
	}
	public void setMarchingLabel(byte label){
		this.marchingLabel=label;
	}
	public Point3f getInnerPoint(){return innerPoint;}
	public Point3f getOuterPoint(){return outerPoint;}
	public void setCorrespodence(Point3f p){
		if(compareToInner){
			innerPoint=p;
		} else {
			outerPoint=p;
		}
	}
	public Point3f getCorrespodence(){
		if(compareToInner){
			return innerPoint;
		} else {
			return outerPoint;
		}
	}
	public abstract double getInnerLength();
	public abstract double getOuterLength();
	public abstract double getNormalizedLength();
	
	public abstract void setLength(double len);
	public abstract void connect(EmbeddedNode n);
	public abstract double getLength();
	//public abstract BoundaryNode clone();
	public Double getValue() {
		return getLength();
	}
	public void setValue(Comparable len) {
		setLength((Double)len);
	}
	public Vector3f getGradient() {
		Vector3f grad=new Vector3f(tanget.x,tanget.y,tanget.z);
		if(!EmbeddedNode.isCompareToInner()){
			grad.negate();
		}
		return grad;
	}
	public void setGradient(Vector3f g) {
		// TODO Auto-generated method stub
		
	}
	
}
