package edu.jhu.ece.iacl.algorithms.thickness.grid;
import java.util.ArrayList;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Boundary node that is immersed in eulerian grid with more than two neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class ExtendedImmersedBoundaryNode extends ExtendedGridNode implements ExtendedNode{
	private ArrayList<EmbeddedNode> neighbors;
	private double innerLength=0;
	private double outerLength=0;
	protected Point3f innerPoint;
	protected Point3f outerPoint;	
	protected Point3f location;
	public byte marchingLabel;
	protected Vector3f tanget;
	protected Vector3f grad;
	public ExtendedImmersedBoundaryNode(Point3f p,Point3f corr){
		location=p;
		this.i=(int)Math.floor(p.x);
		this.j=(int)Math.floor(p.y);
		this.k=(int)Math.floor(p.z);
		this.setCorrespodence(corr);
		neighbors=new ArrayList<EmbeddedNode>();
	}
	public void connect(EmbeddedNode node){
		if(!neighbors.contains(node))neighbors.add(node);
		if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
	}
	public Point3f getLocation(){
		return location;
	}
	public Vector3f getTanget(){
		return tanget;
	}
	public void setTanget(Vector3f v){
		this.tanget=v;
	}
	public double getThickness(){
		return innerLength+outerLength;
	}
	public double getInnerLength(){
		return innerLength;
	}
	public double getOuterLength(){
		return outerLength;
	}

	public double getNormalizedLength(){
		if(normalizedLength<0){
			return innerLength/(innerLength+outerLength);
		} else {
			return normalizedLength;
		}
	}
	public Point3f getInnerPoint(){return innerPoint;}
	public Point3f getOuterPoint(){return outerPoint;}
	public void setCorrespodence(Point3f p){
		if(compareToInner){
			innerPoint=p;
		} else {
			outerPoint=p;
		}
	}
	public Point3f getCorrespodence(){
		if(compareToInner){
			return innerPoint;
		} else {
			return outerPoint;
		}
	}
	public void setLength(double inner,double outer){
			innerLength=inner;
			outerLength=outer;
	}
	public void setLength(double len){
		if(compareToInner){
			innerLength=len;
		} else {
			outerLength=len;
		}
	}
	public double getLength(){
		if(compareToInner){
			return innerLength;
		} else {
			return outerLength;
		}
	}
	public byte getMarchingLabel(){
		return marchingLabel;
	}
	public void setMarchingLabel(byte label){
		this.marchingLabel=label;
	}
	public Vector3f getGradient() {
		return grad;
	}
	public void setGradient(Vector3f g) {
		this.grad=g;
	}
}
