package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Grid node that lies outside shell
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class SimpleOutsideNode extends GridNode{
	public static final byte marchingLabel=SOLVED;
	public SimpleOutsideNode(int i,int j,int k,byte label){
		super();
		this.i=i;this.j=j;this.k=k;
		this.regionLabel=label;
	}
	public SimpleOutsideNode clone(){
		SimpleOutsideNode dat=new SimpleOutsideNode(i,j,k,regionLabel);
		dat.chain=chain;
		dat.index=index;
		dat.regionLabel=regionLabel;	
		dat.connect(nbhd[0], 0);
		dat.connect(nbhd[1], 1);
		dat.connect(nbhd[2], 2);
		dat.connect(nbhd[3], 3);
		dat.connect(nbhd[4], 4);
		dat.connect(nbhd[5], 5);
		return dat;
	}
	public Vector3f getTanget(){
		return new Vector3f();
	}
	public void setTanget(Vector3f v){
		
	}
	public double getThickness(){
		return -1;
	}
	public double getInnerLength(){
		return 0;
	}
	public double getOuterLength(){
		return 0;
	}
	public Point3f getInnerPoint(){return null;}
	public Point3f getOuterPoint(){return null;}
	public double getNormalizedLength(){
		if(regionLabel>0){
			return 2;
		} else {
			return -1;
		}
	}
	/*
	public double getNormalizedLength(){
		if(normalizedLength<0){
			if(regionLabel>0){
				return 2;
			} else {
				return -1;
			}
		} else {
			return normalizedLength;
		}
	}
	public void setNormalizedLength(double len){
	}
	*/
	public void setCorrespodence(Point3f p){}
	public Point3f getCorrespodence(){
		return null;
	}
	public void setLength(double inner,double outer){}
	public void setLength(double len){}
	public double getLength(){return 0;}
	public byte getMarchingLabel(){
		return marchingLabel;
	}
	public void setMarchingLabel(byte label){}
	@Override
	public Vector3f getGradient() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public void setGradient(Vector3f g) {
		// TODO Auto-generated method stub
		
	};
}
