package edu.jhu.ece.iacl.plugins.classification;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;

import edu.jhmi.rad.medic.algorithms.AlgorithmLesionToads;
import edu.jhmi.rad.medic.methods.LesionToadAtlas;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

import gov.nih.mipav.model.structures.ModelImage;

/**
 * Lesion TOADS Algorithm (Variation of MedicAlgorithmMultioTOADS)
 * Using TOADS for segmenting MS Lesion as well as other tissues 
 * 
 * @author Navid Shiee
 * 
 */

public class MedicAlgorithmLesionToads extends ProcessingAlgorithm {



//	private ParamWeightedVolumeCollection<String> inputImages;
	private ParamVolume MPRAGE;
	private ParamVolume SPGR;
	private ParamVolume T2;
	private ParamVolume PD;
	private ParamVolume FLAIR;
	
		
//	private ParamVolume VentHard;

	private ParamFile atlasFile;

	private ParamBoolean correctInhomogeneity;
	
	private ParamBoolean scaleData;

	private ParamDouble smoothParam;

	private ParamInteger maxIters;
	
	private ParamDouble maxDiff;
	
	private ParamInteger maxGMDist;
	
	private ParamInteger maxVentDist;
	
	private ParamInteger maxInterVentDist;
		
	private ParamDouble spread;
	
	private ParamDouble atlasPrior;

	private ParamDouble atlasRange;
	
	private ParamOption registerationMode;
	
	private ParamOption connectivity;
	
	private ParamOption outputType;
	
	private ParamOption normType;
	
	private ParamOption centroidMode;
	
	private ParamFloat centroidSmoothness;
	
	private ParamBoolean useLesionWeight;
	
	private ParamBoolean includeLesions;
	
	private ParamBoolean outputMembershipClassification;
	
	private ParamVolume classification;
	
	private ParamVolume classification_mem;

	private ParamVolume field;
	
	private ParamBoolean outputField;
	
	private ParamInteger polynomialDegree;
	
	private ParamOption correctionMethod;
	
	private ParamFloat kernelSize;

	private ParamVolume memberships;

	private ParamVolume lesions;
	
	//private ParamVolume prior;
	
	private ParamVolume wmfill;
	
	private ParamVolume gm;
	
	//private ParamVolume gm_cl;
	
	//private ParamVolume wm_cl;
	
	private ParamVolume csf;
	
	private ParamVolume wmMask;
	
	//private ParamVolume totalwmMask;
	
	private HashMap<String,String> connMap;

	private static final String revnum = new AlgorithmLesionToads().get_version();
	/**
	 * Create Input parameters for LesionTOADS as specified in AlgorithmLesionToads The
	 * boundaries for these variables do not necessarily match those specified
	 * in the original dialog
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		
		//algorithmInformation.add(ReferencedPapers.toads);
		//algorithmInformation.add(PrinceGroupAuthors.navidShee);

		connMap=new HashMap<String,String>();
		connMap.put("(18,6)","18/6");
		connMap.put("(6,18)","6/18");
		connMap.put("(26,6)","26/6");
		connMap.put("(6,26)","6/26");
		
		//String[] modal = {"T1","MPRAGE","T2","FLAIR","PD"};
		//inputImages = new ParamWeightedVolumeCollection<String>("Image Channels",new ParamOption("Modality",modal));
		MPRAGE =  new ParamVolume("T1_MPRAGE Image", VoxelType.UBYTE);
		MPRAGE.setMandatory(false);
		SPGR =  new ParamVolume("T1_SPGR Image", VoxelType.UBYTE);
		SPGR.setMandatory(false);
		T2 =  new ParamVolume("T2 Image", VoxelType.UBYTE);
		T2.setMandatory(false);
		PD =  new ParamVolume("PD Image", VoxelType.UBYTE);
		PD.setMandatory(false);
		FLAIR =  new ParamVolume("FLAIR Image", VoxelType.UBYTE);
		FLAIR.setMandatory(false);
		atlasFile = new ParamFile("Atlas file");
		
		String filename = "Atlas/lesion/cruise-atlas-11obj-lesiontoads2009.txt";
        try {

        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        atlasFile.setValue(cl.getResource(filename).getFile());
        } catch (Exception e) {
                System.out.print("Error: Unable to set default atlas\n");        
        }
				
		correctInhomogeneity = new ParamBoolean("Correct inhomogeneity");
		correctInhomogeneity.setValue(true);
		correctInhomogeneity.setDescription("Correct MR field inhomogeneity.");
		
		outputField= new ParamBoolean("Output inhomogeniety filed", false);
		outputField.setDescription("Output the estimated inhomogeneity field");
		
		polynomialDegree = new ParamInteger("Inhomogeneity field degree", 1, 4);
		polynomialDegree.setValue(3);
		polynomialDegree.setDescription("Polynomial degree for MR field estimation.");
		
		String[] fieldOption = {"Chebyshev","Splines"};
		correctionMethod = new ParamOption("Correction Method",fieldOption);
		correctionMethod.setValue("Chebyshev");
		correctionMethod.setDescription("The type of polynomial used for inhomogeneity correction");
		
	    kernelSize= new ParamFloat("Kernel size",0,1000.0f);
	    kernelSize.setValue(30.0f);
	    kernelSize.setDescription("The krenel size for spline polynimals");
		
		smoothParam = new ParamDouble("Smooting parameter", 0, 1E10);
		smoothParam.setValue(0.1);
		smoothParam.setDescription("Controls the effect of neighberhood voxels on the membership");
		
		maxIters = new ParamInteger("Maximum iterations", 0, 100000);
		maxIters.setValue(99);
				
		maxDiff = new ParamDouble("Maximum difference", 0.0, 1E10);
		maxDiff.setValue(0.0001);
		maxDiff.setDescription("Maximum amount of relative change in the energy function considered as the convergence criteria");
				
		atlasPrior = new ParamDouble("Atlas prior", 0, 1E10);
		atlasPrior.setValue(0.1);
		atlasPrior.setDescription("Controls the effect of the statistical atlas on the segmentation");
		atlasRange = new ParamDouble("Atlas range", 0, 1E10);
		atlasRange.setValue(0.1);
		String[]	registerationType = {"rigid","single_scale","quadratic_scale","scaled_rigid","tri_quadratic_scale","fully_affine","fully_quadratic","fully_cubic",
			"multi_rigid","multi_single_scale","multi_quadratic_scale","multi_scaled_rigid","multi_tri_quadratic_scale","multi_fully_affine","multi_fully_quadratic","multi_fully_cubic"};
		registerationMode = new ParamOption("registeration Type", registerationType);
		registerationMode.setValue("rigid");
		registerationMode.setDescription("The method which is used for the registration of the atlases to the image");
		String[] centroidType={"none","linked","damped","prior"};
		centroidMode = new ParamOption("Centroid Mode",centroidType);
		centroidMode.setValue("prior");
		centroidSmoothness = new ParamFloat("Centroid Smoothness",0, 1.0f);
		centroidSmoothness.setValue(0.1);
		
		useLesionWeight = new ParamBoolean("Use lesion weights");
		useLesionWeight.setValue(true);
		useLesionWeight.setDescription("Flag for using sequence specific intensity utilization in segmentation of lesions");
		
		includeLesions = new ParamBoolean("Include lesions in white matter", true);
		includeLesions.setDescription("Include lesion in WM class in hard classification");
		
		outputMembershipClassification = new ParamBoolean ("Output max membership classification", false);
		outputMembershipClassification.setDescription("Output the hard classification using maximum membership (not neceesarily topologically correct)");
	
		
		scaleData = new ParamBoolean("Scale Cruise Output",true);
		
		String[] norms = {"Identity","Diagonal Covariance"};
		normType = new ParamOption("Norm Type",norms);
		
		maxGMDist = new ParamInteger("Maximum GM Distance",0,256);
		maxGMDist.setValue(3);
		maxGMDist.setDescription("Maximum distance from the GM boundary to downweight the lesion membership to avoid false postives");
		maxVentDist = new ParamInteger("Maximum Ventircle Distance",0,256);
		maxVentDist.setValue(2);
		maxGMDist.setDescription("Maximum distance from the Ventricles boundary to downweight the lesion membership to avoid false postives");
		maxInterVentDist = new ParamInteger("Maximum InterVentricular Distance",0,256);
		maxInterVentDist.setValue(25);
		maxGMDist.setDescription("Maximum distance from the interventricular WM boundary to downweight the lesion membership to avoid false postives");
		spread = new ParamDouble("Minimum Distance", 0, 1E10);
		spread.setValue(1.0);
		spread.setDescription("The defualt value of the distance function inside the structures");
		
		connectivity=new ParamOption("Connectivity (foreground,background)",new ArrayList<String>(connMap.keySet()));
		
		String[] out = {"classification","cruise inputs","dura removal inputs","class+member"};
		outputType=new ParamOption("Output images", out);
		outputType.setValue("cruise inputs");
		
		// Add input to main pane
		//inputParams.add(inputImages);
		inputParams.add(MPRAGE);
		inputParams.add(SPGR);
		inputParams.add(T2);
		inputParams.add(PD);
		inputParams.add(FLAIR);
		inputParams.add(atlasFile);
		inputParams.add(smoothParam);
		inputParams.add(atlasPrior);
		inputParams.add(maxDiff);
		inputParams.add(registerationMode);
		inputParams.add(atlasRange);
		inputParams.add(maxGMDist);
		inputParams.add(maxVentDist);
		inputParams.add(maxInterVentDist);
		inputParams.add(spread);
		inputParams.add(maxIters);
		inputParams.add(outputType);
		inputParams.add(outputMembershipClassification);
		inputParams.add(includeLesions);
		inputParams.add(normType);
		inputParams.add(centroidMode);
		inputParams.add(centroidSmoothness);
		inputParams.add(connectivity);
		inputParams.add(correctInhomogeneity);
		inputParams.add(outputField);
		inputParams.add(polynomialDegree);
		inputParams.add(correctionMethod);
		inputParams.add(kernelSize);
		inputParams.add(useLesionWeight);
		inputParams.add(scaleData);

		inputParams.setPackage("IACL");
		inputParams.setCategory("Classification");
		inputParams.setName("lesion toads");
		inputParams.setLabel("Lesion TOADS");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.navidShiee);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.setDescription("Algorithm for simulataneous brain structures and MS lesion segmentation of MS Brains. The brain segmentation is topologically consistent and the algorithm can use multiple MR sequences as input data." );
	}

	/**
	 * Create output Parameters for TOADS. Note: Not all output fields are
	 * populated and the non-populated fields will create an error that is
	 * caught by the dialog.
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(classification = new ParamVolume("classification",VoxelType.UBYTE));
		classification.setMandatory(false);
		outputParams.add(classification_mem = new ParamVolume("classification from memberships",VoxelType.UBYTE));
		classification_mem.setMandatory(false);
		outputParams.add(field = new ParamVolume("Inhomogeneity Field",VoxelType.FLOAT));
		field.setMandatory(false);
		outputParams.add(memberships = new ParamVolume("Membership Classes",VoxelType.UBYTE));
		memberships.setMandatory(false);
		lesions = new ParamVolume("Lesion Class",VoxelType.FLOAT);
		outputParams.add(lesions);
		lesions.setMandatory(false);
		/*prior = new ParamVolume("Priors",VoxelType.FLOAT);
		outputParams.add(prior);
		prior.setMandatory(false);*/
		csf = new ParamVolume("CSF",VoxelType.FLOAT);
		outputParams.add(csf);
		csf.setMandatory(false);
		gm = new ParamVolume("GM",VoxelType.FLOAT);
		outputParams.add(gm);
		gm.setMandatory(false);
		wmfill = new ParamVolume("WM Fill",VoxelType.UBYTE);
		outputParams.add(wmfill);
		wmfill.setMandatory(false);
		wmMask = new ParamVolume("WM Mask",VoxelType.UBYTE);
		outputParams.add(wmMask);
		wmMask.setMandatory(false);
		outputParams.setLabel("Lesion TOADS");
		outputParams.setName("lesion toads" );
	}

	/**
	 * Execute the LesionTOADS algorithm given the input parameters
	 */
	protected class LesionToadsWrapper extends AbstractCalculation{
		public LesionToadsWrapper(){
			setLabel("Lesion TOADS");
		}
		public void execute(){
						
            System.out.println("Loading Images");
			int i;
			boolean mprage = (MPRAGE.getImageData() != null);
			boolean spgr = (SPGR.getImageData() != null);
			boolean flair = (FLAIR.getImageData() != null);
			boolean pd = (PD.getImageData() != null);
			boolean t2 = (T2.getImageData() != null);
			ModelImage[] images = null;
			String[] modals = null;
			String[] psfs = null;
			if (mprage && flair) {
				images = new ModelImage[2];
				images[0] = MPRAGE.getImageData().getModelImageCopy();
				images[1] = FLAIR.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_MPRAGE";
				modals[1]="FLAIR";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
				MPRAGE.getImageData().getModelImageCopy().getFileInfo();
			}else if (spgr && flair) {
				images = new ModelImage[2];
				images[0] = SPGR.getImageData().getModelImageCopy();
				images[1] = FLAIR.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_SPGR";
				modals[1]="FLAIR";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (mprage && t2 && pd) {
				images = new ModelImage[3];
				images[0] = MPRAGE.getImageData().getModelImageCopy();
				images[1] = T2.getImageData().getModelImageCopy();
				images[2] = PD.getImageData().getModelImageCopy();
				modals = new String[3];
				modals[0] = "T1_MPRAGE";
				modals[1]="T2";
				modals[2]="PD";
				psfs = new String[3];
				psfs[0]=psfs[1]=psfs[3]="1x1x1";
			}else if (spgr && t2 && pd) {
				images = new ModelImage[3];
				images[0] = SPGR.getImageData().getModelImageCopy();
				images[1] = T2.getImageData().getModelImageCopy();
				images[2] = PD.getImageData().getModelImageCopy();
				modals = new String[3];
				modals[0] = "T1_SPGR";
				modals[1]="T2";
				modals[2]="PD";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (mprage && t2) {
				images = new ModelImage[2];
				images[0] = MPRAGE.getImageData().getModelImageCopy();
				images[1] = T2.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_MPRAGE";
				modals[1]="T2";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (spgr && t2) {
				images = new ModelImage[2];
				images[0] = SPGR.getImageData().getModelImageCopy();
				images[1] = T2.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_SPGR";
				modals[1]="T2";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (mprage && pd) {
				images = new ModelImage[2];
				images[0] = MPRAGE.getImageData().getModelImageCopy();
				images[1] = PD.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_MPRAGE";
				modals[1]="PD";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (spgr && pd) {
				images = new ModelImage[2];
				images[0] = SPGR.getImageData().getModelImageCopy();
				images[1] = PD.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T1_SPGR";
				modals[1]="PD";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (flair && t2 && pd) {
				images = new ModelImage[3];
				images[0] = FLAIR.getImageData().getModelImageCopy();
				images[1] = T2.getImageData().getModelImageCopy();
				images[2] = PD.getImageData().getModelImageCopy();
				modals = new String[3];
				modals[0] = "FLAIR";
				modals[1]="T2";
				modals[2]="PD";
				psfs = new String[3];
				psfs[0]=psfs[1]=psfs[2]="1x1x1";
			}else if (t2 && pd) {
				images = new ModelImage[2];
				images[0] = T2.getImageData().getModelImageCopy();
				images[1] = PD.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T2";
				modals[1]="PD";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (flair && pd) {
				images = new ModelImage[2];
				images[0] = FLAIR.getImageData().getModelImageCopy();
				images[1] = PD.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "FLAIR";
				modals[1]="PD";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (t2 && flair) {
				images = new ModelImage[2];
				images[0] = T2.getImageData().getModelImageCopy();
				images[1] = FLAIR.getImageData().getModelImageCopy();
				modals = new String[2];
				modals[0] = "T2";
				modals[1]="FLAIR";
				psfs = new String[2];
				psfs[0]=psfs[1]="1x1x1";
			}else if (mprage) {
				images = new ModelImage[1];
				images[0] = MPRAGE.getImageData().getModelImageCopy();
				modals = new String[1];
				modals[0] = "T1_MPRAGE";
				psfs = new String[1];
				psfs[0]="1x1x1";
			}else if (spgr) {
				images = new ModelImage[1];
				images[0] = SPGR.getImageData().getModelImageCopy();
				modals = new String[1];
				modals[0] = "T1_SPGR";
				psfs = new String[1];
				psfs[0]="1x1x1";
			}
			
				
			
			
			//ModelImage[] images = {MPRAGE.getImageData().getModelImage(),FLAIR.getImageData().getModelImage()};
			//String[] modals = {"T1_MPRAGE", "FLAIR"};
			//String[] psfs = {"1x1x1","1x1x1"};
			LesionToadAtlas atlas = new LesionToadAtlas(atlasFile.getValue().getAbsolutePath());
			int nClasses = atlas.getNumber();
			setTotalUnits(1);
			
			AlgorithmLesionToadsWrapper algo = new AlgorithmLesionToadsWrapper(images, images.length,
					modals, psfs,
					atlasFile.getValue().getAbsolutePath(), atlas, outputType.getValue(), 
					smoothParam.getFloat(), 0.1f, maxIters.getInt(), maxDiff.getFloat(), 0,
					outputMembershipClassification.getValue(), 
				    3.0f, 0.5f, spread.getFloat(),
					(short)maxGMDist.getInt(),(short)maxInterVentDist.getInt(), (short)maxVentDist.getInt(),
					includeLesions.getValue(),
					atlasPrior.getFloat(), atlasRange.getFloat(),
					"diffeomorphism", 
					centroidMode.getValue(), centroidSmoothness.getFloat(),
					useLesionWeight.getValue(),
					registerationMode.getValue(),
					normType.getValue(),
					true, 
					4, 50, 1, 0,
					correctInhomogeneity.getValue(),outputField.getValue(), correctionMethod.getValue(), 
					polynomialDegree.getInt(),kernelSize.getFloat(),
					"linear_fast_marching",
					connMap.get(connectivity.getValue())
					) ;
			algo.setObserver(this); 
			algo.runAlgorithm();
			 
//			export the images needed
			ModelImage[] resultImage=algo.getResultImages();
			i=0;
			if ( outputType.getValue().equals("class+member")){
				memberships.setValue(new ImageDataMipavWrapper(resultImage[i]));
				i++;
			}
			ImageHeader[] imagesHeader=new ImageHeader[images.length];
			for(int k=0;k < images.length; k++) imagesHeader[k]= new ImageDataMipav(images[0]).getHeader();
			
			classification.setValue(new ImageDataMipavWrapper(resultImage[i]));
			classification.getImageData().setHeader(imagesHeader[0]);
			i++;
			if (outputMembershipClassification.getValue()) {
				classification_mem.setValue(new ImageDataMipavWrapper(resultImage[i]));
				i++;
				classification_mem.getImageData().setHeader(imagesHeader[0]);
			}
			lesions.setValue(new ImageDataMipavWrapper(resultImage[i]));
			lesions.getImageData().setHeader(imagesHeader[0]);
			//lesions_mem.setValue(resultImage[i+2]);
			//lesions_mem.getModelImage().copyFileTypeInfo(images[0]);
			i++;
			if ( (outputType.getValue().equals("cruise inputs")) || (outputType.getValue().equals("dura removal inputs"))){
				csf.setValue(new ImageDataMipavWrapper(resultImage[i]));
				csf.getImageData().setHeader(imagesHeader[0]);
				gm.setValue(new ImageDataMipavWrapper(resultImage[i+1]));
				gm.getImageData().setHeader(imagesHeader[0]);
				wmfill.setValue(new ImageDataMipavWrapper(resultImage[i+2]));
				wmfill.getImageData().setHeader(imagesHeader[0]);
				wmMask.setValue(new ImageDataMipavWrapper(resultImage[i+3]));
				wmMask.getImageData().setHeader(imagesHeader[0]);
				i+=4;
				/*if (outputType.getValue().equals("dura removal inputs")){
					wm_cl.setValue(resultImage[i]);
					wm_cl.getModelImage().copyFileTypeInfo(images[0]);
					gm_cl.setValue(resultImage[i+1]);
					gm_cl.getModelImage().copyFileTypeInfo(images[0]);
					totalwmMask.setValue(resultImage[i+2]);
					totalwmMask.getModelImage().copyFileTypeInfo(images[0]);
					i +=3;
				}*/
				if(scaleData.getValue()){
					ImageDataMath.scaleFloatValue(csf.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(gm.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(wmfill.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(wmMask.getImageData(), 255.0f);
					/*if (outputType.getValue().equals("dura removal inputs")){
						ImageDataMath.scaleFloatValue(gm_cl.getImageData(), 255.0f);
						ImageDataMath.scaleFloatValue(wm_cl.getImageData(), 255.0f);
						ImageDataMath.scaleFloatValue(totalwmMask.getImageData(), 255.0f);						
					}*/
				}				
			}
				
			if (outputField.getValue() && correctInhomogeneity.getValue())
				field.setValue(new ImageDataMipavWrapper(resultImage[i]));
			/*if (outputType.getValue().equals("all_images")){
				prior.setValue(new ImageDataMipavWrapper(resultImage[i]));
				prior.getImageData().setHeader(imagesHeader[0]);
			}*/
			
			
			
			
			for(int k=0;k < images.length; k++) images[k].disposeLocal();
			
			markCompleted();
			
			
			
		}
	}
	
	protected class AlgorithmLesionToadsWrapper extends AlgorithmLesionToads{
		protected AbstractCalculation observer;
		public AlgorithmLesionToadsWrapper(ModelImage[] srcImg_, int nInput_,String[] imgModal_, String[] psf_,
				String aName_, LesionToadAtlas atlas_, String segOutput_, float smooth_, 
				float out_, int nIterMax_, float distMax_, float bgth_, boolean outputMaxMem_, 
				float fLim_, float lLim_, float spread_,
				short maxGMDist_, short maxBstemDist_, short maxVentDist_,
				boolean inludeLesions_, float aFirstCoeff_,float aScale_,
				String relMode_, String centMode_, float smoothCentr_,
				boolean useLesionWeight_, String spcMode_, String nrmType_, boolean register_, 
				int lev_, int first_, int top_, int last_, boolean correct_, boolean outputField_, String correctType_, int poly_, float kernel_,
				String algo_, String connect_) {
			super( srcImg_,  nInput_, imgModal_, psf_, aName_,  atlas_,  segOutput_, smooth_,  out_,  nIterMax_,  distMax_,  bgth_,
					 outputMaxMem_, fLim_,  lLim_, spread_,  maxGMDist_, maxBstemDist_, maxVentDist_, inludeLesions_,
					aFirstCoeff_, aScale_, relMode_, centMode_, smoothCentr_,useLesionWeight_, 
					spcMode_,nrmType_,register_,lev_, first_, top_, last_, correct_, outputField_, correctType_, poly_, kernel_,
					algo_, connect_);
		}
		public void setObserver(AbstractCalculation observer){
			this.observer=observer;
		}
		public void runAlgorithm(){
			observer.setTotalUnits(100);
			super.runAlgorithm();
			observer.markCompleted();
		}
	    /**
	     * Notifies all listeners that have registered interest for notification on this event type.
	     *
	     * @param  value  the value of the progress bar.
	     */
	    protected void fireProgressStateChanged(int value) {
	        super.fireProgressStateChanged(value);
	        observer.setCompletedUnits(value);
	    }

	    /**
	     * Updates listeners of progress status. Without actually changing the numerical value
	     *
	     * @param  imageName  the name of the image
	     * @param  message    the new message to display
	     */
	    protected void fireProgressStateChanged(String imageName, String message) {
	    	super.fireProgressStateChanged(imageName, message);
	    	observer.setLabel(message);
	    }
	}
	protected void execute(CalculationMonitor monitor) {
		LesionToadsWrapper lesiontoads=new LesionToadsWrapper();
		monitor.observe(lesiontoads);
		lesiontoads.execute();
	}
	public Dimension getPreferredSize() {
		return new Dimension(600,800);
	}
}


