package edu.jhu.ece.iacl.plugins.segmentation.cruise;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.image.*;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.ace.AnatomicallyConsistentEnhancement;

/**
 * Anatomically Consistent Enhancement Algorithm
 * 
 * @author Blake Lucas
 * 
 */
public class MedicAlgorithmAnatomicallyConsistentEnhance extends ProcessingAlgorithm {
	/**
	 * Gray Matter Input
	 */
	private ParamVolume gmVol;

	/**
	 * White Matter Input
	 */
	private ParamVolume wmVol;

	/**
	 * Intensity Threshold
	 */
	private ParamDouble thresh;

	/**
	 * Thinned Gray Matter (BOOLEAN)
	 */
	private ParamVolume thinSkelVol;

	/**
	 * Thinned CSF (BOOLEAN)
	 */
	private ParamVolume skelVol;

	/**
	 * Thinned Gray Matter (UBYTE)
	 */
	private ParamVolume aceGmVol;

	/**
	 * Exceute ACE Algorithm
	 */
	protected void execute(CalculationMonitor monitor) {
		AnatomicallyConsistentEnhancement ace = new AnatomicallyConsistentEnhancement();
		monitor.observe(ace);
		String gmname=gmVol.getImageData().getName();
		ace.solve(wmVol.getImageData(), gmVol.getImageData(), thresh.getValue()
				.doubleValue());

		ImageData aceGm = ace.getEnhancedGM();
		ImageData skel = ace.getSkeleton();
		ImageData thinSkel = ace.getThinnedSkeleton();
			
		
		aceGm.setName(gmname + "_ace");
		thinSkel.setName(gmname+ "_thin");
		skel.setName(gmname + "_skel");

		aceGmVol.setValue(aceGm);
		thinSkelVol.setValue(thinSkel);
		skelVol.setValue(skel);

	}


	private static final String revnum = AnatomicallyConsistentEnhancement.getVersion();

	/**
	 * Create input parameters for ACE: gray matter,white matter and intensity
	 * threshold
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		gmVol = new ParamVolume(VoxelType.FLOAT);
		gmVol.setName("Gray Matter");
		gmVol.setDescription("Gray Matter volume must be of Float type.");
		wmVol = new ParamVolume(VoxelType.FLOAT);
		wmVol.setName("White Matter");
		wmVol.setDescription("White Matter volume must be of Float type.");
		thresh = new ParamDouble(0, 255);
		thresh.setName("Intensity Threshold");
		thresh.setValue(126.9);
//		inputParams.setLabel("Gray Matter Enhance");
		inputParams.setName("ace");
		inputParams.setLabel("Gray Matter Enhance");
//		inputParams.setName("ace");
		inputParams.add(gmVol);
		inputParams.add(wmVol);
		inputParams.add(thresh);

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(ReferencedPapers.ace);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Anatomically Consistent Enhancement. It takes the GM membership and enhances deep sulcal CSF.");
		info.setLongDescription("ACE takes GM and WM memberships. Sometimes sulcal CSF is blurred by partial volume effect, because the thickness of CSF is often quite small. ACE tries to undo the partial volume effect and creates thin CSF to reveal sulcal banks.");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}

	/**
	 * Create output parameter for ACE: enhanced gray matter, thinned csf,
	 * thinned gray matter
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
//		aceGmVol = new ParamVolume(VoxelType.FLOAT);
		aceGmVol = new ParamVolume(VoxelType.FLOAT,-1,-1,-1,1);
		aceGmVol.setName("Enhanced GM");
//		skelVol = new ParamVolume(VoxelType.INT);
		skelVol = new ParamVolume(VoxelType.INT,-1,-1,-1,1);
		skelVol.setName("Skeleton");
//		thinSkelVol = new ParamVolume(VoxelType.UBYTE);
//		thinSkelVol = new ParamVolume(VoxelType.INT);
		thinSkelVol = new ParamVolume(VoxelType.INT,-1,-1,-1,1);
		thinSkelVol.setName("Thinned Skeleton");
		outputParams.setName("ace");
		outputParams.setLabel("ACE");
		outputParams.add(aceGmVol);
		outputParams.add(skelVol);
		outputParams.add(thinSkelVol);
	}

}
