package edu.jhu.ece.iacl.plugins.segmentation.cruise;

//import edu.jhu.ece.iacl.algorithms.*;
import gov.nih.mipav.model.file.FileInfoBase;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.view.MipavUtil;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.gvf.GradVecFlow;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamNumberSliderInputView;
import edu.jhu.ece.iacl.jist.structures.image.*;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
/**
 * Gradient Vector Flow Algorithm
 * 
 * @author Blake Lucas
 * 
 */
public class MedicAlgorithmGradVecFlow extends ProcessingAlgorithm {
	private ParamVolume inputVol;
	private ParamOption method;
	private ParamBoolean normalize;
	private ParamDouble lambda;
	private ParamInteger iterations;
	private ParamVolume outputVol;

	private static final String revnum = GradVecFlow.getVersion();

	/**
	 * Create input parameters for GVF :cubic volume, field method, lambda,
	 * iterations and normalized
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		inputVol = new ParamVolume("Volume", VoxelType.FLOAT);
		method = new ParamOption("Method", new String[] { "Generalized",
				"Original" });
		lambda = new ParamDouble("Lambda", 0, Double.MAX_VALUE);
		lambda.setValue(0.2);
		normalize = new ParamBoolean("Normalize Vectors");
		iterations = new ParamInteger("Max Iterations", 0,300,200);

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");

		inputParams.add(method);
		inputParams.add(inputVol);
		inputParams.add(lambda);

		// Max iterations implemented using slider bar instead of spinner, which
		// is default
		//iterations.setInputView(new ParamNumberSliderInputView(iterations));
		inputParams.add(iterations);

		inputParams.add(normalize);

		inputParams.setLabel("Grad Vector Flow");
		inputParams.setName("gvf");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setDescription("Generate graident vector field.");
		info.setLongDescription("The GVF field is used to find the central surface.");
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		info.add(ReferencedPapers.gvf);
		info.add(PrinceGroupAuthors.chenyangXu);
    	info.add(PrinceGroupAuthors.blakeLucas);
	}

	/**
	 * Create output parameters for GVF: cubic volume
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputVol = new ParamVolume("Vector Field",VoxelType.FLOAT,-1,-1,-1,3);
//		ImageData outputVol=null;
		outputVol.setName("Vector Field");
		outputParams.add(outputVol);
		outputParams.setLabel("GVF");
		outputParams.setName("gvf");
	}

	/**
	 * Execute GVF
	 */
	protected void execute(CalculationMonitor monitor) {
		GradVecFlow gvf = GradVecFlow.create(method.getValue());
		monitor.observe(gvf);
		ImageDataMipav image1=new ImageDataMipav(inputVol.getImageData());

		ImageData result2 = gvf.solve(inputVol.getImageData(), lambda.getValue()
				.floatValue(), normalize.getValue().booleanValue(), iterations
				.getValue().intValue());
		ImageDataMipav result=new ImageDataMipav(result2);
		//FileUtil.updateFileInfo(image1.getModelImageCopy(), result.getModelImageCopy());
		result.setHeader(image1.getHeader());
        outputVol.setValue(result);

 		
	}

}
