package edu.jhu.ece.iacl.plugins.comp_geom;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.smooth.SmoothAndRegularize;
import edu.jhu.ece.iacl.algorithms.graphics.smooth.SmoothAndRegularize.Method;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurfaceCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;


public class MedicAlgorithmMultiResolutionDecomposition extends ProcessingAlgorithm{
	protected ParamSurface surfParam;
	protected ParamSurfaceCollection surfsParam;
	protected ParamInteger resolutions;
	protected ParamInteger maxItersParam;
	protected ParamDouble maxDecimation;
	protected ParamBoolean preventSelfIntersection;
	protected ParamBoolean regularize;
	private static final String cvsversion = "$Revision: 1.1 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = SmoothAndRegularize.getVersion();
	private static final String shortDescription = "Progressive Surface decomposition with Taubin smoothing and self-intersection prevention.\n"
		+ "Algorithm Version: " + revnum + "\n"
		+ "GUI Version:" + cvsversion + "\n";
	private static final String longDescription = "CRUISE surfaces are extremely large and usually have far more vertices than needed to accurately represent the cortex. This module can be used for multi-resolution analysis, accelerate processing algorithms, or for testing.";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(surfParam=new ParamSurface("Surface"));
		inputParams.add(maxItersParam=new ParamInteger("Smooth Iterations",0,100000,10));
		inputParams.add(resolutions=new ParamInteger("Multi-Resolutions",0,1000,4));
		inputParams.add(maxDecimation=new ParamDouble("Maximum Decimation (%)",0,1,0.5));
		inputParams.add(regularize=new ParamBoolean("Regularize"));
		regularize.setDescription("Should the surface be regularized by flipping edges?");
		inputParams.add(preventSelfIntersection=new ParamBoolean("Prevent Self-Intersection"));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Processing.Surface");
		inputParams.setLabel("Multi-Resolution Surface Decomposition");
		inputParams.setName("Multi-Resolution_Surface_Decomposition");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.blakeLucas);
		info.add(ReferencedPapers.progressiveMesh);
		info.add(ReferencedPapers.robustParameterizationBrainSurface);
		info.add(ReferencedPapers.meshRegularizationAndAdaptiveSmoothing);
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(surfsParam=new ParamSurfaceCollection("Multi-Resolution Surfaces"));
	}


	protected void execute(CalculationMonitor monitor) {
		SmoothAndRegularize sandr = new SmoothAndRegularize();
		monitor.observe(sandr);
		sandr.setMaxIterations(maxItersParam.getInt());
		sandr.setLambda(0.8f);
		sandr.setUpdateStep(10);
		sandr.setPreventSelfIntersection(preventSelfIntersection.getValue());
		sandr.setResolutions(resolutions.getInt());
		sandr.setMaxDecimation(maxDecimation.getDouble());
		sandr.setRegularizeEdges(regularize.getValue());
		EmbeddedSurface[] surfs = sandr.decompose(surfParam.getSurface(), SmoothAndRegularize.Method.TAUBIN);
		for (EmbeddedSurface surf:surfs){
			surfsParam.add(surf);
		}
	}
}
