import gov.nih.mipav.plugins.PlugInGeneric;
import edu.jhmi.rad.medic.floatvoi.*;
import edu.jhmi.rad.medic.visualization.framework.loaders.IncompatibleFormatException;
import edu.jhmi.rad.medic.visualization.framework.loaders.VTKMeshLoader;
import edu.jhmi.rad.medic.visualization.models.*;
import edu.jhmi.rad.medic.visualization.ui.ProgressBarDialog;

import javax.swing.*;
import java.io.*;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class PlugInStandAloneSurfaceViewer implements PlugInGeneric {
	public static final String[] CATEGORY = {"TOADS-CRUISE", "Visualization"};
	private JFileChooser fc;
	public void run() {
		System.out.println("Launching Medic Simple Surface Viewer");
		fc = new JFileChooser();
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY );
		int returnVal = fc.showOpenDialog(null);
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			new Thread( new Runnable() {
  				public void run() {
  					File f = fc.getSelectedFile();
  					ProgressBarDialog pb = new ProgressBarDialog("Loading ...", "Reading Surface : " + f.getName(), 0, 100);
  					try {
						String extension = f.getName().substring(f.getName().lastIndexOf('.') + 1).toLowerCase();
						String errorMessage = "Unable to load Surface File.";
						TriangleMesh m = null;						
						if(extension.equals("vtk")) {
							VTKMeshLoader loader = new VTKMeshLoader();
							try {								
								m = (TriangleMesh) loader.Load(f.getAbsolutePath(), pb);
							} catch (IncompatibleFormatException e) {
								JOptionPane.showMessageDialog(null, "Incorrect file format.", "Loading Error", JOptionPane.ERROR_MESSAGE); 
								e.printStackTrace();
							}
						}
						else
							errorMessage = "Unrecognized file format.";
        				if(m == null)
							JOptionPane.showMessageDialog(null, errorMessage);
						else {
							new JSurfaceFrame(null, m, null, null );
						}
  					}
					catch(IOException e) {
						JOptionPane.showMessageDialog(null, "Error loading surface file. Reason : " + e.getMessage());
					}
					pb.dispose();
      			}
			}).start();
		}
		System.gc();
	}
	
	public static void main(String args[]) {
		PlugInStandAloneSurfaceViewer viewer = new PlugInStandAloneSurfaceViewer();
		viewer.run();
	}
}
