package edu.jhmi.rad.medic.floatvoi;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.awt.Point;

/*
 * ArcBall Code based on pepe's jogl port of nehe's code.
 * http://pepijn.fab4.be/software/nehe-java-ports/
 */
public class ArcBall {
	private Vector3f savedVector;
	private Vector3f dragVector;
	private float width;
	private float height;
	private static final float EPSILON = 1.0e-5f;
	
	public ArcBall(float fWidth, float fHeight) {
		savedVector = new Vector3f(0,0,0);
		dragVector	= new Vector3f(0,0,0);
		setBounds(fWidth, fHeight);
	}
	
	
	public void setBounds(float fWidth, float fHeight) {     
		width	= 1.0f / ((fWidth	- 1.0f) * 0.5f);
    	height	= 1.0f / ((fHeight	- 1.0f) * 0.5f);
    }
    
    
    public void mapToSphere(Point point, Vector3f v) {
    	float x = (float) point.x;
    	float y = (float) point.y;
    	
    	x = (x * width) - 1.0f;
    	y = 1.0f - (y * height);
    	
    	float sqrLen = x * x + y * y;
    	
    	if(sqrLen > 1.0f) {
    		float len = (float) (1.0 / Math.sqrt(sqrLen));
    		v.X = x * len;
    		v.Y = y * len;
    		v.Z = 0.0f;
    	}
    	else {
    		v.X = x;
    		v.Y = y;
    		v.Z = (float) Math.sqrt(1.0f - sqrLen);
    	}
    }
    
    public void drag(Point pt, Quat4f quat) {
    	mapToSphere(pt, dragVector);    	
    	if(quat != null) {
    		Vector3f Perp = cross(savedVector, dragVector);    		
    		if(length(Perp) > EPSILON) {
    			quat.x = Perp.X;
    			quat.y = Perp.Y;
    			quat.z = Perp.Z;
    			quat.w = dot(savedVector, dragVector);
    		}
    		else {
    			quat.x = quat.y = quat.z = quat.w = 0.0f;
    		}
    	}
    }
    
    public void click(Point pt) {
    	mapToSphere(pt, savedVector);
    }
    
    /* Vector Stuff */
    private Vector3f cross(Vector3f v1, Vector3f v2) {
    	Vector3f result = new Vector3f(0,0,0);
    	result.X = (v1.Y * v2.Z) - (v1.Z * v2.Y);
        result.Y = (v1.Z * v2.X) - (v1.X * v2.Z);
        result.Z = (v1.X * v2.Y) - (v1.Y * v2.X);
    	return result;
    }
    
    private float dot(Vector3f v1, Vector3f v2) {
    	return (v1.X * v2.X) + (v1.Y * v2.Y) + (v1.Z * v2.Z);
    }
    
    private float length(Vector3f v1) {
    	return (float) Math.sqrt(v1.X * v1.X + v1.Y * v1.Y + v1.Z * v1.Z);
    }
}