package edu.jhmi.rad.medic.visualization.framework.loaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import edu.jhmi.rad.medic.visualization.framework.MedicDrawable;
import edu.jhmi.rad.medic.visualization.framework.plugin.ModelLoaderInterface;
import edu.jhmi.rad.medic.visualization.models.TriangleMesh;
import edu.jhmi.rad.medic.visualization.structures.ScalarFloatData;
import edu.jhmi.rad.medic.visualization.ui.ProgressBarDialog;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class VTKMeshLoader implements ModelLoaderInterface {

	public MedicDrawable Load(String filename, ProgressBarDialog progress) throws IOException, IncompatibleFormatException {
		File file = new File(filename);
		
		// Check if file is readable
		if(!file.exists() || !file.canRead()) 
			return null;
		
		BufferedReader b = new BufferedReader(new FileReader(file));
		String line = "";
		String [] splits;
		String name = "";
		int FileType = 1;
		int vertex_num, poly_num;
			
		if(b == null)	return null;
		
		System.out.println("Loading Surface ... ");
			
		//Read in the headers
		line = b.readLine().trim().toLowerCase();
		
		//Check for VTK
		if(line.indexOf("vtk datafile") == -1) 	return null;		
			
		//progress.setVisible(true);
		
		// Read in Surface name
		line = b.readLine();
		name = line.trim();		
		
		// Read in format type
		line = b.readLine().trim().toLowerCase();
		if(line.compareTo("binary") == 0)
			FileType = TriangleMesh.FILE_BINARY;		
		else 
			FileType = TriangleMesh.FILE_ASCII;
		
		// Check if the file contains polygon data
		line = b.readLine().trim().toLowerCase();		
		if(line.indexOf("dataset") == -1 || line.indexOf("polydata") == -1)	return null;
			
		// Read in the number of points
		line = b.readLine().trim().toLowerCase();
		splits = line.split(" ");		
			
		if(splits.length != 3)					return null;		
		if(splits[0].indexOf("points") == -1)	return null;
		
		vertex_num	= Integer.parseInt(splits[1]);
		TriangleMesh s = new TriangleMesh();
		if(name == null)
			s.setName(file.getName());
		else if(name.contentEquals("null"))
			s.setName(file.getName());
		else
			s.setName(name);
		//s.setFileType(FileType);
		s.allocateVertexBuffer(vertex_num);
		
		float[] vertex = new float[3];
		
		System.out.println("Found " + vertex_num + " points");
		
		progress.setMessage("Reading Points ... ");
		if(FileType == TriangleMesh.FILE_ASCII)			
			for(int i = 0; i < vertex_num; ++i) {				
				line = b.readLine().trim();
				splits = line.split(" ");
				if(splits.length != 3) {
					System.out.println("Incorrect number of coordinates for Point : " + i);
					return null;
				}
				vertex[0] = Float.parseFloat(splits[0]);
				vertex[1] = Float.parseFloat(splits[1]);
				vertex[2] = Float.parseFloat(splits[2]);
				s.addVertex(vertex);				
			}		
		progress.setValue(25);
		
		line = b.readLine().trim().toLowerCase();
		splits = line.split(" ");
		
		if(splits.length != 3)					return null;
		if(splits[0].indexOf("polygons") == -1)	return null;
		
		poly_num	= Integer.parseInt(splits[1]);
		
		s.allocatePolygonBuffer(poly_num);
		
		int[] polygon = new int[3];
		
		progress.setMessage("Reading Polygons ... ");
		
		System.gc();
		System.out.println("Found " + poly_num + " polygons");
		if(FileType	== TriangleMesh.FILE_ASCII) 
			for(int i = 0 ; i < poly_num; ++i) {								
				line = b.readLine().trim();				
				splits = line.split(" ");
				if(splits.length < 4)	return null;
				int counter = Integer.parseInt(splits[0]);
				if(counter != 3)
					return null;
				for(int j = 0; j < counter; ++j) {					
					polygon[j] = Integer.parseInt(splits[1 + j]);;
				}
				s.addPolygon(polygon);					
			}
		
		if(b.ready()) {
			// Check if we have more data
			if(FileType == TriangleMesh.FILE_ASCII) {
				line = b.readLine().trim();
				if(line.contains("POINT_DATA")) {
					splits = line.split(" ");
					if(splits.length == 2) {
						int counter = Integer.parseInt(splits[1]);
						line = b.readLine().trim();
						if(line.contains("SCALARS")) {
							b.readLine(); //Skips over LOOKUP_TABLE DEFINITION
							// Read Scalar Data
							ScalarFloatData dataBuffer = new ScalarFloatData(counter);
							
							for(int i = 0; i < counter; ++i) {
								dataBuffer.addDataPoint(Float.parseFloat(b.readLine().trim()));
							}
							s.setScalarBuffer(dataBuffer);
						}
					}
				}
			}
		}
		
		progress.setValue(50);		
		progress.setMessage("Computing Normals ... ");
		s.computeNormals();
		
		progress.setValue(75);				
		progress.setMessage("Computing Bounding Box ...");
		s.computeBoundingBox();
		
		progress.setValue(100);
		progress.setMessage("Surface Loaded");
		
		vertex = null;
		polygon = null;
		
		b.close();
		System.out.println("Surface loaded");
		System.gc();
		return s;
	}

	public String getLoaderFileExtension() {
		return "vtk";
	}

	public String getLoaderMaxFileVersion() {	
		return "1.0";
	}

	public String getLoaderMinFileVersion() {
		return "1.0";
	}

	public String getLoaderName() {
		return "VTKMeshLoader";
	}

	public boolean isFileLoader() {
		return true;
	}
	
	//Ignored
	public MedicDrawable Load() {
		return null;
	}

	public String getLoaderFileDescription() {
		return "VTK Mesh Files";
	}

	public boolean isMIPAVRequired() {
		// TODO Auto-generated method stub
		return false;
	}

}
