package edu.jhmi.rad.medic.visualization.structures;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import edu.jhmi.rad.medic.visualization.primitives.BoundingBox;

public class Triangle extends BoundingBox {	
	private Point3f v0,v1,v2;
		
	public Triangle(Point3f vertex0, Point3f vertex1, Point3f vertex2) {		
		v0 = new Point3f(vertex0);
		v1 = new Point3f(vertex1);
		v2 = new Point3f(vertex2);
		update();
	}
	
	public Triangle(float [] vertex0, float [] vertex1, float [] vertex2) {
		v0 = new Point3f(vertex0[0], vertex0[1], vertex0[2]);
		v1 = new Point3f(vertex1[0], vertex1[1], vertex1[2]);
		v2 = new Point3f(vertex2[0], vertex2[1], vertex2[2]);
		update();
	}
	
	public void update() {
		minCoords.x = Math.min(v0.x, Math.min(v1.x, v2.x));
		minCoords.y = Math.min(v0.y, Math.min(v1.y, v2.y));
		minCoords.z = Math.min(v0.z, Math.min(v1.z, v2.z));
		
		maxCoords.x = Math.max(v0.x, Math.max(v1.x, v2.x));
		maxCoords.y = Math.max(v0.y, Math.max(v1.y, v2.y));
		maxCoords.z = Math.max(v0.z, Math.max(v1.z, v2.z));
	}
		
	public Vector3f getNormal() {
		Vector3f normal = new Vector3f();
		Vector3f edge1 = new Vector3f();
		Vector3f edge2 = new Vector3f();		
		edge1.sub(v1, v0);
		edge2.sub(v2, v0);
		normal.cross(edge1, edge2);
		normal.normalize();
		edge1 = edge2 = null;
		return normal;		
	}

	/**
	 * Implementation of Geometric Tools - Distance to triangle formulation.
	 */
	public float distance(Point3f point) {
		double dist = Float.POSITIVE_INFINITY;
		Vector3d edge0, edge1, pV0, vt0,vt1,vt2, pt;
		edge0 = new Vector3d();
		edge1 = new Vector3d();
		pV0   = new Vector3d();
				
		vt0 = new Vector3d(v0.x, v0.y, v0.z);
		vt1 = new Vector3d(v1.x, v1.y, v1.z);
		vt2 = new Vector3d(v2.x, v2.y, v2.z);
		pt  = new Vector3d(point.x, point.y, point.z);
		
		edge0.sub(vt1, vt0);
		edge1.sub(vt2, vt0);
		pV0.sub(vt0, pt);
		
		double a = edge0.lengthSquared();
		double b = edge0.dot(edge1);
		double c = edge1.lengthSquared();
		double d = edge0.dot(pV0);
		double e = edge1.dot(pV0);
		double f = pV0.dot(pV0);
		double det = Math.abs(a*c - b*b);
		double s = b*e - c*d;
		double t = b*d - a*e;
		double numer, denom, tmp0, tmp1;		
		if ( s+t <= det ){
			if ( s < 0.0 ){
				if ( t < 0.0 ){
					//region 4
					
					if (d < 0.0) {
						t = 0.0;
						if (-d >= a) 
							s = 1.0;
						else
							s = -d / a;							
					} else {
						s = 0.0;
						if (e >= 0.0)
							t = 0.0;							
						else{ 
							if (-e >= c)					
								t = 1.0;							
							else 
								t = -e / c;							
						}
					}
				}
				else{
					//region 3
					s = 0.0;
					if(e >= 0.0)
						t = 0.0;
					else if ( -e >= c)
						t = 1.0;
					else
						t = -e/c;
				}
			}
			else {
				if ( t < 0.0 ) {
					//region 5
					t = 0.0;
					if( d>= 0.0) 
						s = 0.0;
					else if( -d >= a)
						s = 1.0;
					else
						s = -d/a;
				}
				else {
					//region 0
					double invDet = 1.0 / det;
					s *= invDet;
					t *= invDet;
				}
			}
		}
		else{
			if ( s < 0.0 ){
				// region 2
				tmp0 = b + d;
				tmp1 = c + e;
				if(tmp1 > tmp0) {
					numer = tmp1  - tmp0;
					denom = a - 2.0 *b +c;
					if(numer >= denom)
						s = 1.0;
					else
						s = numer / denom;
					t = 1.0 - s;
				}
				else {
					s = 0.0;
					if( tmp1 <= 0.0)
						t = 1.0;
					else {
						if(e >=0.0)					
							t = 0.0;
						else
							t = -e/c;
					}
				}
			}
			else if ( t < 0.0 ){
				// region 6
			 	tmp0 = b + e;
				tmp1 = a + d;
				if (tmp1 > tmp0) {
					numer = tmp1 - tmp0;
					denom = a - 2.0 * b + c;
					if (numer >= denom) 
						t = 1.0;		
					else 
						t = numer / denom;
					s = 1.0 - t;
				} else {
					t = 0.0;
					if (tmp1 <= 0.0)
						s = 1.0;						
					else {
						if (d >= 0.0) 					
							s = 0.0;						
						else
							s = -d / a;						
					}	
				}
			}
			else {
				// region 1
				numer = c + e -b -d;
				denom = 0.0;
				if(numer <= 0.0) {
					s = 0.0;
				}
				else {
					denom = a - 2.0 * b + c;
					if(numer >= denom)
						s = 1.0;
					else
						s = numer / denom;
				}
				t = 1.0 - f;
			}
		}
		
		dist = a*s*s + 2*b*s*t + c*t*t +2*d*s + 2*e*t + f;
		
		if(dist < 0.0f)
			dist = 0.0f;
		dist = Math.sqrt(dist);
		return (float) dist;
	}	
	
	public String toString() {
		return "" + v0.toString() + " || " + v1.toString() + " || " + v2.toString();
	}
}
