package edu.jhmi.rad.medic.visualization.ui;

import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JLabel;;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
@SuppressWarnings("serial")
public class ProgressBarDialog extends JDialog {
	private JProgressBar m_ProgressBar;
	private JLabel m_Label;
	private int m_Min, m_Max;

	public ProgressBarDialog(String title, String labelText, int min, int max) {
		super();	
		m_Min = min;
		m_Max = max;		
		setTitle(title);
		setLocationRelativeTo(null);
		m_Label = new JLabel(labelText);
		m_ProgressBar = new JProgressBar(min, max);
		m_ProgressBar.setStringPainted(true);
		getContentPane().add(m_Label, BorderLayout.NORTH);
		getContentPane().add(m_ProgressBar, BorderLayout.SOUTH);
		pack();
		setSize(300, getHeight());
		setVisible(true);
	}
	

	public ProgressBarDialog(String title, String labelText) {
		super();	
		m_Min = 0;
		m_Max = 100;		
		setTitle(title);
		setLocationRelativeTo(null);
		m_Label = new JLabel(labelText);
		m_ProgressBar = new JProgressBar(m_Min, m_Max);
		m_ProgressBar.setStringPainted(true);
		getContentPane().add(m_Label, BorderLayout.NORTH);
		getContentPane().add(m_ProgressBar, BorderLayout.SOUTH);
		pack();
		setSize(200, getHeight());
		setVisible(true);
	}


	public void setValue(int value) {
		if(value < m_Min) 
			m_ProgressBar.setValue(m_Min);
		else
			if(value > m_Max) 
				m_ProgressBar.setValue(m_Max);
			else
				m_ProgressBar.setValue(value);
	}
	
	public int getValue() {
		return m_ProgressBar.getValue();
	}
	
	public void setMessage(String message) {
		m_Label.setText(message);
	}
}
