package edu.jhu.ece.iacl.algorithms.graphics;

import java.util.Hashtable;

import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface.Edge;

/**
 * Port of Xu 3D graphics. These mesh manipulation techniques are deprecated.
 * Instead, use the updated implementation in EmbeddedSurface.
 * 
 * @author Blake Lucas
 * 
 */
public class XuGraphicsWrapper extends AbstractCalculation {
	public EmbeddedSurface surf;
	public int[][] neighborVertexVertexTable;
	protected EmbeddedSurface.Face[][] neighborEdgeFaceTable;
	protected EmbeddedSurface.Face[][] neighborVertexFaceTable;
	protected EmbeddedSurface.Edge[] edges;
	protected EmbeddedSurface.Edge[][] neighborVertexEdgeTable;
	protected EmbeddedSurface.Face[] faces;

	public XuGraphicsWrapper(XuGraphicsWrapper wrappedSurf) {
		super(wrappedSurf);
		surf = wrappedSurf.surf;
		edges = wrappedSurf.edges;
		faces = wrappedSurf.faces;
		neighborVertexVertexTable = wrappedSurf.neighborVertexVertexTable;
		neighborEdgeFaceTable = wrappedSurf.neighborEdgeFaceTable;
		neighborVertexEdgeTable = wrappedSurf.neighborVertexEdgeTable;
		neighborVertexFaceTable = wrappedSurf.neighborVertexFaceTable;
	}

	public XuGraphicsWrapper(EmbeddedSurface mesh, boolean initAllTables) {
		super();
		this.setLabel("Surface Topology");
		this.surf = mesh;
		initTables(initAllTables);
	}

	public XuGraphicsWrapper(AbstractCalculation parent, EmbeddedSurface mesh,
			boolean initAllTables) {
		super(parent);
		this.setLabel("Surface Topology");
		this.surf = mesh;
		initTables(initAllTables);

	}

	public XuGraphicsWrapper(AbstractCalculation parent) {
		super(parent);
		this.setLabel("Surface Topology");

	}

	public XuGraphicsWrapper() {
		super();
		this.setLabel("Surface Topology");
	}

	public void initTables(boolean initAllTables) {
		neighborVertexVertexTable = EmbeddedSurface
				.buildNeighborVertexVertexTable(surf,
						EmbeddedSurface.Direction.COUNTER_CLOCKWISE);
		if (initAllTables) {
			edges = EmbeddedSurface.buildEdgeTable(surf);
			Hashtable<Long, EmbeddedSurface.Edge> hash = EmbeddedSurface
					.buildEdgeHash(edges);
			faces = EmbeddedSurface.buildFaceTable(surf, edges, hash);
			neighborEdgeFaceTable = EmbeddedSurface.buildNeighborEdgeFaceTable(
					surf, faces, hash, edges);
			neighborVertexEdgeTable = EmbeddedSurface
					.buildNeighborVertexEdgeTable(neighborVertexVertexTable,
							edges, hash);
			neighborVertexFaceTable = EmbeddedSurface
					.buildNeighborVertexFaceTable(neighborVertexEdgeTable,
							neighborEdgeFaceTable);
		}
	}

	public Edge[] XUGetNeighbor(int Vid) {
		return neighborVertexEdgeTable[Vid];
	}

	public Vector3f XUPolyCenter(int PId) {
		int EN, i;
		int VId;
		Vector3f V, center = new Vector3f();

		EN = XUGetPolyEN(PId);
		center.x = 0;
		center.y = 0;
		center.z = 0;

		for (i = 0; i < EN; i++) {
			VId = XUGetPolyVertexId(PId, i);
			V = XUGetVertex(VId);
			center.x += V.x;
			center.y += V.y;
			center.z += V.z;
		}

		center.x /= EN;
		center.y /= EN;
		center.z /= EN;

		return (center);
	}

	public int XUGetPolyEN(int PId) {
		return 3;
	}

	public EmbeddedSurface.Edge[] XUGetNeighborElist(int vertex) {
		return neighborVertexEdgeTable[vertex];
	}

	public int XUGetPolyVertexId(int PId, int i) {
		return surf.getCoordinateIndex(PId * 3 + i);
	}

	public Vector3f XUGetVertex(int VId) {
		float[] p = new float[3];
		surf.getCoordinate(VId, p);
		return new Vector3f(p[0], p[1], p[2]);
	}

	public Vector3f XUVecAdd(Vector3f vec1, Vector3f vec2) /* vector addition */
	{
		Vector3f vec = new Vector3f(vec1);
		vec.add(vec2);
		return (vec);
	}

	public Vector3f XUVecSub(Vector3f vec1, Vector3f vec2) {
		Vector3f vec = new Vector3f();
		vec.sub(vec1, vec2);
		return (vec);
	}

	public double XUVecDot(Vector3f vec1, Vector3f vec2) /* vector dot product */
	{
		return vec1.dot(vec2);
	}

	public Vector3f XUVecScale(Vector3f vec1, float scalar) /*
															 * vector scalar
															 * product
															 */
	{
		Vector3f vec = new Vector3f(vec1);
		vec.scale(scalar);
		return (vec);
	}

	protected double XUPolyArea(int PId) {
		return faces[PId].getArea(surf);
	}

	public Vector3f XUVecCross(Vector3f vec1, Vector3f vec2) /*
															 * vector cross
															 * product
															 */
	{
		Vector3f vec = new Vector3f();
		vec.cross(vec1, vec2);
		return (vec);
	}

	public double XUVecMag(Vector3f vec) /* vector magnitude */
	{
		return vec.length();

	}

	/* find the other PolyId of the edge given one PolyId */
	public int XUGetEdgeOtherPolyId(EmbeddedSurface.Edge edge, int PId) {
		EmbeddedSurface.Face[] nbhd = neighborEdgeFaceTable[edge.id];
		if (PId == nbhd[0].id)
			return nbhd[1].id;
		else
			return nbhd[0].id;
	}

	/*
	 * find the Nnum th vertex neighbor of the vertex with vertex Id VId on the
	 * poly_mesh
	 */
	public int XUGetVertexNeighborVId(int VId, int Nnum) {
		return neighborVertexVertexTable[VId][Nnum];
	}

	public int XUGetPolyNextVertexId(int PId, int num) {
		return surf.getCoordinateIndex(PId * 3 + num % 3);
	}

	public int XUGetPolyEdgeId(int Pid, int num) {
		return faces[Pid].edges[num].id;
	}

	public EmbeddedSurface.Edge XUGetEdge(int Eid) {
		return edges[Eid];
	}

	public int XUGetEdgePolyId(EmbeddedSurface.Edge e, int num) {
		return neighborEdgeFaceTable[e.id][num].id;
	}

	/*
	 * find the kth neighboring poly which share ek with the polygon PId, The
	 * vertex is from v0, v1, ..., vn, the edge is labeled from e0, e1, ... en,
	 * and e0 = v0--v1, ..., en = vn-1---vn
	 */
	public int XUGetPolyNeighborPoly(int PId, int num) {
		int EId;
		EmbeddedSurface.Edge E;
		int pid;

		EId = XUGetPolyEdgeId(PId, num);

		E = XUGetEdge(EId);

		pid = XUGetEdgePolyId(E, 0);

		if (pid != PId)
			return (pid);

		pid = XUGetEdgePolyId(E, 1);

		return (pid);
	}

	public int XUGetNeighborPolyId(int VId, int num) {
		return neighborVertexFaceTable[VId][num].id;
	}

	public int XUGetNeighborEN(int vertex) {
		return neighborVertexVertexTable[vertex].length;
	}

	/*
	 * public void XUGetVertex(poly_mesh,VId)
	 * (poly_mesh)->vertex_table.vertex[(VId)]
	 * 
	 * public void XUGetEdge(poly_mesh,EId) (poly_mesh)->edge_table.edge[(EId)]
	 * 
	 * public void XUGetPoly(poly_mesh,PId) (poly_mesh)->poly_table.poly[(PId)]
	 * 
	 * public void XUGetVertexPtr(poly_mesh,VId)
	 * &((poly_mesh)->vertex_table.vertex[(VId)])
	 * 
	 * VertexId XUGetVertexNeighborVId(PolyMeshpoly_mesh, VertexId VId, int
	 * Nnum);
	 * 
	 * public void XUGetEdgePtr(poly_mesh,EId)
	 * &((poly_mesh)->edge_table.edge[(EId)])
	 * 
	 * public void XUGetPolyPtr(poly_mesh,PId)
	 * &((poly_mesh)->poly_table.poly[(PId)])
	 * 
	 * public void XUGetEdgeVertexId(edge,num) (edge).V[(num)]
	 * 
	 * public void XUGetEdgePolyId(edge,num) (edge).P[(num)] PolyId
	 * XUGetEdgeOtherPolyId(Edge edge, PolyId PId);
	 * 
	 * public void XUGetEdgeVertex(poly_mesh,edge,num)
	 * XUGetVertex((poly_mesh),((edge).V[(num)]))
	 * 
	 * public void XUGetEdgePoly(poly_mesh,edge,num)
	 * XUGetPoly((poly_mesh),((edge).P[(num)]))
	 * 
	 * public void XUGetPolyEN(poly_mesh,PId)
	 * ((poly_mesh)->poly_table.poly[(PId)].EN)
	 * 
	 * public void XUGetPolyElist(poly_mesh,PId)
	 * ((poly_mesh)->poly_table.poly[(PId)].elist)
	 * 
	 * public void XUGetPolyEdgeId(poly_mesh,PId,num)
	 * ((poly_mesh)->poly_table.poly[(PId)].elist[(num)])
	 * 
	 * VertexId XUGetPolyVertexId(PolyMeshpoly_mesh, PolyId PId, int num);
	 * 
	 * VertexId XUGetPolyNextVertexId(PolyMeshpoly_mesh, PolyId PId, int num);
	 * 
	 * PolyId XUGetPolyNeighborPoly(PolyMeshpoly_mesh, PolyId PId, int num);
	 * 
	 * public void XUGetNeighbor(poly_mesh,VId)
	 * ((poly_mesh)->neighbor_table.neighbor[(VId)])
	 * 
	 * public void XUGetNeighborEN(poly_mesh,VId)
	 * ((poly_mesh)->neighbor_table.neighbor[(VId)].EN)
	 * 
	 * public void XUGetNeighborPtr(poly_mesh,VId)
	 * (&((poly_mesh)->neighbor_table.neighbor[(VId)]))
	 * 
	 * public void XUGetNeighborElist(poly_mesh,VId)
	 * ((poly_mesh)->neighbor_table.neighbor[(VId)].elist)
	 * 
	 * public void XUGetNeighborEdgeId(neighbor,num) ((neighbor)->elist[(num)])
	 * 
	 * public void XUGetNeighborPtrEdgeId(neighbor,num)
	 * ((neighbor)->elist[(num)])
	 * 
	 * PolyId XUGetNeighborPolyId(PolyMeshpoly_mesh, VertexId VId, int num);
	 */

	public int XUGetVertexTableVN() {
		return surf.getVertexCount();
	}

	public int XUGetEdgeTableEN() {
		return edges.length;
	}

	public int XUGetPolyTablePN() {
		return surf.getFaceCount();
	}
}
