package edu.jhu.ece.iacl.algorithms.graphics.intersector;

import javax.vecmath.Point2d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdPoint3;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTriangle;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

import Jama.*;

/**
 * A mesh triangle object to be used with the surface intersector data
 * structure.
 * 
 * @author Blake Lucas
 * 
 */
public class IntersectorTriangle extends KdTriangle {
	public int id1, id2, id3;
	public int fid;
	/**
	 * Get vertex locations associated with this triangle.
	 * @return vertices
	 */
	public Point3f[] getPoints() {
		return pts;
	}
	/**
	 * Constructor
	 * @param id1 vertex id 1
	 * @param id2 vertex id 2
	 * @param id3 vertex id 3
	 * @param fid face id
	 * @param mesh surface mesh
	 */
	public IntersectorTriangle(int id1, int id2, int id3, int fid,
			EmbeddedSurface mesh) {
		super();
		this.id1 = id1;
		this.id2 = id2;
		this.id3 = id3;
		this.fid = fid;
		pts = new KdPoint3[3];
		pts[0] = new KdPoint3(mesh.getVertex(id1));
		pts[1] = new KdPoint3(mesh.getVertex(id2));
		pts[2] = new KdPoint3(mesh.getVertex(id3));
		update();
		// Find plane normal

	}
	/**
	 * Update bounding box
	 */
	public void update() {
		minPoint.x = Math.min(Math.min(pts[0].x, pts[1].x), pts[2].x)
				- (float) EPS;
		minPoint.y = Math.min(Math.min(pts[0].y, pts[1].y), pts[2].y)
				- (float) EPS;
		minPoint.z = Math.min(Math.min(pts[0].z, pts[1].z), pts[2].z)
				- (float) EPS;

		maxPoint.x = Math.max(Math.max(pts[0].x, pts[1].x), pts[2].x)
				+ (float) EPS;
		maxPoint.y = Math.max(Math.max(pts[0].y, pts[1].y), pts[2].y)
				+ (float) EPS;
		maxPoint.z = Math.max(Math.max(pts[0].z, pts[1].z), pts[2].z)
				+ (float) EPS;
	}
	
	public String toString() {

		return super.toString() + "\nTriangle" + pts[0] + " " + pts[1] + " "
				+ pts[2];
	}
	// P = origin + t*direction = b0*V0 + b1*V1 + b2*V2

}
