package edu.jhu.ece.iacl.algorithms.graphics.map;

import java.util.ArrayList;
import javax.vecmath.Point3f;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.gvf.FastMarchingGradient;
import edu.jhu.ece.iacl.algorithms.gvf.FastMarchingGradient.Normalization;
import edu.jhu.ece.iacl.algorithms.tgdm.TrackingTGDM;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.*;

/**
 * Register two level set representations of surfaces using a speed derived from
 * level set distance. The surfaces are tracked with a spherical map to maintain
 * bijective correspondence with the source surface.
 * 
 * @author Blake Lucas
 * 
 */
public class LevelSetRegistration extends AbstractCalculation {
	ImageData registeredVol;
	ImageDataFloat mapVol;
	float[][][] sourceMat;
	float[][][][] mapMat;
	int rows, cols, slices;
	ArrayList<EmbeddedSurface> surfs;

	public LevelSetRegistration() {
		super();
		setLabel("Fast-Marching Map");
	}

	public void solve(ImageData sourceVol, ImageData targetVol,
			EmbeddedSurface sphericalMap, float isoVal, float curv, int iters) {
		rows = sourceVol.getRows();
		cols = sourceVol.getCols();
		slices = sourceVol.getSlices();
		IsoSurfaceOnGrid surfGen = new IsoSurfaceOnGrid();
		setTotalUnits(1);
		EmbeddedSurface surf = surfGen.solveOriginal(sourceVol,
				ConnectivityRule.CONNECT_18_6, isoVal, false);
		double[][] data = sphericalMap.getVertexData();
		if (data == null || data[0].length != 3) {
			data = new double[sphericalMap.getVertexCount()][3];
			for (int i = 0; i < data.length; i++) {
				Point3f p = sphericalMap.getVertex(i);
				data[i][0] = p.x;
				data[i][1] = p.y;
				data[i][2] = p.z;
			}
		}
		surf.setVertexData(data);

		TrackingTGDM tgdm = new TrackingTGDM(this,
				ConnectivityRule.CONNECT_18_6);
		tgdm.setSphericalMap(surf);
		FastMarchingGradient fmg = new FastMarchingGradient(this);
		float[][][][] grad = fmg.gradient((new ImageDataFloat(sourceVol))
				.toArray3d(), Normalization.MAGNITUDE);
		/*
		 * for(int i=0;i<rows;i++){ for(int j=0;j<cols;j++){ for(int
		 * k=0;k<slices;k++){ Point3d r=GeomUtil.toSpherical(new
		 * Point3f(grad[i][j][k][0],grad[i][j][k][1],grad[i][j][k][2]));
		 * grad[i][j][k][0]=(float)r.x; grad[i][j][k][1]=(float)r.y;
		 * grad[i][j][k][2]=(float)r.z;
		 * 
		 * } } }
		 */
		registeredVol = tgdm.solveRegisterSurface(sourceVol, targetVol, curv,
				0, 1.0f, iters, true);
		// NarrowBandSkeleton nbs=new NarrowBandSkeleton();
		// registeredVol=new CubicVolumeUByte(nbs.solve((new
		// CubicVolumeFloat(sourceVol)).toArray3d(), 5));
		registeredVol.setName("target");
		mapVol = new ImageDataFloat(grad);// tgdm.getCorrespondence();
		mapVol.setName("sphere_map");
		surfs = new ArrayList<EmbeddedSurface>();
		surfs.add(tgdm.getFinalSurface());
		surfs.get(0).setName("target");
		SphericalMapCorrection hmc = new SphericalMapCorrection(this);
		hmc.nonHarmonicPoints(surfs.get(0), 0);
		// hmc.solve(surfs.get(0), surfs.get(1), 0);
		/*
		 * CubicVolumeFloat src=new CubicVolumeFloat(sourceVol);
		 * CubicVolumeFloat tar=new CubicVolumeFloat(targetVol);
		 * FastMarchingExtension fext=new FastMarchingExtension(this);
		 * fext.solve(src.toArray3d(), surf, 0,7); Point3f[][][] Qf=fext.getQ();
		 * FastMarchingExtension gext=new FastMarchingExtension(this);
		 * gext.solve(src.toArray3d(), fext.getQx(),fext.getQy(),fext.getQz(),
		 * 0,7);
		 * 
		 * //GenericMarchingExtension gext=new GenericMarchingExtension(this);
		 * //gext.solve(src.toArray3d(), surf, 0); Point3f[][][] Qg=gext.getQ();
		 * mapVol=new CubicVolumeFloat(rows,cols,slices,3);
		 * mapVol.setName("fmap"); registeredVol=new
		 * CubicVolumeFloat(rows,cols,slices,3); registeredVol.setName("gmap");
		 * //registeredVol=new CubicVolumeFloat(fext.getGradient());
		 * //registeredVol.setName("grad");
		 * 
		 * float[][][][] fmapMat=mapVol.toArray4d(); float[][][][]
		 * gmapMat=registeredVol.toArray4d(); Point3d r; FastMarchingGradient
		 * fmg = new FastMarchingGradient(this); float[][][][] gradQx =
		 * fmg.gradient(src.toArray3d(), fext.getQx(),Normalization.NONE);
		 * float[][][][] gradQy = fmg.gradient(src.toArray3d(),
		 * fext.getQy(),Normalization.NONE); float[][][][] gradQz =
		 * fmg.gradient(src.toArray3d(), fext.getQz(),Normalization.NONE);
		 * Vector3f v; for(int i=0;i<rows;i++){ for(int j=0;j<cols;j++){ for(int
		 * k=0;k<slices;k++){ if(Qf[i][j][k]!=null){
		 * r=GeomUtil.toSpherical(Qf[i][j][k]); fmapMat[i][j][k][0]=(float)r.x;
		 * fmapMat[i][j][k][1]=(float)r.y; fmapMat[i][j][k][2]=(float)r.z; }
		 * if(Qg[i][j][k]!=null){ r=GeomUtil.toSpherical(Qg[i][j][k]);
		 * gmapMat[i][j][k][0]=(float)r.x; gmapMat[i][j][k][1]=(float)r.y;
		 * gmapMat[i][j][k][2]=(float)r.z;
		 * 
		 * } } } } surfs=new ArrayList<EmbeddedSurface>();
		 * sphericalMap.setName(src.getName()); surfs.add(surf); EmbeddedSurface
		 * targetSurf=fext.mapToSurf(tar.toArray3d());
		 * targetSurf.setName(tar.getName()); surfs.add(targetSurf);
		 */
		// registeredVol.setName("gradient");
	}

	public ImageData getRegistered() {
		return registeredVol;
	}

	public ImageDataFloat getMap() {
		return mapVol;
	}

	public ArrayList<EmbeddedSurface> getEmbeddedSurfaces() {
		return surfs;
	}
}
