package edu.jhu.ece.iacl.algorithms.graphics.utilities;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.algorithms.topology.TopologyCorrection;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;

/**
 * Up-samples a level set and hopefully preserves the topology of the underlying
 * surface. This method was never really perfected and never used in any
 * important capacity.
 * 
 * @author Blake Lucas
 * 
 */
public class ResampleLevelSet extends AbstractCalculation {
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.4 $");
	}

	public ResampleLevelSet() {
		super();
		this.setLabel("Resample Level Set");
	}

	public ResampleLevelSet(AbstractCalculation parent) {
		super(parent);
		this.setLabel("Resample Level Set");
	}

	private int sgn(float val) {
		return (int) Math.signum(val);
	}

	public ImageDataFloat upsample(ImageData vol, int rule) {
		int rows = vol.getRows();
		int cols = vol.getCols();
		int slices = vol.getSlices();
		ImageDataFloat volf = new ImageDataFloat(vol);
		ImageDataFloat result = new ImageDataFloat(rows * 2 - 1, cols * 2 - 1,
				slices * 2 - 1);
		float[][][] resultMat = result.toArray3d();
		float[][][] volfMat = volf.toArray3d();
		for (int i = 0; i < 2 * rows - 1; i++) {
			for (int j = 0; j < 2 * cols - 1; j++) {
				for (int k = 0; k < 2 * slices - 1; k++) {
					resultMat[i][j][k] = Float.NaN;
				}
			}
		}
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					resultMat[i * 2][j * 2][k * 2] = volfMat[i][j][k];
				}
			}
		}
		float val1, val2, val3, val4;
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					val1 = volfMat[i][j][k];
					if (i < rows - 1)
						if (Math.abs(sgn(val1) + sgn(volfMat[i + 1][j][k])) == 2) {
							resultMat[i * 2 + 1][j * 2][k * 2] = 0.5f * (val1 + volfMat[i + 1][j][k]);
						}
					if (j < cols - 1)
						if (Math.abs(sgn(val1) + sgn(volfMat[i][j + 1][k])) == 2) {
							resultMat[i * 2][j * 2 + 1][k * 2] = 0.5f * (val1 + volfMat[i][j + 1][k]);
						}

					if (k < slices - 1)
						if (Math.abs(sgn(val1) + sgn(volfMat[i][j][k + 1])) == 2) {
							resultMat[i * 2][j * 2][k * 2 + 1] = 0.5f * (val1 + volfMat[i][j][k + 1]);
						}

					if (i < rows - 1 && j < cols - 1) {
						val1 = volfMat[i][j][k];
						val2 = volfMat[i][j + 1][k];
						val3 = volfMat[i + 1][j + 1][k];
						val4 = volfMat[i + 1][j][k];
						if (Math.abs(sgn(val1) + sgn(val2) + sgn(val3)
								+ sgn(val4)) == 4)
							resultMat[i * 2 + 1][j * 2 + 1][k * 2] = 0.25f * (val1
									+ val2 + val3 + val4);
					}
					if (j < cols - 1 && k < slices - 1) {
						val1 = volfMat[i][j][k];
						val2 = volfMat[i][j + 1][k];
						val3 = volfMat[i][j + 1][k + 1];
						val4 = volfMat[i][j][k + 1];
						if (Math.abs(sgn(val1) + sgn(val2) + sgn(val3)
								+ sgn(val4)) == 4)
							resultMat[i * 2][j * 2 + 1][k * 2 + 1] = 0.25f * (val1
									+ val2 + val3 + val4);
					}
					if (i < rows - 1 && k < slices - 1) {
						val1 = volfMat[i][j][k];
						val2 = volfMat[i + 1][j][k];
						val3 = volfMat[i + 1][j][k + 1];
						val4 = volfMat[i][j][k + 1];
						if (Math.abs(sgn(val1) + sgn(val2) + sgn(val3)
								+ sgn(val4)) == 4)
							resultMat[i * 2 + 1][j * 2][k * 2 + 1] = 0.25f * (val1
									+ val2 + val3 + val4);
					}
					if (i < rows - 1 && j < cols - 1 && k < slices - 1) {
						if (Math.abs(sgn(volfMat[i][j][k])
								+ sgn(volfMat[i + 1][j][k])
								+ sgn(volfMat[i][j + 1][k])
								+ sgn(volfMat[i + 1][j + 1][k + 1])
								+ sgn(volfMat[i][j][k + 1])
								+ sgn(volfMat[i + 1][j][k + 1])
								+ sgn(volfMat[i][j + 1][k + 1])
								+ sgn(volfMat[i + 1][j + 1][k + 1])) == 8)
							resultMat[i * 2 + 1][j * 2 + 1][k * 2 + 1] = 0.125f * (volfMat[i][j][k]
									+ volfMat[i + 1][j][k]
									+ volfMat[i][j + 1][k]
									+ volfMat[i + 1][j + 1][k + 1]
									+ volfMat[i][j][k + 1]
									+ volfMat[i + 1][j][k + 1]
									+ volfMat[i][j + 1][k + 1] + volfMat[i + 1][j + 1][k + 1]);
					}
				}
			}
		}
		IsoSurfaceOnGrid isosurf = new IsoSurfaceOnGrid();
		EmbeddedSurface surf = isosurf.solveOriginal(vol, rule, 0, false);
		System.out.println("TOPOLOGY " + surf.getNumberOfHoles());
		System.out.println("VERT COUNT " + surf.getVertexCount());
		SurfaceIntersector locator = new SurfaceIntersector(this, 12, surf);
		setTotalUnits(2 * rows);
		for (int i = 0; i < 2 * rows - 1; i++) {
			for (int j = 0; j < 2 * cols - 1; j++) {
				for (int k = 0; k < 2 * slices - 1; k++) {
					if (Float.isNaN(resultMat[i][j][k])) {
						resultMat[i][j][k] = (float) locator
								.signedDistance(new Point3f(0.5f * i, 0.5f * j,
										0.5f * k));
					}
				}
			}
			incrementCompletedUnits();
		}
		this.markCompleted();
		TopologyCorrection tc = new TopologyCorrection(result);
		result = tc.correctLevelSet(rule);
		result.setName(vol.getName() + "_up");
		return result;
	}
}
