package edu.jhu.ece.iacl.algorithms.graphics.utilities.rbf;

import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Abstract class for floating point radial basis function operations.
 * 
 * @author Blake
 * 
 */
public abstract class RadialBasisFunctionFloat {
	protected RadialFunctionType radialFunc;
	protected double alpha = 1;
	protected double C = 1;
	protected Point3f[] points;
	protected double[] lambda;
	protected double[] chi;

	protected abstract void computeCoefficients();

	public abstract float evalFunc(Point3f p1, Point3f p2);

	public abstract Vector3f evalFuncGradient(Point3f p1, Point3f p2);
}
