package edu.jhu.ece.iacl.algorithms.gvf;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.utility.ArrayUtil;
import edu.jhu.ece.iacl.jist.structures.vector.Vector3;

/**
 * Original solution to Gradient Vector Flow
 * 
 * @author Blake Lucas
 * 
 */
public class GradVecFlowOriginal extends GradVecFlow {
	private static final GradVecFlowOriginal gvf = new GradVecFlowOriginal();

	public static ImageData doSolve(ImageData f, float lambda,
			boolean normalize, int iter) {
		return gvf.solve(f, lambda, normalize, iter);
	}

	public GradVecFlowOriginal(AbstractCalculation parent) {
		super(parent);
	}

	public GradVecFlowOriginal() {
		super();
	}

	public float[][][][] process(float[][][][] Gfmat, 
			float lambda, boolean normalize, int ITER) {
		int i, _z, _y, _x;
		Vector3 del2;
		int xn = Gfmat.length;
		int yn = Gfmat[0].length;
		int zn = Gfmat[0][0].length;
		float[][][] SqrMagfmat= ArrayUtil.vectorMagnitude4D(Gfmat);
		float[][][][] Vmat = ArrayUtil.clone(Gfmat);
		float[][][][] Wmat = new float[xn][yn][zn][3]; 
		float[][][][] temp;
		setTotalUnits(ITER);
		for (i = 0; i < ITER; i++) {
			temp = Vmat;
			Vmat = Wmat;
			Wmat = temp; /*
						 * make the V point to the new volume which is used to
						 * hold result
						 */
			for (_x = 0; _x < xn; _x++) {
				for (_y = 0; _y < yn; _y++) {
					for (_z = 0; _z < zn; _z++) {
						del2 = Laplace3d.doSolve(Wmat, _x, _y, _z);
						/*
						 * this indeed is one sixth of laplacian but it is
						 * exactly the form I need when I want laplacian to be
						 * stable, because I need to divide it by 6, therefore,
						 * the following is correct
						 */

						Vmat[_x][_y][_z][2] = Wmat[_x][_y][_z][2] + del2.getZ().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][2] - Gfmat[_x][_y][_z][2])
								* SqrMagfmat[_x][_y][_z];
						Vmat[_x][_y][_z][1] = Wmat[_x][_y][_z][1] + del2.getY().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][1] - Gfmat[_x][_y][_z][1])
								* SqrMagfmat[_x][_y][_z];
						Vmat[_x][_y][_z][0] = Wmat[_x][_y][_z][0] + del2.getX().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][0] - Gfmat[_x][_y][_z][0])
								* SqrMagfmat[_x][_y][_z];
					}
				}
			}
			incrementCompletedUnits();
		}
		markCompleted();
		if (normalize) {
			System.out.println("normalizing...");
			ArrayUtil.normalizeComponentsOverwrite(Vmat);
		}
		return Vmat;
	}
	
	public ImageDataFloat process(ImageDataFloat Gf, 
			float lambda, boolean normalize, int ITER) {
		int i, _z, _y, _x;
		Vector3 del2;
		int xn = Gf.getRows();
		int yn = Gf.getCols();
		int zn = Gf.getSlices();
		String name=Gf.getName()+"_gvf";
		ImageDataFloat SqrMagf = ImageDataMath.vectorMagnitude4D(Gf); 
		float[][][][] Gfmat=Gf.toArray4d();
		float[][][] SqrMagfmat=SqrMagf.toArray3d();
		ImageDataFloat V = Gf.clone();
		float[][][][] Vmat=V.toArray4d();
		ImageDataFloat W= new ImageDataFloat(xn, yn, zn,3);
		float[][][][] Wmat=W.toArray4d();
		ImageDataFloat temp;// = new CubicVolumeFloat(xn, yn, zn,3);
		setTotalUnits(ITER);
		for (i = 0; i < ITER; i++) {
			temp = V;
			V = W;
			W = temp; /*
						 * make the V point to the new volume which is used to
						 * hold result
						 */
			Wmat=W.toArray4d();
			Vmat=V.toArray4d();
			for (_x = 0; _x < xn; _x++) {
				for (_y = 0; _y < yn; _y++) {
					for (_z = 0; _z < zn; _z++) {
						del2 = Laplace3d.doSolve(W, _x, _y, _z);
						/*
						 * this indeed is one sixth of laplacian but it is
						 * exactly the form I need when I want laplacian to be
						 * stable, because I need to divide it by 6, therefore,
						 * the following is correct
						 */

						Vmat[_x][_y][_z][2]=Wmat[_x][_y][_z][2] + del2.getZ().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][2] - Gfmat[_x][_y][_z][2])
								* SqrMagfmat[_x][_y][_z];
						Vmat[_x][_y][_z][1]=Wmat[_x][_y][_z][1] + del2.getY().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][1] - Gfmat[_x][_y][_z][1])
								* SqrMagfmat[_x][_y][_z];
						Vmat[_x][_y][_z][0]=Wmat[_x][_y][_z][0] + del2.getX().floatValue()
								- lambda
								* (Wmat[_x][_y][_z][0] - Gfmat[_x][_y][_z][0])
								* SqrMagfmat[_x][_y][_z];
					}
				}
			}
			incrementCompletedUnits();
		}
		markCompleted();
		if (normalize) {
			V.normalize();
		}
		V.setName(name);
		return V;
	}

	/**
	 * Solve GVF using original method
	 * 
	 * @param vol
	 *            matrix 3d
	 * @param lambda
	 *            lambda
	 * @param normalize
	 *            normalize if true
	 * @param iter
	 *            maximum iterations
	 * @return vector matrix3d
	 */
	public ImageData solve(ImageData _f, float lambda, boolean normalize,
			int iter) {
		ImageDataFloat f=new ImageDataFloat(_f);
		int xn = f.getRows();
		int yn = f.getCols();
		int zn = f.getSlices();
		//if(_f.getType()==VoxelType.UBYTE){
			System.out.println("Original");
			float[][][] tmp=f.toArray3d();
			for(int i=0;i<xn;i++){
				for(int j=0;j<yn;j++){
					for(int k=0;k<zn;k++){
						tmp[i][j][k]/=255.0f;
					}
				}
			}
		//}
		setLabel("Gradient Vector Flow");
		String name=f.getName()+"_gvf";
		//VectorMatrixX V = new VectorMatrixX(xn, yn, zn,new Vector3());
		//VectorMatrixX Gf = new VectorMatrixX(xn, yn, zn,new Vector3());
		ImageDataFloat Gf;
		ImageDataFloat V;
		ImageDataFloat SqrMagf;// = new CubicVolumeFloat(xn, yn, zn);

		Gf = Gradient3d.doSolve(f); /* compute the gradient of ivol */
		// calculate edge map
//		f = Gf.mag();
		f = ImageDataMath.vectorMagnitude4D(Gf);

		f.normalize();
		// calculate gradient of edge map

		Gf = Gradient3d.doSolve(f);
		// calculated euclidian norm
//		SqrMagf = Gf.mag();
		
		V=process(Gf, lambda, normalize, iter);

		V.setName(name);
		V.setHeader(_f.getHeader());
		return V;
	}


}
