package edu.jhu.ece.iacl.algorithms.tgdm;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.algorithms.graphics.GeometricUtilities;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.graphics.map.SphericalMapCorrection;
import edu.jhu.ece.iacl.algorithms.gvf.FastMarchingGradient;
import edu.jhu.ece.iacl.algorithms.gvf.FastMarchingGradient.Normalization;
import edu.jhu.ece.iacl.algorithms.tgdm.ProfileTGDM.Tracking;
import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedPointSet;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class TrackingTGDM extends GenericTGDM {
	// Correspondence points
	protected float[][][] Qx = null;
	protected float[][][] Qy = null;
	protected float[][][] Qz = null;
	// Initial Gradient
	protected Tracking tracking;
	protected boolean pdeEnabled = true;
	protected boolean mapInterpolationEnabled = true;
	protected static final double ALPHA=0.005;
	protected float[][][] lastPhi;
	protected float[][][] initPhi;
	EmbeddedSurface sphericalMap = null;

	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.6 $");
	}


	public TrackingTGDM(AbstractCalculation parent, int rule) {
		super(parent, rule);
	}

	public TrackingTGDM(int rule) {
		super(rule);
	}
	/*
	protected EmbeddedPointSet ps;
	public EmbeddedPointSet getPointSetCorrespondence(){
		return ps;
	}
	*/
	public static class EmbeddedNBPoint extends NBPoint{
		public Vector3d vec=null;
		//public Vector3d dqdt=null;
		public EmbeddedNBPoint(){
			super();
		}
		public String toString() {
			if (vec != null) {
				return "[(" + x + "," + y + "," + z + ") " + w + " " + vec
				+ "]";
			} else {
				return "[(" + x + "," + y + "," + z + ") " + w + "]";
			}
		}
	}

	protected EmbeddedNBPoint createNBPoint(){
		return new EmbeddedNBPoint();
	}
	protected double updatePoint(NBPoint nbPoint,ProfileTGDM profile){
		int LX, LY, LZ, HX, HY, HZ; /* Varibales implementing mirror boundary */
		double North, South, West, East, Current, Front, Back;
		/*
		 * Dmx (Dmy, Dmz) : backward difference Dpx (Dpy, Dpz) : forward
		 * difference D0x (D0y, D0z) : centered difference
		 */
		double Dmx, Dmy, Dpx, Dpy, D0x, D0y, D0z, Dxx, Dyy, Dxy;
		double Dmz, Dpz, Dzz, Dxz, Dyz;
		double SD0x, SD0y, SD0z; /* Temperory storage */
		int x,y,z;
		double K, G; /* Curvature, is the Vs above */
		double regionWeight = profile.getPressureForce();
		double externalWeight = profile.getExternalForce();
		double regionForce; /* pressure force */
		// NBPoint = narrowBand.get(NBIndex - 1);
		x = nbPoint.x;
		y = nbPoint.y;
		z = nbPoint.z;
		// System.out.printf("%d %d %d\n",d,i,j);
		LY = (y == 0) ? 1 : 0;
		HY = (y == (cols - 1)) ? 1 : 0;
		LZ = (z == 0) ? 1 : 0;
		HZ = (z == (slices - 1)) ? 1 : 0;
		LX = (x == 0) ? 1 : 0;
		HX = (x == (rows - 1)) ? 1 : 0; // j should correspond
		// to _x ?!

		North = implicitLevelSet[x][y - 1 + LY][z];
		South = implicitLevelSet[x][y + 1 - HY][z];
		West = implicitLevelSet[x - 1 + LX][y][z];
		East = implicitLevelSet[x + 1 - HX][y][z];
		Front = implicitLevelSet[x][y][z + 1 - HZ];
		Back = implicitLevelSet[x][y][z - 1 + LZ];
		Current = implicitLevelSet[x][y][z];
		// m for minus
		// p for plus
		Dmx = Current - West;
		Dpx = East - Current;
		Dmy = Current - North;
		Dpy = South - Current;
		Dmz = Current - Back;
		Dpz = Front - Current;
		// central differences
		D0x = (East - West) / 2;
		D0y = (South - North) / 2;
		D0z = (Front - Back) / 2;
		// second derivative
		Dxx = (West + East - Current - Current);
		Dyy = (North + South - Current - Current);
		Dzz = (Front + Back - Current - Current);
		// cross derivatives
		Dxy = (implicitLevelSet[x + 1 - HX][y + 1 - HY][z]
				+ implicitLevelSet[x - 1 + LX][y - 1 + LY][z]
				- implicitLevelSet[x - 1 + LX][y + 1 - HY][z] - implicitLevelSet[x
				+ 1 - HX][y - 1 + LY][z]) / 4;

		Dxz = (implicitLevelSet[x + 1 - HX][y][z + 1 - HZ]
				+ implicitLevelSet[x - 1 + LX][y][z - 1 + LZ]
				- implicitLevelSet[x - 1 + LX][y][z + 1 - HZ] - implicitLevelSet[x
				+ 1 - HX][y][z - 1 + LZ]) / 4;

		Dyz = (implicitLevelSet[x][y + 1 - HY][z + 1 - HZ]
				+ implicitLevelSet[x][y - 1 + LY][z - 1 + LZ]
				- implicitLevelSet[x][y - 1 + LY][z + 1 - HZ] - implicitLevelSet[x][y
				+ 1 - HY][z - 1 + LZ]) / 4;
		// PHI GRADIENT COMPONENTS SQUARED
		SD0x = D0x * D0x;
		SD0y = D0y * D0y;
		SD0z = D0z * D0z;

		// MEAN CURVATURE NUMERATOR
		K = (Dyy + Dzz)
				* SD0x
				+ (Dxx + Dzz)
				* SD0y
				+ (Dxx + Dyy)
				* SD0z
				- 2
				* (D0x * D0y * Dxy + D0x * D0z * Dxz + D0y * D0z
						* Dyz);
		// GAUSSIAN CURVATURE NUMERATOR
		G = (Dyy * Dzz - Dyz * Dyz)
				* SD0x
				+ (Dxx * Dzz - Dxz * Dxz)
				* SD0y
				+ (Dxx * Dyy - Dxy * Dxy)
				* SD0z
				+ 2
				* (D0x * D0y * (Dxz * Dyz - Dxy * Dzz) + D0x * D0z
						* (Dxy * Dyz - Dxz * Dyy) + D0y * D0z
						* (Dxy * Dxz - Dyz * Dxx));
		// CENTRAL DIFFERENCE PHI GRADIENT MAGNITUDE

		// Variable pressure field
		curvatureGrad.x = D0x;
		curvatureGrad.y = D0y;
		curvatureGrad.z = D0z;
		if (regionForces == null) {
			regionForce = regionWeight;
		} else {
			regionForce = regionWeight * regionForces[x][y][z];
		}
		if (regionForce > 0) {
			regionGrad.x = ((Dmx > 0) ? Dmx : 0)
					+ ((Dpx < 0) ? Dpx : 0);
			regionGrad.y = ((Dmy > 0) ? Dmy : 0)
					+ ((Dpy < 0) ? Dpy : 0);
			regionGrad.z = ((Dmz > 0) ? Dmz : 0)
					+ ((Dpz < 0) ? Dpz : 0);
		} else {
			regionGrad.x = ((Dmx < 0) ? Dmx : 0)
					+ ((Dpx > 0) ? Dpx : 0);
			regionGrad.y = ((Dmy < 0) ? Dmy : 0)
					+ ((Dpy > 0) ? Dpy : 0);
			regionGrad.z = ((Dmz < 0) ? Dmz : 0)
					+ ((Dpz > 0) ? Dpz : 0);
		}
		// ADVECTION FORCE FUNCTION
		if (advectionForces != null) {
			advectionForce = new Vector3d(
					advectionForces[x][y][z][0],
					advectionForces[x][y][z][1],
					advectionForces[x][y][z][2]);
			advectionForce.scale(externalWeight);
			advectionGrad.x = (advectionForce.x > 0) ? Dmx : Dpx;
			advectionGrad.y = (advectionForce.y > 0) ? Dmy : Dpy;
			advectionGrad.z = (advectionForce.z > 0) ? Dmz : Dpz;
		}
		if (tracking != Tracking.OFF) {
			((EmbeddedNBPoint)nbPoint).vec = profile.getEffectiveVelocity(K, G,
					curvatureGrad, regionForce, regionGrad,
					advectionForce, advectionGrad);
			((EmbeddedNBPoint)nbPoint).vec.scale(timeStep);
		}
		double tmp = implicitLevelSet[x][y][z]
				- timeStep
				* profile.getEffectiveForce(K, G, curvatureGrad,
						regionForce, regionGrad, advectionForce,
						advectionGrad);
		return tmp;
	}
	protected void endTGDM(ProfileTGDM profile){

		super.endTGDM(profile);
		//if tracking is enabled, map Qs back to surface
		if (tracking != Tracking.OFF) {
			mapToSurf(implicitLevelSet);
		}
		//Count the number of non-harmonic points
		/*
		if (tracking == Tracking.SPHERE||tracking==Tracking.SHELL) {
			HarmonicMapCorrection hmc = new HarmonicMapCorrection();
			hmc.nonHarmonicPoints(finalSurf, 0);
		}
		*/
	}
	public ImageDataFloat getCorrespondence() {
		//Get volume of correspondence points
		ImageDataFloat q = new ImageDataFloat(rows, cols, slices, 3);
		float[][][][] qmat = q.toArray4d();
		if (tracking == Tracking.SPHERE||tracking==Tracking.SHELL) {
			for (int z = 0; z < slices; z++) {
				for (int y = 0; y < cols; y++) {
					for (int x = 0; x < rows; x++) {
						Vector3f p = new Vector3f(Qx[x][y][z], Qy[x][y][z],
								Qz[x][y][z]);
						Point3d r = GeometricUtilities.toSpherical(p);
						qmat[x][y][z][0] = (float) r.x;
						qmat[x][y][z][1] = (float) r.y;
						qmat[x][y][z][2] = (float) r.z;
					}
				}
			}
		} else if (tracking == Tracking.POINT) {
			for (int z = 0; z < slices; z++) {
				for (int y = 0; y < cols; y++) {
					for (int x = 0; x < rows; x++) {
						qmat[x][y][z][0] = Qx[x][y][z];
						qmat[x][y][z][1] = Qy[x][y][z];
						qmat[x][y][z][2] = Qz[x][y][z];
					}
				}
			}
		}
		q.setName("embedding");
		return q;
	}



	public Tracking getTracking() {
		return tracking;
	}
	protected void initTGDM(ProfileTGDM profile) {
		super.initTGDM(profile);
		int x, y, z;
		if(tracking!=Tracking.OFF)lastPhi=new float[rows][cols][slices];
		if (tracking == Tracking.SPHERE || tracking == Tracking.SHELL) {
			//Copy embedded coordinate system to initial surface
			double[][] data = sphericalMap.getVertexData();
			if (data == null || data[0].length != 3) {
				data = new double[sphericalMap.getVertexCount()][3];
				for (int i = 0; i < data.length; i++) {
					Point3f p = sphericalMap.getVertex(i);
					data[i][0] = p.x;
					data[i][1] = p.y;
					data[i][2] = p.z;
				}
			}
			initSurf.setVertexData(data);
		} else if (tracking == Tracking.POINT && initPhi != null) {
			//Compute fast marching gradient for point correspondence
			FastMarchingGradient fmg = new FastMarchingGradient(this);
			initGrad = fmg.gradient(initPhi, Normalization.MAGNITUDE);
		}
		if (tracking == Tracking.SPHERE) {
			FastMarchingSphericalExtension fext = new FastMarchingSphericalExtension(
					this);
			fext.solve(implicitLevelSet, initSurf, 0,maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
		} else if (tracking == Tracking.POINT) {
			FastMarchingPointExtension fext = new FastMarchingPointExtension(
					this);
			fext.solve(implicitLevelSet, initSurf, 0,maxSignedDist);	
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();

		} else if (tracking == Tracking.SHELL) {
			FastMarchingSphericalExtension fext = new FastMarchingSphericalExtension(
					this);
			fext.solve(implicitLevelSet,initSurf, 0, maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
			double scale = ALPHA / maxSignedDist;
			System.out.println("INIT SHELL TRACKING "+scale);
			double tmpx=0,tmpy,tmpz;
			for (x = 0; x < rows; x++) {
				for (y = 0; y < cols; y++) {
					for (z = 0; z < slices; z++) {
						double phi = scale * implicitLevelSet[x][y][z] + 1;
						tmpx=Qx[x][y][z] *= phi;
						tmpy=Qy[x][y][z] *= phi;
						tmpz=Qz[x][y][z] *= phi;
						/*
						if(Double.isNaN(tmpx)||Double.isNaN(tmpy)||Double.isNaN(tmpz)){
							System.err.println("Start POINT IS NaN "+tmpx+" "+tmpy+" "+tmpz+" "+x+" "+y+" "+z);
						}
						*/
					}
				}
			}
		}
		if (tracking != Tracking.OFF) {
			for (x = 0; x < rows; x++) {
				for (y = 0; y < cols; y++) {
					for (z = 0; z < slices; z++) {
						lastPhi[x][y][z] = implicitLevelSet[x][y][z];
					}
				}
			}
		}
		System.gc();
	}
	/**
	 * Estimate distance to surface by interpolating level set
	 * @param x
	 * @param y
	 * @param z
	 * @return
	 */
	public double interpolateDistance(double x, double y, double z) {
		int i0, j0, k0, i1, j1, k1;
		double dx, dy, dz, hx, hy, hz;
		j0 = (int) Math.floor(x);
		i0 = (int) Math.floor(y);
		k0 = (int) Math.floor(z);
		j1 = j0 + 1;
		i1 = i0 + 1;
		k1 = k0 + 1;

		if (j0 < 0 || j1 > (rows - 1) || i0 < 0 || i1 > (cols - 1) || k0 < 0
				|| k1 > (slices - 1)) {
			System.out.println("INVALID " + x + " " + y + " " + z + " " + rows
					+ " " + cols + " " + slices);
			return 0;
		} else {
			dx = x - j0;
			dy = y - i0;
			dz = z - k0;
			/* Introduce more variables to reduce computation */
			hx = 1.0 - dx;
			hy = 1.0 - dy;
			hz = 1.0 - dz;
			return (((initPhi[j0][i0][k0] * hx + initPhi[j1][i0][k0] * dx) * hy + (initPhi[j0][i1][k0]
					* hx + initPhi[j1][i1][k0] * dx)
					* dy)
					* hz + ((initPhi[j0][i0][k1] * hx + initPhi[j1][i0][k1]
					* dx)
					* hy + (initPhi[j0][i1][k1] * hx + initPhi[j1][i1][k1] * dx)
					* dy)
					* dz);
		}
	}
	/**
	 * Estimate normal at surface by interpolating level set gradient
	 * @param x
	 * @param y
	 * @param z
	 * @return
	 */
	public Vector3f interpolateNormal(double x, double y, double z) {
		int i0, j0, k0, i1, j1, k1;
		double dx, dy, dz, hx, hy, hz;
		j0 = (int) Math.floor(x);
		i0 = (int) Math.floor(y);
		k0 = (int) Math.floor(z);
		j1 = j0 + 1;
		i1 = i0 + 1;
		k1 = k0 + 1;
		Vector3f v = new Vector3f();
		if (j0 < 0 || j1 > (rows - 1) || i0 < 0 || i1 > (cols - 1) || k0 < 0
				|| k1 > (slices - 1)) {
			System.out.println("INVALID " + x + " " + y + " " + z + " " + rows
					+ " " + cols + " " + slices);
			j0 = Math.min(Math.max(j0, 0), rows - 1);
			i0 = Math.min(Math.max(i0, 0), cols - 1);
			k0 = Math.min(Math.max(k0, 0), slices - 1);

			v.x = initGrad[j0][i0][k0][0];
			v.y = initGrad[j0][i0][k0][1];
			v.z = initGrad[j0][i0][k0][2];
			return v;
		} else {
			dx = x - j0;
			dy = y - i0;
			dz = z - k0;
			/* Introduce more variables to reduce computation */
			hx = 1.0 - dx;
			hy = 1.0 - dy;
			hz = 1.0 - dz;
			v.x = (float) (((initGrad[j0][i0][k0][0] * hx + initGrad[j1][i0][k0][0]
					* dx)
					* hy + (initGrad[j0][i1][k0][0] * hx + initGrad[j1][i1][k0][0]
					* dx)
					* dy)
					* hz + ((initGrad[j0][i0][k1][0] * hx + initGrad[j1][i0][k1][0]
					* dx)
					* hy + (initGrad[j0][i1][k1][0] * hx + initGrad[j1][i1][k1][0]
					* dx)
					* dy)
					* dz);
			v.y = (float) (((initGrad[j0][i0][k0][1] * hx + initGrad[j1][i0][k0][1]
					* dx)
					* hy + (initGrad[j0][i1][k0][1] * hx + initGrad[j1][i1][k0][1]
					* dx)
					* dy)
					* hz + ((initGrad[j0][i0][k1][1] * hx + initGrad[j1][i0][k1][1]
					* dx)
					* hy + (initGrad[j0][i1][k1][1] * hx + initGrad[j1][i1][k1][1]
					* dx)
					* dy)
					* dz);
			v.z = (float) (((initGrad[j0][i0][k0][2] * hx + initGrad[j1][i0][k0][2]
					* dx)
					* hy + (initGrad[j0][i1][k0][2] * hx + initGrad[j1][i1][k0][2]
					* dx)
					* dy)
					* hz + ((initGrad[j0][i0][k1][2] * hx + initGrad[j1][i0][k1][2]
					* dx)
					* hy + (initGrad[j0][i1][k1][2] * hx + initGrad[j1][i1][k1][2]
					* dx)
					* dy)
					* dz);
			GeometricUtilities.normalize(v);
			return v;
		}
	}
	/**
	 * Interpolate correspondence point
	 * @param x
	 * @param y
	 * @param z
	 * @return
	 */
	public Point3f interpolateQ(double x, double y, double z) {
		int i0, j0, k0, i1, j1, k1;
		double dx, dy, dz, hx, hy, hz;
		j0 = (int) Math.floor(x);
		i0 = (int) Math.floor(y);
		k0 = (int) Math.floor(z);
		j1 = j0 + 1;
		i1 = i0 + 1;
		k1 = k0 + 1;
		Point3f v = new Point3f();
		if (j0 < 0 || j1 > (rows - 1) || i0 < 0 || i1 > (cols - 1) || k0 < 0
				|| k1 > (slices - 1)) {
			System.out.println("INVALID " + x + " " + y + " " + z + " " + rows
					+ " " + cols + " " + slices);
			j0 = Math.min(Math.max(j0, 0), rows - 1);
			i0 = Math.min(Math.max(i0, 0), cols - 1);
			k0 = Math.min(Math.max(k0, 0), slices - 1);

			v.x = initGrad[j0][i0][k0][0];
			v.y = initGrad[j0][i0][k0][1];
			v.z = initGrad[j0][i0][k0][2];
			return v;
		} else {
			dx = x - j0;
			dy = y - i0;
			dz = z - k0;
			/* Introduce more variables to reduce computation */
			hx = 1.0 - dx;
			hy = 1.0 - dy;
			hz = 1.0 - dz;
			v.x = (float) (((Qx[j0][i0][k0] * hx + Qx[j1][i0][k0] * dx) * hy + (Qx[j0][i1][k0]
					* hx + Qx[j1][i1][k0] * dx)
					* dy)
					* hz + ((Qx[j0][i0][k1] * hx + Qx[j1][i0][k1] * dx) * hy + (Qx[j0][i1][k1]
					* hx + Qx[j1][i1][k1] * dx)
					* dy)
					* dz);
			v.y = (float) (((Qy[j0][i0][k0] * hx + Qy[j1][i0][k0] * dx) * hy + (Qy[j0][i1][k0]
					* hx + Qy[j1][i1][k0] * dx)
					* dy)
					* hz + ((Qy[j0][i0][k1] * hx + Qy[j1][i0][k1] * dx) * hy + (Qy[j0][i1][k1]
					* hx + Qy[j1][i1][k1] * dx)
					* dy)
					* dz);
			v.z = (float) (((Qz[j0][i0][k0] * hx + Qz[j1][i0][k0] * dx) * hy + (Qz[j0][i1][k0]
					* hx + Qz[j1][i1][k0] * dx)
					* dy)
					* hz + ((Qz[j0][i0][k1] * hx + Qz[j1][i0][k1] * dx) * hy + (Qz[j0][i1][k1]
					* hx + Qz[j1][i1][k1] * dx)
					* dy)
					* dz);
			return v;
		}
	}

	public boolean isMapInterpolationEnabled() {
		return mapInterpolationEnabled;
	}
	/**
	 * Is transportation of coordinate system enabled
	 * @return
	 */
	public boolean isPdeEnabled() {
		return pdeEnabled;
	}

	protected void updateNarrowBand(ProfileTGDM profile) {
		super.updateNarrowBand(profile);
		if (!pdeEnabled){
			System.out.println("PDE IS NOT ENABLED");
			return;
		}
		int count = 0;
		int n = 0;
		double maxV = 0, maxVx = 0, maxVy = 0, maxVz = 0, maxVd = 0;
		double meanV = 0;
		Vector3f norm;
		double sum = 0;
		count = 0;
		for (NBPoint p : narrowBand) {
			double l = (((EmbeddedNBPoint)p).vec != null) ? ((EmbeddedNBPoint)p).vec.length() : 0;
			if (l < 1) {
				sum += l;
				count++;
			}
		}
		meanV = sum / count;
		// Assume exponential distribution
		double maxDevV = 10 * meanV;
		count = 0;
		meanV = 0;
		if (tracking == Tracking.SPHERE) {
			FastMarchingGradient fmg = new FastMarchingGradient(this);
			// fmg.velocity(lastPhi, Phi, narrowBand);
			float[][] gradQx = fmg.gradientUpwind(lastPhi, Qx, narrowBand,
					Normalization.NONE);
			float[][] gradQy = fmg.gradientUpwind(lastPhi, Qy, narrowBand,
					Normalization.NONE);
			float[][] gradQz = fmg.gradientUpwind(lastPhi, Qz, narrowBand,
					Normalization.NONE);
			for (NBPoint p : narrowBand) {
				float[] gx = gradQx[n];
				float[] gy = gradQy[n];
				float[] gz = gradQz[n];
				Vector3f q = new Vector3f(Qx[p.x][p.y][p.z], Qy[p.x][p.y][p.z],
						Qz[p.x][p.y][p.z]);

				Vector3d v = (((EmbeddedNBPoint)p).vec != null) ? ((EmbeddedNBPoint)p).vec : new Vector3d();
				if (v.length() >= maxDevV) {
					v = new Vector3d(0, 0, 0);
				} else {
					meanV += v.length();
					count++;
				}
				Vector3d vx = new Vector3d(gx[0], gx[1], gx[2]);
				Vector3d vy = new Vector3d(gy[0], gy[1], gy[2]);
				Vector3d vz = new Vector3d(gz[0], gz[1], gz[2]);
				maxV = Math.max(v.length(), maxV);
				maxVx = Math.max(vx.length(), maxVx);
				maxVy = Math.max(vy.length(), maxVy);
				maxVz = Math.max(vz.length(), maxVz);
				maxVd = Math.max(Math.max(maxVd, Math.abs(v.dot(vz))), Math
						.max(Math.max(maxVd, Math.abs(v.dot(vx))), Math.max(
								maxVd, Math.abs(v.dot(vy)))));
				Vector3d dqdt=new Vector3d(v.dot(vx),v.dot(vy),v.dot(vz));
				q.x -= dqdt.x;
				q.y -= dqdt.y;
				q.z -= dqdt.z;
				//((EmbeddedNBPoint)p).dqdt=dqdt;
				GeometricUtilities.normalize(q);

				lastPhi[p.x][p.y][p.z] = (float)p.w;
				Qx[p.x][p.y][p.z] = q.x;
				Qy[p.x][p.y][p.z] = q.y;
				Qz[p.x][p.y][p.z] = q.z;
				
				n++;
			}
		} else if (tracking == Tracking.POINT) {
			FastMarchingGradient fmg = new FastMarchingGradient(this);
			// fmg.velocity(lastPhi, Phi, narrowBand);
			float[][] gradQx = fmg.gradientUpwind(lastPhi, Qx, narrowBand,
					Normalization.NONE);
			float[][] gradQy = fmg.gradientUpwind(lastPhi, Qy, narrowBand,
					Normalization.NONE);
			float[][] gradQz = fmg.gradientUpwind(lastPhi, Qz, narrowBand,
					Normalization.NONE);
			for (NBPoint p : narrowBand) {
				float[] gx = gradQx[n];
				float[] gy = gradQy[n];
				float[] gz = gradQz[n];
				Vector3f q = new Vector3f(Qx[p.x][p.y][p.z], Qy[p.x][p.y][p.z],
						Qz[p.x][p.y][p.z]);

				Vector3d v = (((EmbeddedNBPoint)p).vec != null) ? ((EmbeddedNBPoint)p).vec : new Vector3d();
				if (v.length() >= maxDevV) {
					v = new Vector3d(0, 0, 0);
				} else {
					meanV += v.length();
					count++;
				}
				Vector3d vx = new Vector3d(gx[0], gx[1], gx[2]);
				Vector3d vy = new Vector3d(gy[0], gy[1], gy[2]);
				Vector3d vz = new Vector3d(gz[0], gz[1], gz[2]);

				maxV = Math.max(v.length(), maxV);
				maxVx = Math.max(vx.length(), maxVx);
				maxVy = Math.max(vy.length(), maxVy);
				maxVz = Math.max(vz.length(), maxVz);
				maxVd = Math.max(Math.max(maxVd, Math.abs(v.dot(vz))), Math
						.max(Math.max(maxVd, Math.abs(v.dot(vx))), Math.max(
								maxVd, Math.abs(v.dot(vy)))));

				/*
				 * norm=interpolateNormal(q.x, q.y, q.z); Matrix3f Pr=new
				 * Matrix3f(new float[]{ 1-norm.x*norm.x, -norm.x*norm.y,
				 * -norm.x*norm.z, -norm.y*norm.x, 1-norm.y*norm.y,
				 * -norm.y*norm.z, -norm.z*norm.x, -norm.z*norm.y,
				 * 1-norm.z*norm.z});
				 */
				// Project variation to plane
				// Pr.transform(vx);
				// Pr.transform(vy);
				// Pr.transform(vz);
				q.x -= (v.dot(vx));
				q.y -= (v.dot(vy));
				q.z -= (v.dot(vz));
				// Project point to surface
				float d = (float) interpolateDistance(q.x, q.y, q.z);
				norm = interpolateNormal(q.x, q.y, q.z);
				norm.scale(-d);
				q.add(norm);
				lastPhi[p.x][p.y][p.z] = (float)p.w;
				Qx[p.x][p.y][p.z] = q.x;
				Qy[p.x][p.y][p.z] = q.y;
				Qz[p.x][p.y][p.z] = q.z;
				n++;
			}

		} else if (tracking == Tracking.SHELL) {
			FastMarchingGradient fmg = new FastMarchingGradient(this);
			// fmg.velocity(lastPhi, Phi, narrowBand);
			float[][] gradQx = fmg.gradientUpwind(lastPhi, Qx, narrowBand,
					Normalization.NONE);
			float[][] gradQy = fmg.gradientUpwind(lastPhi, Qy, narrowBand,
					Normalization.NONE);
			float[][] gradQz = fmg.gradientUpwind(lastPhi, Qz, narrowBand,
					Normalization.NONE);
			for (NBPoint p : narrowBand) {
				float[] gx = gradQx[n];
				float[] gy = gradQy[n];
				float[] gz = gradQz[n];
				Vector3f q = new Vector3f(Qx[p.x][p.y][p.z], Qy[p.x][p.y][p.z],
						Qz[p.x][p.y][p.z]);
				//System.out.println(this.getClass().getSimpleName()+" Q "+q);
				Vector3d v = (((EmbeddedNBPoint)p).vec != null) ? ((EmbeddedNBPoint)p).vec : new Vector3d();
				if (v.length() >= maxDevV) {
					v = new Vector3d(0, 0, 0);
				} else {
					meanV += v.length();
					count++;
				}
				Vector3d vx = new Vector3d(gx[0], gx[1], gx[2]);
				Vector3d vy = new Vector3d(gy[0], gy[1], gy[2]);
				Vector3d vz = new Vector3d(gz[0], gz[1], gz[2]);
				maxV = Math.max(v.length(), maxV);
				maxVx = Math.max(vx.length(), maxVx);
				maxVy = Math.max(vy.length(), maxVy);
				maxVz = Math.max(vz.length(), maxVz);
				maxVd = Math.max(Math.max(maxVd, Math.abs(v.dot(vz))), Math
						.max(Math.max(maxVd, Math.abs(v.dot(vx))), Math.max(
								maxVd, Math.abs(v.dot(vy)))));
				Vector3d dqdt=new Vector3d(v.dot(vx),v.dot(vy),v.dot(vz));
				q.x -= dqdt.x;
				q.y -= dqdt.y;
				q.z -= dqdt.z;

				//((EmbeddedNBPoint)p).dqdt=dqdt;
				lastPhi[p.x][p.y][p.z] = (float)p.w;
				Qx[p.x][p.y][p.z] = q.x;
				Qy[p.x][p.y][p.z] = q.y;
				Qz[p.x][p.y][p.z] = q.z;
				n++;
			}
		}
		if(tracking!=Tracking.OFF){
			meanV /= count;
			System.out.println(this.getClass().getSimpleName()+" meanV " + meanV + " PERCENT " + count / (float) n
					+ " VELOCITY " + maxV + " GX " + maxVx + " GY " + maxVy
					+ " GZ " + maxVz);
		}
	}

	protected void mapToSurf(float[][][] Phi) {
		double[][] dat = new double[finalSurf.getVertexCount()][3];
		for (int i = 0; i < dat.length; i++) {
			Point3f p = finalSurf.getVertex(i);

			Point3f pl = new Point3f((float) Math.floor(p.x), (float) Math
					.floor(p.y), (float) Math.floor(p.z));
			Point3f ph = new Point3f((float) Math.ceil(p.x), (float) Math
					.ceil(p.y), (float) Math.ceil(p.z));
			Point3f p1 = new Point3f(Qx[(int) pl.x][(int) pl.y][(int) pl.z],
					Qy[(int) pl.x][(int) pl.y][(int) pl.z],
					Qz[(int) pl.x][(int) pl.y][(int) pl.z]);
			Point3f p2 = new Point3f(Qx[(int) ph.x][(int) ph.y][(int) ph.z],
					Qy[(int) ph.x][(int) ph.y][(int) ph.z],
					Qz[(int) ph.x][(int) ph.y][(int) ph.z]);
			if (mapInterpolationEnabled) {
				if (tracking == Tracking.SPHERE) {
					double d1 = pl.distance(p);
					double d2 = ph.distance(p);
					double t = (d1 + d2 > 1E-10) ? d1 / (d1 + d2) : 0;
					Vector3f ret = GeometricUtilities.slerp(p1, p2, t);
					dat[i][0] = ret.x;
					dat[i][1] = ret.y;
					dat[i][2] = ret.z;
				} else if (tracking == Tracking.POINT) {
					double d1 = pl.distance(p);
					double d2 = ph.distance(p);
					double t = (d1 + d2 > 1E-10) ? d1 / (d1 + d2) : 0;
					Vector3f ret = GeometricUtilities.interp(p1, p2, t);
					dat[i][0] = ret.x;
					dat[i][1] = ret.y;
					dat[i][2] = ret.z;
				} else if (tracking == Tracking.SHELL) {
					double d1 = pl.distance(p);
					double d2 = ph.distance(p);
					GeometricUtilities.normalize(p1);
					GeometricUtilities.normalize(p2);
					double t = (d1 + d2 > 1E-10) ? d1 / (d1 + d2) : 0;
					Vector3f ret = GeometricUtilities.slerp(p1, p2, t);
					dat[i][0] = ret.x;
					dat[i][1] = ret.y;
					dat[i][2] = ret.z;
				}
			} else {
				if (tracking == Tracking.SHELL) {
					GeometricUtilities.normalize(p1);
					GeometricUtilities.normalize(p2);
				}
				if (Phi[(int) pl.x][(int) pl.y][(int) pl.z] < Phi[(int) ph.x][(int) ph.y][(int) ph.z]) {
					dat[i][0] = p1.x;
					dat[i][1] = p1.y;
					dat[i][2] = p1.z;
				} else {

					dat[i][0] = p2.x;
					dat[i][1] = p2.y;
					dat[i][2] = p2.z;
				}

			}
			if(Double.isNaN(dat[i][0])||Double.isInfinite(dat[i][0])||
					Double.isNaN(dat[i][1])||Double.isInfinite(dat[i][1])
					||Double.isNaN(dat[i][2])||Double.isInfinite(dat[i][2])){
				
				dat[i][0] = 0;
				dat[i][1] = 0;
				dat[i][2] = 0;
				System.err.println("Q IS NaN "+p1+" "+p2+" "+pl+" "+ph+" "+mapInterpolationEnabled+" "+tracking);
			}
		}
		finalSurf.setVertexData(dat);
	}

	protected void endNarrowBand(ProfileTGDM profile) {
		super.endNarrowBand(profile);
		Point3f[] pts=new Point3f[narrowBand.size()];
		int i=0;
		double[][] ptData=new double[narrowBand.size()][3];
		/*
		for(NBPoint pt:narrowBand){
			pts[i]=new Point3f(Qx[pt.x][pt.y][pt.z],Qy[pt.x][pt.y][pt.z],Qz[pt.x][pt.y][pt.z]);
			Vector3d dqdt=((EmbeddedNBPoint)pt).vec;
			ptData[i][0]=dqdt.x;
			ptData[i][1]=dqdt.y;
			ptData[i][2]=dqdt.z;
			
			i++;
		}
		
		ps=new EmbeddedPointSet(pts);
		ps.setName(sphericalMap.getName()+".points");
		ps.setPointData(ptData);
		*/
		int rows = implicitLevelSet.length;
		int cols = implicitLevelSet[0].length;
		int slices = implicitLevelSet[0][0].length;
		int x, y, z;
		if (tracking == Tracking.SPHERE) {
			FastMarchingSphericalExtension fext = new FastMarchingSphericalExtension(
					this);
			fext.solve(implicitLevelSet, Qx, Qy, Qz, null, 0, maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
		} else if (tracking == Tracking.POINT) {
			FastMarchingPointExtension fext = new FastMarchingPointExtension(
					this);
			fext.solve(implicitLevelSet, Qx, Qy, Qz, null, 0, maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
		} else if (tracking == Tracking.SHELL) {
			FastMarchingSphericalExtension fext = new FastMarchingSphericalExtension(
					this);
			fext.solve(implicitLevelSet, Qx, Qy, Qz, null, 0, maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
			double scale = ALPHA/ maxSignedDist;
			double tmpx,tmpy,tmpz;
			for (x = 0; x < rows; x++) {
				for (y = 0; y < cols; y++) {
					for (z = 0; z < slices; z++) {
						double phi = scale * implicitLevelSet[x][y][z] + 1;
						tmpx=Qx[x][y][z] *= phi;
						tmpy=Qy[x][y][z] *= phi;
						tmpz=Qz[x][y][z] *= phi;
						if(tmpx==Double.NaN||tmpy==Double.NaN||tmpz==Double.NaN){
							System.out.println("End POINT IS NaN "+tmpx+" "+tmpy+" "+tmpz+" "+x+" "+y+" "+z);
						}
					}
				}
			}
		}
		if (tracking != Tracking.OFF) {
			for (x = 0; x < rows; x++) {
				for (y = 0; y < cols; y++) {
					for (z = 0; z < slices; z++) {
						lastPhi[x][y][z] = implicitLevelSet[x][y][z];
					}
				}
			}

			System.gc();
		}
	}
	public void setMapInterpolationEnabled(boolean mapInterpolationEnabled) {
		this.mapInterpolationEnabled = mapInterpolationEnabled;
	}

	public void setPdeEnabled(boolean pdeEnabled) {
		this.pdeEnabled = pdeEnabled;
	}
	public void setTracking(Tracking tracking) {
		this.tracking = tracking;
	}
	public void setSphericalMap(EmbeddedSurface sphericalMap) {
		this.sphericalMap = sphericalMap;
	}

	


	public ImageDataFloat solveRegisterSurface(ImageData source,
			ImageData target, float curvatureForce, float externalForce,
			float pressureForce, int maxiters, boolean exactMatch) {
		rows = target.getRows();
		cols = target.getCols();
		slices = target.getSlices();
		df = new DistanceField(this);
		ImageDataFloat phi = new ImageDataFloat(source);
		float[][][] Phi = phi.toArray3d();
		initPhi = new float[rows][cols][slices];
		for (int x = 0; x < rows; x++) {
			for (int y = 0; y < cols; y++) {
				for (int z = 0; z < slices; z++) {
					initPhi[x][y][z] = Phi[x][y][z];
				}
			}
		}
		float[][][] VpM = (new ImageDataFloat(target)).toArray3d();
		RegisterCortexProfile profile;
		innerBound = null;
		outerBound = null;
		skeletalBound = null;

		this.advectionForces = null;
		regionForces = VpM;
		implicitLevelSet = Phi;

		execute(profile = new RegisterCortexProfile(-curvatureForce,
				externalForce, -pressureForce, 0, maxiters));// fphi.toArray3d()
		ImageDataFloat vol;
		if (exactMatch) {
			FastMarchingSphericalExtension fext = new FastMarchingSphericalExtension(
					this);
			fext.solve(VpM, Qx, Qy, Qz, null, 0, maxSignedDist);
			Qx = fext.getQx();
			Qy = fext.getQy();
			Qz = fext.getQz();
			IsoSurfaceOnGrid isogrid = new IsoSurfaceOnGrid();
			vol = new ImageDataFloat(VpM);
			finalSurf = isogrid.solveOriginal(vol, connectivityRule, 0, false);
			mapToSurf(VpM);
		} else {
			vol = new ImageDataFloat(Phi);
		}
		if (tracking == Tracking.SPHERE) {
			SphericalMapCorrection harmonic = new SphericalMapCorrection(this,
					0.8f, 0.1f, 5);
			harmonic.solve(initSurf, finalSurf, 0);
		}

		vol.setName(target.getName()+ "_reg");
		initSurf.setName(source.getName() + "_reg");
		finalSurf.setName(target.getName() + "_reg");
		return vol;
	}

	public ImageDataFloat solveSmoothSurface(ImageData initPhi_,
			float curvatureForce, int maxiters) {
		df = new DistanceField(this);
		ImageDataFloat phi = new ImageDataFloat(initPhi_);
		float[][][] Phi = phi.toArray3d();
		rows = initPhi_.getRows();
		cols = initPhi_.getCols();
		slices = initPhi_.getSlices();
		System.out.println("Fast Marching...");
		phi = df.solve(phi, 8);
		Phi = phi.toArray3d();
		initPhi = new float[rows][cols][slices];
		double max_dist=0;
		for (int x = 0; x < rows; x++) {
			for (int y = 0; y < cols; y++) {
				for (int z = 0; z < slices; z++) {
					float tmp=initPhi[x][y][z] = Phi[x][y][z];
					max_dist=Math.max(max_dist,tmp);
				}
			}
		}
		System.out.println("Initial Max Distance "+max_dist);
		innerBound = null;
		outerBound = null;
		regionForces = null;
		implicitLevelSet = Phi;
		skeletalBound = null;
		this.advectionForces = null;
		regionForces = null;
		execute(new SmoothCortexProfile(-curvatureForce, 0, 0, 0, maxiters));// fphi.toArray3d()
		if (tracking == Tracking.SPHERE || tracking == Tracking.SHELL) {
			SphericalMapCorrection harmonic = new SphericalMapCorrection(this,
					0.8f, 0.1f, 5);
			harmonic.solve(initSurf, finalSurf, 0);
		}
		ImageDataFloat vol = new ImageDataFloat(Phi);
		vol.setName(initPhi_.getName() + "_inf");
		initSurf.setName(initPhi_.getName());
		finalSurf.setName(initPhi_.getName() + "_inf");

		return vol;
	}

}
