package edu.jhu.ece.iacl.algorithms.thickness;

import java.awt.Color;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

/**
 * Compute thickness by subtracting level sets
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class LevelSetThickness extends ThicknessSolver{
	public LevelSetThickness(double lambda,double isoVal,double lagrangeDeltaT){
		super(lambda,isoVal,lagrangeDeltaT);
	}	
	
	public LevelSetThickness(){
		super();
	}
	
	/**
	 * Compute level set thickness
	 */
	public void solve(ImageData innerVolTmp, ImageData outerVolTmp) {
		int i, j, k;
		
		this.innerVol = new ImageDataFloat(innerVolTmp);
		this.outerVol = new ImageDataFloat(outerVolTmp);
		
		rows = innerVol.getRows();
		cols = innerVol.getCols();
		slices = innerVol.getSlices();
		
		if(ADJUST_BOUNDARY) adjustBoundary(innerVol, outerVol);

		thicknessVol = new ImageDataFloat(rows, cols, slices);
		thicknessMat = thicknessVol.toArray3d();
		
		minThickness = 1E30;
		maxThickness = -1E30;
		meanThickness = 0;
		float thick;
		double sqrs = 0;
		double sum = 0;
		double count = 0;
		
		//DistanceField df=new DistanceField(this);
		//innerVol=df.solve((ImageDataFloat)innerVol, 25);
		//outerVol=df.solve((ImageDataFloat)outerVol, 25);
		
		setTotalUnits(rows);
		setLabel("Subtracting level sets");
		levelSetVol = new ImageDataFloat(rows, cols, slices);
		for(i = 0; i < rows; i++){
			for(j = 0; j < cols; j++){
				for(k = 0; k < slices; k++){
					double val1 = outerVol.getDouble(i, j, k);
					double val2 = innerVol.getDouble(i, j, k);
					
					thicknessMat[i][j][k] = thick = (float)Math.abs(val2-val1);
					
					if(val1 < 0 && val2 >= 0 || val1 >= 0 && val2 < 0){
						minThickness = Math.min(minThickness, thick);
						maxThickness = Math.max(maxThickness, thick);
						sqrs += (thick)*(thick);
						sum += thick;
						count++;
					}
				}
			}
			incrementCompletedUnits();
		}
		meanThickness = (sum/count);
		stdevThickness = Math.sqrt((sqrs-sum*sum/count)/(count-1));

		thicknessVol.setName(innerVol.getName() + "_thick");
		markCompleted();
		
		setLabel("Updating surfaces");
		setTotalUnits(1);
		updateSurfaces();		
		markCompleted();		
	}
	
	/**
	 * Interpolate volumetric thickness measurements and map them to the surface
	 */
	protected void mapThickness(EmbeddedSurface mesh){
		int vertCount = mesh.getVertexCount();
		Point3f p = new Point3f();
		for(int n = 0; n<vertCount; n++){
			mesh.getCoordinate(n,p);
			mesh.setVertexData(n, new double[]{interpolateThickness(p.x, p.y, p.z)});

			Color c = Color.getHSBColor((float)((mesh.getThickness(n)-minThickness)/(maxThickness-minThickness)), 1.0f, 0.4f);
			mesh.setColor(n, c);
		}
	}
	
	@Override
	protected void computeThickness() {
		// TODO Auto-generated method stub
		
	}

}
