package edu.jhu.ece.iacl.algorithms.thickness.grid;

import java.util.ArrayList;

import javax.vecmath.Point2d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
/**
 * Abstract class for grid nodes
 * 
 * @author Blake Lucas
 */
import edu.jhu.ece.iacl.jist.structures.data.Indexable;
public abstract class EmbeddedNode implements Indexable<EmbeddedNode>{

	public static final int NORTH=0,SOUTH=1,EAST=2,WEST=3,UP=4,DOWN=5;
	public static final byte OUTSIDE_NARROW_BAND=5;
	public static final byte OUTSIDE_OUTER=4;
	public static final byte JUST_OUTSIDE_OUTER_BOUNDARY=3;
	public static final byte OUTER_BOUNDARY=2;
	public static final byte INSIDE=9;
	public static final byte INNER_BOUNDARY=-2;
	public static final byte JUST_INSIDE_INNER_BOUNDARY=-3;
	public static final byte INSIDE_INNER=-4;
	public static final byte INSIDE_NARROW_BAND=-5;
	public static final byte JUST_INSIDE=1;
	public static final byte UNVISITED=0;
	public static final byte VISITED=1;
	public static final byte SOLVED=2;
	/*
	public static final int[][] volnbhd={
		{EAST,NORTH,UP},
		{EAST,NORTH,DOWN},
		{EAST,SOUTH,UP},
		{EAST,SOUTH,DOWN},
		{WEST,NORTH,UP},
		{WEST,NORTH,DOWN},
		{WEST,SOUTH,UP},
		{WEST,SOUTH,DOWN}};
	 */
	public static final int[] nbhdX=new int[]{0,  0,  1, -1, 0,  0}; 
	public static final int[] nbhdY=new int[]{1, -1,  0,  0, 0,  0};
	public static final int[] nbhdZ=new int[]{0,  0,  0,  0, 1, -1};
	protected static boolean compareToInner=true;
	public static String getLabelString(byte i){
		switch(i){
		case INSIDE_NARROW_BAND:return "INSIDE_NARROW_BAND";
		case OUTSIDE_NARROW_BAND:return "OUTISIDE_NARROW_BAND";
		case INSIDE_INNER:return "INSIDE_INNER";
		case OUTSIDE_OUTER:return "OUTISIDE_OUTER";
		case JUST_INSIDE_INNER_BOUNDARY:return "JUST_INSIDE_INNER_BOUNDARY";
		case JUST_OUTSIDE_OUTER_BOUNDARY:return "JUST_OUTSIDE_OUTER_BOUNDARY";
		case JUST_INSIDE:return "JUST_INSIDE";
		case OUTER_BOUNDARY:return "OUTER_BOUNDARY";
		case INNER_BOUNDARY:return "INNER_BOUNDARY";
		case INSIDE:return "INSIDE";
		default: return "INVALID";
		}
	}
	public static boolean isCompareToInner(){
		return compareToInner;
	}
	public static void setCompareInnerLength(boolean c){
		compareToInner=c;
	}
	public int i,j,k,chain=0,index;
	public EmbeddedNode[] nbhd;
	public byte regionLabel;
	public EmbeddedNode(){
		nbhd=new EmbeddedNode[6];
	}
	public int compareTo(EmbeddedNode data) {
		int ret=(int)Math.signum(getLength()-data.getLength());
		if(ret==0){
			return (int)Math.signum(getChainIndex()-data.getChainIndex());
		} else return ret;


	}
	public void connect(EmbeddedNode node,int pos){
		if(pos<0){
			System.out.println("INVALID INDEX "+pos+" "+node);
			System.exit(-1);
			return;
		}
		nbhd[pos]=node;
		if(node==null){
			System.out.println("INVALID NODE "+pos+" "+node);
			System.exit(-1);
			return;
		}
		switch(pos){
			case NORTH	:node.nbhd[	SOUTH	]=this;break;
			case SOUTH	:node.nbhd[	NORTH	]=this;break;
			case EAST	:node.nbhd[	WEST	]=this;break;
			case WEST	:node.nbhd[	EAST	]=this;break;
			case UP		:node.nbhd[	DOWN	]=this;break;
			case DOWN	:node.nbhd[	UP		]=this;break;
		}
	}
	public void disconnect(){
		if(nbhd[SOUTH]!=null){
			nbhd[SOUTH].nbhd[NORTH]=null;
		}
		if(nbhd[NORTH]!=null){
			nbhd[NORTH].nbhd[SOUTH]=null;
		}
		if(nbhd[EAST]!=null){
			nbhd[EAST].nbhd[WEST]=null;
		}
		if(nbhd[WEST]!=null){
			nbhd[WEST].nbhd[EAST]=null;
		}
		if(nbhd[UP]!=null){
			nbhd[UP].nbhd[DOWN]=null;
		}
		if(nbhd[DOWN]!=null){
			nbhd[DOWN].nbhd[UP]=null;
		}
	}
	public double distance(EmbeddedNode n){
		return getLocation().distance(n.getLocation());
	}

	public double dotError(){
		return (1-((EmbeddedNode.isCompareToInner())?1:-1)*getGradient().dot(getTanget()));
	}
	public boolean equals(Object obj){
		if(this==obj)return true;
		if(obj instanceof EmbeddedNode){
			Point3f p1=((EmbeddedNode)obj).getLocation();
			Point3f p2=this.getLocation();
			return (p1.distance(p2)<1E-6);
		} else {
			return false;
		}
	}
	public int getChainIndex() {
		return chain;
	}
	public int getColumn() {
		return j;
	}
	public int getConnectivity(){
		int talley=0;
		for(EmbeddedNode n:nbhd){
			if(n!=null)talley++;
		}
		return talley;
	}
	public abstract Point3f getCorrespodence();
	public Vector3f getDirection(EmbeddedNode node){
		Point3f l1=getLocation();
		Point3f l2=node.getLocation();
		return new Vector3f(l1.x-l2.x,l1.y-l2.y,l1.z-l2.z);
	}
	public abstract Vector3f getGradient();
	/*
	public Vector3f getGradient(){
		if(this instanceof BoundaryNode){
			Vector3f tan=new Vector3f(getTanget());
			if(!EmbeddedNode.isCompareToInner())tan.negate();
			return tan;
		}

		List<EmbeddedNode> boundaryNodes=new ArrayList<EmbeddedNode>();
		for(EmbeddedNode nd:getNeighbors()){
			if(nd.getMarchingLabel()!= UNVISITED&&!(nd instanceof ExtendedOutsideNode)&&nd.getTanget().dot(getTanget())>0){
				boundaryNodes.add(nd);
			}
		}
		Vector3f diff=new Vector3f();
		Matrix D=new Matrix(boundaryNodes.size(),3);
		Matrix W=new Matrix(boundaryNodes.size(),boundaryNodes.size());
		Matrix L=new Matrix(boundaryNodes.size(),1);
		double len=getLength();
		for(int i=0;i<boundaryNodes.size();i++){
			EmbeddedNode n=boundaryNodes.get(i);
			diff=getDirection(n);
			D.set(i, 0, diff.x);
			D.set(i, 1, diff.y);
			D.set(i, 2, diff.z);
			W.set(i, i, 1/diff.length());
			L.set(i, 0, len-n.getLength());
		}

		Matrix Dsqr=D.transpose().times(W).times(D);
		SingularValueDecomposition svd=new SingularValueDecomposition(Dsqr);
		Matrix S=svd.getS();
		Matrix V=svd.getV();
		Matrix U=svd.getU();
		for(int i=0;i<S.getColumnDimension();i++){
			if(Math.abs(S.get(i, i))>1E-6){
				S.set(i, i, 1/S.get(i, i));
			} else {
				S.set(i,i,0);
			}
		}

		Matrix Dinv=V.times(S.times(U.transpose())).times(D.transpose()).times(W);
		Matrix grad=Dinv.times(L);
		return (new Vector3f((float)grad.get(0,0),(float)grad.get(1,0),(float)grad.get(2,0)));
	}
	*/
	/*
	public Vector3f getGradient(){
		double dx1=0,dy1=0,dz1=0;
		double dx2=0,dy2=0,dz2=0;
		double ux1=0,ux2=0,uy1=0,uy2=0,uz1=0,uz2=0;
		EmbeddedNode neighbor;
		Vector3f v=null;
				neighbor=nbhd[EAST];
				if(neighbor!=null){
					ux1=neighbor.getLength()-getLength();
					dx1=distance(neighbor);
				}
				neighbor=nbhd[WEST];
				if(neighbor!=null){
					ux2=getLength()-neighbor.getLength();
					dx2=distance(neighbor);
				} 
				neighbor=nbhd[NORTH];
				if(neighbor!=null){
					uy1=neighbor.getLength()-getLength();
					dy1=distance(neighbor);
				}
				neighbor=nbhd[SOUTH];
				if(neighbor!=null){
					uy2=getLength()-neighbor.getLength();
					dy2=distance(neighbor);
				} 
				neighbor=nbhd[UP];
				if(neighbor!=null){
					uz1=neighbor.getLength()-getLength();
					dz1=distance(neighbor);
				} 
				neighbor=nbhd[DOWN];
				if(neighbor!=null){
					uz2=getLength()-neighbor.getLength();
					dz2=distance(neighbor);
				} 
		v=new Vector3f((float)((dx1*ux2+dx2*ux1)/(dx1+dx2)),(float)((dy1*uy2+dy2*uy1)/(dy1+dy2)),(float)((dz1*uz2+dz2*uz1)/(dz1+dz2)));
		return v;
	}
	 */
	public int getIndex() {
		return index;
	}
	public abstract double getInnerLength();
	public abstract Point3f getInnerPoint();
	public abstract double getLength();
	public abstract Point3f getLocation();
	public abstract byte getMarchingLabel();
	public String getMarchingLabelString(){
		switch(getMarchingLabel()){
			case 0:return "UNVISITED";
			case 1:return "VISITED";
			case 2:return "SOLVED"; 
			default:return "UNLABELED";
		}
	}
	public EmbeddedNode getNeighbor(int pos){
		return nbhd[pos];
	}
	@SuppressWarnings("unchecked")
	
	public ArrayList<EmbeddedNode> getNeighbors(){
		ArrayList<EmbeddedNode> list=new ArrayList<EmbeddedNode>();
		for(EmbeddedNode n:nbhd){
			if(n!=null)list.add(n);
		}
		return list;
	}
	public abstract double getNormalizedLength();
	public abstract double getOuterLength();
	public abstract Point3f getOuterPoint();
	public byte getRegionLabel(){
		return regionLabel;
	}
	public String getRegionLabelString(){
		return getLabelString(regionLabel);
	}
	public int getRow() {
		return i;
	}
	public int getSlice() {
		return k;
	}
	public Point2d getSphericalCorrespondence(){
		Point3f p=getCorrespodence();
		return new Point2d(Math.atan2(p.y, p.x),Math.acos(p.z));
	}
	public Point2d getSphericalInnerPoint(){
		Point3f p=getInnerPoint();
		return new Point2d(Math.atan2(p.y, p.x),Math.acos(p.z));
	}
	public Point2d getSphericalOuterPoint(){
		Point3f p=getOuterPoint();
		return new Point2d(Math.atan2(p.y, p.x),Math.acos(p.z));
	}
	public abstract Vector3f getTanget();
	public abstract double getThickness();
	//public abstract EmbeddedNode clone();
	public void incrementChainIndex(){
		chain++;
	}
	public final boolean isBoundary(){
		return (regionLabel==INNER_BOUNDARY||regionLabel==OUTER_BOUNDARY);
	}
	public final boolean isInnerBoundary(){
		return (regionLabel==INNER_BOUNDARY);
	}

	public final boolean isInside(){
		return (regionLabel==INSIDE);
	}

	public final boolean isInterior(){
		return (regionLabel==INSIDE||regionLabel==JUST_INSIDE);
	}


	public final boolean isJustInside(){
		return (regionLabel==JUST_INSIDE);
	}
	public final boolean isOuterBoundary(){
		return (regionLabel==OUTER_BOUNDARY);
	}

	public final boolean isOutside(){
		return (regionLabel==OUTSIDE_OUTER||regionLabel==INSIDE_INNER||regionLabel==INSIDE_NARROW_BAND||regionLabel==OUTSIDE_NARROW_BAND||regionLabel==JUST_OUTSIDE_OUTER_BOUNDARY||regionLabel==JUST_INSIDE_INNER_BOUNDARY);
	}
	public void setChainIndex(int chain) {
		this.chain=chain;
	}
	public abstract void setCorrespodence(Point3f p);
	public abstract void setGradient(Vector3f g);
	public void setIndex(int index) {
		this.index=index;
	}
	public abstract void setLength(double len);

	public abstract void setLength(double inner,double outer);

	public abstract void setLocation(Point3f p);
	public abstract void setMarchingLabel(byte label);

	public abstract void setRefPosition(int i, int j, int k);
	public abstract void setTanget(Vector3f v);
	public double signedDistance(EmbeddedNode n){
		Point3f l1=getLocation();
		Point3f l2=n.getLocation();
		return 	 l1.x-l2.x
		+l1.y-l2.y
		+l1.z-l2.z;
	}

	public String toString(){
		String str="NODE "+this.getClass().getSimpleName()+" "+getLocation().toString()+" "+getRegionLabelString()+" "+getMarchingLabelString()+" CONNECTIVITY "+getConnectivity()+" LENGTH "+getLength()+"\n";
		Vector3f diff;
		for(EmbeddedNode node:getNeighbors()){
			diff=getDirection(node);
			str+=node.getClass().getSimpleName()+" "+node.getRegionLabelString()+" "+node.getMarchingLabelString()+" "+node.getLocation()+" "+node.getLength()+"\n";

			//str+=node.getClass().getSimpleName()+" "+getRegionLabelString()+" "+node.getLocation()+" LENGTH "+node.getLength()+" "+node.getMarchingLabel()+" ANGLE "+(180/Math.PI)*GeomUtil.angle(node.getTanget(), node.getGradient())+" TAN "+(180/Math.PI)*GeomUtil.angle(diff, node.getTanget())+" GRAD "+(180/Math.PI)*GeomUtil.angle(diff, node.getGradient())+" CENTRAL TAN "+(180/Math.PI)*GeomUtil.angle(diff, getTanget())+"\n";
		}
		return str;
	}

}
