package edu.jhu.ece.iacl.algorithms.thickness.grid;
import java.util.ArrayList;

import javax.vecmath.Point3f;
/**
 * Inner boundary node
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class ExtendedInnerBoundaryNode extends SimpleInnerBoundaryNode implements ExtendedNode{
	private static final String Collections = null;
	private ArrayList<EmbeddedNode> neighbors;
	public ExtendedInnerBoundaryNode(Point3f p,Point3f corr){
		super(p,corr);
		neighbors=new ArrayList<EmbeddedNode>();
	}
	public void connect(EmbeddedNode node){
		if(!neighbors.contains(node))neighbors.add(node);
		if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
	}
	public int getConnectivity(){
		return neighbors.size();
	}
	public void disconnect(){
		super.disconnect();
		for(EmbeddedNode node:neighbors){
			if(node instanceof ExtendedNode)((ExtendedNode)node).getNeighbors().remove(this);
		}
	}
	public ArrayList<EmbeddedNode> getNeighbors() {
		return neighbors;
	}


}
