package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Grid node that lies on outer boundary and has two neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class SimpleOuterBoundaryNode extends BoundaryNode{

	public SimpleOuterBoundaryNode(Point3f p,Point3f corr) {
		super(p,corr, OUTER_BOUNDARY);
		// TODO Auto-generated constructor stub
	}
	public double getInnerLength(){
		return thickness;
	}
	public double getOuterLength(){
		return 0;
	}
	public double getNormalizedLength(){
		return 1;
	}

	public void setLength(double len){
		if(compareToInner){
			thickness=len;
		}
	}
	public double getLength(){
		if(compareToInner){
			return thickness;
		} else {
			return 0;
		}
	}
	public SimpleOuterBoundaryNode clone(){
		SimpleOuterBoundaryNode dat=new SimpleOuterBoundaryNode(location,outerPoint);
		dat.chain=chain;
		dat.index=index;
		dat.marchingLabel=marchingLabel;
		dat.regionLabel=regionLabel;
		dat.thickness=thickness;
		dat.innerPoint=new Point3f(innerPoint);
		dat.outerPoint=new Point3f(outerPoint);
		dat.location=(Point3f)location.clone();
		
		dat.connect(nbhd[0], 0);
		dat.connect(nbhd[1], 1);
		dat.connect(nbhd[2], 2);
		dat.connect(nbhd[3], 3);
		dat.connect(nbhd[4], 4);
		dat.connect(nbhd[5], 5);
		dat.tanget=(Vector3f)tanget.clone();
		return dat;
	}
	@Override
	public void connect(EmbeddedNode n) {
		// TODO Auto-generated method stub
		
	}
}
