package edu.jhu.ece.iacl.plugins.classification;

import java.io.File;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.net.URL;
import java.net.URI;

import javax.swing.SpringLayout;

import edu.jhmi.rad.medic.algorithms.AlgorithmMultipleToads;
import edu.jhmi.rad.medic.methods.MultipleToadDeformableAtlas;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.MipavController;

import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionPaneInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionWindowInputView;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.view.MipavUtil;
import gov.nih.mipav.view.ViewUserInterface;
import gov.nih.mipav.view.dialogs.JDialogBase;

/**
 *   Medic wrapper for the release of Toads (atlas-based version)
 *
 *	@version    Jan 2008
 *	@author     Pilou Bazin
 */
public class MedicAlgorithmToads08 extends ProcessingAlgorithm {
	private ParamWeightedVolumeCollection<String> inputImages;

	private ParamFile atlasFile;

	private ParamOption inputModality;

	private ParamBoolean correctInhomogeneity;

	/*private ParamInteger polynomialDegree;
	
	private ParamOption correctionMethod;
	
	private ParamFloat kernelSize;*/
	
	private ParamDouble smoothParam;

	private ParamInteger maxIters;

	private ParamDouble maxDiff;

	private ParamDouble atlasPrior;

	//private ParamDouble atlasRange;
	
	private ParamOption connectivity;
	
	private ParamOption outputType;
	
	private ParamOption alignType;
	
	private ParamVolume inputImage;
	
	private ParamVolume classification;

	private ParamVolume field;

	private ParamVolume memberships;
	
	private ParamVolume csf;
	
	private ParamVolume gm;
	
	private ParamVolume wmfill;
	
	private ParamVolume wmmask;
	
	private ParamVolume thalamus;
	
	private ParamVolume classification_mem;
	
	//private ParamBoolean scaleData;
	
	private ParamBoolean outputField;
	
	private ParamBoolean outputMembershipClassification;


	//private ParamVolumeCollection volClasses;
	private HashMap<String,String> connMap;

	private static final String cvsversion = "$Revision: 1.10 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
	
	/**
	 * Create Input parameters for TOADS as specified in AlgorithmMultipleToads The
	 * boundaries for these variables do not necessarily match those specified
	 * in the original dialog
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		connMap=new HashMap<String,String>();
		connMap.put("(18,6)","18/6");
		connMap.put("(6,18)","6/18");
		connMap.put("(26,6)","26/6");
		connMap.put("(6,26)","6/26");

		String[] modal = {"T1_MPRAGE","T1_SPGR","T2","PD","FLAIR"};
		
		inputImage = new ParamVolume("Image to segment");
		inputImage.setDescription("Stripped MR Image that has correct anatomical axis assignments.");
		inputModality=new ParamOption("Image modality",modal);
		inputModality.setDescription("MRI Image Modality");
	
		
//		inputImages = new ParamWeightedVolumeCollection<String>("Image Channels",new ParamOption("Modality",modal));
//		inputImages.setDescription("Collection of images with specifed MR imaging modality.");
/*		String filename = "toads08-brain-atlas.txt";
		URI af_uri = null;
		URL af_res = null;
		try {
			af_res = MedicAlgorithmToads08.class.getResource( filename );
			af_uri = af_res.toURI();
		} catch (Exception e) {
			//System.out.print("Error: "+e.getMessage()+ "\n");
		}
*/
		atlasFile = new ParamFile("Atlas file",new FileExtensionFilter(new String[]{"txt"}));
		//atlasFile.setValue(af_uri); 
		atlasFile.setDescription("Atlas Description File, containing default parameters and atlas path.");
		String filename = "Atlas/cruise-atlas-10obj-toads2008.txt";
        try {

        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        atlasFile.setValue(cl.getResource(filename).getFile());
        } catch (Exception e) {
                System.out.print("Error: Unable to set default atlas\n");
                //System.out.print("Error: "+e.getMessage()+ "\n");
        }
        
        outputMembershipClassification = new ParamBoolean ("Output max membership classification", false);
		outputMembershipClassification.setDescription("Output the hard classification using maximum membership (not neceesarily topologically correct)");
        
		correctInhomogeneity = new ParamBoolean("Correct inhomogeneity");
		correctInhomogeneity.setValue(true);
		correctInhomogeneity.setDescription("Correct MR field inhomogeneity.");
		
		outputField= new ParamBoolean("Output inhomogeniety filed", false);
		outputField.setDescription("Output the estimated inhomogeneity field");
		
		/*String[] fieldOption = {"Chebyshev","Splines"};
		correctionMethod = new ParamOption("Correction Method",fieldOption);
		correctionMethod.setValue("Chebyshev");
		correctionMethod.setDescription("The type of polynomial used for inhomogeneity correction");
		
	    kernelSize= new ParamFloat("Kernel size",0,1000.0f);
	    kernelSize.setValue(30.0f);
	    kernelSize.setDescription("The kernel size for spline polynomials");
		
		polynomialDegree = new ParamInteger("Inhomogeneity field degree", 1, 4);
		polynomialDegree.setValue(3);
		polynomialDegree.setDescription("Chebyshev polynomial degree for MR field estimation.");*/
		
		smoothParam = new ParamDouble("Smooting parameter", 0, 1E10);
		smoothParam.setValue(0.2);

		maxIters = new ParamInteger("Maximum iterations", 0, 100000);
		maxIters.setValue(50);

		maxDiff = new ParamDouble("Maximum difference", 0, 1E10);
		maxDiff.setValue(0.0001);

		atlasPrior = new ParamDouble("Atlas prior", 0, 1E10);
		atlasPrior.setValue(2.0);
		/*atlasRange = new ParamDouble("Atlas range", 0, 1E10);
		atlasRange.setValue(0.2);*/
		
		connectivity=new ParamOption("Connectivity (Foreground,Background)",new ArrayList<String>(connMap.keySet()));

		String[] out = {"hard segmentation","hard segmentation+memberships","cruise inputs","dura removal inputs","thalamus segmentation"};
		outputType=new ParamOption("Output images", out);

		String[] align = {"rigid","multi_fully_affine"};
		alignType=new ParamOption("Atlas alignment", align);
		
		ParamCollection main = new ParamCollection("Main Inputs");
		ParamCollection advanced = new ParamCollection("Advanced Options");

		// Add input to main pane
		main.add(inputImage);
		main.add(inputModality);
//		inputParams.add(inputImages);
		main.add(atlasFile);
		main.add(outputType);
		main.add(outputMembershipClassification);
		main.add(correctInhomogeneity);
		main.add(outputField);
		/*inputParams.add(correctionMethod);
		inputParams.add(polynomialDegree);
		inputParams.add(kernelSize);*/
		
		advanced.add(atlasPrior);
		advanced.add(smoothParam);
		//inputParams.add(atlasRange);
		advanced.add(maxDiff);
		advanced.add(maxIters);
		//advanced.add(scaleData=new ParamBoolean("Scale Output by 255",true));
		advanced.add(alignType);
		advanced.add(connectivity);
		inputParams.add(main);
		inputParams.add(advanced);
		inputParams.setPackage("IACL");
		inputParams.setCategory("Classification");
		inputParams.setName("Toads08");
		inputParams.setLabel("TOADS 2008");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(ReferencedPapers.toads);
		info.setWebsite("http://medic.rad.jhmi.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.add(PrinceGroupAuthors.snehashisRoy);
		info.setDescription("Algorithm for topologically consistent classification and segmentation of cortical and subcortical human brain structures from multiple MR images with possibly different modalities.");
		info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/classification/MedicAlgorithmToads08/index.html");
	}

	/**
	 * Create output Parameters for TOADS. Note: Not all output fields are
	 * populated and the non-populated fields will create an error that is
	 * caught by the dialog.
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		// not working; is it set before the input parameters are received ??
		
		outputParams.add(classification = new ParamVolume("Hard segmentation"));
		outputParams.add(classification_mem = new ParamVolume("Hard segmentation from memberships",VoxelType.UBYTE));
		outputParams.add(field = new ParamVolume("Inhomogeneity Field"));
		outputParams.add(memberships = new ParamVolume("Membership Functions",null,-1,-1,-1,-1));
		outputParams.add(wmmask = new ParamVolume("WM mask"));
		outputParams.add(csf = new ParamVolume("Sulcal CSF Membership"));
		outputParams.add(gm = new ParamVolume("Cortical GM Membership"));
		outputParams.add(wmfill = new ParamVolume("Filled WM Membership"));	
		outputParams.add(thalamus = new ParamVolume("Thalamus Membership"));	
		classification_mem.setMandatory(false);
		field.setMandatory(false);
		memberships.setMandatory(false);
		wmmask.setMandatory(false);
		csf.setMandatory(false);
		gm.setMandatory(false);
		wmfill.setMandatory(false);
		thalamus.setMandatory(false);
		//outputParams.add(volClasses = new ParamVolumeCollection("Membership Classes",VoxelType.UBYTE));

	}

	/**
	 * Execute the TOADS/CRUISE algorithm given the input parameters
	 */
	protected class Toads08Wrapper extends AbstractCalculation{
		public Toads08Wrapper(){
			setLabel("Toads 2008");
		}
		public void execute(){
			ModelImage[] images = new ModelImage[1];
			//images[0] = IsotropicResample.resample(new ImageDataMipav(inputImage.getImageData()),InterpolationMethod.WSINC).getModelImageCopy();
			images[0] = inputImage.getImageData().getModelImageCopy();
			
			String[] modals = new String[1];
			modals[0] = inputModality.getValue();
			// get the ModelImage needed by the algorithm
/*			List<ImageData> vols=inputImages.getImageDataList();
			ModelImage[] images = new ModelImage[vols.size()];
			String[] modals = new String[vols.size()];
			int i=0;
			for(ImageData vol:vols){
				images[i] = IsotropicResample.resample(new ImageDataMipav(vol.getModelImage()),InterpolationMethod.WSINC).getModelImage();
				modals[i] = inputImages.getWeight(i);
				System.out.println("CHANNEL "+(i+1)+" "+images[i].getImageName()+" "+modals[i]);
				i++;
			}
*/			
			String[] psfs = {"1x1x1"};
			System.out.println("ATLAS FILE "+atlasFile.getValue().getAbsolutePath());
			MultipleToadDeformableAtlas atlas = new MultipleToadDeformableAtlas(atlasFile.getValue().getAbsolutePath());

			int nClasses = atlas.getNumber();
			String correctionMethod = "Chebyshev";
			int polynomialDegree =3;
			float kernelSize = 30.0f;
			float atlasRange = 0.2f;
			//String alignType = "rigid";
			//String connectivity = "18/6";
			setTotalUnits(1);
			AlgorithmMultipleToadsWrapper algo = new AlgorithmMultipleToadsWrapper(images, images.length,
									  modals, 
									  atlasFile.getValue().getAbsolutePath(), atlas,
									  outputType.getValue(), 
									  smoothParam.getFloat(), maxIters.getInt(), maxDiff.getFloat(), 
									  3.0f, 0.5f,
									  atlasPrior.getFloat(), atlasRange,
									  alignType.getValue(), 
									  4, 50, 5, 0,
									  correctInhomogeneity.getValue(),correctionMethod, polynomialDegree,kernelSize,
									  connMap.get(connectivity.getValue()),
									  outputMembershipClassification.getValue(),outputField.getValue());
			algo.setObserver(this);
			algo.runAlgorithm();
			ImageHeader img_header = inputImage.getImageData().getHeader();
			ModelImage[] resultImage=algo.getResultImages();
			/*for(ModelImage img:resultImage){
				if(img.getExtents().length<4||img.getExtents()[3]==1){
					img.copyFileTypeInfo(images[0]);
				}
			}*/
			// export the images needed
			
		
			if (outputType.getValue().equals("hard segmentation")) {
				classification.setValue(new ImageDataMipavWrapper(resultImage[0]));
				if (outputMembershipClassification.getValue()){
					classification_mem.setValue(new ImageDataMipavWrapper(resultImage[1]));
					if (correctInhomogeneity.getValue() & outputField.getValue()) {
						field.setValue(new ImageDataMipavWrapper(resultImage[2]));
					} 
				}else if (correctInhomogeneity.getValue() & outputField.getValue()) {
					field.setValue(new ImageDataMipavWrapper(resultImage[1]));
				} 
			} else if (outputType.getValue().equals("hard segmentation+memberships")) {
				classification.setValue(new ImageDataMipavWrapper(resultImage[0]));
				memberships.setValue(new ImageDataMipavWrapper(resultImage[1]));
				memberships.getImageData().setHeader(img_header);
				
				if (outputMembershipClassification.getValue()){
					classification_mem.setValue(new ImageDataMipavWrapper(resultImage[2]));
					if (correctInhomogeneity.getValue() & outputField.getValue()) {
						field.setValue(new ImageDataMipavWrapper(resultImage[3]));
					} 
				}else if (correctInhomogeneity.getValue() & outputField.getValue()) {
					field.setValue(new ImageDataMipavWrapper(resultImage[2]));
				}  
				
			} else if (outputType.getValue().equals("cruise inputs") 
					|| outputType.getValue().equals("dura removal inputs")) {
				classification.setValue(new ImageDataMipavWrapper(resultImage[0]));
				csf.setValue(new ImageDataMipavWrapper(resultImage[1]));
				gm.setValue(new ImageDataMipavWrapper(resultImage[2]));
				wmfill.setValue(new ImageDataMipavWrapper(resultImage[3]));
				wmmask.setValue(new ImageDataMipavWrapper(resultImage[4]));

				//if(scaleData.getValue()){
					ImageDataMath.scaleFloatValue(csf.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(gm.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(wmfill.getImageData(), 255.0f);
					ImageDataMath.scaleFloatValue(wmmask.getImageData(), 255.0f);
				//}	
				
				if (outputMembershipClassification.getValue()){
					classification_mem.setValue(new ImageDataMipavWrapper(resultImage[5]));
					if (correctInhomogeneity.getValue() & outputField.getValue()) {
						field.setValue(new ImageDataMipavWrapper(resultImage[6]));
					} 
				}else if (correctInhomogeneity.getValue() & outputField.getValue()) {
					field.setValue(new ImageDataMipavWrapper(resultImage[5]));
				} 
				
			} else if (outputType.getValue().equals("thalamus segmentation")) {
				classification.setValue(new ImageDataMipavWrapper(resultImage[0]));
				thalamus.setValue(new ImageDataMipavWrapper(resultImage[1]));
				if (outputMembershipClassification.getValue()){
					classification_mem.setValue(new ImageDataMipavWrapper(resultImage[2]));
					if (correctInhomogeneity.getValue() & outputField.getValue()) {
						field.setValue(new ImageDataMipavWrapper(resultImage[3]));
					} 
				}else if (correctInhomogeneity.getValue() & outputField.getValue()) {
					field.setValue(new ImageDataMipavWrapper(resultImage[2]));
				} 
			}	
			
			images[0].disposeLocal();
			markCompleted();
		}
	}
	protected class AlgorithmMultipleToadsWrapper extends AlgorithmMultipleToads{
		protected AbstractCalculation observer;
		public AlgorithmMultipleToadsWrapper(ModelImage[] srcImg_, int input_, String[] imgModal_, String name_,
				MultipleToadDeformableAtlas atlas_, String segOutput_, float smooth_, int iterMax_, float distMax_, float lim_,
				float lim_2, float firstCoeff_, float scale_, String align_, int lev_, int first_, int top_, int last_,
				boolean correct_,String correctType_, int poly_, float kernel_,
				String connect_, boolean outputMaxMem_, boolean outputField_) {
			super(srcImg_, input_, imgModal_, name_, atlas_, segOutput_, smooth_, iterMax_, distMax_, lim_, lim_2, firstCoeff_,
					scale_, align_, lev_, first_, top_, last_, correct_,correctType_, poly_, kernel_,
					connect_, outputMaxMem_, outputField_);
		}
		public void setObserver(AbstractCalculation observer){
			this.observer=observer;
		}
		public void runAlgorithm(){
			observer.setTotalUnits(100);
			super.runAlgorithm();
			observer.markCompleted();
		}
	    /**
	     * Notifies all listeners that have registered interest for notification on this event type.
	     *
	     * @param  value  the value of the progress bar.
	     */
	    protected void fireProgressStateChanged(int value) {
	        super.fireProgressStateChanged(value);
	        observer.setCompletedUnits(value);
	    }

	    /**
	     * Updates listeners of progress status. Without actually changing the numerical value
	     *
	     * @param  imageName  the name of the image
	     * @param  message    the new message to display
	     */
	    protected void fireProgressStateChanged(String imageName, String message) {
	    	super.fireProgressStateChanged(imageName, message);
	    	observer.setLabel(message);
	    }
	}
	protected void execute(CalculationMonitor monitor) {
		Toads08Wrapper toads=new Toads08Wrapper();
		monitor.observe(toads);
		toads.execute();
	}
	public Dimension getPreferredSize() {
		return new Dimension(450,350);
	}
}
