package edu.jhu.ece.iacl.plugins.comp_geom;


import java.util.LinkedList;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.smooth.MultiResolutionImplicitSmoothing;
import edu.jhu.ece.iacl.algorithms.graphics.surf.ProgressiveSurface;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

public class MedicAlgorithmMultiResolutionSmoothing extends ProcessingAlgorithm{
	ParamSurface surf;
	ParamSurface result;
	ParamDouble meanCurvature;
	ParamInteger maxIters;
	ParamInteger smoothIters;
	ParamDouble lambda;
	ParamBoolean decimate;
	ParamBoolean regularize;
	ParamBoolean preventSelfIntersection;
	ParamOption metric;
	ParamDouble maxDecimation;
	private static final String revnum = MultiResolutionImplicitSmoothing.getVersion();
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(surf=new ParamSurface("Surface"));
		inputParams.add(metric=new ParamOption("Metric",new String[]{"Mean Curvature","Surface Distance"}));
		inputParams.add(meanCurvature=new ParamDouble("Metric Threshold",-1E10,1E10,0.3));
		meanCurvature.setDescription("Threshold to terminate decimation of the surface.");
		inputParams.add(maxDecimation=new ParamDouble("Max Decimation",0,1,1));
		inputParams.add(lambda=new ParamDouble("Lambda",0,1,0.8));
		inputParams.add(smoothIters=new ParamInteger("Smooth Iterations",0,10000,10));
		inputParams.add(maxIters=new ParamInteger("Multi-Resolution Iterations",0,10000,5));
		inputParams.add(decimate=new ParamBoolean("Decimate"));
		inputParams.add(regularize=new ParamBoolean("Regularize"));
		regularize.setDescription("Should the surface be regularized by flipping edges?");
		inputParams.add(preventSelfIntersection=new ParamBoolean("Prevent Self-Intersection"));
		inputParams.setPackage("IACL");
		inputParams.setCategory("Processing.Surface");
		inputParams.setLabel("Multi-Resolution Implicit Smoothing");
		inputParams.setName("multismooth");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.add(ReferencedPapers.implicitFairing);
		info.add(ReferencedPapers.meshRegularizationAndAdaptiveSmoothing);
		info.add(ReferencedPapers.progressiveMesh);
		info.setDescription("Smooth surface with an implicit smoothing algorithm at multiple resolutions. The module can also be used for pure decimation or smoothing.");
		info.setLongDescription("Implicit smoothing algorithms are unconditionally stable and can incorporate soft constraints, but require a sparse linear solver.");
		
		info.setStatus(DevelopmentStatus.BETA);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/comp_geom/MedicAlgorithmMultiResolutionSmoothing/index.html");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(result=new ParamSurface("Smoothed Surface"));
	}
	public void execute(CalculationMonitor monitor) {
		MultiResolutionImplicitSmoothing smooth=new MultiResolutionImplicitSmoothing(meanCurvature.getFloat(),lambda.getFloat(),smoothIters.getInt(),maxIters.getInt());
		smooth.setDecimate(decimate.getValue());
		smooth.setRegularize(regularize.getValue());
		smooth.setMaxDecimation(maxDecimation.getFloat());
		smooth.setMetric(ProgressiveSurface.VertexMetric.values()[metric.getIndex()]);
		smooth.setPreventSelfIntersection(preventSelfIntersection.getValue());
		EmbeddedSurface mesh=surf.getSurface();
		int genus=EmbeddedSurface.getGenus(mesh);
		System.out.println("MESH "+mesh.getVertexCount()+" "+mesh.getFaceCount()+" "+genus);
		if(genus==0){
			monitor.observe(smooth);
			result.setValue(smooth.solve(mesh));
		} else {
			result.setValue(mesh);
		}
	}

}
