package edu.jhu.ece.iacl.plugins.comp_geom;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.graphics.edit.RemapCoupledSurfaces;
import edu.jhu.ece.iacl.algorithms.graphics.edit.RemeshCoupledSurfaces;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;


public class MedicAlgorithmRemapCoupledSurfaces extends ProcessingAlgorithm{
	protected ParamSurface innerSurf, outerSurf, refInnerSurf, refOuterSurf;
	protected ParamSurface remappedInnerSurf, remappedOuterSurf;
	protected ParamDouble decimationAmt;
	private ParamBoolean nearestNeighborInterpolation;

	private static final String cvsversion = "$Revision: 1.7 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = RemapCoupledSurfaces.getVersion();
	private static final String shortDescription = "Resample surfaces that have been mapped to each other. The mapped surfaces have barycentric coordinates associated with each vertex. The reference surfaces are used for resampling.\n"
		+ "Algorithm Version: " + revnum + "\n"
		+ "GUI Version:" + cvsversion + "\n";
	private static final String longDescription = "The mapped surfaces are usually partially inflated since closest point mappings are more reliable when computed on these surfaces. The resulting surfaces will have the same parameterization.";



	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(innerSurf = new ParamSurface("Mapped Inner Surface"));
		innerSurf.setDescription("Surface with barycentric coordinates assigned to each vertex");
		inputParams.add(outerSurf = new ParamSurface("Mapped Outer Surface"));
		outerSurf.setDescription("Surface with barycentric coordinates assigned to each vertex");
		outerSurf.setMandatory(false);
		innerSurf.setMandatory(false);


		inputParams.add(refInnerSurf = new ParamSurface("Reference Inner Surface"));
		refInnerSurf.setDescription("Surface with same parameterization as mapped inner surface and is used for resampling");
		inputParams.add(refOuterSurf = new ParamSurface("Reference Outer Surface"));
		refInnerSurf.setDescription("Surface with same parameterization as mapped outer surface and is used for resampling");

		inputParams.add(nearestNeighborInterpolation = new ParamBoolean("Nearest Neighbor Interpolation"));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Mapping.Point");
		inputParams.setLabel("Remap Coupled Surfaces");
		inputParams.setName("Remap_Coupled_Surfaces");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(remappedInnerSurf=new ParamSurface("Remapped Inner Surface"));
		outputParams.add(remappedOuterSurf=new ParamSurface("Remapped Outer Surface"));
		remappedInnerSurf.setMandatory(false);
		remappedOuterSurf.setMandatory(false);
	}


	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		RemapCoupledSurfaces remap = new RemapCoupledSurfaces(innerSurf.getSurface(), outerSurf.getSurface(), refInnerSurf.getSurface(), refOuterSurf.getSurface(), !nearestNeighborInterpolation.getValue());

		monitor.observe(remap);
		remap.remap();

		if (remap.getRemappedSource() != null) remappedInnerSurf.setValue(remap.getRemappedSource());
		if (remap.getRemappedTarget() != null) remappedOuterSurf.setValue(remap.getRemappedTarget());
	}
}
