package edu.jhu.ece.iacl.plugins.mapping;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.edit.SurfaceSlicer;
import edu.jhu.ece.iacl.algorithms.graphics.map.HemisphericalMap;
import edu.jhu.ece.iacl.algorithms.graphics.map.RobustSphericalMap;
import edu.jhu.ece.iacl.algorithms.graphics.map.SurfaceToComplex;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPointFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

public class MedicAlgorithmSurface2Sphere2009 extends ProcessingAlgorithm {
	ParamSurface inSurf,origSurf;
	ParamSurface outSurf;
	ParamSurface sphereSurf;
	ParamPointFloat norm;
	ParamDouble dec,maxCurvature;
	ParamInteger iters, res;
	ParamBoolean elev,correct;
	ParamOption weightFunc;
	ParamDouble mu,lambda,hormann;
	private static final String revnum = HemisphericalMap.getVersion();

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(origSurf = new ParamSurface("Original Surface"));
		inputParams.add(inSurf = new ParamSurface("Inflated Surface"));
		inputParams.add(norm= new ParamPointFloat("Hemispherical Normal",new Point3f(1,0,0)));
		inputParams.add(maxCurvature = new ParamDouble("Curvature Threshold", 0, 100000, 0.3));
		inputParams.add(weightFunc=new ParamOption("Weighting Function",new String[]{"TUETTE","CONFORMAL","AUTHALIC","CONFORMAL/AUTHALIC BLEND","MEAN VALUE"}));
		weightFunc.setValue(1);
		inputParams.add(mu=new ParamDouble("Authalic Weight",0,1,0.5));
		inputParams.add(lambda=new ParamDouble("Conformal Weight",0,1,0.75));
		inputParams.add(hormann=new ParamDouble("Hormann Weight",0,10000,0));
		inputParams.add(correct=new ParamBoolean("Correct Map",true));
		inputParams.add(elev=new ParamBoolean("Find Elevations",false));
		
		inputParams.setName("surf2msphere09");
		inputParams.setLabel("Surface to Sphere 2009");

		inputParams.setPackage("IACL");
		inputParams.setCategory("Mapping.Spherical");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setStatus(DevelopmentStatus.ALPHA);
		info.setDescription("Global spherical parameterization algorithm that generates a bijective spherical map and can be tuned to be conformal, authalic, or a blend between conformal/authalic. It requires that the mid-saggital plane be aligned with the Z-axis.");
		info.setLongDescription("Works best on partially inflated surface. This is a research project that could be very close to publication.");
		
		info.add(PrinceGroupAuthors.blakeLucas);
		info.add(ReferencedPapers.sphericalParameterizationAndRemeshing);
		info.add(ReferencedPapers.intrinsicParameterization);
		info.add(ReferencedPapers.robustParameterizationBrainSurface);
		info.add(ReferencedPapers.progressiveMesh);
		info.setEditable(false);
		
		info.setStatus(DevelopmentStatus.ALPHA);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		outputParams.add(sphereSurf = new ParamSurface(" Spherical Map"));
		outputParams.add(outSurf = new ParamSurface("Elevation Map"));
		outSurf.setMandatory(false);
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		Vector3f normal = new Vector3f(norm.getValue());
		HemisphericalMap stoc = new HemisphericalMap();
		monitor.observe(stoc);
		stoc.setBlendLambda(lambda.getDouble());
		stoc.setBlendMu(mu.getDouble());
		stoc.setHormannWeight(hormann.getDouble());
		EmbeddedSurface[] surfs = stoc.solve( normal, inSurf.getSurface(),origSurf.getSurface(),maxCurvature.getDouble(),correct.getValue(),elev.getValue(),HemisphericalMap.WeightFunction.values()[weightFunc.getIndex()]);
		sphereSurf.setValue(surfs[0]);
		if(surfs.length>1){
			outSurf.setValue(surfs[1]);
		}
	}

}
