package edu.jhu.ece.iacl.plugins.segmentation;

import java.util.Arrays;
import edu.jhmi.rad.medic.algorithms.AlgorithmFantasm;
import edu.jhmi.rad.medic.libraries.ObjectProcessing;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.model.structures.jama.JamaMatrix;
import gov.nih.mipav.view.MipavUtil;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;


public class MedicAlgorithmSpineSeg extends ProcessingAlgorithm {

	//Declare inputs
	public ParamVolume volParam;
	//private ParamFloat threshParam;
	public ParamInteger	fantasmClassesParam;
	public ParamInteger 	nIsolationParam;
	public ParamFloat 		tendrilThreshParam;
	public ParamFloat		bgCParam;
	public ParamFloat		spCParam;
	public ParamFloat		csfCParam;
	public ParamFloat		connCParam;
	public ParamInteger 	xBiasParam;
	public ParamInteger 	yBiasParam;
	public ParamInteger 	windowSizeParam;
	public ParamInteger 	xCenterParam;
	public ParamInteger 	yCenterParam;

	//private		int			showOutputs = 0;


	//Declare outputs
	public ParamVolume segOutputVol;
	public ParamVolumeCollection debugOutputVols;

	//Algorithm header information
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Performs spine segmentation of CSF, Spinal Cord and BG.";
	private static final String longDescription = "Performs spine segmentation of CSF, Spinal Cord and BG.";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation");
		inputParams.setLabel("SpineSeg");
		inputParams.setName("Spine Segmentation");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.nitrc.org/projects/jist/");
		info.setAffiliation("Johns Hopkins University, Department of Electrical Engineering");
		info.add(new AlgorithmAuthor("Will Gray", "willgray@jhu.edu", ""));
		info.add(new AlgorithmAuthor("Pilou Bazin", "pbazin1@jhmi.edu", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);

		//These are the input subject images
		inputParams.add(volParam=new ParamVolume("Volumes",null,-1,-1,-1,-1));

		inputParams.add(fantasmClassesParam=new ParamInteger("Fantasm Classes",3));
		inputParams.add(tendrilThreshParam=new ParamFloat("Tendril Threshold", .05f));
		inputParams.add(nIsolationParam=new ParamInteger("Number of Slice Isolations",3));
		inputParams.add(bgCParam=new ParamFloat("BG Coefficient",1.0f));
		inputParams.add(spCParam=new ParamFloat("Spine Coefficient",1.2f));
		inputParams.add(csfCParam=new ParamFloat("CSF Coefficient",1.0f));
		inputParams.add(connCParam=new ParamFloat("Connectivity Coefficient",1.0f));
		inputParams.add(xBiasParam=new ParamInteger("X Centroid Bias",0));
		inputParams.add(yBiasParam=new ParamInteger("Y Centroid Bias",0));
		inputParams.add(windowSizeParam=new ParamInteger("Window Size",50));
		inputParams.add(xCenterParam=new ParamInteger("X Center",0));
		inputParams.add(yCenterParam=new ParamInteger("Y Center",0));


		//	inputParams.add(threshParam=new ParamFloat("Mask Threshhold",(float)100));
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(segOutputVol=new ParamVolume("Seg Volume",null,-1,-1,-1,-1));
		//		outputParams.add(debugOutputVols=new ParamVolumeCollection("Debug Out"));
	}


	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {

		ImageData vol=volParam.getImageData();
		int nx=vol.getRows();
		int ny=vol.getCols();
		int nz=vol.getSlices();


		int fantasmClasses = fantasmClassesParam.getInt();
		float bgC = bgCParam.getFloat();
		float spC = spCParam.getFloat();
		float csfC = csfCParam.getFloat();
		float connC = connCParam.getFloat();
		int nIsolation = nIsolationParam.getInt();
		float tendrilThresh = tendrilThreshParam.getFloat();
		int xBias = xBiasParam.getInt();
		int yBias = yBiasParam.getInt();
		int windowSize = windowSizeParam.getInt();
		int xCenter = xCenterParam.getInt();
		int yCenter = yCenterParam.getInt();

		System.out.println("bgC: "+bgC+" spC: "+spC+" csfC: "+csfC+" connC: "+connC+" tendrilThresh: "+tendrilThresh+" z-dilations: "+nIsolation+"\n");

		AlgorithmFantasm			segment = null;
		AlgorithmFantasm			segment2 = null;
		ModelImage              image;                	// source image
		ModelImage				segImage;
		ModelImage              resultImage[] = null;   	// result image

		float[][][] 			topoMask = null;


		float[][][] regionMask = null;
		float[][][] regionMaskSpine;

		float [][][] segGrow1;
		float [][][] segGrow2;

		//Don't delete
		
		int[][][] spineMask1;
		int[][][] spineMask3;
		 
		int			minSpineComponent = 5000;
		float		segThreshold	=	0.05f;
		int			maxFantasmIter = 50;

		// parameters -- do not delete for now - may incorporate these values, later
		/*	int		    threshSize = 3;  
		int			dilationSize = 0;
		int 		erosionSize = 0;
		int			numResults;
		 */
		try {
			System.out.println("HI WILL\n");
			System.out.println("Starting overall Fantasm Segmentation\n");
			// 4. Segment image
			resultImage = new ModelImage[1];

			/**	if (showOutputs == 1) resultImage = new ModelImage[17];//TODO  new ModelImage[numResults];
			else resultImage = new ModelImage[1];
			 */
			int[] destExtents = new int[3];
			destExtents[0] = nx;
			destExtents[1] = ny;
			destExtents[2] = nz;

			ModelImage[] segImages = new ModelImage[1];
			segImages[0] = new ModelImage(ModelStorageBase.UBYTE, destExtents, "segmented_image");
			//makeImageName(image.getImageName(), "_seg"));
			image = vol.getModelImageCopy();
			segment = new AlgorithmFantasm(segImages, image, 
					1, "range", "hard_segmentation",
					fantasmClasses, maxFantasmIter, 0.01f, 0.01f,  //25
					2.0f,
					false, 0.1f, 
					"none", 3,
					false, 0.0f, 0.0f, 0.0f,
					true, segThreshold, true, false);  //segThreshold

			segment.run();

			segImage = segImages[0];

			segment.finalize();

			//Parameter Declarations
			float[][][] initImg;
			float[][][] mask1 = null;
			boolean[][][] mask3 = null;

			int[][][] mask4 = null;
			float[][][] imgOut = null;
			float[][][] imgOrig = null;

			float[][][] imgF0 = null;
			float[][][] imgF1 = null;
			float[][][] imgF2 = null;
			float[][][] imgF3 = null;

			int[] labelArea;
			float[] labelScore;

			//ImageCropper crop = new ImageCropper(nx, ny, nz);
			initImg = (new ImageDataFloat(new ImageDataMipavWrapper(segImage))).toArray3d();
			imgOrig = (new ImageDataFloat(new ImageDataMipavWrapper(image))).toArray3d();
			mask1 = new float[nx][ny][nz];	
			topoMask = new float[nx][ny][nz];
			mask3 = new boolean[nx][ny][nz];
			mask4 = new int[nx][ny][nz];
			imgOut = new float [nx][ny][nz];
			imgF0 = new float [nx][ny][nz];
			imgF1 = new float [nx][ny][nz];
			imgF2 = new float [nx][ny][nz];
			imgF3 = new float [nx][ny][nz];


			/**			if(showOutputs == 1){
				resultImage[1] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Initial Fantasm"));
				try {
					float [] imgBuffer = null;
					imgBuffer = crop.convertArray(initImg);
					resultImage[1].importData(0, imgBuffer, true);
				} catch (OutOfMemoryError e) {
					return;
				} catch (IOException error) {
					return;
				}	
			}
			 */
			//Do cropping iff center value is specified
			if (xCenter != 0 && yCenter != 0){
				int windowBig = 40;


				for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
					float dist = euclidDist2D(x, y, xCenter, yCenter);
					if (dist > windowBig){
						initImg[x][y][z] = 0;
					}
				}
			}



			//Compute initial centroid
			for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
				if (initImg[x][y][z] >= fantasmClasses){
					mask1[x][y][z] = 1.0f;
					mask3[x][y][z] = true;
				}
				else { 
					mask1[x][y][z] = 0.0f;
					mask3[x][y][z] = false;
				}
			}

			/**	if(showOutputs == 1){
				resultImage[2] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Thresholded Image"));
				try {
					float [] imgBuffer = null;
					imgBuffer = crop.convertArray(mask1);
					resultImage[2].importData(0, imgBuffer, true);
				} catch (OutOfMemoryError e) {
					return;
				} catch (IOException error) {
					return;
				}	
			}
			 */
			for(int ii=0;ii<nIsolation;ii++){
				mask1 = zDilate(mask1,1, nx, ny, nz);
				mask1 = erodeImage(mask1, nx, ny, nz, 1, 1, 0);
			}

			for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z =0;z<nz;z++){
				if (mask1[x][y][z] > 0) mask3[x][y][z] = true;
				else mask3[x][y][z] = false;
			}

			/**		if(showOutputs == 1){
				resultImage[3] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Post-dilation/erosion"));
				try {
					float [] imgBuffer = null;
					imgBuffer = crop.convertArray(mask1);
					resultImage[3].importData(0, imgBuffer, true);
				} catch (OutOfMemoryError e) {
					return;
				} catch (IOException error) {
					return;
				}	
			}
			 */

			//Find centroid
			int[] xCa, yCa;
			xCa = new int[nz];
			yCa = new int[nz];
			int xCtempA = 0;
			int yCtempA = 0;
			int wValuesA = 0;
			System.out.println("\n");

			for(int z=0;z<nz;z++){
				xCtempA = 0;
				yCtempA = 0;
				wValuesA = 0;
				for(int x=0;x<nx;x++)for(int y=0;y<ny;y++){		
					if(mask3[x][y][z] == true){
						xCtempA = xCtempA + x;
						yCtempA = yCtempA + y;
						wValuesA = wValuesA + 1;
					}
				}
				if(wValuesA != 0){ 
					xCa[z] = Math.round(xCtempA/wValuesA);
					yCa[z] = Math.round(yCtempA/wValuesA);
				}
			}

			System.out.println("Proposed New Centroids:\n");

			for(int z = 0;z<nz;z++){

				System.out.println("Centroid for slice: "+z+" is: ["+xCa[z]+"] ["+yCa[z]+"]\n");
			}

			mask4 = ObjectProcessing.connected6Object3D(mask3,nx,ny,nz);
			int labelCount = ObjectProcessing.countLabels(mask4,nx,ny,nz);
			//	System.out.println("(Label count is:" +labelCount+ ")\n");
			//float[] labelScore, labelArea;
			labelScore = new float[labelCount];
			labelArea = new int[labelCount];


			int[] labelAreaSort;
			labelAreaSort = new int[labelCount];
			for(int qq=0;qq<labelCount;qq++){
				labelAreaSort[qq] = labelArea[qq];
			}
			Arrays.sort(labelAreaSort);

			int labelAreaHalf = labelAreaSort[Math.round(labelCount/2)];

			for(int ii =0;ii<labelCount;ii++){
				if(labelArea[ii] < labelAreaHalf) labelArea[ii] = 0;
			}

			//Need to find centroid of each label area.  Subtract centroid from center of image.  Label score is area * 1/centroiddist
			float[] labelDist2;
			int failSlice = 0;
			labelDist2 = new float[labelCount];
			for (int ii=1;ii<labelCount;ii++){
				labelArea[ii] = 0;
				labelDist2[ii] = 0;
				for(int z=0;z<nz;z++){
					//failSlice = 0;
					int cPixelFail = 0;
					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++){
						if (mask4[x][y][z] == ii){
							cPixelFail++;
							labelDist2[ii] = labelDist2[ii]+euclidDist2D(xCa[z],yCa[z],x,y)*euclidDist2D(xCa[z],yCa[z],x,y)*euclidDist2D(xCa[z],yCa[z],x,y)*euclidDist2D(xCa[z],yCa[z],x,y);
							//tempImg[x][y][z] = true;
							labelArea[ii]++;
						}//else tempImg[x][y][z] = false;
					}
					if(cPixelFail < 5) failSlice++;

				}
				//if(failSlice > .20f*nz) labelArea[ii] = 0;
				labelScore[ii] = labelArea[ii]/(.00001f*labelDist2[ii]);
			}

			int highLabel = 0;

			float highLabelCount = 0;
			for (int ii=1;ii<labelCount;ii++){
				if (labelScore[ii]>highLabelCount && labelArea[ii] > minSpineComponent){
					//TODO
					highLabelCount = labelScore[ii];
					highLabel = ii;
				}	
			}

			for (int ii=0;ii<labelCount;ii++){
				System.out.println("(Label Score and Area for Label: "+ii+" is: "+labelScore[ii]+" and "+labelArea[ii]+")\n");	
			}	

			System.out.println("(Largest Object Label is: "+highLabel+" with a value of: "+highLabelCount+")\n");


			for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
				if (mask4[x][y][z] == highLabel){// || mask4[x][y][z] == secondLabel){
					topoMask[x][y][z] = 2.0f;
				} else {
					topoMask[x][y][z] = 0.0f;
				}
			}		
			/**	if(showOutputs == 1){
				resultImage[4] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Largest Component"));
				try {
					float [] imgBuffer = null;
					imgBuffer = crop.convertArray(topoMask);
					resultImage[4].importData(0, imgBuffer, true);
				} catch (OutOfMemoryError e) {
					return;
				} catch (IOException error) {
					return;
				}	
			}

			 */

			//	}
			//fill holes - TODO
			for(int ii = 0;ii<5;ii++){
				int connPixel1, connPixel2;
				for(int z = 0;z<nz; z++){

					for(int x=1;x<nx-1;x++){
						boolean csfEdge = false;
						boolean connPixel = false;
						connPixel1 = 0;
						connPixel2 = 0;
						for(int y=1;y<ny-1;y++){
							if(topoMask[x][y][z] == 2) csfEdge = true;
							if(csfEdge == true && topoMask[x][y][z] == 2 && connPixel == false){
								connPixel = true;
								connPixel1 = y;
							}
							if((topoMask[x][y][z] == 2 || topoMask[x][y-1][z] == 2 || topoMask[x][y+1][z] == 2) && csfEdge == true) connPixel2 = y;
						}
						if(csfEdge == true && connPixel == true){
							for(int y=connPixel1;y<=connPixel2;y++) topoMask[x][y][z] = 2; //must be region
						}
					}

					for(int y=1;y<ny-1;y++){
						boolean csfEdge = false;
						boolean connPixel = false;
						connPixel1 = 0;
						connPixel2 = 0;
						for(int x=1;x<nx-1;x++){
							if(topoMask[x][y][z] == 2) csfEdge = true;
							if(csfEdge == true && topoMask[x][y][z] == 2 && connPixel == false){
								connPixel = true;
								connPixel1 = x;
							}
							if((topoMask[x][y][z] == 2 || topoMask[x-1][y][z] == 2 || topoMask[x+1][y][z] == 2) && csfEdge == true) connPixel2 = x;
						}
						if(csfEdge == true && connPixel == true){
							for(int x=connPixel1;x<=connPixel2;x++) topoMask[x][y][z] = 2; //must be spine
						}
					}
				}
			}

			/**
			if(showOutputs == 1){
				resultImage[5] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Filled Region"));
				try {
					float [] imgBuffer = null;
					imgBuffer = crop.convertArray(topoMask);
					resultImage[5].importData(0, imgBuffer, true);
				} catch (OutOfMemoryError e) {
					return;
				} catch (IOException error) {
					return;
				}	
			}
			 */


			float[][][] topoMask2;
			topoMask2 = new float[nx][ny][nz];

			for(int x =0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
				if(topoMask[x][y][z] > 0) topoMask2[x][y][z] = imgOrig[x][y][z];
			}

				///////////////////////
				//CENTROID TO USE!!!
				///////////////////////	
				// THIS STEP IS USED TO "PUNCH A HOLE" IN THE MASK TO CREATE THE CORRECT TOPOLOGY			

				//To find equation for a1*z^2+b1*z+c1 and a2*z^2+b2*z+c2
				//hard coded 3
				float xCtemp = 0;
				float yCtemp = 0;
				float wValues = 0;
				int[] xC = null;
				int[] yC = null;
				xC = new int[nz];
				yC = new int[nz];
				System.out.println("\n");

				for(int z=0;z<nz;z++){
					for(int x=0;x<nx;x++)for(int y=0;y<ny;y++){		
						if(topoMask[x][y][z] > 0.0f){
							xCtemp = xCtemp + x;
							yCtemp = yCtemp + y;
							wValues = wValues + 1;

						}
					}
					if(wValues != 0){
						xC[z] = Math.round(xCtemp/wValues)+xBias;
						yC[z] = Math.round(yCtemp/wValues)+yBias;
					}else{
						System.out.format("WARNING: Empty Slice");
					}

					//reinitialize for next pass
					xCtemp = 0;
					yCtemp = 0;
					wValues = 0;
				}

				JamaMatrix A = new JamaMatrix(nz,3,0.0f);
				JamaMatrix b1 = new JamaMatrix(nz,1,0.0f);
				JamaMatrix b2 = new JamaMatrix(nz,1,0.0f);
				JamaMatrix x1 = new JamaMatrix(3,1,0.0f);
				JamaMatrix y1 = new JamaMatrix(3,1,0.0f);

				for(int ii=0;ii<nz;ii++) {

					b1.set(ii,0, xC[ii]);
					b2.set(ii,0, yC[ii]);
				}

				for(int ii=0;ii<nz;ii++){
					for(int j=0;j<3;j++){
						if(j==0)	A.set(ii,j,ii*ii);
						if(j==1)    A.set(ii,j,ii);
						if(j==2)    A.set(ii,j,1);
					}
				}
				double[] xEqn = null;
				double[] yEqn = null;
				xEqn = new double[3];
				yEqn = new double[3];
				x1 = A.solve(b1);
				y1 = A.solve(b2);

				for(int jj=0;jj<3;jj++){
					xEqn[jj] = x1.get(jj, 0);
					yEqn[jj] = y1.get(jj, 0);
				}

				System.out.println("Equation for centroid in x is: "+xEqn[0]+"*z^2 + "+xEqn[1]+"*z + "+xEqn[2]+"\n");
				System.out.println("Equation for centroid in y is: "+yEqn[0]+"*z^2 + "+yEqn[1]+"*z + "+yEqn[2]+"\n");

				int[] xC2 = null;
				int[] yC2 = null;
				xC2 = new int[nz];
				yC2 = new int[nz];

				for(int z=0;z<nz;z++){

					xC2[z] = (int)Math.max(0,Math.min(nx-1,Math.round(xEqn[0]*z*z+xEqn[1]*z+xEqn[2])));
					yC2[z] = (int)Math.max(0,Math.min(ny-1,Math.round(yEqn[0]*z*z+yEqn[1]*z+yEqn[2])));
					System.out.println("Equation for centroid in slice: "+z+" is: ["+xC2[z]+"] ["+yC2[z]+"])");
					System.out.println(" with a voxel value of: ["+imgOrig[xC2[z]][yC2[z]][z]+"]\n");
				}



				//END CENTROID TO USE			
				topoMask = new float[nx][ny][nz];
				for(int z = 0; z<=nz-1; z++){
					for(int x=0;x<nx;x++)for(int y=0;y<ny;y++){

						if(euclidDist2D(x, y, xC2[z], yC2[z])<20)	topoMask[x][y][z] = 2;
					}
				}


				//Add connected section
				int xP1, xP2, yP1, yP2;
				int k = 0;
				float[] cSpine;
				int maxXdist=0;
				int maxYdist=0;
				for (int z=0;z<nz;z++){
					if(z == nz-1){
						xP1 = xC2[z];
						xP2 = xC2[z];
						yP1 = yC2[z];
						yP2 = yC2[z];
					}else{
						xP1 = Math.min(xC2[z],xC2[z+1]);
						xP2 = Math.max(xC2[z],xC2[z+1]);
						yP1 = Math.min(yC2[z],yC2[z+1]);
						yP2 = Math.max(yC2[z],yC2[z+1]);
					}

					if(maxXdist < Math.abs(xP1 - xP2))maxXdist = Math.abs(xP1 - xP2); 
					if(maxYdist < Math.abs(yP1 - yP2))maxYdist = Math.abs(yP1 - yP2);

				}

				cSpine = new float[(maxYdist+1)* (maxXdist+1)*nz];
				for (int z=0;z<nz;z++){

					if(z == nz-1){
						xP1 = xC2[z];
						xP2 = xC2[z];
						yP1 = yC2[z];
						yP2 = yC2[z];
					}else{
						xP1 = Math.min(xC2[z],xC2[z+1]);
						xP2 = Math.max(xC2[z],xC2[z+1]);
						yP1 = Math.min(yC2[z],yC2[z+1]);
						yP2 = Math.max(yC2[z],yC2[z+1]);
					}

					for(int xx = xP1;xx<xP2+1;xx++){
						for(int yy = yP1;yy<yP2+1;yy++){

							topoMask[xx][yy][z] = 1;
							cSpine[k] = imgOrig[xx][yy][z];
							k++;
						}
					}
				}	
				/**	if(showOutputs == 1){
					resultImage[6] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Spine Curve"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(topoMask);
						resultImage[6].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}	
				}
				 */
				System.out.println("The number of pixels for the spine is: "+k+"\n");

					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){	

						float dist3 = euclidDist2D(x, y, xC2[z], yC2[z]);
						if (dist3 > windowSize) {    //windowSize2){

							imgOut[x][y][z] = 0.0f;
						}else {
							imgOut[x][y][z] = imgOrig[x][y][z];
							//	cImage[k2] = imgOrig[x][y][z];
							//	k2++;
						}
					}

					/**
					if(showOutputs == 1){
						resultImage[7] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Cropped Image"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(imgOut);
							resultImage[7].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}
					 */
					/////////////////////////////////////
					///FANTASM FOR STAGE 2///
					/////////////////////////////////////

					//Now we need to do the median

					float vSpine = 0.0f;
					float[] cSpine2;
					cSpine2 = new float[k];

					for(int qq=0;qq<k;qq++){
						cSpine2[qq] = cSpine[qq];
					}

					Arrays.sort(cSpine2);

					if(k % 2 == 1){   //k is odd
						vSpine = (cSpine2[(k-1)/2]);
					}else{
						vSpine = (cSpine2[k/2-1]+cSpine2[k/2])/2;
					}

					System.out.println("Median of Spine is:"  + vSpine + "\n");

					//Setup code for FANTASM - what can we do to preserve precise estimate?  Does it matter?

					float[] cImage;
					cImage = new float[Math.round(windowSize*windowSize*4*nz*1.25f)];//Hack//1.5f*nz*windowSize*windowSize)];
					int k2 = 0;
					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){	

						float dist3 = euclidDist2D(x, y, xC2[z], yC2[z]);
						if (dist3 > windowSize) {

							imgOut[x][y][z] = 0.0f;
						}else {
							imgOut[x][y][z] = imgOrig[x][y][z];
							cImage[k2] = imgOrig[x][y][z];
							k2++;
						}
					}

					System.out.println("The number of elements in cImage is: "+k2+"\n");
					float[] cImage2;
					cImage2 = new float[k2];

					for(int qq=0;qq<k2;qq++){
						cImage2[qq] = cImage[qq];
					}
					Arrays.sort(cImage2);

					float vBackground = cImage2[Math.round(k2/20)];
					float vCSF = Math.max(cImage2[(int)Math.round(k2*.6)],vSpine+50000);

					System.out.println("Here are the centroids: BG: "+Math.round(vBackground)+" Spine: "+Math.round(vSpine)+" CSF: "+vCSF+"\n");

					/////////////////////////////////////////////////////////////////////
					//Need to find centroids and do FCM Segmentation on a per-slice basis
					/////////////////////////////////////////////////////////////////////					

					float[][][] sliceSeg1;

					for(int z = 0; z<nz; z++){
						System.out.println("Starting FCM Segmentation for Slice: ["+z+"]\n");

						sliceSeg1 = new float[nx][ny][1];

						for(int x = 0;x<nx;x++)for(int y = 0;y<ny;y++){
							sliceSeg1[x][y][0] = imgOut[x][y][z];  //This creates the 2D image for the FANTASM segmentation
						}

						destExtents[0] = nx;
						destExtents[1] = ny;
						destExtents[2] = 1;
						resultImage[0] = (new ImageDataFloat(sliceSeg1)).getModelImageCopy();
						/*
								//resultImage[0] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "Spine Slice Region");
								//makeImageName(image.getImageName(),"_spineSliceRegion"));

								try {
									float [] imgBuffer = null;
									imgBuffer = ImageCropper.convertArray(sliceSeg1, nx, ny, 1);
									//									imgBuffer = crop.convertArray(sliceSeg1, nx, ny, 1); //TODO

									resultImage[0].importData(0, imgBuffer, true);

									//resultImage[n].importData(0,crop.convertArray(imgOut[n],true);
									//      algorithmPerformed(segment);
								} catch (OutOfMemoryError e) {

									return;
								} catch (IOException error) {

									return;
								}*/		

						ModelImage[] segImages2 = new ModelImage[4];
						segImages2[0] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "segmented_image");
						segImages2[1] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "segmented_image");
						segImages2[2] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "segmented_image");
						segImages2[3] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "segmented_image");

						segment2 = new AlgorithmFantasm(segImages2, resultImage[0], 
								1, "range", "both_fuzzy_&_hard",//"hard_segmentation", // "both_fuzzy_&_hard",
								3, 50, 0.01f, 0.01f, //.1f //25
								2.0f,
								false, 0.1f, 
								"none", 3,
								false, 0.0f, 0.0f, 0.0f,
								true, 0.05f, true, false);  

						segment2.run();

						segment2.finalize();

						for(int x=0;x<nx;x++)for(int y=0;y<ny;y++){

							imgF0[x][y][z] = segImages2[0].getFloat(x,y,0);
							imgF1[x][y][z] = segImages2[1].getFloat(x,y,0);
							imgF2[x][y][z] = segImages2[2].getFloat(x,y,0);
							imgF3[x][y][z] = segImages2[3].getFloat(x,y,0);
						}
					}
					destExtents[2] = nz;
					System.out.println("Got past segmentation!!!\n");

					/**		if(showOutputs == 1){
						resultImage[8] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Spine Segementation2"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(imgF1);
							resultImage[8].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}

					 */
					/**		if(showOutputs == 1){
						resultImage[9] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"CSF Segmentation2"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(imgF2);
							resultImage[9].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}
					 */

					/**
					if(showOutputs == 1){
						resultImage[10] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Hard Segmentation2"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(imgF3);
							resultImage[10].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}
					 */
					//region connectivity

					spineMask1 = new int[nx][ny][nz];
					boolean[][] spineMaskTest;
					int[][] maskSegGrow;
					boolean endTest = false;

					int countZ = 0;
					float testScore;

					//////////////////////
					//Third Segmentation
					//////////////////////

					//Can we use topology?  

					//SpineMask1 does a hopefully excellent job of segmenting the spine and CSF from the background.
					//The next task is to use this information to create a partial volume segmentation using calculated
					//centroid classes to identify which of these pixels are spine (instead of CSF).
					//The spine pixels will be grown from this new underlying segmentation map.


					//This is a two class problem.  Accept that there are still some background pixels - these will be ignored for now.
					//Hopefully the growth process will fix this later.

					//Spine Centroid:  centroid values from above, but take center and look at surrounding 8 pixels as well.  Take all of the 
					//pixels from the slices 8*nz pixels and use the median of that for the initial class centroid.

					//CSF Centroid:  Use the 80% percentile value as the CSF centroid.  May need to adjust this. 

					//Find Spine Centroid: 

					/////////////////////
					//Region Growing Part 2
					/////////////////////
					float spineMask2[][][];
					spineMask2 = new float[nx][ny][nz];
					endTest = false;
					//implement slice by slice for overlap term
					System.out.println("\nNow starting spine/CSF region growing:\n");
					for(int x=2;x<nx-2;x++)for(int y=2;y<ny-2;y++)for(int z = 0; z<=nz-1; z++){
						for(int ii = -2;ii<=2;ii++){
							if(topoMask[x+ii][y+ii][z] == 1)	spineMask2[x][y][z] = 1;  //initialize mask
						}
					}


					///////////////////////
					//DETERMINE BACKGROUND REGION REGION
					///////////////////////

					//spineMask1 is the result from the previous processing
					endTest = false;
					countZ = 0;

					//Initialize CSF region:
					for(int z = 0;z<nz;z++){
						//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
						for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
							for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
								if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
									if(spineMask2[x+1][y][z] == 1 || spineMask2[x-1][y][z] == 1 || spineMask2[x][y-1][z] == 1 || spineMask2[x][y+1][z] == 1){
										spineMask2[x][y][z] = 2;
									}
								}
							}
					}

					while(endTest == false){
						countZ++;
						System.out.println("Overall z-iteration #: "+countZ+"\n");
						endTest = true;

						for(int z = 0; z<nz-1; z++){
							int nbPixels = 0;
							spineMaskTest = new boolean[nx][ny];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
										if(spineMask2[x+1][y][z] == 2 || spineMask2[x-1][y][z]==2 || spineMask2[x][y-1][z] == 2 || spineMask2[x][y+1][z] == 2){
											nbPixels++; //useful for tendril elimination
											//this is being calculated extra times - but saves an if loop

											//Then we need to find out the energy value for that pixel.  Would changing it to spine make things better?
											//To satisfy this, all that needs to be tested is if the E of the new changed pixel is negative
											//If it is, add it to the map.  If not, skip it.

											if(spineMask2[x][y][z+1]==2){
												//float testScore = csfC*imgF2[x][y][z]+bgC*imgF0[x][y][z]-spC*imgF1[x][y][z]-connC*spineMask1[x][y][z-1];
												testScore = -imgF2[x][y][z]+1*imgF0[x][y][z]-imgF1[x][y][z]-.7f;//connC;//-csfC*imgF2[x][y][z]+bgC*imgF0[x][y][z]+spC*imgF1[x][y][z]-connC;
											}else{ 
												testScore = -imgF2[x][y][z]+1*imgF0[x][y][z]-imgF1[x][y][z]+0.7f;//connC;//-csfC*imgF2[x][y][z]+bgC*imgF0[x][y][z]+spC*imgF1[x][y][z]+connC;
											}

											if(testScore < 0){
												spineMaskTest[x][y] = true; 
											}
										}	
									}
								}

							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);

							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){	
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}


							highLabel = 0;
							highLabelCount = 0;

							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>tendrilThresh*.5*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0) highLabel = -100;

							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										spineMask2[x][y][z] = 2;
										//Iterate over all slices until no boundary pixels show an improvement!
										endTest = false;

									}
								}

						}

						for(int z = nz-1; z>0; z--){
							int nbPixels = 0;
							spineMaskTest = new boolean[nx][ny];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){

									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
										if(spineMask2[x+1][y][z] == 2 || spineMask2[x-1][y][z]==2 || spineMask2[x][y-1][z] == 2 || spineMask2[x][y+1][z] == 2){
											nbPixels++;

											if(spineMask2[x][y][z-1]==2){
												testScore = -imgF2[x][y][z]+10*imgF0[x][y][z]-imgF1[x][y][z]-0.2f;
											}else{ 
												testScore = -imgF2[x][y][z]+10*imgF0[x][y][z]-imgF1[x][y][z]+0.2f;
											}
											if(testScore < 0){
												spineMaskTest[x][y] = true; 	//make sure that this is a sufficient condition             			

											}
										}	
									}
								}
							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);

							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}


							highLabel = 0;
							highLabelCount = 0;
							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>tendrilThresh*.5*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0) highLabel = -100;

							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										spineMask2[x][y][z] = 2;
										//Iterate over all slices until no boundary pixels show an improvement!
										endTest = false;
									}
								}
						}



					}  //while statement

					///////////////////////////
					//END REGION GROWING PART 2
					///////////////////////////
					segGrow1 = new float[nx][ny][nz];

					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						if(euclidDist2D(x,y,xC2[z],yC2[z])>=40){
							segGrow1[x][y][z] = 0.0f;  //bg 
						}
						if(euclidDist2D(x, y, xC2[z],yC2[z]) < 40){
							segGrow1[x][y][z] = 0.2f; //bg inner
						}
						if(spineMask2[x][y][z] == 2){
							segGrow1[x][y][z] = 2.0f;
						}
						if(spineMask2[x][y][z] == 1){
							segGrow1[x][y][z] = 1.0f;
						}

					}                   
					/**				if(showOutputs == 1){
						resultImage[11] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "Region 1");//makeImageName(image.getImageName(),"Region 1"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(segGrow1);
							resultImage[11].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}
					 */
					regionMask = new float[nx][ny][nz];

					//Modified Fill Holes Routine
					int csfEdge1, csfEdge2;
					for(int z = 0;z<nz; z++){

						//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
						for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
							boolean csfEdge = false;
							boolean csfEdgeOn = false;
							csfEdge1 = yC[z];
							csfEdge2 = yC[z];
							for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
								//for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								if(segGrow1[x][y][z] > .5) csfEdge = true;
								if(csfEdge == true && segGrow1[x][y][z] > 0.5 && csfEdgeOn == false)
									csfEdgeOn = true;
								csfEdge1 = y;

								if(segGrow1[x][y][z] > 0.5 && csfEdge == true) csfEdge2 = y;
							}
							if(csfEdge == true && csfEdgeOn == true){
								for(int y=csfEdge1;y<=csfEdge2;y++) regionMask[x][y][z] = 1; //must be region
							}
						}

						//for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
						for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
							boolean csfEdge = false;
							boolean csfEdgeOn = false;
							csfEdge1 = xC[z];
							csfEdge2 = xC[z];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
								if(segGrow1[x][y][z] > 0.5) csfEdge = true;
								if(csfEdge == true && segGrow1[x][y][z] > 0.5 && csfEdgeOn == false){
									csfEdgeOn = true;
									csfEdge1 = x;
								}
								if(segGrow1[x][y][z] > 0.5 && csfEdge == true) csfEdge2 = x;
							}
							if(csfEdge == true && csfEdgeOn == true){
								for(int x=csfEdge1;x<=csfEdge2;x++) regionMask[x][y][z] = 1; //must be spine
							}
						}
					}


				/**			if(showOutputs == 1){
					resultImage[12] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Region Mask1"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(regionMask);
						resultImage[12].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}	
				}
				 */

				imgOut = new float[nx][ny][nz]; //zero out the matrix
				regionMaskSpine = new float[nx][ny][nz];
				//added erosion step - temporary
				regionMaskSpine =  erodeImage(regionMask, nx, ny, nz, 5, 5, 0);
				for(int x = 0; x<nx; x++)for(int y = 0; y<ny; y++)for(int z = 0;z<nz;z++){
					if(regionMask[x][y][z] == 1) {
						imgOut[x][y][z] = imgOrig[x][y][z];  
					}
				}

				float[][][] spineCentroidMask5, spineCentroidMask10;
				spineCentroidMask10 = new float[nx][ny][nz];
				spineCentroidMask5 = new float[nx][ny][nz];

				spineCentroidMask10 =  erodeImage(regionMask, nx, ny, nz, 10, 10, 0);
				spineCentroidMask5 = erodeImage(regionMask, nx, ny, nz, 5, 5, 0);

				xCtemp = 0;
				yCtemp = 0;
				wValues = 0;

				xC = new int[nz];
				yC = new int[nz];

				for(int z=0;z<nz;z++){
					boolean foundCentroid = false;
					for(int x = 0;x<nx;x++)for(int y=0;y<ny;y++){
						if(spineCentroidMask10[x][y][z]>0 && imgF1[x][y][z] > 0.25f){
							xCtemp = xCtemp + x*imgF1[x][y][z];
							yCtemp = yCtemp + y*imgF1[x][y][z];
							wValues = wValues + imgF1[x][y][z];
							foundCentroid = true;	
						}
					}
					if(foundCentroid == true){
						xC[z] = Math.round(xCtemp/wValues)+xBias;
						yC[z] = Math.round(yCtemp/wValues)+yBias;
					}else{

						xCtemp = 0;
						yCtemp = 0;
						wValues = 0;
						for(int x = 0;x<nx;x++)for(int y=0;y<ny;y++){
							if(spineCentroidMask5[x][y][z]>0 && imgF1[x][y][z] > 0.25f){
								xCtemp = xCtemp + x*imgF1[x][y][z];
								yCtemp = yCtemp + y*imgF1[x][y][z];
								wValues = wValues + imgF1[x][y][z];
							}
						}
						if(wValues != 0){
							xC[z] = Math.round(xCtemp/wValues)+xBias;
							yC[z] = Math.round(yCtemp/wValues)+yBias;
							System.out.format("x:" + xC[z] + " y:" + yC[z] + " z:"+z+"\n");
						}else{
							System.out.format("WARNING: Empty Slice");
						}
					}
					//reinitialize for next pass
					xCtemp = 0;
					yCtemp = 0;
					wValues = 0;
				}

				JamaMatrix A2 = new JamaMatrix(nz,3,0.0f);
				JamaMatrix b12 = new JamaMatrix(nz,1,0.0f);
				JamaMatrix b22 = new JamaMatrix(nz,1,0.0f);
				JamaMatrix x12 = new JamaMatrix(3,1,0.0f);
				JamaMatrix y12 = new JamaMatrix(3,1,0.0f);

				for(int ii=0;ii<nz;ii++) {

					b12.set(ii,0, xC[ii]);
					b22.set(ii,0, yC[ii]);
				}

				for(int ii=0;ii<nz;ii++){
					for(int j=0;j<3;j++){
						if(j==0)	A2.set(ii,j,ii*ii);
						if(j==1)    A2.set(ii,j,ii);
						if(j==2)    A2.set(ii,j,1);
					}
				}

				xEqn = new double[3];
				yEqn = new double[3];
				x12 = A2.solve(b12);
				y12 = A2.solve(b22);

				for(int jj=0;jj<3;jj++){
					xEqn[jj] = x12.get(jj, 0);
					yEqn[jj] = y12.get(jj, 0);
				}

				System.out.println("Equation for centroid in x is: "+xEqn[0]+"*z^2 + "+xEqn[1]+"*z + "+xEqn[2]+"\n");
				System.out.println("Equation for centroid in y is: "+yEqn[0]+"*z^2 + "+yEqn[1]+"*z + "+yEqn[2]+"\n");

				xC2 = new int[nz];
				yC2 = new int[nz];

				for(int z=0;z<nz;z++){

					xC2[z] = Math.max(0, Math.min(nx-1,(int)Math.round(xEqn[0]*z*z+xEqn[1]*z+xEqn[2])));
					yC2[z] = Math.max(0, Math.min(ny-1,(int)Math.round(yEqn[0]*z*z+yEqn[1]*z+yEqn[2])));
					System.out.println("Equation for centroid in slice: "+z+" is: ["+xC2[z]+"] ["+yC2[z]+"] with a voxel value of: ["+imgOrig[xC2[z]][yC2[z]][z]+"]\n");
				}

				//END NEW ESTIMATION



				/////////////////////////////////////////////////////////////////////////////////
				///THIS IS A TEMPORARY RESEGMENTATION AND REGION GROWING STEP TO TEST A THEORY///
				/////////////////////////////////////////////////////////////////////////////////				
				int FCMType = 2;
				if(FCMType == 2){
					float spCentroid2[], csfCentroid2[], bgCentroid2[];
					spCentroid2 = new float[nz];
					csfCentroid2 = new float[nz];
					bgCentroid2 = new float[nz];
					float[] cImage3b, cSpine3, cImage3;
					cImage3b = new float[(int)Math.round(windowSize*2*windowSize*2*1.1)];//1.5f*nz*windowSize*windowSize)];

					for(int z=0;z<nz;z++){
						int k3 = 0;
						//for (int x=xC2[z]-windowSize;x<=xC2[z]+windowSize;x++)for(int y=yC2[z]-windowSize;y<=yC2[z]+windowSize;y++){
						for(int x=Math.max(1,xC2[z]-windowSize);x<Math.min(nx-1,xC2[z]+windowSize);x++)
							for(int y=Math.max(1,yC2[z]-windowSize);y<Math.min(ny-1,yC2[z]+windowSize);y++){
								//if(spineMask1[x][y][z] == 1){

								cImage3b[k3] = imgOrig[x][y][z];
								k3++;
								//}
							}			

						cImage3 = new float[k3];
						for(int qq=0;qq<k3;qq++){
							cImage3[qq] = cImage3b[qq];
						}
						Arrays.sort(cImage3);
						csfCentroid2[z] = cImage3[(int)Math.round(k3*0.98f)];
						//csfCentroid2[z] = Math.max(csfCentroid2[z],spCentroid2[z]+50000);
					}	  
					for(int z=0;z<nz;z++){
						cSpine3 = new float[49];
						int qidx = 0;
						for(int x=-3;x<=3;x++){
							for(int y=-3;y<=3;y++){
								if(xC2[z]+x < nx && xC2[z]+x >= 0 && yC2[z]+y < ny && yC2[z]+y >=0){
									cSpine3[qidx] = imgOrig[xC2[z]+x][yC2[z]+y][z];
									qidx++;
								}
							}
						}

						Arrays.sort(cSpine3);

						if(qidx % 2 == 1){   //k is odd
							spCentroid2[z] = (cSpine3[(qidx-1)/2]);
						}else{
							spCentroid2[z] = (cSpine3[qidx/2-1]+cSpine3[qidx/2])/2;
						}

						//these are correction (bounding) terms that seem to work well
						csfCentroid2[z] = Math.min(2.0f*spCentroid2[z],csfCentroid2[z]);

						float centroidSep = Math.abs(csfCentroid2[z]-spCentroid2[z]);
						if(centroidSep < 0.05*csfCentroid2[z]){
							spCentroid2[z] = csfCentroid2[z]*.95f;
						}

						//spCentroid2[z] =  Math.min((float)csfCentroid2[z]*.9f,spCentroid2[z]);//csfCentroid2[z]*.7); //spCentroid2[z]+50000;

						bgCentroid2[z] = Math.round(spCentroid2[z]*.001);
					}

					//Basic FCM  B =0, no q term

					//initial conditions
					float[] vk;
					vk = new float[3];

					float[][][] u0, u1, u2;
					u0 = new float[nx][ny][nz];
					u1 = new float[nx][ny][nz];
					u2 = new float[nx][ny][nz];

					float tempU;
					//membership functions

					float bgCrop = 0;// cImage2[Math.round(k2/100)];
					//Background cropping
					System.out.println("Background Cropping Value for RFCM: "+bgCrop+"\n");

					for(int z=0;z<nz;z++){
						bgCrop = 0;// cImage2[Math.round(k2/100)];
						vk[0] = bgCentroid2[z];
						vk[1] = spCentroid2[z];
						vk[2] = csfCentroid2[z];

						for (int x=0;x<nx;x++)for(int y=0;y<ny;y++){
							if(imgOut[x][y][z]>bgCrop){
								tempU = Math.max((imgOut[x][y][z]-vk[0])*(imgOut[x][y][z]-vk[0]),1E-30f);
								u0[x][y][z] = 1.0f/tempU;

								tempU = Math.max((imgOut[x][y][z]-vk[1])*(imgOut[x][y][z]-vk[1]),1E-30f);
								u1[x][y][z] = 1.0f/tempU;

								tempU = Math.max((imgOut[x][y][z]-vk[2])*(imgOut[x][y][z]-vk[2]),1E-30f);
								u2[x][y][z] = 1.0f/tempU;

								float uD = u0[x][y][z]+u1[x][y][z]+u2[x][y][z];

								u0[x][y][z] = u0[x][y][z]/uD;
								u1[x][y][z] = u1[x][y][z]/uD;
								u2[x][y][z] = u2[x][y][z]/uD;
							}
						}

						System.out.println("Current centroids are: ["+vk[0]+"] ["+vk[1]+"] ["+vk[2]+"]\n");
					}


					float[][][] regSegment;
					regSegment = new float[nx][ny][nz];
					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						float dist4 = euclidDist2D(x, y, xC2[z], yC2[z]);
						if (dist4 < windowSize) { 
							//uMember[x][y][z][2] = uMember[x][y][z][2]*1.3f; // this is experimental and not currently used

							if(u1[x][y][z]>=u0[x][y][z] && u1[x][y][z]>=u2[x][y][z]) regSegment[x][y][z] = 1.0f;	

							if(u2[x][y][z]>=u0[x][y][z] && u2[x][y][z]>=u1[x][y][z]) regSegment[x][y][z] = 2.0f;	
							if(u0[x][y][z]>=u1[x][y][z] && u0[x][y][z]>=u2[x][y][z]) regSegment[x][y][z] = 0.0f;	
						}
					}
					imgF1 = u1;
					imgF2 = u2;

				}

				for(int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
					if(regionMaskSpine[x][y][z] == 0){ 
						imgF1[x][y][z] = 0; 
						//confirm this step
					}
				}

				//Recalculate centroid for spinal column

				///////////////////////
				//CENTROID TO USE!!!
				///////////////////////	
				// THIS STEP IS USED TO "PUNCH A HOLE" IN THE MASK TO CREATE THE CORRECT TOPOLOGY			

				/**	if(showOutputs == 1){
					resultImage[13] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"BG Segment"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(imgF0);
						resultImage[13].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}	
				}
				 */
				/**	if(showOutputs == 1){
					resultImage[14] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Spine Segment 3"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(imgF1);
						resultImage[14].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}	
				}
				 */

				/**			if(showOutputs == 1){
					resultImage[15] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"CSF Segment 3"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(imgF2);
						resultImage[15].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}	
				}
				 */

				//NOW NEED TO REGROW EVERYTHING AND OUTPUT AGAIN!!!

				/////////////////////
				//Region Growing Part 2
				/////////////////////
				

					spineMask1 = new int[nx][ny][nz];
					endTest = false;

					countZ = 0;
					//implement slice by slice for overlap term
					System.out.println("\nNow starting spine region growing:\n");

					spineMask2 = new float[nx][ny][nz];
					endTest = false;
					//implement slice by slice for overlap term
					for(int x=3;x<nx-3;x++)for(int y=3;y<ny-3;y++)for(int z = 0; z<=nz-1; z++){
						for(int ii = -3;ii<=3;ii++){
							if(topoMask[x+ii][y+ii][z] == 1)	spineMask2[x][y][z] = 1;  //initialize mask
						}
					}

					float[][][] spineMaskC;
					spineMaskC = new float[nx][ny][nz];

					for(int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						if(spineMask2[x][y][z] == 0) spineMaskC[x][y][z] = -1;
						if(spineMask2[x][y][z] == 1) spineMaskC[x][y][z] = 1;

					}

					float connC2;
					while(endTest == false){
						countZ++;
						System.out.println("Overall z-iteration #: "+countZ+"\n");
						endTest = true;

						for(int z = 1; z<=nz-1; z++){

							int nbPixels = 0;
							spineMaskTest = new boolean[nx][ny];
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){

									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){// && spineMask1[x][y][z] == 1){  //must be 0 to be an (outside) boundary pixel
										float connectedTest = spineMask2[x+1][y][z]+spineMask2[x-1][y][z]+spineMask2[x][y-1][z]+spineMask2[x][y+1][z];
										if(connectedTest >= 1){
											nbPixels++; //useful for tendril elimination

											if(z == 1){
												connC2 = (float)(-0.7*spineMaskC[x][y][z-1]);
											}else{
												connC2 = (float)(-0.2*spineMaskC[x][y][z-2]-0.7*spineMaskC[x][y][z-1]);
											}

											testScore = csfC*imgF2[x][y][z]-spC*imgF1[x][y][z]+connC*connC2+bgC*imgF0[x][y][z];

											if(testScore < 0){
												spineMaskTest[x][y] = true; 	//make sure that this is a sufficient condition             			

											}
										}	
									}
								}
							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);
							System.out.println("Number of labels is: "+labelCount+"\n");
							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}

							highLabel = 0;

							highLabelCount = 0;
							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>tendrilThresh*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0){
								highLabel = -100;
								System.out.println("Set high label = -100\n");
							}
							System.out.println("Just prior to change pixels.\n");
							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							System.out.println("windowSize = "+windowSize+" xC[z]-windowSize ="+windowSize+"yC[z] ="+yC[z]+" z = "+z+"\n");
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										System.out.println("x: "+x+" y: "+y+" z: "+z+"\n");
										spineMask2[x][y][z] = 1;
										spineMaskC[x][y][z] = 1;
										//Iterate over all slices until no boundary pixels show an improvement!
										endTest = false;
									}
								}

						}
						System.out.println("Completed first half of processing\n");
						for(int z = nz-2; z>=0; z--){

							//if(z == 0) System.out.println("0th slice being operated on!\n");
							int nbPixels = 0;
							//			System.out.println("\nStarting Processing for Slice: "+z+"...");
							spineMaskTest = new boolean[nx][ny];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){// && spineMask1[x][y][z] == 1){  //must be 0 to be an (outside) boundary pixel
										float connectedTest = spineMask2[x+1][y][z]+spineMask2[x-1][y][z]+spineMask2[x][y-1][z]+spineMask2[x][y+1][z];
										if(connectedTest >= 1){
											nbPixels++;

											//this is being calculated extra times - but saves an if loop

											if(z == nz-2){
												connC2 = (float)(-0.7*spineMaskC[x][y][z+1]);
											}else{
												connC2 = (float)(-0.7*spineMaskC[x][y][z+1]-0.2*spineMaskC[x][y][z+2]);
											}

											//connC = connC/2;
											testScore = csfC*imgF2[x][y][z]-spC*imgF1[x][y][z]+connC2*connC+bgC*imgF0[x][y][z];


											if(testScore < 0){
												spineMaskTest[x][y] = true; 	//make sure that this is a sufficient condition             			
											}
										}
									}	
								}
							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);

							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}

							highLabel = 0;

							highLabelCount = 0;
							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>tendrilThresh*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0) highLabel = -100;

							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										spineMask2[x][y][z] = 1;
										spineMaskC[x][y][z] = 1;

										endTest = false;

									}
								}
						}
					}  //while statement


					///////////////////////
					//DETERMINE CSF REGION
					///////////////////////

					//spineMask1 is the result from the previous processing
					endTest = false;
					countZ = 0;

					//Initialize CSF region:
					for(int z = 0;z<nz;z++){
						//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
						for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
							for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
								if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
									if(spineMask2[x+1][y][z] == 1 || spineMask2[x-1][y][z] == 1 || spineMask2[x][y-1][z] == 1 || spineMask2[x][y+1][z] == 1){
										spineMask2[x][y][z] = 2;
									}
								}
							}
					}

					//initialize connectivity mask - discriminate between tube and non-tube (background)
					float[][][] csfMaskC;
					csfMaskC = new float[nx][ny][nz];

					for(int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						if(spineMask2[x][y][z] > 0) csfMaskC[x][y][z] = 1;
						if(spineMask2[x][y][z] == 0) csfMaskC[x][y][z] = -1;

					}

					while(endTest == false){
						countZ++;
						System.out.println("Overall z-iteration #: "+countZ+"\n");
						endTest = true;

						for(int z = 1; z<=nz-1; z++){
							int nbPixels = 0;
							spineMaskTest = new boolean[nx][ny];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
										if(spineMask2[x+1][y][z] == 2 || spineMask2[x-1][y][z]==2 || spineMask2[x][y-1][z] == 2 || spineMask2[x][y+1][z] == 2){
											nbPixels++; //useful for tendril elimination
											//this is being calculated extra times - but saves an if loop

											//Then we need to find out the energy value for that pixel.  Would changing it to spine make things better?
											//To satisfy this, all that needs to be tested is if the E of the new changed pixel is negative
											//If it is, add it to the map.  If not, skip it.

											if(z == 1){
												connC2 = (float)(-0.6*csfMaskC[x][y][z-1]);
											}else{
												connC2 = (float)(-0.3*csfMaskC[x][y][z-2]-0.6*csfMaskC[x][y][z-1]);
											}

											testScore = -imgF2[x][y][z]-imgF1[x][y][z]+connC2+10*imgF0[x][y][z]+connC2;

											if(testScore < 0){
												spineMaskTest[x][y] = true; 
											}
										}	
									}
								}

							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);

							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//	for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}

							highLabel = 0;
							highLabelCount = 0;

							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>.001f*nbPixels){//tendrilThresh*.5*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0) highLabel = -100;

							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										spineMask2[x][y][z] = 2;
										csfMaskC[x][y][z] = 1;
										//Iterate over all slices until no boundary pixels show an improvement!
										endTest = false;
										}
								}

						}

						for(int z = nz-2; z>=0; z--){
							int nbPixels = 0;
							//			System.out.println("\nStarting Processing for Slice: "+z+"...");
							spineMaskTest = new boolean[nx][ny];
							//	for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									//first we need to find the boundary pixels for each slice
									//Using 4 connectivity
									if(spineMask2[x][y][z] == 0){  //must be 0 to be an (outside) boundary pixel
										if(spineMask2[x+1][y][z] == 2 || spineMask2[x-1][y][z]==2 || spineMask2[x][y-1][z] == 2 || spineMask2[x][y+1][z] == 2){
											nbPixels++;
											//this is being calculated extra times - but saves an if loop

											//Then we need to find out the energy value for that pixel.  Would changing it to spine make things better?
											//To satisfy this, all that needs to be tested is if the E of the new changed pixel is negative
											//If it is, add it to the map.  If not, skip it.

											if(z == nz-2){
												connC2 = (float)(-0.6*csfMaskC[x][y][z+1]);
											}else{
												connC2 = (float)(-0.6*csfMaskC[x][y][z+1]-0.3*csfMaskC[x][y][z+2]);
											}

											testScore = -imgF2[x][y][z]-imgF1[x][y][z]+10*imgF0[x][y][z]+connC2;

											if(testScore < 0){
												spineMaskTest[x][y] = true; 	//make sure that this is a sufficient condition             			

											}
										}	
									}
								}
							maskSegGrow = new int[nx][ny];
							maskSegGrow = ObjectProcessing.connected8Object2D(spineMaskTest,nx,ny);
							labelCount = ObjectProcessing.countLabels(maskSegGrow,nx,ny);

							labelArea = new int[labelCount];
							for (int ii=0;ii<labelCount;ii++){
								labelArea[ii] = 0;

								//								for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
								for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
									for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
										if (maskSegGrow[x][y] == ii){
											labelArea[ii]++;
										}
									}
							}

							highLabel = 0;
							highLabelCount = 0;
							for (int ii=1;ii<labelCount;ii++){
								if (labelArea[ii]>highLabelCount && labelArea[ii]>.001f*nbPixels){//tendrilThresh*.5*nbPixels){
									highLabelCount = labelArea[ii];
									highLabel = ii;
								}	
							}
							if(highLabel == 0) highLabel = -100;

							//Once we have all of the pixels that show improvement, find connected components
							//Sum over each component to find the best energy reduction

							//Change pixels
							//for (int x=xC[z]-windowSize;x<xC[z]+windowSize;x++)for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++)
								for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
									if(maskSegGrow[x][y] == highLabel){
										spineMask2[x][y][z] = 2;
										csfMaskC[x][y][z] = 1;
										//Iterate over all slices until no boundary pixels show an improvement!
										endTest = false;
									}
								}
						}

					}  //while statement

					///////////////////////////
					//END REGION GROWING PART 2
					///////////////////////////
					segGrow2 = new float[nx][ny][nz];

					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						if(euclidDist2D(x,y,xC2[z],yC2[z])>=40){
							segGrow2[x][y][z] = 0.0f;  //bg 
						}
						if(euclidDist2D(x, y, xC2[z],yC2[z]) < 40){
							segGrow2[x][y][z] = 0.2f; //bg inner
						}
						if(spineMask2[x][y][z] == 2){
							segGrow2[x][y][z] = 2.0f;
						}
						if(spineMask2[x][y][z] == 1){
							segGrow2[x][y][z] = 1.0f;
						}

					}                   
					/**		if(showOutputs == 1){
						resultImage[16] = new ModelImage(ModelStorageBase.FLOAT, destExtents, makeImageName(image.getImageName(),"Region Growth2"));
						try {
							float [] imgBuffer = null;
							imgBuffer = crop.convertArray(segGrow2);
							resultImage[16].importData(0, imgBuffer, true);
						} catch (OutOfMemoryError e) {
							return;
						} catch (IOException error) {
							return;
						}	
					}
					 */

					//Modified Fill Holes Routine  -- SPINE

					float[][][] segGrow2Spine;
					segGrow2Spine = new float[nx][ny][nz];
					int spEdge1, spEdge2;
					for(int z = 0;z<nz; z++){

						//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
						for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
							boolean csfEdge = false;
							boolean spEdge = false;
							spEdge1 = yC[z];
							spEdge2 = yC[z];
							//	for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
							for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
								if(segGrow2[x][y][z] == 2) csfEdge = true;
								if(csfEdge == true && segGrow2[x][y][z] == 1 && spEdge == false){
									spEdge = true;
									spEdge1 = y;
								}
								if(segGrow2[x][y][z] == 1 && csfEdge == true) spEdge2 = y;
							}
							if(csfEdge == true && spEdge == true){
								for(int y=spEdge1;y<=spEdge2;y++) segGrow2[x][y][z] = 1; //must be spine
							}
						}

						//for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
						for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
							boolean csfEdge = false;
							boolean spEdge = false;
							spEdge1 = xC[z];
							spEdge2 = xC[z];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
								if(segGrow2[x][y][z] == 2) csfEdge = true;
								if(csfEdge == true && segGrow2[x][y][z] == 1 && spEdge == false){
									spEdge = true;
									spEdge1 = x;
								}
								if(segGrow2[x][y][z] == 1 && csfEdge == true) spEdge2 = x;
							}
							if(csfEdge == true && spEdge == true){
								for(int x=spEdge1;x<=spEdge2;x++) segGrow2[x][y][z] = 1; //must be spine
							}
						}
					}
					segGrow2Spine = segGrow2;

					//Clean-up CSF background
					float[][][] segGrow2CSF;
					segGrow2CSF = new float[nx][ny][nz];

					//Modified Fill Holes Routine  -- CSF
					//int spEdge1, spEdge2;
					for(int z = 0;z<nz; z++){

						//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
						for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
							boolean csfEdge = false;
							boolean spEdge = false;
							spEdge1 = yC[z];
							spEdge2 = yC[z];
							for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){

								if(segGrow2[x][y][z] == 2) csfEdge = true;
								if(csfEdge == true && segGrow2[x][y][z] == 2 && spEdge == false){
									spEdge = true;
									spEdge1 = y;
								}
								if(segGrow2[x][y][z] == 2 && csfEdge == true) spEdge2 = y;
							}
							if(csfEdge == true && spEdge == true){
								for(int y=spEdge1;y<=spEdge2;y++) segGrow2CSF[x][y][z] = 2; //must be csf
							}
						}

						//for(int y=yC[z]-windowSize;y<yC[z]+windowSize;y++){
						for(int y=Math.max(1,yC[z]-windowSize);y<Math.min(ny-1,yC[z]+windowSize);y++){
							boolean csfEdge = false;
							boolean spEdge = false;
							spEdge1 = xC[z];
							spEdge2 = xC[z];
							//for(int x=xC[z]-windowSize;x<xC[z]+windowSize;x++){
							for(int x=Math.max(1,xC[z]-windowSize);x<Math.min(nx-1,xC[z]+windowSize);x++){
								if(segGrow2[x][y][z] == 2) csfEdge = true;
								if(csfEdge == true && segGrow2[x][y][z] == 2 && spEdge == false){
									spEdge = true;
									spEdge1 = x;
								}
								if(segGrow2[x][y][z] == 2 && csfEdge == true) spEdge2 = x;
							}
							if(csfEdge == true && spEdge == true){
								for(int x=spEdge1;x<=spEdge2;x++) segGrow2CSF[x][y][z] = 2; //must be spine
							}
						}
					}


					segGrow2 = new float[nx][ny][nz];

					for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
						if(euclidDist2D(x,y,xC2[z],yC2[z])>=40){
							segGrow2[x][y][z] = 0.0f;  //bg 
						}
						if(euclidDist2D(x, y, xC2[z],yC2[z]) < 40){
							segGrow2[x][y][z] = 0.2f; //bg inner
						}
						if(segGrow2CSF[x][y][z] == 2){
							segGrow2[x][y][z] = 2.0f;
						}
						if(segGrow2Spine[x][y][z] == 1){
							segGrow2[x][y][z] = 1.0f;
						}

					}                   


					resultImage[0] = (new ImageDataFloat(segGrow2)).getModelImageCopy();
					//if(showOutputs == 1){
					/*resultImage[0] = new ModelImage(ModelStorageBase.FLOAT, destExtents, "Final Region Growth"); //makeImageName(image.getImageName(),"Final Region Growth"));
					try {
						float [] imgBuffer = null;
						imgBuffer = crop.convertArray(segGrow2);
						resultImage[0].importData(0, imgBuffer, true);
					} catch (OutOfMemoryError e) {
						return;
					} catch (IOException error) {
						return;
					}*/	
					ImageData resultOut = new ImageDataMipavWrapper(resultImage[0]);
					resultOut.setHeader(vol.getHeader());
					resultOut.setName(vol.getName() +"_seg");
					segOutputVol.setValue(resultOut);
					ImageData tempVol;
					/*for (int ii = 1; ii < resultImage.length; ii++ ){
						tempVol = new ImageDataMipavWrapper(resultImage[ii]);
						tempVol.setName(vol.getName() + "_debug" + ii);
						debugOutputVols.add(tempVol);
					}*/



				
			

		} catch (OutOfMemoryError x) {

			System.gc();
			MipavUtil.displayError( "Dialog: unable to allocate enough memory");
			return;
		} 

	} // end callAlgorithm()

	public static float[][][] zDilate(float[][][] imgIn, int nSlice, int nx, int ny, int nz){
		//for now, assume nSlice = 1
		float[][][] imgOut;
		imgOut = new float[nx][ny][nz];

		for(int z=0;z<nz;z++){
			int zPlus = Math.min(nz-1,z+1);
			int zMinus = Math.max(0,z-1);

			for (int x=0;x<nx;x++)for(int y=0;y<ny;y++){
				if(imgIn[x][y][z]==1.0f){

					imgOut[x][y][zMinus] = 1.0f;
					imgOut[x][y][z] = 1.0f;     			
					imgOut[x][y][zPlus] = 1.0f;
				}
			}
		}

		return imgOut;
	}

	public static final float euclidDist2D(int x0, int y0, int x1, int y1) {

		float eDist;

		eDist = (float)Math.sqrt((x0-x1)*(x0-x1)+(y0-y1)*(y0-y1));
		return eDist;
	}

	public static boolean[][][] floatToBoolean(float[][][]imgIn,int nx, int ny, int nz){
		boolean[][][] imgOut = new boolean[nx][ny][nz];

		for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
			if(imgIn[x][y][z]>0){
				imgOut[x][y][z] = true;
			} else {
				imgOut[x][y][z] = false;
			}
		}
		return imgOut;
	}

	public static float[][][] booleanToFloat(boolean[][][]imgIn, int nx, int ny, int nz){
		float[][][] imgOut = new float[nx][ny][nz];

		for (int x=0;x<nx;x++)for(int y=0;y<ny;y++)for(int z=0;z<nz;z++){
			if(imgIn[x][y][z] == true){
				imgOut[x][y][z] = 1.0f;
			} else {
				imgOut[x][y][z] = 0.0f;
			}
		}
		return imgOut;    
	}

	public static float[][][] dilateImage(float[][][] img, int nx, int ny, int nz, int dx, int dy, int dz) {
		int x,y,z;
		int i,j,k;
		float[][][] dilated = new float[nx][ny][nz];

		// dx,dy,dz describe the structuring element ( x+/-dx, y+/-dy, z+/-dz )

		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {

			dilated[x][y][z] = img[x][y][z];
			for (i=-dx;i<=dx;i++) for (j=-dy;j<=dy;j++) for (k=-dz;k<=dz;k++) {

				if ( (x+i>=0) && (x+i<nx) && (y+j>=0) && (y+j<ny) && (z+k>=0) && (z+k<nz) ) {

					if (img[x+i][y+j][z+k] > dilated[x][y][z]) dilated[x][y][z] = img[x+i][y+j][z+k];
				}
			}
		}
		return dilated;
	}

	public static float[][][] erodeImage(float[][][] img, int nx, int ny, int nz, int dx, int dy, int dz) {
		int x,y,z;
		int i,j,k;
		float[][][] eroded = new float[nx][ny][nz];

		// dx,dy,dz describe the structuring element ( x+/-dx, y+/-dy, z+/-dz )

		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {

			eroded[x][y][z] = img[x][y][z];
			for (i=-dx;i<=dx;i++) for (j=-dy;j<=dy;j++) for (k=-dz;k<=dz;k++) {

				if ( (x+i>=0) && (x+i<nx) && (y+j>=0) && (y+j<ny) && (z+k>=0) && (z+k<nz) ) {

					if (img[x+i][y+j][z+k] < eroded[x][y][z]) eroded[x][y][z] = img[x+i][y+j][z+k];
				}
			}
		}
		return eroded;
	}

	//
	//  compute the object center 2-D Version
	//

	public static final float[] center2D(boolean img[][][], int nx, int ny, int z) {
		float[] center = new float[2];
		float count=0.0f;

		for (int n=0;n<2;n++) center[n] = 0.0f;
		for (int x=0;x<nx;x++) for (int y=0;y<ny;y++) {
			if (img[x][y][z]) {
				center[0] += x;
				center[1] += y;
				count++;
			}
		}
		if (count>0) {
			center[0] = center[0]/count;
			center[1] = center[1]/count;
		}
		return center;
	}

	//
	//   Connected components of an object.
	//   3D images: 26-neighborhood
	// 

	public static final boolean[][][] largestObjectFromLabel(int[][][] label, int nlb, int nx, int ny, int nz) {
		int x,y,z,n;
		boolean[][][] obj = new boolean[nx][ny][nz];
		int[] Nobj = new int[nlb];
		int best,size;

		for (n=0;n<nlb;n++) Nobj[n]=0;

		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
			Nobj[ label[x][y][z] ]++;
		}
		size=0;best=0;
		for (n=1;n<nlb;n++) if (Nobj[n]>size) {
			size = Nobj[n];
			best = n;
		}
		if (best>0)
			for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
				obj[x][y][z] = (label[x][y][z]==best);
			}
		else
			for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
				obj[x][y][z] = false;
			}
		return obj;
	}
}