package edu.jhu.ece.iacl.plugins.segmentation;

import java.io.File;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.net.URL;
import java.net.URI;

import javax.swing.SpringLayout;

import Jama.Matrix;

import edu.jhmi.rad.medic.algorithms.AlgorithmMultipleToads;
import edu.jhmi.rad.medic.methods.DigitalHomeomorphism;
import edu.jhmi.rad.medic.methods.MultipleToadDeformableAtlas;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.SpineSeg.AlgorithmSpineSeg;
import edu.jhu.ece.iacl.algorithms.SpineSeg.SpineDeformableAtlas;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.MipavController;

import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionPaneInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionWindowInputView;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmN3;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmVABRA;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.view.MipavUtil;
import gov.nih.mipav.view.ViewUserInterface;
import gov.nih.mipav.view.dialogs.JDialogBase;

/**
 *   Medic wrapper for the release of Toads (atlas-based version)
 *
 *	@version    Oct 2010
 *	@author     Min chen
 *	@author     Pilou Bazin
 */
public class MedicAlgorithmSpineSegToads extends ProcessingAlgorithm {
	private ParamWeightedVolumeCollection<String> inputImages;

	public ParamFile inParamAtlasFile;
	public ParamOption inParamModality;
	public ParamBoolean inParamCorrectInhomogeneity;
	public ParamInteger inParamInhomPolyDeg;
	public ParamOption inParamInhomPolyType;
	public ParamFloat inParamInhomKernelSize;
	public ParamDouble inParamSmoothness;
	public ParamInteger inParamMaxIters;
	public ParamDouble inParamMaxDiff;
	public ParamDouble inParamAtlasPriorWeight;
	public ParamDouble inParamAtlasRange;
	public ParamOption inParamConnectivity;
	//public ParamOption inParamOutputType;
	//public ParamOption inParamAlignType;
	public ParamVolume inParamInputImage;
	//public ParamBoolean inParamScaleData;
	public ParamBoolean inParamConstructPrior;

	public MedicAlgorithmVABRA vabra;
	public ParamVolume inParamAtlasToSubDef;
	public ParamVolume inParamDeformedTopologyAtlas;
	public ParamVolume inParamDeformedPriors;
	public ParamVolume outParamHardSeg;
	public ParamVolume outParamInhomField;
	public ParamVolume outParamMemberships;


	//private ParamVolumeCollection volClasses;
	private HashMap<String,String> connMap;

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	/**
	 * Create Input parameters for TOADS as specified in AlgorithmMultipleToads The
	 * boundaries for these variables do not necessarily match those specified
	 * in the original dialog
	 */
	protected void createInputParameters(ParamCollection inputParams) {

		vabra = new MedicAlgorithmVABRA();
		//vabra.inParamSubjects.setHidden(true);
		//vabra.inParamTargets.setHidden(true);
		
		// Add input to main pane
		ParamCollection mainParams = new ParamCollection();
		mainParams.setName("Main");

		mainParams.add(inParamInputImage = new ParamVolume("Image to Segment"));
		String[] modal = {"MT(KKI)","T1(GE)"};
		mainParams.add(inParamModality=new ParamOption("MRI Image modality",modal));
		mainParams.add(inParamAtlasFile = new ParamFile("TOADS Spinal Cord Atlas File",new FileExtensionFilter(new String[]{"txt"})));
		vabra.inParamConfigFile.setName("VABRA Config File");
		mainParams.add(vabra.inParamConfigFile);
		//String[] modal = {"MT","T1_MPRAGE","T2","PD","FLAIR"};

		

		ParamCollection advParams = new ParamCollection();
		advParams.setName("Advanced");
		advParams.add(inParamConstructPrior = new ParamBoolean("Construct Priors From Registration",false));
		advParams.add(inParamSmoothness = new ParamDouble("Smooting Parameter", 0, 1E10, .2));
		advParams.add(inParamAtlasPriorWeight = new ParamDouble("Atlas Prior", 0, 1E10, 2.0));
		advParams.add(inParamAtlasRange = new ParamDouble("Atlas Range", 0, 1E10, .2));
		advParams.add(inParamMaxIters = new ParamInteger("Maximum Iterations", 0, 100000, 50));
		advParams.add(inParamMaxDiff = new ParamDouble("Maximum Difference", 0, 1E10, 0.0001));

		connMap=new HashMap<String,String>();
		connMap.put("(18,6)","18/6");
		connMap.put("(6,18)","6/18");
		connMap.put("(26,6)","26/6");
		connMap.put("(6,26)","6/26");
		advParams.add(inParamConnectivity=new ParamOption("Connectivity (Foreground,Background)",new ArrayList<String>(connMap.keySet())));

		advParams.add(inParamAtlasToSubDef = new ParamVolume("Known Atlas to Subject Deformation (Optional)",null,-1,-1,-1,-1));
		inParamAtlasToSubDef.setMandatory(false);
		advParams.add(inParamDeformedTopologyAtlas = new ParamVolume("Known Aligned Topology Atlas (Optional)",null,-1,-1,-1,-1));
		inParamDeformedTopologyAtlas.setMandatory(false);
		advParams.add(inParamDeformedPriors = new ParamVolume("Known Aligned Priors (Optional)",null,-1,-1,-1,-1));
		inParamDeformedPriors.setMandatory(false);
		
		/*String[] outType = {"hard_segmentation","full_segmentation"};
		mainParams.add(inParamOutputType = new ParamOption("Output Type",outType));

		String[] alignType = {"rigid","single_scale","scaled_rigid","fully_affine",
				"multi_rigid","multi_single_scale","multi_scaled_rigid","multi_fully_affine"};
		mainParams.add(inParamAlignType=new ParamOption("Atlas alignment", alignType));
		mainParams.add(inParamScaleData=new ParamBoolean("Scale Output by 255",true));
		 */
		
		//Inhomogeneity Correction Parameters
		ParamCollection inHomCorrectParams = new ParamCollection();
		inHomCorrectParams.setName("Inhomogeneity Correction");
		inHomCorrectParams.add(inParamCorrectInhomogeneity = new ParamBoolean("Correct MR Field Inhomogeneity Between Itr", false));

		String[] fieldOption = {"Chebyshev","Splines"};
		inHomCorrectParams.add(inParamInhomPolyType = new ParamOption("Polynomial Type for Correction",fieldOption));
		inParamInhomPolyType.setValue("Chebyshev");

		inHomCorrectParams.add(inParamInhomPolyDeg = new ParamInteger("Polynomail Degree (Chebyshev)", 1, 4, 3));
		inHomCorrectParams.add(inParamInhomKernelSize= new ParamFloat("Kernel Size (Spline)",0,1000.0f, 30.0f));


		
		
		inputParams.add(mainParams);
		inputParams.add(advParams);
		inputParams.add(inHomCorrectParams);

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation");
		inputParams.setName("SpineSegToads");
		inputParams.setLabel("TOADS for the Spinal Cord");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(ReferencedPapers.toads);
		info.setWebsite("http://medic.rad.jhmi.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.add(ReferencedPapers.toads);
		info.add(PrinceGroupAuthors.minChen);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.setDescription("Algorithm for topologically consistent classification and segmentation of the spinal cord from multiple MR images with possibly different modalities.");	
	}

	/**
	 * Create output Parameters for TOADS. Note: Not all output fields are
	 * populated and the non-populated fields will create an error that is
	 * caught by the dialog.
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamHardSeg = new ParamVolume("Hard Segmentation"));
		outputParams.add(outParamInhomField = new ParamVolume("Inhomogeneity Field"));
		outputParams.add(outParamMemberships = new ParamVolume("Membership Functions",null,-1,-1,-1,-1));
		outParamHardSeg.setMandatory(false);
		outParamInhomField.setMandatory(false);
		outParamMemberships.setMandatory(false);
		//outputParams.add(volClasses = new ParamVolumeCollection("Membership Classes",VoxelType.UBYTE));
	}

	/**
	 * Execute the TOADS algorithm given the input parameters
	 */
	protected class Toads08Wrapper extends AbstractCalculation{
		public Toads08Wrapper(){
			setLabel("TOADS Spinal Cord");
		}
		public void execute(){

		String[] modals = new String[1];
			modals[0] = inParamModality.getValue();

			System.out.println("ATLAS FILE "+inParamAtlasFile.getValue().getAbsolutePath());
			//Make New Atlas from file
			SpineDeformableAtlas atlas = new SpineDeformableAtlas(inParamAtlasFile.getValue().getAbsolutePath(), inParamInputImage.getImageData());
			
			//If deformed atlases are present then set
			if(inParamDeformedTopologyAtlas.getImageData() != null  && inParamDeformedPriors.getImageData() != null ){
				System.out.format("Loading PreDeformed Atlases\n");
				atlas.loadPreDeformedAtlases(inParamDeformedTopologyAtlas.getImageData(), inParamDeformedPriors.getImageData());
			}else{ //Otherwise find/use atlas to subject deformation to deform atlases 
				ImageData atlasToSubDef = inParamAtlasToSubDef.getImageData();
				//Matrix atlasToSubTranMatrix = null;
				if(atlasToSubDef == null){//Solve for def field via VABRA
					System.out.format("Calculating Atlas to Subject Deformation (VABRA)\n");
					//Set VABRA Parameters
					vabra.inParamUseFlirt.setValue(true);
					vabra.flirt.dof.setValue(3);
					vabra.flirt.costFunction.setValue(3);
					vabra.flirt.coarseAngleIncrement.setValue(.1);
					vabra.flirt.fineAngleIncrement.setValue(.05);
					vabra.flirt.minAngle.setValue(-.1);
					vabra.flirt.maxAngle.setValue(.1);
					vabra.inParamSubjects.add(atlas.getIntensityImageAtlas());
					vabra.inParamTargets.add(inParamInputImage.getImageData());
					vabra.run();
					//Combined matrix and deformation into a single deformation
					atlasToSubDef = RegistrationUtilities.combineTransAndDef(vabra.outParamTransformMatrices.getValue(), vabra.outParamDeformationField.getImageData());
					
				}
	
				//Approximate Homeomorphic Deformation so that deformation preserve cord Topology
				ImageData[] atlasToSubDefSplit = RegistrationUtilities.split4DImageDataIntoArray(atlasToSubDef);
				ImageDataByte topAtlas = new ImageDataByte(atlas.getCordAtlas());
				DigitalHomeomorphism homeoDefApprox = new DigitalHomeomorphism(topAtlas.toArray3d(), 
						new ImageDataFloat(atlasToSubDefSplit[0]).toArray3d(),
						new ImageDataFloat(atlasToSubDefSplit[1]).toArray3d(),
						new ImageDataFloat(atlasToSubDefSplit[2]).toArray3d(),
						atlasToSubDef.getRows(), atlasToSubDef.getCols(), atlasToSubDef.getSlices(),
						atlasToSubDef.getHeader().getDimResolutions()[0], 
						atlasToSubDef.getHeader().getDimResolutions()[1],
						atlasToSubDef.getHeader().getDimResolutions()[2],
						connMap.get(inParamConnectivity.getValue()),
						null);
				homeoDefApprox.computeHomeomorphicTransformAndImage();
				atlasToSubDefSplit[0] = new ImageDataFloat(homeoDefApprox.getTransformedFieldX());
				atlasToSubDefSplit[1] = new ImageDataFloat(homeoDefApprox.getTransformedFieldY());
				atlasToSubDefSplit[2] = new ImageDataFloat(homeoDefApprox.getTransformedFieldZ());
				atlasToSubDef = RegistrationUtilities.combineImageDataArrayTo4D(atlasToSubDefSplit);
				atlasToSubDef.setHeader(inParamInputImage.getImageData().getHeader());
				//Apply Def Field to Atlases
				if(inParamConstructPrior.getValue()){//Construct Shape Prior If needed
					atlas.setShapePriorFromDefField(atlasToSubDef);
				}else{
					atlas.applyDefFieldToShapePriors(atlasToSubDef);
				}
				atlas.applyDefFieldToCordAtlas(atlasToSubDef);
				atlas.buildTopologyAtlasFromCordAtlas();
			}

			ImageData inputImg = inParamInputImage.getImageData();
			
			
			//Mask the input using a dilation of the registered template
			System.out.format("Masking\n");
			maskInputToDilatedTemplate(atlas.getTemplate(), inputImg);

			
			//Run N3 on Masked spinal Cord
			System.out.format("Running N3\n");
			MedicAlgorithmN3 N3 = new MedicAlgorithmN3();

			N3.srcImg.setValue(inputImg);
			N3.run();
			
			inputImg = N3.destImg.getImageData();
			
			//Segment spinal cord
			setTotalUnits(1);
			AlgorithmSpineSegWrapper algo = new AlgorithmSpineSegWrapper(inputImg, 1,
					modals, inParamAtlasFile.getValue().getAbsolutePath(), atlas,
					inParamSmoothness.getFloat(), inParamMaxIters.getInt(), inParamMaxDiff.getFloat(), 3.0f, 0.5f,
					inParamAtlasPriorWeight.getFloat(), inParamAtlasRange.getFloat(), 
					4, 50, 5, 0, inParamCorrectInhomogeneity.getValue(),inParamInhomPolyType.getValue(), 
					inParamInhomPolyDeg.getInt(),inParamInhomKernelSize.getFloat(), connMap.get(inParamConnectivity.getValue())
			);
			algo.setObserver(this);
			algo.runAlgorithm();
		
			outParamHardSeg.setValue(new ImageDataInt(algo.getHardSegOutput()));
			outParamMemberships.setValue(algo.getMembershipOutput());	
			ImageData atlasOut = new ImageDataInt(atlas.getTemplate());
			atlasOut.setHeader(inParamInputImage.getImageData().getHeader());
			atlasOut.setName(inParamInputImage.getImageData().getName() + "_topAtlas");
			//outParamInhomField.setValue(inputImg);
			//outParamHardSeg.setValue(atlasOut);
			//outParamInhomField.setValue(new ImageDataFloat(algo.getDebug()));
			/*
			ModelImage[] resultImage=algo.getResultImages();

			// export the images needed
			if (inParamOutputType.getValue().equals("hard_segmentation")) {
				outParamHardSeg.setValue(new ImageDataMipavWrapper(resultImage[0]));
			} else if (inParamOutputType.getValue().equals("full_segmentation")) {
				outParamHardSeg.setValue(new ImageDataMipavWrapper(resultImage[0]));
				outParamMemberships.setValue(new ImageDataMipavWrapper(resultImage[1]));
				if (inParamCorrectInhomogeneity.getValue()) {
					outParamInhomField.setValue(new ImageDataMipavWrapper(resultImage[2]));
				} 

			} 
			 */			
			markCompleted();
		}
	}

	private void maskInputToDilatedTemplate(ImageData topologyAtlas,ImageData inputImg){
				
		int XN = inputImg.getRows();
		int YN = inputImg.getCols();
		int ZN = inputImg.getSlices();
		int w = 0;//amount to dilate

		boolean clear;
		/*
		ImageData dilatedTemplate=topologyAtlas.mimic();

		for(int i = 0; i < XN; i ++) for(int j = 0; j < YN; j ++) for(int k = 0; k < ZN; k ++){
			if(topologyAtlas.getInt(i, j, k) != 1 ||topologyAtlas.getInt(i, j, k) != 0 && topologyAtlas.getInt(i,j,k)==0){

			}

		}
		 */
		for(int i = 0; i < XN; i ++) for(int j = 0; j < YN; j ++) for(int k = 0; k < ZN; k ++){
			clear = true;
			for(int x = -w; x <= w; x++) for(int y = -w; y <= w; y++) for(int z = -w; z <= w; z++){
				if( i+x>=0 && i+x<XN && j+y>=0 && j+y<YN && k+z>=0 && k+z<ZN)
					if(topologyAtlas.getInt(i+x, j+y, k+z) != 1 && topologyAtlas.getInt(i+x, j+y, k+z) != 0)
						clear = false;


			}
			if(clear)inputImg.set(i, j, k, 0);

		}
	}

	protected class AlgorithmSpineSegWrapper extends AlgorithmSpineSeg{
		protected AbstractCalculation observer;
		public AlgorithmSpineSegWrapper(ImageData srcImg_, int input_, String[] imgModal_, String name_,
				SpineDeformableAtlas atlas_, float smooth_, int iterMax_, float distMax_, float lim_,
				float lim_2, float firstCoeff_, float scale_, int lev_, int first_, int top_, int last_,
				boolean correct_,String correctType_, int poly_, float kernel_,
				String connect_) {
			super(srcImg_, input_, imgModal_, name_, atlas_, smooth_, iterMax_, distMax_, lim_, lim_2, firstCoeff_,
					scale_, lev_, first_, top_, last_, correct_,correctType_, poly_, kernel_,
					connect_);
		}
		public void setObserver(AbstractCalculation observer){
			this.observer=observer;
		}
		public void runAlgorithm(){
			observer.setTotalUnits(100);
			super.runAlgorithm();
			observer.markCompleted();

		}
		/**
		 * Notifies all listeners that have registered interest for notification on this event type.
		 *
		 * @param  value  the value of the progress bar.
		 */
		protected void fireProgressStateChanged(int value) {
			super.fireProgressStateChanged(value);
			observer.setCompletedUnits(value);
		}

		/**
		 * Updates listeners of progress status. Without actually changing the numerical value
		 *
		 * @param  imageName  the name of the image
		 * @param  message    the new message to display
		 */
		protected void fireProgressStateChanged(String imageName, String message) {
			super.fireProgressStateChanged(imageName, message);
			observer.setLabel(message);
		}
	}
	protected void execute(CalculationMonitor monitor) {
		Toads08Wrapper toads=new Toads08Wrapper();
		monitor.observe(toads);
		toads.execute();
	}
	public Dimension getPreferredSize() {
		return new Dimension(300,450);
	}
}
