package edu.jhu.ece.iacl.plugins.segmentation.gdm;

import java.io.File;
import java.util.ArrayList;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedPointSet;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.graphics.locator.sphere.SphericalMapLocator;
import edu.jhu.ece.iacl.algorithms.graphics.map.SphericalMapCorrection;
import edu.jhu.ece.iacl.algorithms.graphics.map.LevelSetRegistration;
import edu.jhu.ece.iacl.algorithms.tgdm.CoupledForceTGDM;
import edu.jhu.ece.iacl.algorithms.tgdm.GenericTGDM;
import edu.jhu.ece.iacl.algorithms.tgdm.TrackingTGDM;
import edu.jhu.ece.iacl.algorithms.tgdm.ProfileTGDM.Tracking;
import edu.jhu.ece.iacl.algorithms.thickness.RobustInterSurfaceConformalMapEuler;
import edu.jhu.ece.iacl.algorithms.thickness.ThicknessSolver;
import edu.jhu.ece.iacl.algorithms.thickness.EulerThickness;
import edu.jhu.ece.iacl.algorithms.thickness.EulerLagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.SimpleLagrangianEmbedding;
import edu.jhu.ece.iacl.algorithms.thickness.LagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.io.*;
public class MedicAlgorithmCoupledSmoothing extends ProcessingAlgorithm{
	ParamVolume initpVol;
	ParamVolume initaVol;
	ParamDouble isoVal;
	ParamDouble curv;
	ParamDouble pressure;
	ParamSurface pMap;
	ParamSurface pSurf;

	ParamSurface aSurf;
	ParamSurface aMap;
	ParamVolume pVol,aVol;
	ParamInteger iters;
	ParamOption connectivity;
	ParamOption tracking;
	ParamObject<EmbeddedPointSet> pPointset,aPointset;
	private ParamBoolean pdeEnabled,interpolateMap;
	private static final String revnum = CoupledForceTGDM.getVersion();
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(initpVol=new ParamVolume("Source Level Set"));
		inputParams.add(initaVol=new ParamVolume("Coupled Level Set"));
		inputParams.add(pMap=new ParamSurface("Source Spherical Map"));
		inputParams.add(aMap=new ParamSurface("Couple Spherical Map"));
		inputParams.add(connectivity=new ParamOption("Connectivity (Foreground,Background)",new String[]{"(18,6)","(6,18)","(26,6)","(6,26)"}));    	
		//Tracking methodology
		inputParams.add(tracking=new ParamOption("Tracking",new String[]{"Off","Sphere","Point","Shell"}));  
		//Smoothing factors
		inputParams.add(curv=new ParamDouble("Curvature Force",0,20,1));
		inputParams.add(pressure=new ParamDouble("Pressure Force",0,20,0.1));
		inputParams.add(iters=new ParamInteger("Iterations",0,100,12));
	
    	inputParams.add(pdeEnabled=new ParamBoolean("PDE Enabled",true));
    	pdeEnabled.setDescription("Should the embedded coordinate system evolve along with the surface?");
    	inputParams.add(interpolateMap=new ParamBoolean("Interpolate Mapping",true));
    	interpolateMap.setDescription("Should the embedded coordinate system be interpolated back onto the surface or should nearest-neighbor be used?");
		inputParams.setLabel("Coupled Level Set Smoothing");
		inputParams.setName("coupled_smooth");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.Geometric_Deformable_Model");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setDescription("Smooth two surfaces that are implicitly coupled with spherical maps. ");
		info.setLongDescription("This method does not work particularly well on cortical surfaces because the narrow band is too small in many places to achieve a smooth sampling of forces. The CFL conditions maybe violated by the transfered forces because the gradient of the level set maybe too sharp.");
		info.add(ReferencedPapers.tgdm);
		info.setVersion(revnum);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(pVol=new ParamVolume("Principal Level Set"));
		outputParams.add(aVol=new ParamVolume("Auxilary Level Set"));
			
		outputParams.add(pSurf=new ParamSurface("Principal Surface"));
		outputParams.add(aSurf=new ParamSurface("Auxilary Surface"));
		
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		int conn=0;
		switch(connectivity.getIndex()){
			case 0:conn=ConnectivityRule.CONNECT_18_6;break;
			case 1:conn=ConnectivityRule.CONNECT_6_18;break;
			case 2:conn=ConnectivityRule.CONNECT_26_6;break;
			case 3:conn=ConnectivityRule.CONNECT_6_26;break;
			default:break;
		}	
		EmbeddedSurface sphericalMap=pMap.getSurface();
		int maxiters=iters.getInt();
		float wcurv=curv.getFloat();
		float wpressure=pressure.getFloat();
		CoupledForceTGDM tgdm=new CoupledForceTGDM(conn);
		Tracking track=Tracking.values()[tracking.getIndex()];
    	tgdm.setTracking(track);
		monitor.observe(tgdm);	
    	tgdm.setPdeEnabled(pdeEnabled.getValue());
    	tgdm.setMapInterpolationEnabled(interpolateMap.getValue());
		tgdm.setSphericalMap(sphericalMap);
		tgdm.setAuxiliarySphericalMap(aMap.getSurface());
		tgdm.solveCoupledSmoothSurface(initpVol.getImageData(), initaVol.getImageData(), wcurv,0,wpressure,maxiters);
		pVol.setValue(tgdm.getFinalLevelSet());
		aVol.setValue(tgdm.getFinalAuxilaryLevelSet());
		pSurf.setValue(tgdm.getFinalSurface());
		aSurf.setValue(tgdm.getFinalAuxilarySurface());
	}

}
