/**
 * 
 */
package edu.jhu.ece.iacl.plugins.segmentation.skull_strip;

import java.awt.Dimension;

import edu.jhmi.rad.medic.libraries.Morphology;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.graphics.topo.ConnectedSurfaceComponents;
import edu.jhu.ece.iacl.algorithms.tgdm.DynamicPressureTGDM;
import edu.jhu.ece.iacl.algorithms.tgdm.GenericTGDM;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.comp_geom.MedicAlgorithmMultiResolutionSmoothing;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmObjectTopology;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 * 
 */
public class MedicAlgorithmRemoveDura09 extends ProcessingAlgorithm {
	private ParamVolume wmVol;
	private ParamVolume wmMaskVol;
	private ParamVolume gmVol;
	private ParamVolume origVol;
	private ParamVolume strippedCorrected;
	private ParamVolume brainMask;
	private ParamVolume gmCorrected;
	private ParamVolume wmCorrected;
	private ParamVolume MaskCorrected;
	private MedicAlgorithmTopologyCorrection tcWM;
	private MedicAlgorithmTopologyCorrection tcGM;
	private ParamDouble curvatureForce;
	private ParamDouble alignmentForce;
	private ParamDouble alignmentAlpha;
	private ParamDouble pressureForce;
	private ParamDouble levelSetTranslation;
	private ParamDouble maskTranslation;
	private ParamDouble membershipLevel;
	private ParamInteger maxIters;
	private ParamDouble wmRegularize;
	private ParamDouble gmRegularize;

	private static final String cvsversion = "$Revision: 1.10 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	protected void createInputParameters(ParamCollection inputParams) {
		tcWM = new MedicAlgorithmTopologyCorrection();
		tcGM = new MedicAlgorithmTopologyCorrection();

		ParamCollection dataPane = new ParamCollection("Data");
		dataPane.add(origVol = new ParamVolume("Original Volume"));
		origVol.setDescription("Original MR volume before skull stripping");
		dataPane.add(wmVol = new ParamVolume("WM Volume"));
		wmVol.setDescription("WM membership scaled from [0,255].");
		dataPane.add(gmVol = new ParamVolume("GM Volume"));
		gmVol.setDescription("GM membership scaled from [0,255].");
		dataPane.add(wmMaskVol = new ParamVolume("WM Mask"));
		wmMaskVol.setDescription("WM topologically correct mask {0,1}");
		inputParams.add(dataPane);

		ParamCollection paramPane = new ParamCollection("Parameters");
		paramPane.add(curvatureForce = new ParamDouble("Curvature Force", 0,
				10, 0.5));
		
		paramPane.add(alignmentForce = new ParamDouble(
				"Level Set Alignment Force", 0, 10, 1));
		paramPane.add(alignmentAlpha = new ParamDouble("Alignment Alpha", 0,
				30, 0.5));
		paramPane.add(pressureForce = new ParamDouble("Pressure Force", 0, 10,
				0.5));
		paramPane.add(membershipLevel = new ParamDouble("Target Membership", 0,
				1, 0.3));
		membershipLevel.setDescription("Target membership level set value.");
		paramPane.add(maskTranslation = new ParamDouble("Mask Translation",
				-10000, 10000, 2));
		maskTranslation.setDescription("Amount to dilate volumetric brain mask.");
		paramPane.add(levelSetTranslation = new ParamDouble(
				"Level Set Translation", -10000, 10000, 0));
		levelSetTranslation.setDescription("Amount to translate brain mask level set surface.");
		paramPane.add(maxIters = new ParamInteger("Maximum Iterations", 0,
				10000, 5));
		paramPane.add(wmRegularize = new ParamDouble("WM regularization amount",0.05));
		paramPane.add(gmRegularize = new ParamDouble("GM regularization amount",0.02));
		inputParams.add(paramPane);

		
		((ParamOption) tcWM.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue("(6,18)");
		((ParamOption) tcWM.getInput().getFirstChildByLabel("Image Type")).setValue("scalar_image");
		((ParamOption) tcWM.getInput().getFirstChildByLabel("Propagation Direction")).setValue("object->background");
		((ParamBoolean) tcWM.getInput().getFirstChildByLabel("Normalize")).setValue(true);
		((ParamBoolean) tcWM.getInput().getFirstChildByLabel("Stop at intensity boundaries")).setValue(true);
		((ParamOption) tcWM.getInput().getFirstChildByName("Initialization")).setValue("paint_mask");
		
		/*((ParamDouble) tcWM.getInput().getFirstChildByLabel("Regularize Amount")).setValue(0.05);
		((ParamVolume) tcWM.getInput().getFirstChildByName("Volume")).setHidden(true);
		((ParamVolume) tcWM.getInput().getFirstChildByName("Paint mask")).setHidden(true);
		((ParamOption) tcWM.getInput().getFirstChildByName(
				"Connectivity (Foreground,Background)")).setHidden(true);
		((ParamOption) tcWM.getInput().getFirstChildByLabel(
				"Image Type")).setHidden(true);
		((ParamOption) tcWM.getInput().getFirstChildByLabel(
				"Propagation Direction")).setHidden(true);
		((ParamBoolean) tcWM.getInput().getFirstChildByLabel("Stop at intensity boundaries"))
				.setHidden(true);
		((ParamOption) tcWM.getInput().getFirstChildByName(
				"Initialization")).setHidden(true);
		tcWM.getInput().setLabel("WM Topology Correction");
		tcWM.getInput().setName("tcWM");
		inputParams.add(tcWM.getInput());*/

		((ParamOption) tcGM.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue("(6,18)");
		((ParamOption) tcGM.getInput().getFirstChildByLabel("Image Type")).setValue("scalar_image");
		((ParamOption) tcGM.getInput().getFirstChildByLabel("Propagation Direction")).setValue("object->background");
		((ParamBoolean) tcGM.getInput().getFirstChildByLabel("Normalize")).setValue(true);
		((ParamBoolean) tcGM.getInput().getFirstChildByLabel("Stop at intensity boundaries")).setValue(true);
		((ParamOption) tcGM.getInput().getFirstChildByName("Initialization")).setValue("paint_mask");
		
		/*((ParamDouble) tcGM.getInput().getFirstChildByLabel("Regularize Amount")).setValue(0.05);
		 ((ParamVolume) tcGM.getInput().getFirstChildByName("Volume"))
				.setHidden(true);
		((ParamVolume) tcGM.getInput().getFirstChildByName("Paint mask"))
				.setHidden(true);
		((ParamOption) tcGM.getInput().getFirstChildByName(
				"Connectivity (Foreground,Background)")).setHidden(true);
		((ParamOption) tcGM.getInput().getFirstChildByLabel(
				"Image Type")).setHidden(true);
		((ParamOption) tcGM.getInput().getFirstChildByLabel(
				"Propagation Direction")).setHidden(true);
		((ParamBoolean) tcGM.getInput().getFirstChildByLabel("Normalize"))
				.setHidden(true);
		((ParamBoolean) tcGM.getInput().getFirstChildByLabel("Stop at intensity boundaries"))
				.setHidden(true);
		((ParamOption) tcGM.getInput().getFirstChildByName(
				"Initialization")).setHidden(true);
		tcGM.getInput().setLabel("GM Topology Correction");
		tcGM.getInput().setName("tcGM");
		inputParams.add(tcGM.getInput());*/

		this.setPreferredSize(new Dimension(400, 500));

		inputParams.setName("remove_dura_2009");
		inputParams.setLabel("Remove Dura 2009");

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.Skull_Stripping");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.add(ReferencedPapers.tgdm);
		info.add(ReferencedPapers.topoCorrect);
		info.setLongDescription("To improve the performance of this method, the thickness regularization force should vary depending on the underlying curvature of the brain in particular regions. To estimate the curvature, compute the mean curvature, smooth the curvature measurements with a Gaussian kernel in log space, fast-march thickness measurements from the surface into the volume, and derive a weight for the thickness regularization force based on the curvature.");
		
		info.setDescription("Removes dura from a skull stripped brain using WM/GM memberships using the following procedure.\n1) Add WM and GM memberships and run topology correction starting from the WM Mask.\n2) Correct the topology of the WM membership starting from the WM Mask.\n3) Run TGDM on the pial surface estimate with an additional force that regularizes cortical thickness.\n4) Create mask volume using the pial surface level set.\n5) Dilate the brain mask and apply it to the original data.");

		info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/skull_strip/MedicAlgorithmRemoveDura/index.html");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams
				.add(strippedCorrected = new ParamVolume("Stripped Volume"));
		outputParams.add(wmCorrected = new ParamVolume(
				"Corrected WM Membership"));
		wmCorrected.setMandatory(false);
		outputParams.add(gmCorrected = new ParamVolume(
				"Corrected GM Membership"));
		gmCorrected.setMandatory(false);
		outputParams.add(brainMask = new ParamVolume("Brain Mask Level Set"));
		brainMask.setMandatory(false);
		outputParams.add(MaskCorrected = new ParamVolume("Corrected Brain Mask"));
	}

	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		ImageDataMipav wm = new ImageDataMipav(wmVol.getImageData());
		ImageDataMipav wmMask =new ImageDataMipav( wmMaskVol.getImageData());
		ImageDataMipav gm =new ImageDataMipav( gmVol.getImageData());
		float curvForce = curvatureForce.getFloat();
		float presForce = pressureForce.getFloat();
		float alignForce = alignmentForce.getFloat();
		float membership = membershipLevel.getFloat();
		float alpha = alignmentAlpha.getFloat();
		int maxiters = maxIters.getInt();
		int rows = gm.getRows(), cols = gm.getCols(), slices = gm.getSlices();
		ImageDataFloat union = new ImageDataFloat(gm.getName() + "_union",
				rows, cols, slices);
		float[][][] unionM = union.toArray3d();


		((ParamVolume) tcWM.getInput().getFirstChildByLabel("Volume"))
				.setValue(wm);
		((ParamVolume) tcWM.getInput().getFirstChildByLabel("Paint mask"))
				.setValue(wmMask);
		((ParamDouble) tcWM.getInput().getFirstChildByLabel("Regularize Amount")).setValue(wmRegularize.getValue());
		tcWM.execute(monitor);
		ImageDataFloat wmTC = new ImageDataFloat(((ParamVolume) tcWM
				.getOutput()
				.getFirstChildByName("Topologically Correct Volume"))
				.getImageData());

		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					unionM[i][j][k] = (wmTC.getFloat(i, j, k) + gm.getFloat(i, j,
							k));
				}
			}
		}

		((ParamVolume) tcGM.getInput().getFirstChildByLabel("Volume"))
				.setValue(union);
		((ParamVolume) tcGM.getInput().getFirstChildByLabel("Paint mask"))
				.setValue(wmMask);
		((ParamDouble) tcGM.getInput().getFirstChildByLabel("Regularize Amount")).setValue(gmRegularize.getValue());
		tcGM.execute(monitor);
		ImageDataFloat gmTC = new ImageDataFloat(((ParamVolume) tcGM
				.getOutput()
				.getFirstChildByName("Topologically Correct Volume"))
				.getImageData());

		float[][][] wmTCmat = wmTC.toArray3d();

		float[][][] gmTCmat = gmTC.toArray3d();

		ImageDataFloat inner = new ImageDataFloat(rows, cols, slices);
		float[][][] innerMat = inner.toArray3d();
		ImageDataFloat outer = new ImageDataFloat(rows, cols, slices);
		float[][][] outerMat = outer.toArray3d();

		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					innerMat[i][j][k] = 0.5f - wmTCmat[i][j][k] / 255.0f;
					outerMat[i][j][k] = membership - gmTCmat[i][j][k] / 255.0f;
				}
			}
		}
		DistanceField df = new DistanceField();
		inner = df.solve(inner, 15);
		outer = df.solve(outer, 10);

		DynamicPressureTGDM tgdm = new DynamicPressureTGDM(
				ConnectivityRule.CONNECT_18_6);
		tgdm.setReferenceLevelSet(inner);
		monitor.observe(tgdm);
		System.out.println("Curvature Force " + curvForce);
		System.out.println("Alignment Force " + alignForce);
		System.out.println("Pressure Force " + presForce);
		System.out.println("Membership " + membership);
		System.out.println("Max Iterations " + maxiters);
		System.out.println("Alpha " + alpha);
		ImageDataFloat mask = tgdm.solveBrainMaskSurface(outer, null, gmTC,
				null, null,curvForce, 0, alignForce,0, alpha, presForce, 0,
				membership, maxiters);
		float[][][] maskMat = mask.toArray3d();

		float levelSetOffset = levelSetTranslation.getFloat();
		float maskOffset = maskTranslation.getFloat();
		ImageData orig = origVol.getImageData();
		ImageDataUByte strip = new ImageDataUByte(rows,cols,slices);
		byte [][][] stripMat = strip.toArray3d();
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					if (maskMat[i][j][k] >= maskOffset) {
						wm.set(i, j, k, 0);
						gm.set(i, j, k, 0);
						orig.set(i, j, k, 0);
						stripMat[i][j][k] = 0;
					}else
						stripMat[i][j][k]=1;
					maskMat[i][j][k] -= levelSetOffset;
				}
			}
		}
		mask.setName(orig.getName() + "_bmask");
		orig.setName(orig.getName()+"_durastripped");
		strip.setName(orig.getName()+"_mask_fixed");
		/*
		wm.setName(wm.getName() + "_fixedwm");
		gm.setName(gm.getName() + "_fixedgm");  
		wmCorrected.setValue(wm);
		gmCorrected.setValue(gm);*/
		brainMask.setValue(mask);
		strippedCorrected.setValue(orig);
		MaskCorrected.setValue(strip);
		//MaskCorrected.getImageData().getModelImageCopy().copyFileTypeInfo(orig.getModelImageCopy());
		MaskCorrected.getImageData().setHeader(orig.getHeader());
	}
}
