/*
 * 
 */
package edu.jhu.ece.iacl.plugins.segmentation.skull_strip;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import Jama.Matrix;
import edu.jhmi.rad.medic.algorithms.AlgorithmFantasm;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009.ImageModality;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009.OutputType;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume;
import edu.jhu.ece.iacl.algorithms.volume.TransformVolume;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Interpolation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Orientation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Resolution;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmFantasm;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRT;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import gov.nih.mipav.model.algorithms.AlgorithmCostFunctions;
import gov.nih.mipav.model.algorithms.AlgorithmTransform;
import gov.nih.mipav.model.algorithms.registration.AlgorithmRegOAR3D;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.model.structures.TransMatrix;
import gov.nih.mipav.view.ViewOpenFileUI;
import gov.nih.mipav.view.ViewUserInterface;
import gov.nih.mipav.view.dialogs.JDialogBase;


import edu.jhu.ece.iacl.jist.structures.image.ImageHeader.AxisOrientation;
/*
 * @author Aaron Carass <aaron_carass@jhu.edu>
 */
public class MedicAlgorithmSPECTRE2009 extends ProcessingAlgorithm {
	private static final String[] modalities = { "T1_SPGR", "T1_ALT", "T1_MPRAGE", "T2", "FLAIR" };
	private OutputType outputType = OutputType.ALL;

	private int registrationScale;

	private double initPrior;

	private double minPrior;

	private int initialErosionSize;
	private int mmcDilationSize;
	private int mmcErosionSize;
	private int max_iterations = 1;
	
	private	double smoothing;
	private double bgThreshold;

	private ParamFile atlasText;

	private ParamDouble priorInitText;
	private ParamDouble priorMinText;

	private ParamInteger initialErosionText;
	private ParamInteger mmcDilationText;
	private ParamInteger mmcErosionText;

	private ParamOption comboModality;

	// Boolean to decide if we make volumes isotropic.
	private ParamBoolean IsotropicResampleBool;

	private ParamVolume priorVol, segVol;
	private ParamVolume marchVol;
	private ParamVolume d0Vol, d1Vol, d2Vol, d3Vol;

	private ParamVolume maskVol;
	private ParamVolume reorientedVol;
	// private ParamVolume trimmedVol;

	private String maskType;

	private String modality;

	private String transformType;

	private ParamVolume origVol, resultVol;

	private int Natlas;

	// private AlgorithmRegOAR3D register = null;

	// private AlgorithmTransform transform = null;

	private AlgorithmFantasm segment = null;
	private ParamBoolean InhomogeneityCorrectionBool;
	private ParamDouble smoothingText;
	private ParamDouble bgThresholdText;

	// private ModelImage image; // source image

	private ImageDataMipav[] atlasImages; // images to register in the atlas

	private ImageDataMipav[] atlasMasks; // associated masks
	private ModelImage resultImage = null; // result image

	private ModelImage segImage; // the segmentation image

	private MedicAlgorithmFLIRT flirt;

	// private MedicAlgorithmFantasm fantasm;

	private static final String rcsid = "$Id: MedicAlgorithmSPECTRE2009.java,v 1.9 2014/04/15 19:27:32 aaron_carass Exp $";
	private static final String cvsversion = "$Revision: 1.9 $".replace(
			"Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = SPECTRE2009.get_version();
	private static final String shortDescription = "Simple Paradigm for Extra-Cranial Tissue REmoval\n"
			+ "################################################\n"
			+ "Algorithm Version: "
			+ revnum
			+ "\n"
			+ "GUI Version: "
			+ cvsversion + "\n";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		maskType = "binary";
		modality = "T1-ALT";
		transformType = "affine";
		registrationScale = 2;
		initPrior = 0.350;
		minPrior = 0.100;
		initialErosionSize = 5;
		mmcDilationSize = 2;
		mmcErosionSize = 2;
		smoothing = 0.02;
		bgThreshold = 0.001;
		flirt = new MedicAlgorithmFLIRT();
		// fantasm = new MedicAlgorithmFantasm();

		ParamCollection mainParams = new ParamCollection("Main");
		origVol = new ParamVolume("Volume");
		origVol.setDescription("Input volume.");

		atlasText = new ParamFile("Atlas list");
		atlasText.setDescription("Text atlas description file.");


		/*
		 * This comes from Bhaskar.
		 */
		String atlasFileName = "Atlas/spectre/oasis-3.txt";
		try {
			ClassLoader cl = Thread.currentThread().getContextClassLoader();
			atlasText.setValue(cl.getResource(atlasFileName).getFile());
		} catch (Exception e) {
			System.err.print("Error: Unable to set default atlas\n");
		}


		initialErosionText = new ParamInteger("Initial Erosion distance", 0, 20, initialErosionSize);
		initialErosionText.setDescription("Erosion of the inital mask, which is based on the probability mask and the classification.\nThe initial mask is ouput as the d0 volume at the conclusion of SPECTRE.");

		comboModality = new ParamOption("Image modality", modalities);
		comboModality.setDescription("Set the image modality. MP-RAGE is recommended for most T1 sequence images.");
		comboModality.setValue(2);

		IsotropicResampleBool = new ParamBoolean("Resample data to Isotropic voxels", true);
		IsotropicResampleBool.setDescription("Determines if the data is kept iin the original space of the image or is resampled to be isotropic.");


		mainParams.add(origVol);
		mainParams.add(atlasText);
		mainParams.add(initialErosionText);
		mainParams.add(comboModality);
		mainParams.add(IsotropicResampleBool);


		ParamCollection advParams = new ParamCollection("Advanced");
		priorInitText = new ParamDouble("Initial probability threshold", initPrior);
		priorInitText.setDescription("");

		priorMinText = new ParamDouble("Minimum probability threshold", minPrior);
		priorMinText.setDescription("");

		mmcDilationText = new ParamInteger("MMC Dilation distance", 0, 20, mmcDilationSize);
		mmcDilationText.setDescription("The size of the dilation step within the Modified Morphological Closing.");

		mmcErosionText = new ParamInteger("MMC Erosion distance", 0, 20, mmcErosionSize);
		mmcErosionText.setDescription("The size of the erosion step within the Modified Morphological Closing.");


		advParams.add(priorInitText);
		advParams.add(priorMinText);
		advParams.add(mmcDilationText);
		advParams.add(mmcErosionText);


		((ParamVolume) flirt.getInput().getFirstChildByName("Source volume")).setHidden(true);
		((ParamVolume) flirt.getInput().getFirstChildByName("Target volume")).setHidden(true);
		((ParamVolume) flirt.getInput().getFirstChildByName("Reference Weighted volume")).setHidden(true);
		((ParamVolume) flirt.getInput().getFirstChildByName("Input Weighted volume")).setHidden(true);


		ParamCollection fantasmParams = new ParamCollection("FANTASM");
		InhomogeneityCorrectionBool = new ParamBoolean("Inhomogeneity Correction", false);
		InhomogeneityCorrectionBool.setDescription("Set to false by default, this parameter will make FANTASM try to do inhomogeneity correction during it's iterative cycle.");
		smoothingText = new ParamDouble("Smoothing parameter", smoothing);
		smoothingText.setDescription("");
		bgThresholdText = new ParamDouble("Background threshold (%)", bgThreshold);
		bgThresholdText.setDescription("");

		fantasmParams.add(InhomogeneityCorrectionBool);
		fantasmParams.add(smoothingText);
		fantasmParams.add(bgThresholdText);

		// ((ParamVolumeCollection)fantasm.getInput().getFirstChildByName("Image
		// to segment")).setHidden(true);
		// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number of
		// classes")).setHidden(true);
		// ((ParamInteger)fantasm.getInput().getFirstChildByName("Maximum
		// iterations")).setHidden(true);

		inputParams.add(mainParams);
		inputParams.add(advParams);
		inputParams.add(fantasmParams);
		inputParams.add(flirt.getInput());
		// inputParams.add(fantasm.getInput());
		// setPreferredSize(new Dimension(300, 600));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.Skull_Stripping");
		inputParams.setLabel("SPECTRE 2009");
		inputParams.setName("SPECTRE_2009");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Aaron Carass", "aaron_carass@jhu.edu",
				"http://www.iacl.ece.jhu.edu/"));
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Computer Engineering");
		info.add(new Citation("A. Carass, J. Cuzzocreo, M.B. Wheeler, P.-L. Bazin, S.M. Resnick, and J.L. Prince, 'Simple paradigm for extra-cerebral tissue removal: Algorithm and analysis', NeuroImage 56:1982-1992, 2011."));
		info.add(new Citation("A. Carass, M.B. Wheeler, J. Cuzzocreo, P.-L. Bazin, S.S. Bassett, and J.L. Prince, 'A Joint Registration and Segmentation Approach to Skull Stripping', Fourth IEEE International Symposium on Biomedical Imaging (ISBI 2007), Arlington, VA, April 12-15, 2007."));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(reorientedVol = new ParamVolume("Reoriented Volume"));
		// outputParams.add(trimmedVol = new ParamVolume("Trimmed Volume"));
		outputParams.add(resultVol = new ParamVolume("Stripped Volume"));

		outputParams.add(maskVol = new ParamVolume("Mask Volume"));
		outputParams.add(priorVol = new ParamVolume("Prior Volume"));
		outputParams.add(segVol = new ParamVolume("FANTASM Segmentation"));
		// outputParams.add(marchVol = new ParamVolume("Fast Marching Output"));
		outputParams.add(d0Vol = new ParamVolume("d0"));
		// outputParams.add(d1Vol = new ParamVolume("d1"));
		// outputParams.add(d2Vol = new ParamVolume("d2"));
		// outputParams.add(d3Vol = new ParamVolume("d3"));

		// outputParams.add(fantasm.getOutput());
		// outputParams.getFirstChildByName("Execution Time").setHidden(true);
	}


	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		SPECTREwrapper algo_run = new SPECTREwrapper();
		monitor.observe(algo_run);
		algo_run.execute();
	}


	protected class SPECTREwrapper extends AbstractCalculation {
		public SPECTREwrapper() {
			setLabel("SPECTRE 2009 " + revnum);
		}


		public void execute() {
			// System.out.println("start");
			ImageDataMipav image = new ImageDataMipav(origVol.getImageData());

			// System.out.println("img");
			loadAtlasFiles(atlasText.getValue().getAbsolutePath());
			// System.out.println("atlas");

			if (IsotropicResampleBool.getValue()) {
				System.out.println("\n\nISOTROPIC RESAMPLE");
				System.out.print("Old resolution:");
				float[] res = image.getHeader().getDimResolutions();
				System.out.println(res[0] + " x " + res[1] + " x " + res[2] );
				image = IsotropicResample.resample(image, InterpolationMethod.TRILINEAR);
				System.out.print("New resolution:");
				res = image.getHeader().getDimResolutions();
				System.out.println(res[0] + " x " + res[1] + " x " + res[2]);
			} else {
				System.out.println("\n\nSKIPPING ISOTROPIC RESAMPLE\n");
			}


			image = ReorientVolume.solve(image, atlasImages[0],
					Orientation.AXIAL, Resolution.UNCHANGED,
					Interpolation.LINEAR);
			ImageHeader header = image.getHeader();
			header.setAxisOrientation(new AxisOrientation[]{AxisOrientation.R2L_TYPE,AxisOrientation.A2P_TYPE,AxisOrientation.I2S_TYPE});
			header.setImageOrientation(ImageHeader.ImageOrientation.AXIAL);
			int XN = image.getRows();
			int YN = image.getCols();
			int ZN = image.getSlices();


			ParamVolume srcVol = (ParamVolume) flirt.getInput().getFirstChildByName("Source volume");
			ParamVolume targetVol = (ParamVolume) flirt.getInput().getFirstChildByName("Target volume");


			targetVol.setValue(image);
			Point3i dimensions = new Point3i(XN, YN, ZN);
			float[] res = image.getHeader().getDimResolutions();
			Point3f resolutions = new Point3f(res[0], res[1], res[2]);


			System.out.println("\n\nALIGNING ATLASES\n");
			for (int i = 0; i < Natlas; i++) {
				srcVol.setValue(atlasImages[i]);
				flirt.run();
				Matrix transMatrix = ((ParamMatrix) flirt.getOutput()
						.getFirstChildByName("Transformation Matrix"))
						.getValue();
				atlasImages[i] = null;
				atlasMasks[i] = TransformVolume.transform(atlasMasks[i],
						TransformVolume.Interpolation.Nearest_Neighbor,
						transMatrix, resolutions, dimensions);
			}
			atlasImages = null;


			float[][][][] masks = new float[Natlas][XN][YN][ZN];
			for (int i = 0; i < Natlas; i++) {
				masks[i] = (new ImageDataFloat(atlasMasks[i])).toArray3d();
				atlasMasks[i] = null;
			}
			atlasMasks = null;


			byte[][][] prob = new byte[XN][YN][ZN];
			int x_min = 10000, x_max = -10000;
			int y_min = 10000, y_max = -10000;
			int z_min = 10000, z_max = -10000;
//			resultImage.disposeLocal();
			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
						prob[x][y][z] = 0;
						for (int n = 0; n < Natlas; n++) {
							if (masks[n][x][y][z] > 0)
								prob[x][y][z] += 1;
						}
					}
			ImageDataUByte probVol = new ImageDataUByte(prob);
			probVol.setHeader(header);


			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
							if (prob[x][y][z] > 0)
							{
								if (x_min > x) x_min = x;
								if (x_max < x) x_max = x;
								if (y_min > y) y_min = y;
								if (y_max < y) y_max = y;
								if (z_min > z) z_min = z;
								if (z_max < z) z_max = z;
							}
						}
			float[][][] image_float = (new ImageDataFloat(image)).toArray3d();


			if (x_min > 0) x_min--;
			if (x_max < XN) x_max++;
			if (y_min > 0) y_min--;
			if (y_max < YN) y_max++;
			if (z_min > 0) z_min--;
			if (z_max < ZN) z_max++;


			System.out.println("\n\nX range [" + x_min + ", " + x_max + "]");
			System.out.println("Y range [" + y_min + ", " + y_max + "]");
			System.out.println("Z range [" + z_min + ", " + z_max + "]\n");


			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
						if (x < x_min || x > x_max || y < y_min || y > y_max || z < z_min || z > z_max)
						{
							image_float[x][y][z] = 0.0f;
						}
					}
			// ImageDataFloat imageTrimmed = new ImageDataFloat(image_float);
			// imageTrimmed.setHeader(header);
			// imageTrimmed.setName(origVol.getName());


			// ParamVolumeCollection fantasmInput =
			// (ParamVolumeCollection)(fantasm.getInput().getFirstChildByName("Image
			// to segment"));
			// System.out.println("\nMaximum iterations\n");
			// ((ParamInteger)fantasm.getInput().getFirstChildByName("Maximum
			// iterations")).setValue("5");


			System.out.println("\nFANTASM BEGIN\n");
			ModelImage[] segImages = new ModelImage[1];
			ModelImage images = image.getModelImageCopy();
			// ModelImage images = imageTrimmed.getModelImage();
			int classes = -1;
			int[] destExtents = images.getExtents();
			segImages[0] = new ModelImage(ModelStorageBase.UBYTE, destExtents, "Fantasm_seg");
			String correct;


			if (InhomogeneityCorrectionBool.getValue()) {
				correct = "image";
			} else {
				correct = "none";
			}


			if (ImageModality.values()[comboModality.getIndex()] == ImageModality.T1_MPRAGE) {
				// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number
				// of classes")).setValue("5");
				classes = 5;
			} else if (ImageModality.values()[comboModality.getIndex()] == ImageModality.T1_ALT) {
				classes = 6;
			} else {
				// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number
				// of classes")).setValue("4");
				classes = 4;
			}

			// fantasmInput.add(image);
			// fantasm.run();
			segment = new AlgorithmFantasm(segImages, images, 1, "range", "hard_segmentation", classes, 20, 0.05f, smoothingText.getFloat(), 2.0f, false, 0.1f, correct, 3, false, 0.0f, 0.0f, 0.0f, true, bgThresholdText.getFloat(), true, false);


			segment.run();
			segImage = segImages[0];
			segment.finalize();

			// ImageDataMipav segImage =
			// ((ParamVolume)fantasm.getOutput().getFirstChildByName("Hard
			// segmentation")).getImageData();
			/*
			 * byte[][][] segmentation = (new
			 * ImageDataUByte(segImage)).toArray3d(); for (int x = 149; x < 150;
			 * x++) for (int y = 100; y < 150; y++){ for (int z = 100; z < 150;
			 * z++){ System.out.print(segmentation[x][y][z] + " "); }
			 * System.out.println(); }
			 */


			SPECTRE2009 spectre = new SPECTRE2009();
			ImageData result = spectre.solve(image,
					new ImageDataMipav(segImage), probVol, ImageModality
							.values()[comboModality.getIndex()], outputType,
					priorInitText.getFloat(), priorMinText.getFloat(),
					initialErosionText.getInt(), mmcDilationText.getInt(),
					mmcErosionText.getInt(), max_iterations, Natlas);

			image.setHeader(header);
			// imageTrimmed.setName(image.getName() + "_trimmed");
			result.setHeader(header);
			spectre.getPrior().setHeader(header);
			spectre.getMask().setHeader(header);
			spectre.getSegmentation().setHeader(header);
			// spectre.getMarchVol().setHeader(header);
			spectre.getd0Vol().setHeader(header);
			// spectre.getd1Vol().setHeader(header);
			// spectre.getd2Vol().setHeader(header);
			// spectre.getd3Vol().setHeader(header);
			reorientedVol.setValue(image);
			// trimmedVol.setValue(imageTrimmed);
			resultVol.setValue(result);
			priorVol.setValue(spectre.getPrior());
			maskVol.setValue(spectre.getMask());
			segVol.setValue(spectre.getSegmentation());
			// marchVol.setValue(spectre.getMarchVol());
			d0Vol.setValue(spectre.getd0Vol());
			// d1Vol.setValue(spectre.getd1Vol());
			// d2Vol.setValue(spectre.getd2Vol());
			// d3Vol.setValue(spectre.getd3Vol());
			
			//Dispose ModelImages
			segImages[0].disposeLocal();
			images.disposeLocal();
		}
	}


	final public void loadAtlasFiles(String filename) {
		String[] atlasFilenames = null;
		try {
			File f = new File(filename);
			FileReader fr = new FileReader(f);
			BufferedReader br = new BufferedReader(fr);
			String line = br.readLine();
			StringTokenizer st;
			String imageFile;
			// Exact corresponding template
			if (!line.equals("Skull stripping atlas list")) {
				System.out.println("not a proper atlas file");
				br.close();
				fr.close();
				return;
			}
			line = br.readLine();
			if (line.startsWith("pairs of original / stripped images: "))
				Natlas = Integer.valueOf(line.substring(line.indexOf(":") + 2))
						.intValue();
			atlasFilenames = new String[2 * Natlas];
			for (int n = 0; n < 2 * Natlas; n++) {
				atlasFilenames[n] = f.getParent() + File.separator
						+ br.readLine();
				System.out.println("file: " + atlasFilenames[n]);
			}
			br.close();
			fr.close();
		} catch (FileNotFoundException e) {
			System.out.println(e.getMessage());
		} catch (IOException e) {
			System.out.println(e.getMessage());
		} catch (OutOfMemoryError e) {
			System.out.println(e.getMessage());
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		atlasImages = new ImageDataMipav[Natlas];
		atlasMasks = new ImageDataMipav[Natlas];
		for (int n = 0; n < Natlas; n++) {
			atlasImages[n] = ((ImageDataMipav) ImageDataReaderWriter
					.getInstance().read(new File(atlasFilenames[2 * n])));
			atlasMasks[n] = ((ImageDataMipav) ImageDataReaderWriter
					.getInstance().read(new File(atlasFilenames[2 * n + 1])));
		}
		return;
	}
}
