package edu.jhu.ece.iacl.plugins.utilities.volume;


import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Interpolation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Orientation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Resolution;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader.AxisOrientation;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader.ImageOrientation;


public class MedicAlgorithmReorientVolume extends ProcessingAlgorithm{
	protected ParamVolume source,target,result;
	protected ParamOption orient;
	protected ParamOption interp;
	protected ParamOption res;


	private static final String cvsversion = "$Revision: 1.2 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = ReorientVolume.getVersion();
	private static final String shortDescription =
		"Reorient volume to particular anatomical orientation.\n"
		+ "Algorithm Version: " + revnum + "\n"
		+ "GUI Version: " + cvsversion + "\n";
	private static final String longDescription = "Many components of CRUISE assume axial orientation, so it is recommended that data is reoriented before processing.";


	protected void createInputParameters(ParamCollection inputParams) {
		String[] orientStrs = new String[Orientation.values().length];
		int i = 0;
		for (Orientation en:Orientation.values()){
			orientStrs[i++] = en.toString();
		}


		String[] interpStrs = new String[Interpolation.values().length];
		i = 0;
		for (Interpolation en:Interpolation.values()){
			interpStrs[i++] = en.toString();
		}


		String[] resStrs = new String[Resolution.values().length];
		i = 0;
		for (Resolution en:Resolution.values()){
			resStrs[i++] = en.toString();
		}


		inputParams.add(source = new ParamVolume("Source"));
		inputParams.add(target = new ParamVolume("Target"));		
		target.setMandatory(false);


		inputParams.add(orient = new ParamOption("Orientation", orientStrs));
		inputParams.add(interp = new ParamOption("Interpolation", interpStrs));
		inputParams.add(res = new ParamOption("Resolution", resStrs));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Volume");
		inputParams.setLabel("Reorient Volume");
		inputParams.setName("Reorient_Volume");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("John Bogovic", "bogovic@jhu.edu", "http://www.iacl.ece.jhu.edu/John"));
		info.add(new AlgorithmAuthor("Aaron Carass", "aaron_carass@jhu.edu", "http://www.iacl.ece.jhu.edu/"));
		info.add(new AlgorithmAuthor("Blake Lucas", "", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(result=new ParamVolume("Reoriented Volume"));
	}


	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		ImageDataMipav sVol = new ImageDataMipav(source.getImageData());
		ImageDataMipav tVol;

		if (target.getImageData() != null){
			tVol = new ImageDataMipav(target.getImageData());
		} else {
			tVol = null;
		}


		ImageDataMipav image = ReorientVolume.solve(sVol, tVol, Orientation.values()[orient.getIndex()], Resolution.values()[res.getIndex()], Interpolation.values()[interp.getIndex()]);
		ImageHeader header = image.getHeader();
		header.setImageOrientation(ImageOrientation.valueOf(orient.getValue()));


		image.setHeader(header);
		result.setValue(image);
	}
}
