package edu.vanderbilt.masi.algorithms.CRUISE.utilities;

import java.io.IOException;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.IntersectorTriangle;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTriangle;
import edu.jhu.ece.iacl.algorithms.thickness.ThicknessSolver;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;



/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Based on Compute thickness by measuring the shortest distance 
 *between corresponding points. by Blake Lucas in CRUISE
 *
 *The difference is that it calculate the average thickness from inner
 *to the closest point in outer and from that point back to inner surf
 *
 *In addition, this file generate the scalar vtk file which project
 *the thickness to central file
 */

public class ParcellateInnerAndOuterFromCentral extends ThicknessSolver {
	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private int distanceMethod = 0; 
	private int direction = 0;

	public static String getVersion(){
		return revnum;
	}


	public ParcellateInnerAndOuterFromCentral(double lambda, double isoVal,
			double lagrangeDeltaT) {
		this.isoVal = isoVal;
		this.lambda = lambda;
		this.lagrangeDeltaT = lagrangeDeltaT;
		setLabel("Parcellate Inner And Outer Surfaces from Central");
	}


	public ParcellateInnerAndOuterFromCentral(int distanceMethodInput, int directionInput) {
		distanceMethod = distanceMethodInput;
		direction = directionInput;
		setLabel("Parcellate Inner And Outer Surfaces from Central");
	}

	public ParcellateInnerAndOuterFromCentral() {
		setLabel("Parcellate Inner And Outer Surfaces from Central");
	}


	//project to central Mesh
	public void solve(EmbeddedSurface innerMesh, EmbeddedSurface centralMesh) {
		this.innerMesh = innerMesh;
		this.centralMesh = centralMesh;

		//		computeThickness();
		centralsurfaceprojection();
		markCompleted();
	}



	public SurfaceIntersector solve(EmbeddedSurface MeshSurf){

		SurfaceIntersector intersectMeshSurf = new SurfaceIntersector(this, 13, MeshSurf);

		return intersectMeshSurf;
	}


	protected void computeThickness() {
	}

	protected void centralsurfaceprojection(){

		Point3f pt;
		Vector3f nv;
		Point3f p = null;
		Point3f[] pts;
		int id1;
		int id2;
		int id3;
		int fid;
		int smallestdistind;
		float smallestdistance;

		// distance central to other
		SurfaceIntersector intersectCentral = new SurfaceIntersector(this, 13, centralMesh);

		int vertCount = innerMesh.getVertexCount();
		double[][] vertData = new double[vertCount][4];
		setTotalUnits(vertCount + centralMesh.getVertexCount());
		for (int id = 0; id < vertCount; id++) {
		
			pt = innerMesh.getVertex(id);
			double[] stats = vertData[id];

			// central to inner triangular distance
			switch(distanceMethod){
			case 0:
				stats[1] = intersectCentral.distance(pt);
				break;	
			case 1:
				nv = innerMesh.getNormal(id); //normal vector
				if (direction==1){
					nv.negate();
				}				
				stats[1] = intersectCentral.distance(pt,nv);	
				break;	
			case 2:
				nv = innerMesh.getNormal(id); //normal vector
				if (direction==1){
					nv.negate();
				}
				stats[1] = intersectCentral.intersectRayDistance(pt, nv);
				break;	
			default:
				stats[1] = intersectCentral.distance(pt);	
				break;
			}

			Point3f lastPointInner = intersectCentral.getLastIntersectionPoint();
			KdTriangle lastTriangleInner= intersectCentral.getLastIntersectionTriangle();
			//yh add following on 05/09/2017 to deal with bug
			if (lastTriangleInner==null){
				stats[1] = intersectCentral.distance(pt);
				lastTriangleInner= intersectCentral.getLastIntersectionTriangle();
				System.out.println("find a null lastTriangleInner at line = "+id);
			}
			
			IntersectorTriangle TriangleInner = (IntersectorTriangle)lastTriangleInner;	

			pts = TriangleInner.getPoints();
			id1 = TriangleInner.id1; 
			id2 = TriangleInner.id2; 
			id3 = TriangleInner.id3; 
			fid = TriangleInner.fid;

			//find the cloest points among the three vertices in
			//the triangular
			smallestdistind = id1;
			smallestdistance = pt.distance(pts[0]);			
			if (pt.distance(pts[1]) < smallestdistance){
				smallestdistind = id2;
				smallestdistance = 	pt.distance(pts[1]);
			}
			if (pt.distance(pts[2]) < smallestdistance){
				smallestdistind = id3;
				smallestdistance = 	pt.distance(pts[2]);
			}

			//central labels

			//			double tmp1 = centralMesh.getVertexDataAtOffset(smallestdistind,0);

			stats[0] = centralMesh.getVertexDataAtOffset(smallestdistind,0);
			//			// central to inner closet point distance
			stats[2] = smallestdistance;
			//			// central to inner closet point vertice
			stats[3] = (double)smallestdistind;					

		}

		innerMesh.setVertexData(vertData);
		innerMesh.setName(innerMesh.getName() + "_parcellated");
		incrementCompletedUnits();

	}


}
