package edu.vanderbilt.masi.algorithms.CRUISE.utilities;

import java.util.ArrayList;
import java.util.Collections;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.IntersectorTriangle;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTriangle;
import edu.jhu.ece.iacl.algorithms.thickness.ThicknessSolver;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;



/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Based on Compute thickness by measuring the shortest distance 
 *between corresponding points. by Blake Lucas in CRUISE
 *
 *The difference is that it calculate the average thickness from inner
 *to the closest point in outer and from that point back to inner surf
 *
 *In addition, this file generate the scalar vtk file which project
 *the thickness to central file
 */

public class ParcellateInnerAndOuterFromVolume extends ThicknessSolver {
	private static final String cvsversion = "$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");


	public static String getVersion(){
		return revnum;
	}


	public ParcellateInnerAndOuterFromVolume(double lambda, double isoVal,
			double lagrangeDeltaT) {
		this.isoVal = isoVal;
		this.lambda = lambda;
		this.lagrangeDeltaT = lagrangeDeltaT;
		setLabel("Parcellate Inner And Outer Surfaces from Central");
	}
	
	
	public ParcellateInnerAndOuterFromVolume() {
		setLabel("Parcellate Inner And Outer Surfaces from Central");
	}



	//project to central Mesh
	//project to central Mesh
	public void solve(EmbeddedSurface innerMesh, ImageData segVol) {
		this.innerMesh = innerMesh;
		this.innerVol = segVol;
		
//		computeThickness();
		centralsurfaceprojection();
		markCompleted();
	}
	


	public SurfaceIntersector solve(EmbeddedSurface MeshSurf){

		SurfaceIntersector intersectMeshSurf = new SurfaceIntersector(this, 13, MeshSurf);

		return intersectMeshSurf;
	}


	protected void computeThickness() {
	}
	
	protected void centralsurfaceprojection(){
		
//		Point3f pt;
//		Point3f p = null;
//		Point3f[] pts;
//		int id1;
//		int id2;
//		int id3;
//		int fid;
//		int smallestdistind;
//		float smallestdistance;
		
		// distance central to other
		//SurfaceIntersector intersectInner = new SurfaceIntersector(this, 13, innerMesh);
		

		EmbeddedSurface result = labelSurf(innerVol,innerMesh.clone());
		
		
	
//		int vertCount = innerMesh.getVertexCount();
//		double[][] vertData = new double[vertCount][4];
//		setTotalUnits(vertCount + centralMesh.getVertexCount());
//		for (int id = 0; id < vertCount; id++) {
//			pt = innerMesh.getVertex(id);
//			double[] stats = vertData[id];
//			
//			// central to inner triangular distance
//			stats[1] = intersectCentral.distance(pt);
//			Point3f lastPointInner = intersectCentral.getLastIntersectionPoint();
//			KdTriangle lastTriangleInner= intersectCentral.getLastIntersectionTriangle();
//			IntersectorTriangle TriangleInner = (IntersectorTriangle)lastTriangleInner;
//			
//			pts = TriangleInner.getPoints();
//			id1 = TriangleInner.id1; 
//			id2 = TriangleInner.id2; 
//			id3 = TriangleInner.id3; 
//			fid = TriangleInner.fid;
//			
//			//find the cloest points among the three vertices in
//			//the triangular
//			smallestdistind = id1;
//			smallestdistance = pt.distance(pts[0]);			
//			if (pt.distance(pts[1]) < smallestdistance){
//				smallestdistind = id2;
//				smallestdistance = 	pt.distance(pts[1]);
//			}
//			if (pt.distance(pts[2]) < smallestdistance){
//				smallestdistind = id3;
//				smallestdistance = 	pt.distance(pts[2]);
//			}
//			
//			//central labels
//			
////			double tmp1 = centralMesh.getVertexDataAtOffset(smallestdistind,0);
//			
//			stats[0] = centralMesh.getVertexDataAtOffset(smallestdistind,0);
////			// central to inner closet point distance
//			stats[2] = smallestdistance;
////			// central to inner closet point vertice
//			stats[3] = (double)smallestdistind;					
//		
//		}
		
		innerMesh.setVertexData(result.getVertexData());
		innerMesh.setName(innerMesh.getName());
		incrementCompletedUnits();
		
	}
	
	
	private EmbeddedSurface labelSurf(ImageData vol,EmbeddedSurface sout){
		
		double[][] data = sout.getVertexData();

//		float[] origin = vol.getModelImage().getOrigin();

		for(int i=0; i<data.length; i++){
			Point3f p = sout.getVertex(i);
			
			int x0 = Math.round(p.x);
			int y0 = Math.round(p.y);
			int z0 = Math.round(p.z);
			double label0 = vol.getDouble(x0,y0,z0);
			double distMin = 1000000;
			//ArrayList<Double> corticalLabels = new ArrayList<Double>();
			
			data[i] = new double[]{-1};
			
			if(isPtinBounds(vol,p)){
				if (label0>100){
					data[i]=new double[]{label0};
				}else{
					for (int x=-1;x<=1;x++){
						for (int y=-1;y<=1;y++){
							for (int z=-1;z<=1;z++){
								int x1 = x0+x;
								int y1 = y0+y;
								int z1 = z0+z;
								Point3f pt = new Point3f(x1,y1,z1);
								
								if(isPtinBounds(vol,pt)){									
									double dist1 = p.distance(pt);
									double label1 = vol.getDouble(x1,y1,z1);
									if (dist1<distMin&&label1>100){
										data[i]=new double[]{label1};
										distMin = dist1;
								}
								
								}
//								if (label1>100){
//									corticalLabels.add(label1);
//								}
							}
						}
					}
//					if (corticalLabels.size()>0){
//						int occurMax = 0;
//						for (double l = 101;l<=207;l++){
//							int occur = Collections.frequency(corticalLabels, l);
//							if (occur>occurMax){
//								occurMax = occur;
//								data[i]=new double[]{l};
//							}
//						}
//					}
					
				}
			}
		}
		sout.setVertexData(data);
		return sout;
	}


	private boolean isPtinBounds(ImageData img, Point3f pt){
		if(pt.x<0 || pt.y<0 || pt.z<0){
			return false;
		}
		if(Math.round(pt.x)>img.getRows()-1){
			return false;
		}
		if(Math.round(pt.y)>img.getCols()-1){
			return false;
		}
		if(Math.round(pt.z)>img.getSlices()-1){
			return false;
		}
		return true;
	}
	

}
