package edu.vanderbilt.masi.plugins.CRUISE.MaCRUISE;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.io.SurfaceFreeSurferReaderWriter;
import edu.jhu.ece.iacl.jist.io.SurfaceVtkReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmN3;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmToads08;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmGradVecFlow;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmRemoveDura09;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmSPECTRE2010;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.vanderbilt.masi.plugins.CRUISE.ace.MaACE;
import edu.vanderbilt.masi.plugins.CRUISE.tgdm.MaTGDMcrop;
import edu.vanderbilt.masi.plugins.CRUISE.tgdm.MaTGDMorigin;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.CleanBoundaryFromToads;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.CorticalSeperation;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.CropBasedOnGM;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.GetMeshSurfaceFromLevelSet;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.InverseCropBasedOnGM;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.MakeThinSkeleton;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.MinFilter3D;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.ToadsCruiseSpaceToOriginalSpace;

public class MaCRUISE extends ProcessingAlgorithm{

	CorticalSeperation corticalsep;
	CropBasedOnGM crop;
	MedicAlgorithmN3 n3;
	MedicAlgorithmSPECTRE2010 spectre;
	MedicAlgorithmRemoveDura09 rmDura;
	MedicAlgorithmToads08 toads,toads2;	
	ToadsCruiseSpaceToOriginalSpace orispace;
	MinFilter3D boundSpeed;
	MakeThinSkeleton boundSpeedThin;
	CleanBoundaryFromToads boundSpeedClean;
	CombineMAandTOADS combine;
	MedicAlgorithmTopologyCorrection topoCorrect;
	MaACE ace;
	ParamCollection ACEenhance;
	MedicAlgorithmGradVecFlow gvfCentral;
	MaTGDMcrop tgdm;
	InverseCropBasedOnGM invcrop;
	GetMeshSurfaceFromLevelSet genmesh;
	

	private ParamVolume T1VolRaw;
	private ParamVolume SegVolRaw;
	private ParamBoolean DebugFlag;
	private ParamBoolean IfACEenhance;
	private ParamOption ACEenhanceInput;
	//debug parameters
	ParamFile ykdebug = new ParamVolume("yk debug");

	private static final String cvsversion = "$Revision: 1.17 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private static final ImageDataReaderWriter vrw = ImageDataReaderWriter.getInstance();
	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();
	private static final SurfaceFreeSurferReaderWriter frw = SurfaceFreeSurferReaderWriter.getInstance();


	@Override
	protected void createInputParameters(ParamCollection inputParams) { 
		setPreferredSize(new Dimension(800, 500));
		// TODO Auto-generated method stub
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("MaCRUISE");
		inputParams.setLabel("Multi-atlas CRUISE");
		inputParams.setName("Multi-atlas_CRUISE");

		//		input files for MaCRUISE
		ParamCollection MaCRUISEinputpanel=new ParamCollection("InputFiles");	
		MaCRUISEinputpanel.add(T1VolRaw=new ParamVolume("T1 Raw",VoxelType.FLOAT));
		T1VolRaw.setDescription("T1 input file");
		MaCRUISEinputpanel.add(SegVolRaw=new ParamVolume("Multi-atlas Segmentation",VoxelType.FLOAT));
		SegVolRaw.setDescription("Multi-atlas Segmentation file");
		MaCRUISEinputpanel.add(DebugFlag=new ParamBoolean("Generate intermediate files",false));
		DebugFlag.setDescription("Generate intermediate files");
		DebugFlag.setValue(true);
		DebugFlag.setHidden(true);
		inputParams.add(MaCRUISEinputpanel);

		//Step 1.1 cortical seperation
		corticalsep = new CorticalSeperation();
		corticalsep.getInput().getFirstChildByName("MaSeg volume").setHidden(true);

		//Step 2.1 N3 correction
		n3 = new MedicAlgorithmN3();
		n3.getInput().getFirstChildByName("Input Volume").setHidden(true);
		inputParams.add(n3.getInput());

		//Step 2.2 spectre
		spectre = new MedicAlgorithmSPECTRE2010();
		spectre.getInput().getFirstChildByName("Input Volume").setHidden(true);
		spectre.getInput().getFirstChildByName("Image modality").setHidden(true);
		spectre.getInput().getFirstChildByName("Output in Original Image Space").setHidden(true);
		spectre.getInput().getFirstChildByName("FANTASM").setHidden(true);
		spectre.getInput().getFirstChildByName("MSP").setHidden(true);
		spectre.getInput().getFirstChildByName("Find Midsaggital Plane").setHidden(true);
		spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels").setHidden(true); //yk modify 1
		spectre.getInput().getFirstChildByName("Run Smooth Brain Mask").setHidden(true);
		//String atlasFileName = "Atlases/Atlas/spectre/oasis-3.txt";
		((ParamOption)spectre.getInput().getFirstChildByName("Image modality")).setValue(2); //always choose T1_MPRAGE for Spectre
		((ParamBoolean)spectre.getInput().getFirstChildByName("Inhomogeneity Correction")).setValue(false); // N3 does correction so set FANTASM option to false.
		((ParamBoolean)spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels")).setValue(false); //yk modify 2
		((ParamBoolean)spectre.getInput().getFirstChildByName("Find Midsaggital Plane")).setValue(false);
		((ParamBoolean)spectre.getInput().getFirstChildByName("Output in Original Image Space")).setValue(false); //yk modify 2
		((ParamBoolean)spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels")).setValue(false); //yk modify 3
		inputParams.add(spectre.getInput());

		//Step 2.3 Toads1
		toads = new MedicAlgorithmToads08();
		toads.getInput().setName("toads1");
		toads.getInput().setLabel("TOADS");
		toads.getInput().getFirstChildByName("Image to segment").setHidden(true);
		toads.getInput().getFirstChildByName("Output images").setHidden(true);
		toads.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		toads.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		toads.getInput().getFirstChildByName("Output max membership classification").setHidden(true);
		//String atlasFileName = "Atlases/Atlas/cruise-atlas-10obj-toads2008.txt";
		((ParamOption)toads.getInput().getFirstChildByName("Output images")).setValue(3); //output should be dura removal inputs
		inputParams.add(toads.getInput());

		//Step 2.4 remove dura
		rmDura = new MedicAlgorithmRemoveDura09();
		rmDura.getInput().getFirstChildByName("Original Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("GM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Mask").setHidden(true);
		rmDura.getInput().getFirstChildByName("Data").setHidden(true);
		inputParams.add(rmDura.getInput());

		//Step 2.5 Toads2
		toads2 = new MedicAlgorithmToads08();
		toads2.getInput().setName("toads2");
		toads2.getInput().setLabel("TOADS Second Pass");
		toads2.getInput().getFirstChildByName("Atlas file").setHidden(true);
		toads2.getInput().getFirstChildByName("Image to segment").setHidden(true);
		toads2.getInput().getFirstChildByName("Output images").setHidden(true);
		toads2.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		toads2.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		toads2.getInput().getFirstChildByName("Image modality").setHidden(true);
		toads2.getInput().getFirstChildByName("Output max membership classification").setHidden(true);
		((ParamOption)toads2.getInput().getFirstChildByName("Output images")).setValue(3); //output should be dura removal inputs
		inputParams.add(toads2.getInput());

		//Step 2.6 Toads to original space
		orispace = new ToadsCruiseSpaceToOriginalSpace();
		orispace.getInput().setName("orispace");
		orispace.getInput().setLabel("TOADS to Ori Space");
		orispace.getInput().getFirstChildByName("ToadsCruise volume").setHidden(true);
		orispace.getInput().getFirstChildByName("Reference volume").setHidden(true);
		inputParams.add(orispace.getInput());

		//Step 3.1 crop based on GM
		crop = new CropBasedOnGM();
		crop.getInput().getFirstChildByName("GM volume").setHidden(true);
		crop.getInput().getFirstChildByName("Target volume").setHidden(true);
		inputParams.add(crop.getInput());

		//Step 3.2 make new boundary speed function from multi-atlas
		boundSpeed = new MinFilter3D();
		boundSpeed.getInput().getFirstChildByName("Input volume").setHidden(true);
		inputParams.add(boundSpeed.getInput());

//		//Step 3.3 thin the new boundary speed function
//		boundSpeedThin = new MakeThinSkeleton();
//		boundSpeedThin.getInput().getFirstChildByName("Original Skeleton").setHidden(true);
//		boundSpeedThin.getInput().getFirstChildByName("GM ACE").setHidden(true);
//		inputParams.add(boundSpeedThin.getInput());
		
		//Step 3.3 clean boundary files using TOADS
		boundSpeedClean = new CleanBoundaryFromToads();
		boundSpeedClean.getInput().getFirstChildByName("Boundary volume").setHidden(true);
		boundSpeedClean.getInput().getFirstChildByName("ToadsWM volume").setHidden(true);
		inputParams.add(boundSpeedClean.getInput());

		//Step 3.4 combine MA and toADS
		combine = new CombineMAandTOADS();
		combine.getInput().getFirstChildByName("multiatlas_GM volume").setHidden(true);
		combine.getInput().getFirstChildByName("multiatlas_WM volume").setHidden(true);
		combine.getInput().getFirstChildByName("multiatlas_BrainMask volume").setHidden(true);
		combine.getInput().getFirstChildByName("toads_GM volume").setHidden(true);
		combine.getInput().getFirstChildByName("toads_WM volume").setHidden(true);
		combine.getInput().getFirstChildByName("toads_Mask volume").setHidden(true);		
		inputParams.add(combine.getInput());

		//Step 4.1 Topo Correct
		topoCorrect = new MedicAlgorithmTopologyCorrection();
		topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Paint mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		inputParams.add(topoCorrect.getInput());

		//Step 4.2 ACE	
		ace=new MaACE();
		ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		ace.getInput().getFirstChildByName("Multi Atlas CSF file").setHidden(true);
		ace.getInput().getFirstChildByName("The place to add the Ma boundary speed function").setHidden(true);
		ace.getInput().getFirstChildByName("Merge or totally replace the old speed function").setHidden(true);
		((ParamOption)ace.getInput().getFirstChildByName("The place to add the Ma boundary speed function")).setValue(2); //after gaussian
		((ParamOption)ace.getInput().getFirstChildByName("Merge or totally replace the old speed function")).setValue(0); //merge
		inputParams.add(ace.getInput());

		//Step 4.3 ACE result enhance
		ACEenhance=new ParamCollection("ACEenhance");	
		ACEenhance.add(IfACEenhance=new ParamBoolean("IfACEenhance",false));
		IfACEenhance.setDescription("If do ACE additional enhance");
		ACEenhance.add(ACEenhanceInput=new ParamOption("Skeleton type of enhanceing ACE", 
				new String[] {"Skeleton","ThinSkeleton"}));
		ACEenhanceInput.setValue("Skeleton");
		ACEenhanceInput.setMandatory(false);
		IfACEenhance.setDescription("If do ACE additional enhance");
		inputParams.add(ACEenhance);

		//Step 4.4 GVF
		gvfCentral = new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);
		inputParams.add(gvfCentral.getInput());

		//Step 4.5 TGDM
		tgdm=new MaTGDMcrop();
		tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Level Set").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Iso Level").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force").setHidden(true);
		tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing").setHidden(true);
		inputParams.add(tgdm.getInput());

		//step 5.1 invcrop based on gm
		invcrop = new InverseCropBasedOnGM();
		invcrop.getInput().getFirstChildByName("GM volume").setHidden(true);
		invcrop.getInput().getFirstChildByName("Target volume").setHidden(true);
		inputParams.add(invcrop.getInput());

		//step 5.2 final surface in origin space
		genmesh = new GetMeshSurfaceFromLevelSet();
		genmesh.getInput().getFirstChildByName("levelset file").setHidden(true);
		
		// set algorithm information
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite(" ");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);

		info.add(ReferencedPapers.cruise);
		info.add(ReferencedPapers.ace);
		info.add(ReferencedPapers.tgdm);
		info.add(ReferencedPapers.gvf);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.duyguTosun);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("MaCRUISE pipeline generating whole brain segmentations and cortical surfaces");
		info.setLongDescription("Full MaCRUISE pipeline. It takes a 3D volume, does NLSS Multi-atlas segmentation to get whole brain segmentation, then modify membership by TOADs, finally reconstruct cortical surfaces by CRUISE");
		info.setAdditionalDocURL("");



	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

		// files that we need
		ImageData t1=T1VolRaw.getImageData();
		ImageData seg=SegVolRaw.getImageData();

		//set the output directory and create it if it doesn't exist
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }

		//step1. cortical separation
		System.out.println("Start Step 1, Preprocessing =======================");
		File dir_Pre= new File(dir + "/Preprocess/");
		if (DebugFlag.getValue()){
			try{
				if(!dir_Pre.isDirectory()){
					(new File(dir_Pre.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}
		//step1.1 cortical separation
		ImageData GM_file,WM_file,Mask_file,BrainMask_file;
		if(DebugFlag.getValue()&&FilesExist(dir_Pre,"CorticalSeperation","Atlas_GM")&&FilesExist(dir_Pre,"CorticalSeperation","Atlas_WM")
				&&FilesExist(dir_Pre,"CorticalSeperation","Atlas_Mask")&&FilesExist(dir_Pre,"CorticalSeperation","Atlas_BrainTissueMask")){
			GM_file = load_file_from_disk(dir_Pre,"CorticalSeperation","Atlas_GM");
			WM_file = load_file_from_disk(dir_Pre,"CorticalSeperation","Atlas_WM");
			Mask_file = load_file_from_disk(dir_Pre,"CorticalSeperation","Atlas_Mask");
			BrainMask_file = load_file_from_disk(dir_Pre,"CorticalSeperation","Atlas_BrainTissueMask");
			System.out.println("Exist, skip step1.1 cortical separation");// yk add debug
		}else{		
			((ParamVolume)corticalsep.getInput().getFirstChildByName("MaSeg volume")).setValue(seg);
			corticalsep.runAlgorithm(monitor);
			GM_file = ((ParamVolume)corticalsep.getOutput().getFirstChildByName("GMVol volume")).getImageData();
			WM_file = ((ParamVolume)corticalsep.getOutput().getFirstChildByName("WMVol volume")).getImageData();
			Mask_file = ((ParamVolume)corticalsep.getOutput().getFirstChildByName("WMmaskVol volume")).getImageData();
			BrainMask_file = ((ParamVolume)corticalsep.getOutput().getFirstChildByName("WholeBrainVol volume")).getImageData();
			save_intermfile(dir_Pre,"CorticalSeperation",GM_file,"Atlas_GM");
			save_intermfile(dir_Pre,"CorticalSeperation",WM_file,"Atlas_WM");
			save_intermfile(dir_Pre,"CorticalSeperation",Mask_file,"Atlas_Mask");
			save_intermfile(dir_Pre,"CorticalSeperation",BrainMask_file,"Atlas_BrainTissueMask");
			corticalsep = null;
		}


		// step2. get membership by TOADs
		System.out.println("Start Step 2, TOADS segmentation =======================");
		File dir_TOADs= new File(dir + "/Toads/");
		if (DebugFlag.getValue()){
			try{
				if(!dir_TOADs.isDirectory()){
					(new File(dir_TOADs.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}

		// step2.1 N3 correction
		ImageData N3_correct_file;
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"N3Correct","T1_N3Corrected")){
			N3_correct_file = load_file_from_disk(dir_TOADs,"N3Correct","T1_N3Corrected");
			System.out.println("Exist, skip step2.1 N3 correction");// yk add debug
		}else{
			((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(t1);
			n3.runAlgorithm(monitor);
			N3_correct_file = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
			save_intermfile(dir_TOADs,"N3Correct",N3_correct_file,"T1_N3Corrected");	
			n3 = null;
		}

		// step2.2 spectre skull stripping
		ImageData spectre_file,orig_transferred_file;
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"spectre","T1_N3Corrected_spectrestripped")
				&&FilesExist(dir_TOADs,"spectre","T1_N3Corrected1_origtransform")){
			spectre_file = load_file_from_disk(dir_TOADs,"spectre","T1_N3Corrected_spectrestripped");
			orig_transferred_file = load_file_from_disk(dir_TOADs,"spectre","T1_N3Corrected1_origtransform");
			System.out.println("Exist, skip step2.2 spectre skull stripping");// yk add debug
		}else{
			((ParamVolume)spectre.getInput().getFirstChildByName("Input Volume")).setValue(N3_correct_file);
			spectre.runAlgorithm(monitor);
			spectre_file = ((ParamVolume)spectre.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
			orig_transferred_file = ((ParamVolume)spectre.getOutput().getFirstChildByName("Original or Reoriented Volume")).getImageData();
			save_intermfile(dir_TOADs,"spectre",spectre_file,"T1_N3Corrected_spectrestripped");
			save_intermfile(dir_TOADs,"spectre",orig_transferred_file,"T1_N3Corrected1_origtransform");
			spectre = null;
		}

		// step2.3 toads
		ImageData Toads1_wmmask_file,Toads1_gm_file,Toads1_wmfill_file;
		int conn = ((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getIndex();
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1gm")
				&&FilesExist(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1wmmask")
				&&FilesExist(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1wmfill")){
			Toads1_gm_file = load_file_from_disk(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1gm");
			Toads1_wmmask_file = load_file_from_disk(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1wmmask");
			Toads1_wmfill_file = load_file_from_disk(dir_TOADs,"Toads1stPass","T1_N3Corrected_toads1wmfill");
			System.out.println("Exist, skip step2.3 toads");// yk add debug
		}else{
			((ParamVolume)toads.getInput().getFirstChildByName("Image to segment")).setValue(spectre_file);
			toads.runAlgorithm(monitor);
			Toads1_gm_file = ((ParamVolume)toads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
			Toads1_wmmask_file = ((ParamVolume)toads.getOutput().getFirstChildByName("WM mask")).getImageData();		
			Toads1_wmfill_file = ((ParamVolume)toads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
			save_intermfile(dir_TOADs,"Toads1stPass",Toads1_gm_file,"T1_N3Corrected_toads1gm");		
			save_intermfile(dir_TOADs,"Toads1stPass",Toads1_wmmask_file,"T1_N3Corrected_toads1wmmask");
			save_intermfile(dir_TOADs,"Toads1stPass",Toads1_wmfill_file,"T1_N3Corrected_toads1wmfill");
		}

		// step2.4 remove dura		
		ImageData dura_file;
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"rmDura","T1_N3Corrected_durastripped")){
			dura_file = load_file_from_disk(dir_TOADs,"rmDura","T1_N3Corrected_durastripped");
			System.out.println("Exist, skip step2.4 remove dura");// yk add debug
		}else{
			((ParamVolume)rmDura.getInput().getFirstChildByName("Original Volume")).setValue(orig_transferred_file);
			((ParamVolume)rmDura.getInput().getFirstChildByName("WM Volume")).setValue(Toads1_wmfill_file);
			((ParamVolume)rmDura.getInput().getFirstChildByName("GM Volume")).setValue(Toads1_gm_file);
			((ParamVolume)rmDura.getInput().getFirstChildByName("WM Mask")).setValue(Toads1_wmmask_file);
			rmDura.runAlgorithm(monitor);
			dura_file = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
			save_intermfile(dir_TOADs,"rmDura",dura_file,"T1_N3Corrected_durastripped");
			rmDura = null;
		}

		// step2.5 toads2
		ImageData Toads2_gm_file,Toads2_wmmask_file,Toads2_wmfill_file;
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2gm")
				&&FilesExist(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmmask")
				&&FilesExist(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmfill")){
			Toads2_gm_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2gm");
			Toads2_wmmask_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmmask");
			Toads2_wmfill_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmfill");
			System.out.println("Exist, skip step2.5 toads2");// yk add debug
		}else{
			((ParamVolume)toads2.getInput().getFirstChildByName("Image to segment")).setValue(dura_file);
			((ParamOption)toads2.getInput().getFirstChildByName("Image modality")).setValue(
					((ParamOption)toads.getInput().getFirstChildByName("Image modality")).getIndex());
			((ParamDouble)toads2.getInput().getFirstChildByName("Smooting parameter")).setValue(
					((ParamDouble)toads.getInput().getFirstChildByName("Smooting parameter")).getValue());
			((ParamInteger)toads2.getInput().getFirstChildByName("Maximum iterations")).setValue(
					((ParamInteger)toads.getInput().getFirstChildByName("Maximum iterations")).getValue());
			((ParamDouble)toads2.getInput().getFirstChildByName("Maximum difference")).setValue(
					((ParamDouble)toads.getInput().getFirstChildByName("Maximum difference")).getValue());
			((ParamDouble)toads2.getInput().getFirstChildByName("Atlas prior")).setValue(
					((ParamDouble)toads.getInput().getFirstChildByName("Atlas prior")).getValue());
			((ParamFile)toads2.getInput().getFirstChildByName("Atlas file")).setValue(
					((ParamFile)toads.getInput().getFirstChildByName("Atlas file")).getValue());
			((ParamOption)toads2.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(
					((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getValue());
			toads2.runAlgorithm(monitor);
			Toads2_gm_file = ((ParamVolume)toads2.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
			Toads2_wmmask_file = ((ParamVolume)toads2.getOutput().getFirstChildByName("WM mask")).getImageData();		
			Toads2_wmfill_file = ((ParamVolume)toads2.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
			save_intermfile(dir_TOADs,"Toads2ndPass",Toads2_gm_file,"T1_N3Corrected_toads2gm");		
			save_intermfile(dir_TOADs,"Toads2ndPass",Toads2_wmmask_file,"T1_N3Corrected_toads2wmmask");
			save_intermfile(dir_TOADs,"Toads2ndPass",Toads2_wmfill_file,"T1_N3Corrected_toads2wmfill");
			toads = null;
			toads2 = null;
		}

		// step 2.6 Toads segmentation to original space
		ImageData Toads2_gm_refspace, Toads2_wmmask_refspace,Toads2_wmfill_refspace;
		if(DebugFlag.getValue()&&FilesExist(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2gm_refspace")
		&&FilesExist(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2wmmask_refspace")
		&&FilesExist(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2wmfill_refspace")){
//		if(DebugFlag.getValue()){
			Toads2_gm_refspace = load_file_from_disk(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2gm_refspace");
			Toads2_wmmask_refspace = load_file_from_disk(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2wmmask_refspace");
			Toads2_wmfill_refspace = load_file_from_disk(dir_TOADs,"ToadsFinal","T1_N3Corrected_toads2wmfill_refspace");
			System.out.println("Exist, skip step2.6 Toads segmentation to original space");// yk add debug
		}else{
			Toads2_gm_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2gm");
			Toads2_wmmask_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmmask");
			Toads2_wmfill_file = load_file_from_disk(dir_TOADs,"Toads2ndPass","T1_N3Corrected_toads2wmfill");
			((ParamVolume)orispace.getInput().getFirstChildByName("Reference volume")).setValue(seg);
			((ParamVolume)orispace.getInput().getFirstChildByName("ToadsCruise volume")).setValue(Toads2_gm_file);
			orispace.runAlgorithm(monitor);
			Toads2_gm_refspace = ((ParamVolume)orispace.getOutput().getFirstChildByName("ToadsCruise original spaces")).getImageData();
			((ParamVolume)orispace.getInput().getFirstChildByName("ToadsCruise volume")).setValue(Toads2_wmmask_file);
			orispace.runAlgorithm(monitor);
			Toads2_wmmask_refspace = ((ParamVolume)orispace.getOutput().getFirstChildByName("ToadsCruise original spaces")).getImageData();
			((ParamVolume)orispace.getInput().getFirstChildByName("ToadsCruise volume")).setValue(Toads2_wmfill_file);
			orispace.runAlgorithm(monitor);
			Toads2_wmfill_refspace = ((ParamVolume)orispace.getOutput().getFirstChildByName("ToadsCruise original spaces")).getImageData();
			save_intermfile(dir_TOADs,"ToadsFinal",Toads2_gm_refspace,"T1_N3Corrected_toads2gm_refspace");		
			save_intermfile(dir_TOADs,"ToadsFinal",Toads2_wmmask_refspace,"T1_N3Corrected_toads2wmmask_refspace");
			save_intermfile(dir_TOADs,"ToadsFinal",Toads2_wmfill_refspace,"T1_N3Corrected_toads2wmfill_refspace");
			orispace = null;
		}
		// clean 1
		N3_correct_file.dispose();
		spectre_file.dispose();
		orig_transferred_file.dispose();
		Toads1_gm_file.dispose();
		Toads1_wmmask_file.dispose();
		Toads1_wmfill_file.dispose();
		dura_file.dispose();
		Toads2_gm_file.dispose();
		Toads2_wmmask_file.dispose();
		Toads2_wmfill_file.dispose();

		// step 3 Combine Multi-atlas and TOADS
		System.out.println("Start Step 3, Combine Multi-atlas and TOADS =======================");
		File dir_Combine= new File(dir + "/Combine/");
		if (DebugFlag.getValue()){
			try{
				if(!dir_Combine.isDirectory()){
					(new File(dir_Combine.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}

		// step3.1 crop based on GM
		ImageData GM_crop_file,WM_crop_file,BrainMask_crop_file;
		ImageData Toads2_gm_refspace_crop_file,Toads2_wmfill_refspace_crop_file,Toads2_wmmask_refspace_crop_file;
		ImageData Seg_crop_file;
		if(DebugFlag.getValue()&&FilesExist(dir_Combine,"CropBasedOnGM","Atlas_GM_cp")&&FilesExist(dir_Combine,"CropBasedOnGM","Atlas_WM_cp")
				&&FilesExist(dir_Combine,"CropBasedOnGM","Atlas_BrainTissueMask_cp")&&FilesExist(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2gm_refspace_cp")
				&&FilesExist(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2wmfill_refspace_cp")&&FilesExist(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2wmmask_refspace_cp")
				&&FilesExist(dir_Combine,"CropBasedOnGM","Seg_cp")){
			GM_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","Atlas_GM_cp");
			WM_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","Atlas_WM_cp");
			BrainMask_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","Atlas_BrainTissueMask_cp");
			Toads2_gm_refspace_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2gm_refspace_cp");
			Toads2_wmfill_refspace_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2wmfill_refspace_cp");
			Toads2_wmmask_refspace_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","T1_N3Corrected_toads2wmmask_refspace_cp");
			Seg_crop_file = load_file_from_disk(dir_Combine,"CropBasedOnGM","Seg_cp");
			System.out.println("Exist, skip step3.1. crop based on GM");// yk add debug
		}else{	
			((ParamVolume)crop.getInput().getFirstChildByName("GM volume")).setValue(GM_file);
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(WM_file);
			crop.runAlgorithm(monitor);
			GM_crop_file = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped GM")).getImageData();
			WM_crop_file = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(BrainMask_file);
			crop.runAlgorithm(monitor);
			BrainMask_crop_file = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(Toads2_gm_refspace);
			crop.runAlgorithm(monitor);
			Toads2_gm_refspace_crop_file = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(Toads2_wmfill_refspace);
			crop.runAlgorithm(monitor);
			Toads2_wmfill_refspace_crop_file  = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(Toads2_wmmask_refspace);
			crop.runAlgorithm(monitor);
			Toads2_wmmask_refspace_crop_file  = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			((ParamVolume)crop.getInput().getFirstChildByName("Target volume")).setValue(seg);
			crop.runAlgorithm(monitor);
			Seg_crop_file  = ((ParamVolume)crop.getOutput().getFirstChildByName("Cropped target")).getImageData();
			save_intermfile(dir_Combine,"CropBasedOnGM",GM_crop_file,"Atlas_GM_cp");	
			save_intermfile(dir_Combine,"CropBasedOnGM",WM_crop_file,"Atlas_WM_cp");		
			save_intermfile(dir_Combine,"CropBasedOnGM",BrainMask_crop_file,"Atlas_BrainTissueMask_cp");
			save_intermfile(dir_Combine,"CropBasedOnGM",Toads2_gm_refspace_crop_file,"T1_N3Corrected_toads2gm_refspace_cp");
			save_intermfile(dir_Combine,"CropBasedOnGM",Toads2_wmfill_refspace_crop_file,"T1_N3Corrected_toads2wmfill_refspace_cp");		
			save_intermfile(dir_Combine,"CropBasedOnGM",Toads2_wmmask_refspace_crop_file,"T1_N3Corrected_toads2wmmask_refspace_cp");
			save_intermfile(dir_Combine,"CropBasedOnGM",Seg_crop_file,"Seg_cp");
			crop = null;
		}

		// step3.2 Make Boundary Speed File from multi-atlas
		ImageData boundary_speed_file;
		if(DebugFlag.getValue()&&FilesExist(dir_Combine,"NewCsfFiles","csf_MaBoundary")){
			boundary_speed_file = load_file_from_disk(dir_Combine,"NewCsfFiles","csf_MaBoundary");
			System.out.println("Exist, skip step3.2 Make Boundary Speed File from multi-atlas");// yk add debug
		}else{
			((ParamVolume)boundSpeed.getInput().getFirstChildByName("Input volume")).setValue(Seg_crop_file);
			boundSpeed.runAlgorithm(monitor);
			boundary_speed_file = ((ParamVolume)boundSpeed.getOutput().getFirstChildByName("Output volume")).getImageData();
			save_intermfile(dir_Combine,"NewCsfFiles",boundary_speed_file,"csf_MaBoundary");
			boundSpeed = null;
		}

		// step3.3 Make Thin Boundary Speed File 
		//		ImageData boundary_speed_thin_file;
		//		if(DebugFlag.getValue()&&FilesExist(dir_Combine,"NewCsfFiles","csf_MaBoundary_thin")){
		//			boundary_speed_thin_file = load_file_from_disk(dir_Combine,"NewCsfFiles","csf_MaBoundary_thin");
		//			System.out.println("Exist, skip step3.3 Make Thin Boundary Speed File in CSF");// yk add debug
		//		}else{
		//			((ParamVolume)boundSpeedThin.getInput().getFirstChildByName("Original Skeleton")).setValue(boundary_speed_file);
		//			boundSpeedThin.runAlgorithm(monitor);
		//			boundary_speed_thin_file = ((ParamVolume)boundSpeedThin.getOutput().getFirstChildByName("Thin Skeleton")).getImageData();
		//			save_intermfile(dir_Combine,"NewCsfFiles",boundary_speed_thin_file,"csf_MaBoundary_thin");
		//			boundSpeedThin = null;
		//		}
		
		// step3.3 Clean Boudnary by Toads
		ImageData boundary_speed_clean_file;
		if(DebugFlag.getValue()&&FilesExist(dir_Combine,"NewCsfFiles","csf_MaBoundary_clean")){
			boundary_speed_clean_file = load_file_from_disk(dir_Combine,"NewCsfFiles","csf_MaBoundary_clean");
			System.out.println("Exist, skip step3.3 Clean Boundary file from TOADs");// yk add debug
		}else{
			((ParamVolume)boundSpeedClean.getInput().getFirstChildByName("Boundary volume")).setValue(boundary_speed_file);
			((ParamVolume)boundSpeedClean.getInput().getFirstChildByName("ToadsWM volume")).setValue(Toads2_wmmask_refspace_crop_file);
			boundSpeedClean.runAlgorithm(monitor);
			boundary_speed_clean_file = ((ParamVolume)boundSpeedClean.getOutput().getFirstChildByName("Output volume")).getImageData();
			save_intermfile(dir_Combine,"NewCsfFiles",boundary_speed_clean_file,"csf_MaBoundary_clean");
			boundSpeedThin = null;
		}
		
		// step3.4 combine multi-atlas segmentation and TOADS
		ImageData GM_combine,WM_combine,Mask_combine;
		if(DebugFlag.getValue()&&FilesExist(dir_Combine,"UpdatedWMandGM","GM_combine")
				&&FilesExist(dir_Combine,"UpdatedWMandGM","WM_combine")&&FilesExist(dir_Combine,"UpdatedWMandGM","Mask_combine")){
			GM_combine = load_file_from_disk(dir_Combine,"UpdatedWMandGM","GM_combine");
			WM_combine = load_file_from_disk(dir_Combine,"UpdatedWMandGM","WM_combine");
			Mask_combine = load_file_from_disk(dir_Combine,"UpdatedWMandGM","Mask_combine");
			System.out.println("Exist, skip step3.4 combine multi-atlas segmentation and TOADS");// yk add debug
		}else{
			((ParamVolume)combine.getInput().getFirstChildByName("multiatlas_GM volume")).setValue(GM_crop_file);
			((ParamVolume)combine.getInput().getFirstChildByName("multiatlas_WM volume")).setValue(WM_crop_file);
			((ParamVolume)combine.getInput().getFirstChildByName("multiatlas_BrainMask volume")).setValue(BrainMask_crop_file);
			((ParamVolume)combine.getInput().getFirstChildByName("toads_GM volume")).setValue(Toads2_gm_refspace_crop_file);
			((ParamVolume)combine.getInput().getFirstChildByName("toads_WM volume")).setValue(Toads2_wmfill_refspace_crop_file);
			((ParamVolume)combine.getInput().getFirstChildByName("toads_Mask volume")).setValue(Toads2_wmmask_refspace_crop_file);
			combine.runAlgorithm(monitor);
			GM_combine =  ((ParamVolume)combine.getOutput().getFirstChildByName("combined_GM volume")).getImageData();
			WM_combine =  ((ParamVolume)combine.getOutput().getFirstChildByName("combined_WM volume")).getImageData();
			Mask_combine =  ((ParamVolume)combine.getOutput().getFirstChildByName("combined_Mask volume")).getImageData();
			save_intermfile(dir_Combine,"UpdatedWMandGM",GM_combine,"GM_combine");
			save_intermfile(dir_Combine,"UpdatedWMandGM",WM_combine,"WM_combine");
			save_intermfile(dir_Combine,"UpdatedWMandGM",Mask_combine,"Mask_combine");
			combine = null;
		}

		// clean 2
		GM_crop_file.dispose();
		WM_crop_file.dispose();
		BrainMask_crop_file.dispose();
		Toads2_gm_refspace_crop_file.dispose();
		Toads2_wmfill_refspace_crop_file.dispose();
		Toads2_wmmask_refspace_crop_file.dispose();
		WM_file.dispose();
		BrainMask_file.dispose();
		Toads2_gm_refspace.dispose();
		Toads2_wmfill_refspace.dispose();
		Toads2_wmmask_refspace.dispose();

		// step 4 Surface reconstruction
		System.out.println("Start Step 4, Surface reconstruction =======================");
		File dir_Surf= new File(dir + "/SurfRec/");
		if (DebugFlag.getValue()){
			try{
				if(!dir_Surf.isDirectory()){
					(new File(dir_Surf.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}
		//Connectivity rule is reversed for topology correction!
		int bcon=0;
		switch(conn){
		case 0:bcon=1;break;
		case 1:bcon=0;break;
		case 2:bcon=3;break;
		case 3:bcon=2;break;
		}

		// step4.1 Topological Correction
		ImageData Mask_topo;
		if(DebugFlag.getValue()&&FilesExist(dir_Surf,"TopoCorrect","Atlas_WM_corrected")){
			Mask_topo = load_file_from_disk(dir_Surf,"TopoCorrect","Atlas_WM_corrected");
			System.out.println("Exist, skip step4.1 Topological Correction");// yk add debug
		}else{
			((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
			((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(WM_combine);
			((ParamVolume)topoCorrect.getInput().getFirstChildByName("Paint mask")).setValue(Mask_combine);
			topoCorrect.runAlgorithm(monitor);
			Mask_topo = ((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();
			save_intermfile(dir_Surf,"TopoCorrect",Mask_topo,"Atlas_WM_corrected");
			topoCorrect = null;
		}

		// step4.2 ACE
		ImageData Skeleton,Skeleton_thin,GM_ACE_enhanced;
		if(DebugFlag.getValue()&&FilesExist(dir_Surf,"ACE","Atlas_GM_skel")
				&&FilesExist(dir_Surf,"ACE","Atlas_GM_thin")&&FilesExist(dir_Surf,"ACE","Atlas_GM_ace")){
			Skeleton = load_file_from_disk(dir_Surf,"ACE","Atlas_GM_skel");
			Skeleton_thin = load_file_from_disk(dir_Surf,"ACE","Atlas_GM_thin");
			GM_ACE_enhanced = load_file_from_disk(dir_Surf,"ACE","Atlas_GM_ace");
			System.out.println("Exist, skip step4.2 ACE");// yk add debug
		}else{
			((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(GM_combine);
			((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(WM_combine);
			((ParamVolume)ace.getInput().getFirstChildByName("Multi Atlas CSF file")).setValue(boundary_speed_clean_file);
			ace.runAlgorithm(monitor);
			Skeleton = ((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData();
			Skeleton_thin = ((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
			GM_ACE_enhanced = ((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
			save_intermfile(dir_Surf,"ACE",Skeleton,"Atlas_GM_skel");
			save_intermfile(dir_Surf,"ACE",Skeleton_thin,"Atlas_GM_thin");
			save_intermfile(dir_Surf,"ACE",GM_ACE_enhanced,"Atlas_GM_ace");
			ace = null;
		}

		// step4.3 EnhanceGM additional
		ImageData GM_ACE_final,Skeleton_final,Skeleton_thin_final;
		if(DebugFlag.getValue()&&FilesExist(dir_Surf,"ACEenhance","Atlas_GM_skel")
				&&FilesExist(dir_Surf,"ACEenhance","Atlas_GM_thin")&&FilesExist(dir_Surf,"ACEenhance","Atlas_GM_ace")){
			Skeleton_final = load_file_from_disk(dir_Surf,"ACEenhance","Atlas_GM_skel");
			Skeleton_thin_final = load_file_from_disk(dir_Surf,"ACEenhance","Atlas_GM_thin");
			GM_ACE_final = load_file_from_disk(dir_Surf,"ACEenhance","Atlas_GM_ace");
			System.out.println("Exist, skip step4.3 EnhanceGM additional");// yk add debug
		}else{
			if(IfACEenhance.getValue()){
				EnhanceGMadditional enhance_add = new EnhanceGMadditional();
				((ParamVolume)enhance_add.getInput().getFirstChildByName("ACE_GM file")).setValue(GM_combine);
				((ParamVolume)enhance_add.getInput().getFirstChildByName("MA_boundary file")).setValue(boundary_speed_clean_file);
				if(ACEenhanceInput.getIndex()==1){
					((ParamVolume)enhance_add.getInput().getFirstChildByName("ACE_Skeleton from ACE")).setValue(Skeleton);
				}else{
					((ParamVolume)enhance_add.getInput().getFirstChildByName("ACE_Skeleton from ACE")).setValue(Skeleton_thin);
				}
				enhance_add.runAlgorithm(monitor);
				GM_ACE_final = ((ParamVolume)enhance_add.getOutput().getFirstChildByName("Enhanced_GM volume")).getImageData();
				Skeleton_final = ((ParamVolume)enhance_add.getOutput().getFirstChildByName("Enhanced_Skeleton volume")).getImageData();
				Skeleton_thin_final = ((ParamVolume)enhance_add.getOutput().getFirstChildByName("Enhanced_Thin volume")).getImageData();
				enhance_add = null;
			}else{
				GM_ACE_final = GM_ACE_enhanced;
				Skeleton_final = Skeleton;
				Skeleton_thin_final = Skeleton_thin;
			}
			save_intermfile(dir_Surf,"ACEenhance",GM_ACE_final,"Atlas_GM_ace");
			save_intermfile(dir_Surf,"ACEenhance",Skeleton_final,"Atlas_GM_skel");
			save_intermfile(dir_Surf,"ACEenhance",Skeleton_thin_final,"Atlas_GM_thin");
		}

		// step4.4 GVF
		ImageData GM_GVF;
		if(DebugFlag.getValue()&&FilesExist(dir_Surf,"GVF","Atlas_GM_ace_gvf")){
			GM_GVF = load_file_from_disk(dir_Surf,"GVF","Atlas_GM_ace_gvf");
			System.out.println("Exist, skip step4.4 GVF");// yk add debug
		}else{
			((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(GM_ACE_final);
			gvfCentral.runAlgorithm(monitor);
			GM_GVF = ((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData();
			save_intermfile(dir_Surf,"GVF",GM_GVF,"Atlas_GM_ace_gvf");
			gvfCentral = null;
		}
		ImageDataMipav gmvecfield = new ImageDataMipav(GM_GVF);

		// step4.5 TGDM
		ImageData inner_vol,central_vol,outer_vol;
		EmbeddedSurface inner_surf,central_surf,outer_surf;
		if(DebugFlag.getValue()&&FilesExist(dir_Surf,"TGDM","target_image_GMimg_outerSurf")){
			inner_vol = load_file_from_disk(dir_Surf,"TGDM","target_image_GMimg_innerlevelset");
			central_vol = load_file_from_disk(dir_Surf,"TGDM","target_image_GMimg_centrallevelset");
			outer_vol = load_file_from_disk(dir_Surf,"TGDM","target_image_GMimg_outerlevelset");
			System.out.println("Exist, skip step4.4 GVF");// yk add debug
		}else{
			((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
			((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(Mask_topo);
			((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(WM_combine);
			((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(GM_ACE_final);	
			((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(GM_combine);
			((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(Skeleton_thin_final);
			((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(GM_GVF);
			((ParamVolume)tgdm.getInput().getFirstChildByName(("UnCroped GM Image"))).setValue(GM_file);
			tgdm.runAlgorithm(monitor);
			inner_vol = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData();
			central_vol = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData();
			outer_vol = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData();
			inner_surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
			central_surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
			outer_surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
			save_intermfile(dir_Surf,"TGDM",inner_vol,"target_image_GMimg_innerlevelset");
			save_intermfile(dir_Surf,"TGDM",central_vol,"target_image_GMimg_centrallevelset");
			save_intermfile(dir_Surf,"TGDM",outer_vol,"target_image_GMimg_outerlevelset");
			save_intermfile(dir_Surf,"TGDM",inner_surf,"target_image_GMimg_innerSurf");
			save_intermfile(dir_Surf,"TGDM",central_surf,"target_image_GMimg_centralSurf");
			save_intermfile(dir_Surf,"TGDM",outer_surf,"target_image_GMimg_outerSurf");
			tgdm = null;
		}
			
			// step 5 Final Output
			System.out.println("Start Step 5, Generate Final Volumes and Surface in origin space =======================");
			File dir_Final= new File(dir + "/FinalVolandSurf/");
			if (DebugFlag.getValue()){
				try{
					if(!dir_Final.isDirectory()){
						(new File(dir_Final.getCanonicalPath())).mkdir();
					}
				}catch(IOException e){ e.printStackTrace(); }
			}
			
			//step5.1 invcrop based on GM
			ImageData inner_vol_invcrop,central_vol_invcrop,outer_vol_invcrop;
			if(DebugFlag.getValue()&&FilesExist(dir_Final,"Final_LevelsetVol","inner_vol_final")
					&&FilesExist(dir_Final,"Final_LevelsetVol","central_vol_final")
					&&FilesExist(dir_Final,"Final_LevelsetVol","outer_vol_final")){
				inner_vol_invcrop = load_file_from_disk(dir_Final,"Final_LevelsetVol","inner_vol_final");
				central_vol_invcrop = load_file_from_disk(dir_Final,"Final_LevelsetVol","central_vol_final");
				outer_vol_invcrop = load_file_from_disk(dir_Final,"Final_LevelsetVol","outer_vol_final");
			    System.out.println("Exist, skip step5.1. get final vol by invcrop based on GM");// yk add debug
			}else{	
				((ParamVolume)invcrop.getInput().getFirstChildByName("GM volume")).setValue(GM_file);
				((ParamVolume)invcrop.getInput().getFirstChildByName("Target volume")).setValue(inner_vol);
				invcrop.runAlgorithm(monitor);
				inner_vol_invcrop = ((ParamVolume)invcrop.getOutput().getFirstChildByName("unCropped target")).getImageData();
				((ParamVolume)invcrop.getInput().getFirstChildByName("Target volume")).setValue(central_vol);
				invcrop.runAlgorithm(monitor);
				central_vol_invcrop = ((ParamVolume)invcrop.getOutput().getFirstChildByName("unCropped target")).getImageData();
				((ParamVolume)invcrop.getInput().getFirstChildByName("Target volume")).setValue(outer_vol);
				invcrop.runAlgorithm(monitor);
				outer_vol_invcrop = ((ParamVolume)invcrop.getOutput().getFirstChildByName("unCropped target")).getImageData();
				save_intermfile(dir_Final,"Final_LevelsetVol",inner_vol_invcrop,"inner_vol_final");	
				save_intermfile(dir_Final,"Final_LevelsetVol",central_vol_invcrop,"central_vol_final");		
				save_intermfile(dir_Final,"Final_LevelsetVol",outer_vol_invcrop,"outer_vol_final");
				invcrop = null;
			}
			
			//step 5.2 generate final surfaces in original space
			EmbeddedSurface inner_surf_origspace,central_surf_origspace,outer_surf_origspace;
			if(DebugFlag.getValue()&&FilesExist(dir_Final,"Final_Surfaces","inner_surface_final")
					&&FilesExist(dir_Final,"Final_Surfaces","central_surface_final")
					&&FilesExist(dir_Final,"Final_Surfaces","outer_surface_final")){
			    System.out.println("Exist, skip step5.2 Congratulations! all surfaces have been generated!");// yk add debug
			}else{	
				((ParamVolume)genmesh.getInput().getFirstChildByName("levelset file")).setValue(inner_vol_invcrop);
				genmesh.runAlgorithm(monitor);
				inner_surf_origspace = ((ParamSurface)genmesh.getOutput().getFirstChildByName("OutputVtk file")).getSurface();
				((ParamVolume)genmesh.getInput().getFirstChildByName("levelset file")).setValue(central_vol_invcrop);
				genmesh.runAlgorithm(monitor);
				central_surf_origspace = ((ParamSurface)genmesh.getOutput().getFirstChildByName("OutputVtk file")).getSurface();
				((ParamVolume)genmesh.getInput().getFirstChildByName("levelset file")).setValue(outer_vol_invcrop);
				genmesh.runAlgorithm(monitor);
				outer_surf_origspace = ((ParamSurface)genmesh.getOutput().getFirstChildByName("OutputVtk file")).getSurface();
				save_intermfile(dir_Final,"Final_Surfaces",inner_surf_origspace,"inner_surface_final");
				save_intermfile(dir_Final,"Final_Surfaces",central_surf_origspace,"central_surface_final");
				save_intermfile(dir_Final,"Final_Surfaces",outer_surf_origspace,"outer_surface_final");
				genmesh = null;
			}
	}

	public ImageData load_file_from_disk(File dir,String IntermediateFolderName,String NewOutputName){
		String file_str = dir + "/"+IntermediateFolderName+"/"+NewOutputName+".nii.gz";
		File file_file = new File(file_str);
		ImageData Data = vrw.read(file_file);
		return Data;
	}

	public boolean FilesExist(File dir,String IntermediateFolderName,String NewOutputName){	
		String file_output_str = dir + "/"+IntermediateFolderName+"/"+NewOutputName+".nii.gz";
		File f = new File(file_output_str);
		return f.exists();
	}


	public void save_intermfile(File dir,String IntermediateFolderName,
			ImageData OutputImg,String NewOutputName){
		//cortical seperation folder
		String dir_output_str = dir + "/"+IntermediateFolderName+"/";
		File dir_output= new File(dir_output_str);
		if(DebugFlag.getValue()){
			try{
				if(!dir_output.isDirectory()){
					(new File(dir_output.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}
		if(DebugFlag.getValue()){		
			System.out.println("NewOutputName: "+NewOutputName);// yk add debug
			OutputImg.setName(NewOutputName);
			ykdebug.setValue(vrw.write(OutputImg, dir_output));
		}
	}

	public void save_intermfile(File dir,String IntermediateFolderName,
			EmbeddedSurface OutputSurf,String NewOutputName){
		//cortical seperation folder
		String dir_output_str = dir + "/"+IntermediateFolderName+"/";
		File dir_output= new File(dir_output_str);
		if(DebugFlag.getValue()){
			try{
				if(!dir_output.isDirectory()){
					(new File(dir_output.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}
		if(DebugFlag.getValue()){		
			System.out.println("NewOutputName: "+NewOutputName);// yk add debug
			OutputSurf.setName(NewOutputName);
			ykdebug.setValue(srw.write(OutputSurf, dir_output));
		}
	}



}