package edu.vanderbilt.masi.plugins.CRUISE.ace;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.image.*;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.ace.AnatomicallyConsistentEnhancement;
import edu.vanderbilt.masi.algorithms.CRUISE.ace.MaAnatomicallyConsistentEnhance;

/**
 * @author Yuankai Huo 
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0.0 *
 *Based on Anatomically Consistent Enhancement Algorithm by Blake Lucas in CRUISE
 *add the improved CSF file 
 */


public class MaACE extends ProcessingAlgorithm {
	/**
	 * Gray Matter Input
	 */
	private ParamVolume gmVol;

	/**
	 * White Matter Input
	 */
	private ParamVolume wmVol;
	
	/**
	 * Multi Atlas CSF Input
	 */
	private ParamVolume mAcsfVol;
//	private ParamVolume mAcsfDifusedVol;
//	private ParamVolume mAcsfGaussianVol;

	/**
	 * if generate intermediate files
	 */
	private ParamBoolean IfGenerateIntermediate;
	
	/**
	 * Gaussian Smooth alpha = 1.4/sigma, default 1.8
	 */
	private ParamDouble guassianAlpha;
	
	/**
	 * if use Multi Atlas CSf
	 */
//	private ParamBoolean IfUseMAcsf,IfUseMAdiffusedcsf,IfUseMAGaussiancsf;

	/**
	 * IfUseMAcsf: add csf before diffusion
	 * IfUseMAdiffusedcsf: add csf after diffusion
	 * Intensity Threshold
	 */
	private ParamDouble thresh;

	/**
	 * Thinned Gray Matter (BOOLEAN)
	 */
	private ParamVolume thinSkelVol;

	/**
	 * Thinned CSF (BOOLEAN)
	 */
	private ParamVolume skelVol;

	/**
	 * Thinned Gray Matter (UBYTE)
	 */
	private ParamVolume aceGmVol;

	/**
	 * Exceute ACE Algorithm
	 */
	
	private ParamOption placeToAddCSF,ReplaceMethod;
	
	protected void execute(CalculationMonitor monitor) {

				
		MaAnatomicallyConsistentEnhance ace = new MaAnatomicallyConsistentEnhance();
		monitor.observe(ace);
		String gmname=gmVol.getImageData().getName();
		
		File dir = new File(this.getOutputDirectory()+File.separator+"ACEintermediate");
		
		ImageData mAcsf,mAcsfDiffused,mAcsfGaussian;
		//		
		mAcsf = mAcsfVol.getImageData();
//		mAcsfDiffused = mAcsfDifusedVol.getImageData();
//		mAcsfGaussian = mAcsfGaussianVol.getImageData();
		
		if ((placeToAddCSF.getIndex()>0)&&(mAcsf==null)){
			System.out.println("Error: Please choose the new csf file once!");
			System.exit(0); // ???	
		}
		
		ace.solve(wmVol.getImageData(), gmVol.getImageData(), thresh.getValue()
				.doubleValue(),dir,mAcsf,placeToAddCSF.getIndex(),ReplaceMethod.getIndex(),
				guassianAlpha.getValue().doubleValue(),IfGenerateIntermediate.getValue());

		
		ImageData aceGm = ace.getEnhancedGM();
		ImageData skel = ace.getSkeleton();
		ImageData thinSkel = ace.getThinnedSkeleton();
			
		
		aceGm.setName(gmname + "_ace");
		thinSkel.setName(gmname+ "_thin");
		skel.setName(gmname + "_skel");

		aceGmVol.setValue(aceGm);
		thinSkelVol.setValue(thinSkel);
		skelVol.setValue(skel);

	}


	private static final String revnum = AnatomicallyConsistentEnhancement.getVersion();

	/**
	 * Create input parameters for ACE: gray matter,white matter and intensity
	 * threshold
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		gmVol = new ParamVolume(VoxelType.FLOAT);
		gmVol.setName("Gray Matter");
		gmVol.setDescription("Gray Matter volume must be of Float type.");
		wmVol = new ParamVolume(VoxelType.FLOAT);
		wmVol.setName("White Matter");
		wmVol.setDescription("White Matter volume must be of Float type.");
		
		mAcsfVol = new ParamVolume(VoxelType.FLOAT);
		mAcsfVol.setName("Multi Atlas CSF file");
		mAcsfVol.setDescription("CSF volume must be of Float type.");
		mAcsfVol.setMandatory(false);
		
//		mAcsfDifusedVol = new ParamVolume(VoxelType.FLOAT);
//		mAcsfDifusedVol.setName("Diffused Multi Atlas CSF file");
//		mAcsfDifusedVol.setDescription("CSF volume must be of Float type.");
//		mAcsfDifusedVol.setMandatory(false);
//		
//		mAcsfGaussianVol = new ParamVolume(VoxelType.FLOAT);
//		mAcsfGaussianVol.setName("Gaussian Multi Atlas CSF file");
//		mAcsfGaussianVol.setDescription("CSF volume must be of Float type.");
//		mAcsfGaussianVol.setMandatory(false);
		
//		IfUseMAcsf = new ParamBoolean("Use Multi Atlas CSF file before diffusion", false);
//		IfUseMAdiffusedcsf = new ParamBoolean("Employ Multi Atlas CSF file after diffusion", false);
//		IfUseMAGaussiancsf = new ParamBoolean("Based on Multi Atlas CSF file after Gaussian", false);
		
		placeToAddCSF = new ParamOption("The place to add the Ma boundary speed function", 
				new String[] {"None","BeforeDiffuse", "AfterDiffuse", "AfterGaussian"});
		placeToAddCSF.setValue("None");
		
		ReplaceMethod = new ParamOption("Merge or totally replace the old speed function", 
				new String[] {"Merge","Replace"});
		ReplaceMethod.setValue("Merge");
		
		IfGenerateIntermediate = new ParamBoolean("Intermediate files", false);
		
		
		thresh = new ParamDouble(0, 255);
		thresh.setName("Intensity Threshold");
		thresh.setValue(126.9);
		
		guassianAlpha = new ParamDouble(0, 10);
		guassianAlpha.setName("Alpha Guassian Smooth");
		guassianAlpha.setValue(1.8);
		
		
//		inputParams.setLabel("Gray Matter Enhance");
		inputParams.setName("ace");
		inputParams.setLabel("Gray Matter Enhance");
//		inputParams.setName("ace");mAcsfVol.getImageData()
		inputParams.add(gmVol);
		inputParams.add(wmVol);
		inputParams.add(thresh);
		inputParams.add(guassianAlpha);
		inputParams.add(mAcsfVol);
//		inputParams.add(mAcsfDifusedVol);
//		inputParams.add(mAcsfGaussianVol);
//		inputParams.add(IfUseMAcsf);
//		inputParams.add(IfUseMAdiffusedcsf);
//		inputParams.add(IfUseMAGaussiancsf);
		inputParams.add(placeToAddCSF);
		inputParams.add(ReplaceMethod);
		inputParams.add(IfGenerateIntermediate);

		inputParams.setPackage("IACL");
		inputParams.setCategory("Multi Atlas CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(ReferencedPapers.ace);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Anatomically Consistent Enhancement. It takes the GM membership and enhances deep sulcal CSF.");
		info.setLongDescription("ACE takes GM and WM memberships. Sometimes sulcal CSF is blurred by partial volume effect, because the thickness of CSF is often quite small. ACE tries to undo the partial volume effect and creates thin CSF to reveal sulcal banks.");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.setAdditionalDocURL("edu/jhu/ece/iacl/plugins/segmentation/cruise/MedicAlgorithmAnatomicallyConsistentEnhance/index.html");
	}

	/**
	 * Create output parameter for ACE: enhanced gray matter, thinned csf,
	 * thinned gray matter
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
//		aceGmVol = new ParamVolume(VoxelType.FLOAT);
		aceGmVol = new ParamVolume(VoxelType.FLOAT,-1,-1,-1,1);
		aceGmVol.setName("Enhanced GM");
//		skelVol = new ParamVolume(VoxelType.INT);
		skelVol = new ParamVolume(VoxelType.INT,-1,-1,-1,1);
		skelVol.setName("Skeleton");
//		thinSkelVol = new ParamVolume(VoxelType.UBYTE);
//		thinSkelVol = new ParamVolume(VoxelType.INT);
		thinSkelVol = new ParamVolume(VoxelType.INT,-1,-1,-1,1);
		thinSkelVol.setName("Thinned Skeleton");
		outputParams.setName("ace");
		outputParams.setLabel("ACE");
		outputParams.add(aceGmVol);
		outputParams.add(skelVol);
		outputParams.add(thinSkelVol);
	}

}
