package edu.vanderbilt.masi.plugins.CRUISE.tgdm.GAC;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.algorithms.ace.AnisotropicDiffusion;
import edu.jhu.ece.iacl.algorithms.gvf.Gradient3d;
import edu.jhu.ece.iacl.algorithms.tgdm.GenericTGDM;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

public class GeodesicActiveContours extends ProcessingAlgorithm  {

	private ParamVolume wmVol;
	private ParamVolume centralVol;
	private ParamVolume innerVol;
	private ParamVolume T1Vol;
	
	private ParamSurface innerSurf;
	private ParamVolume shrinkCentralVol,Point1InnerVol;

	private ParamOption connectivity;
	
	 private ParamDouble initIsoLevel;
	 

	private ParamInteger innerIterations;

	private ParamDouble innerCurvatureForce, innerExternalForce,
	innerPressureForce;
	private ParamDouble centralCurvatureForce, centralExternalForce,
	centralPressureForce;

	private ParamDouble isoWmInit, isoWmFinal;
	
	private ParamBoolean IfGenerateIntermediate;


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		// TODO Auto-generated method stub
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Geodesic Active Contours");
		inputParams.setName("Geodesic_Active_Contours");

        wmVol = new ParamVolume("White Matter Membership",VoxelType.FLOAT);
		centralVol=new ParamVolume("Central Levelset");
		T1Vol=new ParamVolume("T1 image after N3 correct");
		
		connectivity = new ParamOption("Connectivity (Foreground,Background)", new String[] {
				"(18,6)", "(6,18)", "(26,6)", "(6,26)" });
		connectivity.setValue(0);
		
        initIsoLevel = new ParamDouble("Initial Iso Level",126.9);

		innerCurvatureForce = new ParamDouble("Inner Surface Curvature Force", 0, 10, 0.2);
		innerPressureForce = new ParamDouble("Inner Surface Pressure Force", 0, 10, 1);
		innerExternalForce = new ParamDouble("Inner Surface External Force", 0, 10, 0);
		innerIterations = new ParamInteger("Iterations for Inner Surface", 0, 1000, 4);
		
		centralCurvatureForce = new ParamDouble("Central Surface Curvature Force", 0, 10, 0.15);
		
        isoWmFinal = new ParamDouble("FinalWhite Matter Iso Level",0, 1, 0.6); // yk modified from 0.6 for multiatlas
        isoWmInit = new ParamDouble("InitWhite Matter Iso Level",0, 1, 0.1); // yk modified from 0.6 for multiatlas

        
        IfGenerateIntermediate = new ParamBoolean("Intermediate files", false);
        
        shrinkCentralVol = new ParamVolume("Shrink Central Surface");
        shrinkCentralVol.setMandatory(false);
        
        Point1InnerVol = new ParamVolume("Point1 Inner Surface");
        Point1InnerVol.setMandatory(false);
        
        inputParams.add(wmVol);
		inputParams.add(centralVol);
//		inputParams.add(innerVol);
		inputParams.add(T1Vol);
		inputParams.add(connectivity);
		inputParams.add(initIsoLevel);
		inputParams.add(innerCurvatureForce);
		inputParams.add(innerPressureForce);
		inputParams.add(innerExternalForce);
		inputParams.add(innerIterations);
		inputParams.add(centralCurvatureForce);
		inputParams.add(isoWmInit);
		inputParams.add(isoWmFinal);
		inputParams.add(IfGenerateIntermediate);
		inputParams.add(shrinkCentralVol);
		inputParams.add(Point1InnerVol);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		innerVol = new ParamVolume("OutputInnerVol");
		outputParams.add(innerVol);
		innerSurf = new ParamSurface("OutputInnerSurface");
		outputParams.add(innerSurf);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		int conn = 0;
		switch (connectivity.getIndex()) {
		case 0:
			conn = ConnectivityRule.CONNECT_18_6;
			break;
		case 1:
			conn = ConnectivityRule.CONNECT_6_18;
			break;
		case 2:
			conn = ConnectivityRule.CONNECT_26_6;
			break;
		case 3:
			conn = ConnectivityRule.CONNECT_6_26;
			break;
		default:
			break;
		}
		
		final ImageDataReaderWriter vrw = ImageDataReaderWriter.getInstance();
		
		File dir = new File(this.getOutputDirectory()+File.separator+"GACintermediate");
		if (IfGenerateIntermediate.getValue()) {
			try{
				if(!dir.isDirectory()){
					(new File(dir.getCanonicalPath())).mkdir();
				}
			}catch(IOException e){ e.printStackTrace(); }
		}
		
		ImageDataFloat inner,central,P1inner,T1, T1blur, T1g;
		ImageDataFloat central_shrink;

//		GenericTGDM tgdm = new GenericTGDM(conn);
		MaGenericTGDMGAC tgdmGAC = new MaGenericTGDMGAC(conn);
		central = new ImageDataFloat(centralVol.getImageData());
//		inner = new ImageDataFloat(innerVol.getImageData());
		T1 = new ImageDataFloat(T1Vol.getImageData());
		
		//gaussian blur
//		AnisotropicDiffusion diffusion = new AnisotropicDiffusion();
		T1blur = AnisotropicDiffusion.GaussianBlur(T1, 1.8f);
		if (IfGenerateIntermediate.getValue()){
			T1blur.setName("01_GaussianBlurT1");
			T1blur.setHeader(central.getHeader());
			vrw.write(T1blur,dir);	
		}
			
		//gradient
//		Gradient3d gradientGAC = new Gradient3d();
		T1g = Gradient3d.doSolve(T1blur);
		if (IfGenerateIntermediate.getValue()){
			T1g.setName("02_GradientT1");
			T1g.setHeader(central.getHeader());
			vrw.write(T1g,dir);	
		}
		
		float isomemInit = isoWmInit.getFloat();
		float isomemFinal = isoWmFinal.getFloat();
		
		ImageData central_shrink_tmp = shrinkCentralVol.getImageData();
//		central_shrink = new ImageDataFloat();
		if (central_shrink_tmp == null) {
		central_shrink = tgdmGAC.solveInnerSurfaceFromCentral(central, null, null
				, null, centralCurvatureForce.getFloat(),
				0, -1.0f, initIsoLevel.getFloat(), isomemInit,1);}
		else{
			central_shrink = new ImageDataFloat(central_shrink_tmp);
		}
		
		System.out.println("centralCurvatureForce centralCurvatureForce is"+centralCurvatureForce.getFloat());// yk add debug
		System.out.println("initIsoLevel initIsoLevel"+initIsoLevel.getFloat());// yk add debug
		System.out.println("isomem isomem is"+isomemInit);// yk add debug
		
		if (IfGenerateIntermediate.getValue()){
			central_shrink.setName("03_CentralShrink");
			central_shrink.setHeader(central.getHeader());
			vrw.write(central_shrink,dir);	
		}
		
		//iso level at WM iso level 0.1
		ImageData point1_inner_tmp = Point1InnerVol.getImageData();
//		central_shrink = new ImageDataFloat();
		if (point1_inner_tmp == null) {
		
		P1inner = tgdmGAC.solveInnerSurfaceFromCentral(central_shrink, null, wmVol
				.getImageData(), null, innerCurvatureForce.getFloat(),
				innerExternalForce.getFloat(), -innerPressureForce
				.getFloat(), initIsoLevel.getFloat(), isomemInit,
				innerIterations.getInt());
		}
		else{
			P1inner = new ImageDataFloat(point1_inner_tmp);
		}
		
		if (IfGenerateIntermediate.getValue()){
			P1inner.setName("04_IntiInnerLevel");
			P1inner.setHeader(central.getHeader());
			vrw.write(P1inner,dir);	
		} 		
		
		//recompute inner surface using Geodesic Active Contour
		inner = tgdmGAC.solveInnerSurfaceFromCentralGAC(P1inner, null, wmVol
				.getImageData(), null, innerCurvatureForce.getFloat(),
				innerExternalForce.getFloat(), -innerPressureForce
				.getFloat(), initIsoLevel.getFloat(), isomemFinal,
				innerIterations.getInt(),T1g);
		

        EmbeddedSurface surf = tgdmGAC.getFinalSurface();
        // MedicUtil.displayMessage("Center of mass = "+surf.getCenterOfMass()+", name="+name+"_InnerSurf\n");
        
        inner.setName("InnerVol");
        innerVol.setValue(inner);  //yk modified from central_shrink 05/29/2015 
        innerVol.getImageData().setHeader(central.getHeader());
        
        surf.setName("InnerSurf");
        innerSurf.setValue(surf);
 		
		
	}

}
