package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamNumberCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Separate Multi_atlas segmentation to GM,WM,WholeBrian
 *
 */

public class CorticalSeperation extends ProcessingAlgorithm{

	private ParamVolume InputVol;
	private ParamVolume GMVol,WMVol,WMmaskVol,WholeBrainVol;
	//	ParamNumberCollection OverlookLabels;
	private ParamString GMLabels,WMLabels,GMorWMLabels;


	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Conduct imerode like MATLAB" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Cortical Seperation");
		inputParams.setName("CorticalSeperation");

		// input multi-atlas segmentation
		InputVol=new ParamVolume("MaSeg volume");

		GMLabels = new ParamString("GM fill","100,101,102,103,104,105,106,107,108,"+
				"109,112,113,114,115,116,117,118,119,120,121,122,123,124,125,128,129,"+
				"132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,"+
				"149,150,151,152,153,154,155,156,157,160,161,162,163,164,165,166,167,"+
				"168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,"+
				"185,186,187,190,191,192,193,194,195,196,197,198,199,200,201,202,203,"+
				"204,205,206,207");

		WMLabels = new ParamString("WM fill","4,23,30,36,37,44,45,51,52,55,56,57,58,59,"+
				"60,61,62");

		GMorWMLabels = new ParamString("GMorWM fill","75,76,47,48,31,32,49,50");

		inputParams.add(InputVol);
		inputParams.add(GMLabels);
		inputParams.add(WMLabels);
		inputParams.add(GMorWMLabels);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		GMVol = new ParamVolume("GMVol volume");
		outputParams.add(GMVol);
		WMVol = new ParamVolume("WMVol volume");
		outputParams.add(WMVol);
		WMmaskVol = new ParamVolume("WMmaskVol volume");
		outputParams.add(WMmaskVol);
		WholeBrainVol = new ParamVolume("WholeBrainVol volume");
		outputParams.add(WholeBrainVol);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

		ImageDataInt GM,WM,WholeBrain,WMmask;
		ParamString WholeBrainLabels = null;

		ImageDataInt MaSeg = new ImageDataInt(InputVol.getImageData());
		int rows = MaSeg.getRows();
		int cols = MaSeg.getCols();
		int slices = MaSeg.getSlices();

		//initial output
		GM = new ImageDataInt(rows, cols, slices);
		WM = new ImageDataInt(rows, cols, slices);
		WholeBrain = new ImageDataInt(rows, cols, slices);
		WMmask = new ImageDataInt(rows, cols, slices);
		
		String WholeBrainString = GMLabels.getValue()+","+
		WMLabels.getValue()+","+GMorWMLabels.getValue();
		
		WholeBrainLabels = new ParamString("WholeBrain fill",WholeBrainString);
		

		//get tissue maps
		GM = GetBinaryImage(MaSeg,GM,GMLabels);
		WM = GetBinaryImage(MaSeg,WM,WMLabels);
		WMmask = GetBinaryImage(MaSeg,WMmask,WMLabels);
		WholeBrain = GetBinaryImage(MaSeg,WholeBrain,WholeBrainLabels);
		
		//set output
		GM.setName("Atlas_GM");
		GMVol.setValue(GM);
		GMVol.getImageData().setHeader(MaSeg.getHeader());
		WM.setName("Atlas_WM");
		WMVol.setValue(WM);
		WMVol.getImageData().setHeader(MaSeg.getHeader());
		WMmask.setName("Atlas_Mask");
		WMmaskVol.setValue(WMmask);
		WMmaskVol.getImageData().setHeader(MaSeg.getHeader());
		WholeBrain.setName("Atlas_BrainTissueMask");
		WholeBrainVol.setValue(WholeBrain);
		WholeBrainVol.getImageData().setHeader(MaSeg.getHeader());

	}

	public ImageDataInt GetBinaryImage(ImageDataInt MaSeg,ImageDataInt Tissue,ParamString Label){
		int i,j,k;
		int rows = MaSeg.getRows();
		int cols = MaSeg.getCols();
		int slices = MaSeg.getSlices();

		// get removable labels
		String LabelString = Label.getValue();
		String[] LabelStrings = LabelString.split(",");
		//		int[] RemoveLabels = new int[RemoveStrings.length];
		List<Integer> LabelList = new ArrayList<Integer>();
		for (int ii = 0; ii < LabelStrings.length; ii++) {
			try {
				LabelList.add(Integer.parseInt(LabelStrings[ii]));
			} catch (NumberFormatException nfe) {};
		}

		for (i = 0; i < rows; i++) {
			for (j = 0; j < cols; j++) {
				for (k = 0; k < slices; k++) {
					if(LabelList.contains(MaSeg.getInt(i, j, k))){
						Tissue.set(i, j, k, (int) 1);
					}else{
						Tissue.set(i, j, k, (int) 0);
					}
				}
			}
		}
		return Tissue;
	}

}
