package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Crop other images based on GM
 *
 */

public class CropBasedOnGM extends ProcessingAlgorithm{
	
	private ParamVolume GMdata,GMdataCrop;
	private ParamVolume Targetdata,TargetdataCrop;
	private ParamInteger CropEdge;
//	private ParamSurface VTKsurfParam;
//	private ParamSurface ASCsurfParam;
	
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Crop other images based on GM" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Crop by GM");
		inputParams.setName("Crop_by_GM");
		
		GMdata=new ParamVolume("GM volume");		
		Targetdata=new ParamVolume("Target volume");		
		CropEdge = new ParamInteger(0, 20);
		CropEdge.setName("Boarder value");
		CropEdge.setValue(5);
		
		inputParams.add(GMdata);
		inputParams.add(Targetdata);
		inputParams.add(CropEdge);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		GMdataCrop = new ParamVolume("Cropped GM");
		outputParams.add(GMdataCrop);
		TargetdataCrop = new ParamVolume("Cropped target");
		outputParams.add(TargetdataCrop);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		CubicVolumeCropper cropper = new CubicVolumeCropper();	
		
		ImageData gm = GMdata.getImageData();
		ImageData target = Targetdata.getImageData();
		
		gm = cropper.crop(gm, 0, CropEdge.getInt()); //enlarge (crop) the image by 5 voxels
		GMdataCrop.setValue(gm);
		
		CropParameters crops = cropper.getLastCropParams();
		target = cropper.crop(target, crops);
		TargetdataCrop.setValue(target);
		
//		ParamFile ykdebug = new ParamVolume("yk debug");
////		surf = innerSurf.getSurface();
////		surf.translate(offset);
//		surf.setName(name);
//		ykdebug.setValue(frw.write(surf, dir));
		
	}

}
