package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.jist.io.VertexFloatXmlReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ClosestPointThicknessForInner;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *calculate the distance from points in xml files to a surface
 *
 */

public class DistanceFromVertexFloatXml extends ProcessingAlgorithm{

	private ParamFileCollection xmlInputFiles;
	private ParamSurface SurfaceInputVTK; 


	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Calculate the distance from points in xml files to a surface" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Get Distance XML");
		inputParams.setName("Get_Distance_XML");		

		xmlInputFiles = new ParamFileCollection("xmlFile which saves surface landmarks");
		SurfaceInputVTK = new ParamSurface("mesh in VTK");


		inputParams.add(xmlInputFiles);
		inputParams.add(SurfaceInputVTK);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		//		ThinSkeleton = new ParamVolume("Thin Skeleton");
		//		GMclean = new ParamVolume("GM clean");
		//		Skeletonclean = new ParamVolume("Skeleton Skeleton");
		//		outputParams.add(ThinSkeleton);
		//		outputParams.add(GMclean);
		//		outputParams.add(Skeletonclean);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

		int filesize = xmlInputFiles.size();
		int i,j;
		int pointsize;
		Point3f pt = null;
		double distance = 0;

		EmbeddedSurface MeshSurf = SurfaceInputVTK.getSurface();
		System.out.println("mesh file is "+MeshSurf.getName());
		
		//output dir
		File dir = new File(this.getOutputDirectory()+File.separator+"OutputTxt");
		System.out.println("output dir is "+dir.getAbsolutePath());
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }

		// output file name
		String filename= (dir.getAbsolutePath()+File.separator+MeshSurf.getName()+".txt");
		System.out.println("output file is "+filename);
		File filenamedel = new File(filename);
		filenamedel.delete();
		FileWriter fw = null;
		
		//get distance map
		ClosestPointThicknessForInner solver = new ClosestPointThicknessForInner();
		monitor.observe(solver);
		SurfaceIntersector distancemap = solver.solve(MeshSurf);

		for (i=0;i<filesize;i++){
			File xmlFile = xmlInputFiles.getValue(i);		
			VertexFloatXmlReaderWriter xrw = new VertexFloatXmlReaderWriter();
			Point3f[] xmlPoints = xrw.read(xmlFile);
			System.out.println("working on ["+(i+1)+"/"+filesize+"]"+xmlFile.getName());
			
			try {
				fw = new FileWriter(filename,true);
				fw.write(xmlFile.getName()+"\n");
				fw.write("x,y,z,distance\n");
				fw.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}//appends the string to the file

			pointsize = xmlPoints.length;

			for (j=0;j<pointsize;j++){
				pt = xmlPoints[j];	
				distance = distancemap.distance(pt);

				try {
					fw = new FileWriter(filename,true);
					fw.write(pt.x+", "+pt.x+", "+pt.x+", "+distance+"\n");
					fw.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}//appends the string to the file
			}
			
			try {
				fw = new FileWriter(filename,true);
				fw.write("**********************************************************************\n");
				fw.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}//appends the string to the file
			
		}
	}

}
