package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ThicknessSolverLevelset;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.thickness.ClosestPointThickness;
import edu.jhu.ece.iacl.algorithms.thickness.OrthoProjectionThickness;
import edu.jhu.ece.iacl.algorithms.thickness.HybridLagrangianEmbedding;
import edu.jhu.ece.iacl.algorithms.thickness.RobustInterSurfaceConformalMapEuler;
import edu.jhu.ece.iacl.algorithms.thickness.RobustLagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.ThicknessSolver;
import edu.jhu.ece.iacl.algorithms.thickness.EulerThickness;
import edu.jhu.ece.iacl.algorithms.thickness.EulerLagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.SimpleLagrangianEmbedding;
import edu.jhu.ece.iacl.algorithms.thickness.LagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.LevelSetThickness;
import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.io.*;
public class GetThicknessLevelSet extends ProcessingAlgorithm{
	ParamVolume innerVol;
	ParamVolume centralVol;
	ParamVolume outerVol;
	ParamOption algorithm;
	ParamVolume fieldVol;
	ParamVolume thickVol;
	ParamVolume levelVol;
	ParamSurface innerMesh;
	ParamSurface centralMesh;
	ParamSurface outerMesh;
	ParamSurface innerMeshOut;
	ParamSurface centralMeshOut;
	ParamSurface outerMeshOut;
	ParamDouble stepSize;
	ParamDouble isoVal;
	ParamDouble lambda;

	ParamDouble mean;
	ParamDouble stdev;
	
	ParamDouble meanInner;
	ParamDouble stdevInner;
	ParamDouble meanOuter;
	ParamDouble stdevOuter;
	ParamDouble min;
	ParamDouble max;
	ParamObject<CurveCollection> streamlines;
	ParamObject<EmbeddedGrid> grid;
	private static final int MAX_SURFS=10;
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(innerVol=new ParamVolume("Inner Level Set"));
		inputParams.add(outerVol=new ParamVolume("Outer Level Set"));
		inputParams.add(innerMesh=new ParamSurface("InnerMesh Surface"));
		inputParams.add(outerMesh=new ParamSurface("OuterMesh Surface"));
		
		// inputParams.add(algorithm=new ParamOption("Approximation Method", new String[]{"Level Set Subtraction", "Euler-Lagrange", "Euler", "Lagrange", "Closest Point", "Orthogonal Projection", "Robust Inter-Surface Conformal Map", "Robust Lagrange", "Eulerian Lagrangian-Embedding", "Hybrid Lagrangian-Embedding"}));
		inputParams.add(algorithm=new ParamOption("Approximation Method", new String[]{"Level Set Subtraction"}));

		inputParams.add(isoVal=new ParamDouble("Iso Value",-255.0,255.0));
		inputParams.add(lambda=new ParamDouble("Lambda",0,5,1));

		inputParams.add(stepSize=new ParamDouble("Lagrange Step Size",0,100,0.25));
		inputParams.setLabel("Thickness");
		inputParams.setName("Thickness");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Surface");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Using two level set functions (usually inner surface and outer surface levelset), the module generates a thickness volume and statistics on the thickness. The inner and outer level sets can be obtained from NestedTGDM module.");
		info.setLongDescription("The surfaces generated by this method are not the same as the ones generated by CRUISE, they are slightly smoother. CRUISE will perturb vertices closer than 0.1 of a voxel close to a grid point to 0.1 away from that grid point, which greatly affects the precision of thickness measurements. Instead, this method perturbs the surface by only 0.01 voxel. Thickness measurements should be made relative to the perturbed level set, instead of the original level set. To toggle between the original CRUISE and the improved method, change the ADJUST_BOUNDARY flag. However, one shouldn't agonize over these differences because the fast-marching method doesn't have great precision. What's important is that thickness measurements are computed in a consistent manner with consistent metrics.");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(thickVol=new ParamVolume("Thickness Volume"));
		outputParams.add(innerMeshOut=new ParamSurface("Inner Mesh Thickness"));
		outputParams.add(outerMeshOut=new ParamSurface("Outer Mesh Thickness"));
//		outputParams.add(levelVol=new ParamVolume("Level Set"));

//		outputParams.add(mean=new ParamDouble("Mean Thickness in Volume"));
//		outputParams.add(stdev=new ParamDouble("Std Dev Thickness in Volume"));
//		outputParams.add(meanInner=new ParamDouble("Mean Thickness on Inner Surf"));
//		outputParams.add(stdevInner=new ParamDouble("Std Dev Thickness on Inner Surf"));
//		outputParams.add(meanOuter=new ParamDouble("Mean Thickness on Outer Surf"));
//		outputParams.add(stdevOuter=new ParamDouble("Std Dev Thickness on Outer Surf"));
//		outputParams.add(min=new ParamDouble("Minimum Thickness"));
//		outputParams.add(max=new ParamDouble("Maximum Thickness"));

//		outputParams.setName("thickness");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ThicknessSolverLevelset solver=null;
		solver = new ThicknessSolverLevelset(lambda.getDouble(),isoVal.getDouble(),stepSize.getDouble());
		
		if(solver!=null){
			monitor.observe(solver);
			solver.setInnerSurface(innerMesh.getSurface());
			solver.setOuterSurface(outerMesh.getSurface());
			solver.solve(innerVol.getImageData(), outerVol.getImageData());

			innerMeshOut.setValue(solver.getInnerSurface());
			outerMeshOut.setValue(solver.getOuterSurface());
			
	//		fieldVol.setValue(solver.getTangetField());
			thickVol.setValue(solver.getThickness());
			thickVol.getImageData().setHeader(innerVol.getImageData().getHeader());
//			levelVol.setValue(solver.getLevelSet());
//			levelVol.getImageData().setHeader(innerVol.getImageData().getHeader());
//			mean.setValue(solver.getMeanThickness());
//			stdev.setValue(solver.getStdevThickness());
//			meanInner.setValue(solver.getMeanInnerThickness());
//			meanOuter.setValue(solver.getMeanOuterThickness());
//			stdevInner.setValue(solver.getStdevInnerThickness());
//			stdevOuter.setValue(solver.getStdevOuterThickness());
//			min.setValue(solver.getMinThickness());
//			max.setValue(solver.getMaxThickness());
/*			
			if(solver instanceof LagrangeThickness){
				CurveCollection collection=((LagrangeThickness)solver).getStreamlines();

				streamlines.setObject(collection);
			}
			if(solver instanceof RobustLagrangeThickness){
				CurveCollection collection=((RobustLagrangeThickness)solver).getStreamlines();

				streamlines.setObject(collection);
			}
			
			if(solver instanceof ExtendedLagrangianEmbedding){
				EmbeddedGrid egrid=((ExtendedLagrangianEmbedding)solver).getGrid();
				grid.setObject(egrid);
				grid.setFileName(innerVol.getValue().getName()+".grid");
			}
*/			
			
		}
	}

}
