package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *transfer the toads cruise space image to original space
 *
 */

public class ImMorphThreeD extends ProcessingAlgorithm{

	private ParamVolume InputVol;
	private ParamVolume OutputVol;
	private ParamOption ErodeMethod;
	//	ParamNumberCollection OverlookLabels;
	private ParamOption MorphMethod;


	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Conduct imerode like MATLAB" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("3D erode");
		inputParams.setName("3D_erode");

		// input multi-atlas segmentation
		InputVol=new ParamVolume("Input volume");

		MorphMethod = new ParamOption("MorphMethod", new String[] {
				"erode", "dilate"});


		// 3D min filter or slice by slice like matlab
		ErodeMethod = new ParamOption("ErodeMethod", new String[] {
				"3D", "3Dmatlab"});
		ErodeMethod.setValue(0);
		ErodeMethod.setMandatory(false);


		inputParams.add(InputVol);
		inputParams.add(MorphMethod);
		inputParams.add(ErodeMethod);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		OutputVol = new ParamVolume("Output volume");
		outputParams.add(OutputVol);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

		ImageData Inputimg = InputVol.getImageData();
		MASImorph morph = new MASImorph(Inputimg);		
		String OutputName = null ;
		// get erode image

		if (MorphMethod.getIndex()==0){  // erode
			if (ErodeMethod.getIndex()==0){
				morph.Minimize3DFilter();
			}else{
				morph.Minimize3DFilterLikeMatlab();
			}
			OutputName = Inputimg.getName()+"_erode";
			
		}else if(MorphMethod.getIndex()==1){ // dilate
			if (ErodeMethod.getIndex()==0){
				morph.Maximum3DFilter();
			}else{
				morph.Maximum3DFilterLikeMatlab();
			}
			OutputName = Inputimg.getName()+"_dilate";
		}
		ImageData Outputimg = morph.GetOutput();

		Outputimg.setName(OutputName);
		Outputimg.setHeader(Inputimg.getHeader());
		OutputVol.setValue(Outputimg);
	}





}
