package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *inverse Crop other images based on GM
 *
 */

public class InverseCropBasedOnGM extends ProcessingAlgorithm{
	
	private ParamVolume GMdata;
	private ParamVolume Targetdata,TargetdataCrop;
	private ParamInteger CropEdge;
	private ParamDouble BackGroudValue;

	
	private static final String cvsversion = "$Revision: 1.5 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Crop other images based on GM" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Inverse Crop by GM");
		inputParams.setName("Inverse_Crop_by_GM");
		
		GMdata=new ParamVolume("GM volume");		
		Targetdata=new ParamVolume("Target volume");	

		CropEdge = new ParamInteger(0, 20);
		CropEdge.setName("Boarder value");
		CropEdge.setValue(5);
		BackGroudValue = new ParamDouble(0, 1000);
		BackGroudValue.setName("Background value");
		BackGroudValue.setValue(20);
		
		inputParams.add(GMdata);
		inputParams.add(Targetdata);
		inputParams.add(CropEdge);
		inputParams.add(BackGroudValue);
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		TargetdataCrop = new ParamVolume("unCropped target");
		outputParams.add(TargetdataCrop);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		CubicVolumeCropper cropper = new CubicVolumeCropper();	

		ImageData gm = GMdata.getImageData();
		ImageData target = Targetdata.getImageData();
		
		int rows = gm.getRows();
		int cols = gm.getCols();
		int slices = gm.getSlices();
		
		int edgewidth = CropEdge.getInt();
		double backgroundvalue = BackGroudValue.getDouble();
		
		gm = cropper.crop(gm, 0, edgewidth); //enlarge (crop) the image by 5 voxels
		CropParameters crops = cropper.getLastCropParams();
		Point3i d = new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off = new Point3i(crops.xmin,crops.ymin,crops.zmin);
		CropParameters uncrop = new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,backgroundvalue);
		
		target = cropper.uncrop(target,uncrop);

		String outputname =  target.getName()+"_invcp";
		target.setName(outputname);
		TargetdataCrop.setValue(target);
		TargetdataCrop.getImageData().setHeader(gm.getHeader());		

	}

}
