package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Interpolation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Resolution;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *transfer the toads cruise space image to original space
 *
 */

public class ToadsCruiseSpaceToOriginalSpace extends ProcessingAlgorithm{
	
	private ParamVolume Targetdata,TargetdataOriSpace;
	private ParamVolume Referencedata;
//	private ParamSurface VTKsurfParam;
//	private ParamSurface ASCsurfParam;
	
	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Transfer the toads cruise space image to original space" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Toads To Original Space");
		inputParams.setName("Toads_To_Original_Space");
		
		Targetdata=new ParamVolume("ToadsCruise volume");	
		Referencedata=new ParamVolume("Reference volume");	
		
		inputParams.add(Targetdata);
		inputParams.add(Referencedata);
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		TargetdataOriSpace = new ParamVolume("ToadsCruise original spaces");
		outputParams.add(TargetdataOriSpace);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		
	
		ImageDataMipav targetimg = new ImageDataMipav(Targetdata.getImageData());
		ImageDataMipav referenceimg = new ImageDataMipav(Referencedata.getImageData());
		
		
		ImageDataMipav image = ReorientVolume.solve(targetimg, referenceimg,
				Resolution.UNCHANGED,
				Interpolation.NEAREST_NEIGHBOR);
		
		String outputname =  Targetdata.getImageData().getName()+"_refspace";
		image.setName(outputname);
		TargetdataOriSpace.setValue(image);
		TargetdataOriSpace.getImageData().setHeader(referenceimg.getHeader());
		

	}

}
