package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.SurfaceFreeSurferIntReadWriter;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 * Transfer the surface .vtk file to FreeSurfer .asc file with Scalar Data
 *
 */




public class VTKtoFreeSurfSurfaceScalar extends ProcessingAlgorithm{
//	private ParamCollection data;
	private ParamSurface VTKsurfParam;
	private ParamSurface ASCsurfParam;
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "A demonstration module with man examples for programmers to help understand the JIST environment.\nAlgorithm Version: " + revnum + "\n";

	private static final SurfaceFreeSurferIntReadWriter frw = SurfaceFreeSurferIntReadWriter.getInstance();
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("VTK to ASC surface");
		inputParams.setName("VTK_to_ASC_surface");
		
			VTKsurfParam=new ParamSurface("VTK scalar surface");
			inputParams.add(VTKsurfParam);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
//		ASCsurfParam = new ParamSurface("ASC scalar surface");
//		outputParams.add(ASCsurfParam);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		EmbeddedSurface surf = VTKsurfParam.getSurface();
		String name = surf.getName();
		
		File dir = new File(this.getOutputDirectory()+File.separator);
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		
		ParamFile ykdebug = new ParamVolume("yk debug");
//		surf = innerSurf.getSurface();
//		surf.translate(offset);
		surf.setName(name);
		ykdebug.setValue(frw.write(surf, dir));
		
	}

}
