package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;

import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.jist.io.*;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.CorrectVolFromThreeSurfaces;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ParcellateInnerAndOuterFromCentral;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Probagate the contral surface labels to outer and inner surface
 *

 */



public class VolumeLabelCorrectionBasedOneThreeSurfaces extends ProcessingAlgorithm{
	ParamVolume segVol;
	ParamVolume ParcelVol;

	ParamSurface ParcellatedInnerMesh,ParcellatedOuterMesh;
	ParamSurface centralMesh,innerMesh,outerMesh;
	ParamDouble stepSize;
	ParamDouble isoVal;
	ParamDouble lambda;

	ParamDouble mean;
	ParamDouble stdev;

	ParamDouble meanInner;
	ParamDouble stdevInner;
	ParamDouble meanOuter;
	ParamDouble stdevOuter;
	ParamDouble min;
	ParamDouble max;
	ParamObject<CurveCollection> streamlines;
	ParamObject<EmbeddedGrid> grid;
	private static final int MAX_SURFS=10;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();




	protected void createInputParameters(ParamCollection inputParams) {
		innerMesh=new ParamSurface("Inner Surface");
		centralMesh=new ParamSurface("Central Surface");
		outerMesh=new ParamSurface("Outer Surface");

		segVol=new ParamVolume("Segmentation Volume");
		//				lambda=new ParamDouble("Lambda",0,5,1);
		//				stepSize=new ParamDouble("Lagrange Step Size",0,100,0.25);

		inputParams.setLabel("VolumeCorrect");
		inputParams.setName("VolumeCorrect");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Volume");

		inputParams.add(innerMesh);
		inputParams.add(centralMesh);
		inputParams.add(outerMesh);
		inputParams.add(segVol);
		//				inputParams.add(isoVal);
		//				inputParams.add(lambda);
		//				inputParams.add(stepSize);


		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("To topocorrect volume segmentation using three surfaecs");
		info.setLongDescription("The same as description");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		ParcelVol =new ParamVolume("Corrected Segmentation");
		//		ParcellatedOuterMesh=new ParamSurface("Outer Mesh");
		outputParams.add(ParcelVol);
		//		outputParams.add(ParcellatedOuterMesh);
		outputParams.setName("parcellation");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		CorrectVolFromThreeSurfaces solver=null;
		ImageDataInt Inputimg = new ImageDataInt(segVol.getImageData());

		ImageDataInt correctedVol;		

		solver = new CorrectVolFromThreeSurfaces(Inputimg);	


		if(solver!=null){
			monitor.observe(solver);
			solver.solve(innerMesh.getSurface(), centralMesh.getSurface(),  outerMesh.getSurface());
			correctedVol = solver.getCorrectedVol();				
			ParcelVol.setValue(correctedVol);

			//			outerMeshSurf = solver.getOuterSurface();
			//			outerMeshSurf.setName("outerSurf_withData");
			//			ParcellatedOuterMesh.setValue(outerMeshSurf);

		}	
	}
}



